﻿---
title: Agent fields
description: The agent fields contain the data about the software entity, if any, that collects, detects, or observes events on a host, or takes measurements on a...
url: https://www.elastic.co/docs/reference/ecs/ecs-agent
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Agent fields
The agent fields contain the data about the software entity, if any, that collects, detects, or observes events on a host, or takes measurements on a host.
Examples include Beats. Agents may also run on observers. ECS agent.* fields shall be populated with details of the agent running on the host or observer where the event happened or the measurement was taken.

## Agent field details


| Field                                               | Description                                                                                                                                                                                                                                                                                                                | Level    |
|-----------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [agent.build.original](#field-agent-build-original) | Extended build information for the agent.This field is intended to contain any build information that a data source may provide, no specific formatting is required.type: keywordexample: `metricbeat version 7.6.0 (amd64), libbeat 7.6.0 [6a23e8f8f30f5001ba344e4e54d8d9cb82cb107c built 2020-02-05 23:10:10 +0000 UTC]` | core     |
| [agent.ephemeral_id](#field-agent-ephemeral-id)     | Ephemeral identifier of this agent (if one exists).This id normally changes across restarts, but `agent.id` does not.type: keywordexample: `8a4f500f`                                                                                                                                                                      | extended |
| [agent.id](#field-agent-id)                         | Unique identifier of this agent (if one exists).Example: For Beats this would be beat.id.type: keywordexample: `8a4f500d`                                                                                                                                                                                                  | core     |
| [agent.name](#field-agent-name)                     | Custom name of the agent.This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from.type: keywordexample: `foo`                                         | core     |
| [agent.type](#field-agent-type)                     | Type of the agent.The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine.type: keywordexample: `filebeat`                                                                           | core     |
| [agent.version](#field-agent-version)               | Version of the agent.type: keywordexample: `6.0.0-rc2`                                                                                                                                                                                                                                                                     | core     |