﻿---
title: ecctl platform repository
description: Manages snapshot repositories. Manages snapshot repositories that are used by Elasticsearch clusters to perform snapshot operations. ecctl platform -...
url: https://www.elastic.co/docs/reference/ecctl/ecctl_platform_repository
products:
  - Elastic Cloud Control
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ecctl platform repository
Manages snapshot repositories.

## Synopsis

Manages snapshot repositories that are used by Elasticsearch clusters to perform snapshot operations.
```
ecctl platform repository [flags]
```


## Options

```
  -h, --help   help for repository
```


## Options inherited from parent commands

```
      --api-key string        API key to use to authenticate (If empty will look for EC_API_KEY environment variable)
      --config string         Config name, used to have multiple configs in $HOME/.ecctl/<env> (default "config")
      --force                 Do not ask for confirmation
      --format string         Formats the output using a Go template
      --host string           Base URL to use
      --insecure              Skips all TLS validation
      --message string        A message to set on cluster operation
      --output string         Output format [text|json] (default "text")
      --pass string           Password to use to authenticate (If empty will look for EC_PASS environment variable)
      --pprof                 Enables pprofing and saves the profile to pprof-20060102150405
  -q, --quiet                 Suppresses the configuration file used for the run, if any
      --region string         Elastic Cloud Hosted region
      --timeout duration      Timeout to use on all HTTP calls (default 30s)
      --trace                 Enables tracing saves the trace to trace-20060102150405
      --user string           Username to use to authenticate (If empty will look for EC_USER environment variable)
      --verbose               Enable verbose mode
      --verbose-credentials   When set, Authorization headers on the request/response trail will be displayed as plain text
      --verbose-file string   When set, the verbose request/response trail will be written to the defined file
```


## See also

- [ecctl platform](https://www.elastic.co/docs/reference/ecctl/ecctl_platform) - Manages the platform
- [ecctl platform repository create](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_repository_create) - Creates or updates a snapshot repository
- [ecctl platform repository delete](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_repository_delete) - Deletes a snapshot repositories
- [ecctl platform repository list](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_repository_list) - Lists all the snapshot repositories
- [ecctl platform repository show](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_repository_show) - Obtains a snapshot repository config