﻿---
title: ecctl platform
description: Manages the platform. ecctl - Elastic Cloud Control, ecctl platform allocator - Manages allocators, ecctl platform constructor - Manages constructors,...
url: https://www.elastic.co/docs/reference/ecctl/ecctl_platform
products:
  - Elastic Cloud Control
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ecctl platform
Manages the platform.
```
ecctl platform [flags]
```


## Options

```
  -h, --help   help for platform
```


## Options inherited from parent commands

```
      --api-key string        API key to use to authenticate (If empty will look for EC_API_KEY environment variable)
      --config string         Config name, used to have multiple configs in $HOME/.ecctl/<env> (default "config")
      --force                 Do not ask for confirmation
      --format string         Formats the output using a Go template
      --host string           Base URL to use
      --insecure              Skips all TLS validation
      --message string        A message to set on cluster operation
      --output string         Output format [text|json] (default "text")
      --pass string           Password to use to authenticate (If empty will look for EC_PASS environment variable)
      --pprof                 Enables pprofing and saves the profile to pprof-20060102150405
  -q, --quiet                 Suppresses the configuration file used for the run, if any
      --region string         Elastic Cloud Hosted region
      --timeout duration      Timeout to use on all HTTP calls (default 30s)
      --trace                 Enables tracing saves the trace to trace-20060102150405
      --user string           Username to use to authenticate (If empty will look for EC_USER environment variable)
      --verbose               Enable verbose mode
      --verbose-credentials   When set, Authorization headers on the request/response trail will be displayed as plain text
      --verbose-file string   When set, the verbose request/response trail will be written to the defined file
```


## See also

- [ecctl](https://www.elastic.co/docs/reference/ecctl/ecctl) - Elastic Cloud Control
- [ecctl platform allocator](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_allocator) - Manages allocators
- [ecctl platform constructor](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_constructor) - Manages constructors
- [ecctl platform enrollment-token](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_enrollment-token) - Manages tokens
- [ecctl platform info](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_info) - Shows information about the platform
- [ecctl platform instance-configuration](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_instance-configuration) - Manages instance configurations
- [ecctl platform proxy](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_proxy) - Manages proxies
- [ecctl platform repository](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_repository) - Manages snapshot repositories
- [ecctl platform role](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_role) - Manages platform roles
- [ecctl platform runner](https://www.elastic.co/docs/reference/ecctl/ecctl_platform_runner) - Manages platform runners