﻿---
title: ecctl deployment
description: Manages deployments. ecctl	 - Elastic Cloud Control, ecctl deployment create	 - Creates a deployment, ecctl deployment delete	 - Deletes a previously...
url: https://www.elastic.co/docs/reference/ecctl/ecctl_deployment
products:
  - Elastic Cloud Control
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# ecctl deployment
Manages deployments.
```
ecctl deployment [flags]
```


## Options

```
  -h, --help   help for deployment
```


## Options inherited from parent commands

```
      --api-key string        API key to use to authenticate (If empty will look for EC_API_KEY environment variable)
      --config string         Config name, used to have multiple configs in $HOME/.ecctl/<env> (default "config")
      --force                 Do not ask for confirmation
      --format string         Formats the output using a Go template
      --host string           Base URL to use
      --insecure              Skips all TLS validation
      --message string        A message to set on cluster operation
      --output string         Output format [text|json] (default "text")
      --pass string           Password to use to authenticate (If empty will look for EC_PASS environment variable)
      --pprof                 Enables pprofing and saves the profile to pprof-20060102150405
  -q, --quiet                 Suppresses the configuration file used for the run, if any
      --region string         Elastic Cloud Hosted region
      --timeout duration      Timeout to use on all HTTP calls (default 30s)
      --trace                 Enables tracing saves the trace to trace-20060102150405
      --user string           Username to use to authenticate (If empty will look for EC_USER environment variable)
      --verbose               Enable verbose mode
      --verbose-credentials   When set, Authorization headers on the request/response trail will be displayed as plain text
      --verbose-file string   When set, the verbose request/response trail will be written to the defined file
```


## See also

- [ecctl](https://www.elastic.co/docs/reference/ecctl/ecctl)	 - Elastic Cloud Control
- [ecctl deployment create](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_create)	 - Creates a deployment
- [ecctl deployment delete](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_delete)	 - Deletes a previously shutdown deployment ![logo cloud ece](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud_ece.svg "Supported on Elastic Cloud Enterprise") (Available for ECE only)
- [ecctl deployment elasticsearch](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_elasticsearch)	 - Manages Elasticsearch resources
- [ecctl deployment extension](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_extension)	 - Manages deployment extensions, such as custom plugins or bundles
- [ecctl deployment list](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_list)	 - Lists the platform’s deployments
- [ecctl deployment plan](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_plan)	 - Manages deployment plans
- [ecctl deployment resource](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_resource)	 - Manages deployment resources
- [ecctl deployment restore](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_restore)	 - Restores a previously shut down deployment and all of its associated sub-resources
- [ecctl deployment resync](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_resync)	 - Resynchronizes the search index and cache for the selected deployment or all
- [ecctl deployment search](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_search)	 - Performs advanced deployment search using the Elasticsearch Query DSL
- [ecctl deployment show](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_show)	 - Shows the specified deployment resources
- [ecctl deployment shutdown](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_shutdown)	 - Shuts down a deployment and all of its associated sub-resources
- [ecctl deployment template](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_template)	 - Interacts with deployment template APIs
- [ecctl deployment traffic-filter](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_traffic-filter)	 - Manages network security policies or traffic filter rulesets
- [ecctl deployment update](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_update)	 - Updates a deployment from a file definition, allowing certain flag overrides