﻿---
title: Delete a deployment
description: In this last example, you can use the ecctl deployment shutdown command to delete the deployment that you created. $DEPLOYMENT_ID is the ID for the deployment...
url: https://www.elastic.co/docs/reference/ecctl/ecctl-example-delete-deployment
products:
  - Elastic Cloud Control
---

# Delete a deployment
In this last example, you can use the [ecctl deployment shutdown](https://www.elastic.co/docs/reference/ecctl/ecctl_deployment_shutdown) command to delete the deployment that you created.
```sh
ecctl deployment shutdown [--track] $DEPLOYMENT_ID
```

- `$DEPLOYMENT_ID` is the ID for the deployment that was created in the previous [create a deployment](https://www.elastic.co/docs/reference/ecctl/ecctl-example-create-deployment) example.

On running this and other destructive commands, ecctl prompts you with a confirmation message. Use the `--force` option to skip the confirmation step, if you are using ecctl for automation.
To monitor the progress, use the `--track` flag.
To see the different options that ecctl supports, run `ecctl <command> <help>`.