﻿---
title: Regions
description: A region is the geographic area where the data center of the cloud provider that hosts your deployment is located. Use the information listed here to...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/regions
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Regions
A region is the geographic area where the data center of the cloud provider that hosts your deployment is located. Use the information listed here to decide which Elasticsearch Service region to use. Your choice should be based on:
- Your geographic proximity to the region. Picking a region that is closer to you typically reduces latency for indexing and search requests.
- The features that we support for the region. Not all regions support the same set of features.

Elasticsearch Service handles all hosting details for you, no additional accounts with the underlying cloud provider required. The region you select cannot be changed after you create a deployment. If you want to use a different region later on, you can create a new deployment and reindex your data into it.
For details about the available regions, including the deployment templates and instance configurations available for each, check the [list of available regions](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-regions-templates-instances).
<tip>
  If you are not sure what to pick, choose a region that is geographically close to you to reduce latency. You should always use HTTPS to connect to the Elastic stack components of your deployment.
</tip>


## Amazon Web Services (AWS) regions

The following AWS regions are available:

| Region             | Name                      | Supports   |
|--------------------|---------------------------|------------|
| aws-af-south-1     | Africa (Cape Town)        | HTTPS only |
| aws-ap-east-1      | Asia Pacific (Hong Kong)  | HTTPS only |
| ap-northeast-1     | Asia Pacific (Tokyo)      | HTTPS only |
| aws-ap-northeast-2 | Asia Pacific (Seoul)      | HTTPS only |
| aws-ap-south-1     | Asia Pacific (Mumbai)     | HTTPS only |
| ap-southeast-1     | Asia Pacific (Singapore)  | HTTPS only |
| ap-southeast-2     | Asia Pacific (Sydney)     | HTTPS only |
| aws-ca-central-1   | Canada (central)          | HTTPS only |
| aws-eu-central-1   | EU (Frankfurt)            | HTTPS only |
| aws-eu-central-2   | EU (Zurich)               | HTTPS only |
| aws-eu-north-1     | EU (Stockholm)            | HTTPS only |
| aws-eu-south-1     | EU (Milan)                | HTTPS only |
| eu-west-1          | EU (Ireland)              | HTTPS only |
| aws-eu-west-2      | EU (London)               | HTTPS only |
| aws-eu-west-3      | EU (Paris)                | HTTPS only |
| aws-me-south-1     | Middle East (Bahrain)     | HTTPS only |
| sa-east-1          | South America (São Paulo) | HTTPS only |
| us-east-1          | US East (N. Virginia)     | HTTPS only |
| aws-us-east-2      | US East (Ohio)            | HTTPS only |
| us-west-1          | US West (N. California)   | HTTPS only |
| us-west-2          | US West (Oregon)          | HTTPS only |

<note>
  The AWS `us-west-1` region is limited to two availability zones for ES data nodes and one (tiebreaker only) virtual zone (as depicted by the `-z` in the AZ (`us-west-1z`). Check [Restrictions and known problems](/docs/release-notes/cloud-hosted/known-issues#ec-regions-and-availability-zone) for more details.
</note>

<note>
  The AWS `eu-central-2` region is limited to two availability zones for CPU Optimized (ARM) ES data hot node and warm/cold tier.
</note>

<note>
  AWS regions `ap-northeast-1, ap-southeast-1, ap-southeast-2, eu-west-1, sa-east-1, us-east-1, us-west-1, us-west-2` are not prefixed with `aws-`.
</note>


## Google Cloud Platform (GCP) regions

The following GCP regions are available:

| Region                      | Name                                 | Supports   |
|-----------------------------|--------------------------------------|------------|
| gcp-asia-east1              | Asia Pacific East 1 (Taiwan)         | HTTPS only |
| gcp-asia-northeast1         | Asia Pacific Northeast 1 (Tokyo)     | HTTPS only |
| gcp-asia-northeast3         | Asia Pacific Northeast 3 (Seoul)     | HTTPS only |
| gcp-asia-south1             | Asia Pacific South 1 (Mumbai)        | HTTPS only |
| gcp-asia-southeast1         | Asia Pacific Southeast 1 (Singapore) | HTTPS only |
| gcp-asia-southeast2         | Asia Pacific Southeast 2 (Jakarta)   | HTTPS only |
| gcp-australia-southeast1    | Asia Pacific Southeast 1 (Sydney)    | HTTPS only |
| gcp-europe-north1           | Europe North 1 (Finland)             | HTTPS only |
| gcp-europe-west1            | Europe West 1 (Belgium)              | HTTPS only |
| gcp-europe-west2            | Europe West 2 (London)               | HTTPS only |
| gcp-europe-west3            | Europe West 3 (Frankfurt)            | HTTPS only |
| gcp-europe-west4            | Europe West 4 (Netherlands)          | HTTPS only |
| gcp-europe-west9            | Europe West 9 (Paris)                | HTTPS only |
| gcp-me-west1                | ME West 1 (Tel Aviv)                 | HTTPS only |
| gcp-northamerica-northeast1 | North America Northeast 1 (Montreal) | HTTPS only |
| gcp-southamerica-east1      | South America East 1 (Sao Paulo)     | HTTPS only |
| gcp-us-central1             | US Central 1 (Iowa)                  | HTTPS only |
| gcp-us-east1                | US East 1 (South Carolina)           | HTTPS only |
| gcp-us-east4                | US East 4 (N. Virginia)              | HTTPS only |
| gcp-us-west1                | US West 1 (Oregon)                   | HTTPS only |


## Azure regions

The following Azure regions are available:

| Region                 | Name                              | Supports   |
|------------------------|-----------------------------------|------------|
| azure-australiaeast    | Australia East (New South Wales)  | HTTPS only |
| azure-brazilsouth      | Brazil South (São Paulo)          | HTTPS only |
| azure-canadacentral    | Canada Central (Toronto)          | HTTPS only |
| azure-centralindia     | Central India (Pune)              | HTTPS only |
| azure-centralus        | Central US (Iowa)                 | HTTPS only |
| azure-eastus           | East US (Virginia)                | HTTPS only |
| azure-eastus2          | East US 2 (Virginia)              | HTTPS only |
| azure-francecentral    | France Central (Paris)            | HTTPS only |
| azure-japaneast        | Japan East (Tokyo, Saitama)       | HTTPS only |
| azure-northeurope      | North Europe (Ireland)            | HTTPS only |
| azure-southafricanorth | South Africa North (Johannesburg) | HTTPS only |
| azure-southcentralus   | South Central US (Texas)          | HTTPS only |
| azure-southeastasia    | South East Asia (Singapore)       | HTTPS only |
| azure-uksouth          | UK South (London)                 | HTTPS only |
| azure-westeurope       | West Europe (Netherlands)         | HTTPS only |
| azure-westus2          | West US 2 (Washington)            | HTTPS only |

<note>
  The Azure `southcentralus` region is limited to two availability zones for Vector Search optimized Profile ES data hot node.
</note>


## Marketplaces

When procuring Elastic Cloud through [AWS Marketplace](https://aws.amazon.com/marketplace/pp/prodview-voru33wi6xs7k), [Azure Marketplace](https://azuremarketplace.microsoft.com/en-us/marketplace/apps/elastic.ec-azure-pp?tab=overview), or [GCP Marketplace](https://console.cloud.google.com/marketplace/product/elastic-prod/elastic-cloud), only the regions corresponding to the same cloud service provider can be used. This ensures that you can enjoy the benefits of the marketplace, such as Elastic Cloud contributing towards your spend commitment with cloud providers, as applicable.
You can implement a multi-cloud strategy by creating a separate Elastic Cloud organization, either from another marketplace, or directly at [cloud.elastic.co](https://cloud.elastic.co).
For example, if you have created a deployment in `eu-central-1` after signing up on AWS Marketplace, you can provision another deployment in GCP `europe-west1` by signing up for a second Elastic Cloud organization on GCP Marketplace, using another email address.