﻿---
title: GCP default provider
description: Following are the preferred instance types / machine configurations, storage types, disk to memory ratios, and virtual CPU to RAM ratios for all instance...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/gcp-default-provider
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# GCP default provider
Following are the preferred instance types / machine configurations, storage types, disk to memory ratios, and virtual CPU to RAM ratios for all instance configurations available on Elasticsearch Service and provided by GCP.

| Instance configuration        | Preferred Instance Type or Machine Configuration1 | Storage Type1                  | Disk:Memory Ratio2 | vCPU/RAM Ratio |
|-------------------------------|---------------------------------------------------|--------------------------------|--------------------|----------------|
| gcp.es.datahot.n2.68x10x45    | N2                                                | NVMe                           | 45:1               | 0.156          |
| gcp.es.datahot.n2.68x10x95    | N2                                                | NVMe                           | 95:1               | 0.156          |
| gcp.es.datahot.n2.68x16x45    | N2                                                | NVMe                           | 45:1               | 0.250          |
| gcp.es.datahot.n2.68x32x45    | N2                                                | NVMe                           | 45:1               | 0.500          |
| gcp.es.datahot.n2d.64x8x11    | N2d                                               | NVMe                           | 11:1               | 0.133          |
| gcp.es.datawarm.n2.68x10x190  | N2                                                | Zonal standard persistent disk | 190:1              | 0.156          |
| gcp.es.datacold.n2.68x10x190  | N2                                                | Zonal standard persistent disk | 190:1              | 0.156          |
| gcp.es.datafrozen.n2.68x10x95 | N2                                                | NVMe                           | 95:1               | 0.156          |


## Additional instances

Following are the preferred instance configuration and virtual CPU to RAM ratios for additional instance configurations available on Elasticsearch Service and provided by GCP.

| Instance configuration             | Preferred Instance Type or Machine Configuration1 | vCPU/RAM Ratio |
|------------------------------------|---------------------------------------------------|----------------|
| gcp.es.master.n2.68x32x45          | N2                                                | 0.500          |
| gcp.es.ml.n2.68x16x45              | N2                                                | 0.250          |
| gcp.es.ml.n2.68x32x45              | N2                                                | 0.500          |
| gcp.es.coordinating.n2.68x16x45    | N2                                                | 0.250          |
| gcp.kibana.n2.68x32x45             | N2                                                | 0.500          |
| gcp.apm.n2.68x32x45                | N2                                                | 0.500          |
| gcp.integrationsserver.n2.68x32x45 | N2                                                | 0.500          |
| gcp.enterprisesearch.n2.68x32x45   | N2                                                | 0.500          |

1 Preferred instance and storage types are subject to provider availability. To learn more about our provider instances, check the [GCP](https://cloud.google.com/compute/docs/machine-types) reference page.
2 Ratios are estimations.