﻿---
title: VM configurations on AWS
description: For the AWS infrastructure upgrade, we use the default instance type configurations provided by AWS which are unique to them. (VM configurations used...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec_vm_configurations
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# VM configurations on AWS
For the AWS infrastructure upgrade, we use the default instance type configurations provided by AWS which are unique to them. (VM configurations used in FedRAMP Moderate Authorized are found [here](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-aws-fedramp-moderate-vm-configurations).)
To make it easy to identify each instance type in AWS, a new common nomenclature is introduced.
For example, Instance ID / SKU: `aws.es.datahot.i3`

|                   |                                                                                                                                                                                                                                                            |
|-------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `aws.*`           | Denotes the cloud provider, AWS in this case with Azure in future cases.                                                                                                                                                                                   |
| `\*.es.datahot.*` | Denotes that this configuration is an Elasticsearch (`es`) cluster component that serves as a data node for hot content. Other options may be `datawarm`, `datacold`, `datafrozen` for data nodes, and `kibana`, `master`, and so on for other components. |
| `*.i3`            | Denotes that this configuration is running on the AWS i3 instance family.                                                                                                                                                                                  |

The new configuration naming convention aligns with the [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) intended for each configuration type, replacing prior naming conventions of “highio”, “highcpu”, and so on. The following table details the new configurations for data nodes and compares them with prior naming conventions where applicable.

| New config name                            | Notes                                                                                                                                                                                                                                      |
|--------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| aws.es.datahot.i3                          | This configuration maintains the same type of VM configuration as used in the previous config (“aws.data.highio.i3”) but will have a new name (and billing SKU) that is consistent with the new naming.                                    |
| aws.es.datahot.i3en                        | This is a new configuration that is similar to the “aws.data.datahot.i3” config, but with more disk space to allow for longer retention in ingest use cases, or larger catalog in search use cases.                                        |
| aws.es.datahot.m5d                         | This configuration maintains the same type of VM configuration as used in the previous config (“aws.data.highcpu.m5d”) but will have a new name (and billing SKU) that is consistent with the new naming.                                  |
| aws.es.datahot.m6gd                        | This is a new configuration that is similar to the “aws.es.datahot.m5d” config but with more disk space and similar RAM:CPU ratios. It is powered by AWS Graviton2 which offers a better price-performance over comparable Intel chipsets. |
| aws.es.datahot.c5d                         | This is a new configuration that provides double the CPU capacity compared to “aws.es.datahot.m5d” config. It is intended for high throughput ingest use cases or intensive search use cases.                                              |
| aws.es.datahot.c6gd                        | This is a new configuration that is similar to the “aws.es.datahot.c5d” config but with more disk space and similar RAM:CPU ratios. It is powered by AWS Graviton2 which offers a better price-performance over comparable Intel chipsets. |
| aws.es.datahot.r6gd                        | This is a new configuration powered by AWS Graviton2 which offers a better price-performance over comparable Intel chipsets.                                                                                                               |
| aws.es.datawarm.d2, aws.es.datacold.d2     | These configurations maintain the same type of VM configuration as used in the previous config (“aws.data.highstorage.d2”) but will have a new name (and billing SKU) that is consistent with the new naming.                              |
| aws.es.datawarm.d3, aws.es.datacold.d3     | These configurations maintain the same type of VM configuration as used in the previous config (“aws.data.highstorage.d3”) but will have a new name (and billing SKU) that is consistent with the new naming.                              |
| aws.es.datawarm.i3en, aws.es.datacold.i3en | These configurations maintain the same type of VM configuration as used in the previous config (“aws.data.highstorage.i3en”) but will have a new name (and billing SKU) that is consistent with the new naming.                            |
| aws.es.datafrozen.i3en                     | This configuration maintains the same type of VM configuration as defined for (“aws.es.datacold.i3en”) config.                                                                                                                             |

For a detailed price list, check the [Elastic Cloud price list](https://cloud.elastic.co/deployment-pricing-table?provider=aws). For a detailed specification of the new configurations, check [Elasticsearch Service default provider instance configurations](https://www.elastic.co/docs/reference/cloud/cloud-hosted/aws-default).
The benefits of the new configurations are multifold:
- By providing a net new configuration of C5d instances, there is a general boost of performance related to new chipsets and faster hardware. On average the boost we witnessed in select benchmarks can reach up to 15%, however, different workloads may exhibit different improvements.
- Introducing C6gd, M6gd & R6gd instances, powered by AWS Graviton 2, provides high compute coupled with fast NVMe storage and offer more than a 20% improvement in price-performance over comparable Intel chipsets.
- The existing family types have been extended in terms of disk capacity which translates to a more cost effective infrastructure which in some cases can save up to 80% when calculating cost by disk capacity.
- There are now more instance types to choose from in the hot tier.  Rather than the traditional “highio” and “highcpu”, there are now six options to cover the hot data tier which allows to optimize cost/performance further.

In addition to data nodes for storage and search, Elasticsearch nodes also have machine learning nodes, master nodes, and coordinating nodes. These auxiliary node types along with application nodes such as APM servers, Kibana, and Enterprise search have also been upgraded to the new C5d, C6gd, M5d, and M6gd instance types. Both auxiliary node and application node configurations are based on Elasticsearch data node configuration types shown in the previous table.

| New config name            | Notes                                                                                                                                                                                                                                                                                                       |
|----------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| aws.es.master.c5d          | Master nodes have been “upgraded” to use 4x the CPU with more memory and disk space as they had when based on “aws.master.r5d” config. This will help boost the overall performance and stability of clusters, as master nodes have a critical role in maintaining cluster state and controlling workloads. |
| aws.es.master.c6gd         | This is a new configuration that is similar to the “aws.es.master.c5d” config but with more disk space and similar RAM:CPU ratios. It is powered by AWS Graviton2 which offers a better price-performance over comparable Intel chipsets.                                                                   |
| aws.es.ml.m5d              | ML nodes will maintain the same type of VM configuration as used in the previous config (“aws.ml.m5d”), but will have a new name (and billing SKU) that is consistent with the new naming.                                                                                                                  |
| aws.es.ml.m6gd             | This is a new configuration that is similar to the “aws.es.ml.m5d” config but with more disk space and similar RAM:CPU ratios. It is powered by AWS Graviton2 which offers a better price-performance over comparable Intel chipsets.                                                                       |
| aws.es.ml.c5d              | This is a new configuration that is similar to the “aws.es.ml.m5d” config but with 2x more CPU per unit of RAM and more disk space.                                                                                                                                                                         |
| aws.es.coordinating.m5d    | Coordinating nodes will maintain the same type of VM configuration as used in the previous config (“aws.coordinating.m5d”), but will have a new name (and billing SKU) that is consistent with the new naming.                                                                                              |
| aws.es.coordinating.m6gd   | This is a new configuration that is similar to the “aws.es.coordinating.m5d” config but with more disk space and similar RAM:CPU ratios. It is powered by AWS Graviton2 which offers a better price-performance over comparable Intel chipsets.                                                             |
| aws.kibana.c5d             | Same “upgrade” for Kibana as that of master nodes. Will now use 4x the CPU with more memory and disk space.  This ensures a more performant Kibana and helps with some client side aggregation, as well as responsive UI.                                                                                   |
| aws.kibana.c6gd            | This is a new configuration that is similar to the “aws.kibana.c5d” config but with more disk space and similar RAM:CPU ratios. It is powered by AWS Graviton2 which offers a better price-performance over comparable Intel chipsets.                                                                      |
| aws.apm.c5d                | Same “upgrade” for APM as that of Kibana. Will now use 4x the CPU with more memory and disk space.                                                                                                                                                                                                          |
| aws.integrationsserver.c5d | Same “upgrade” for Integrations Server as that of Kibana. Will now use 4x the CPU with more memory and disk space.                                                                                                                                                                                          |
| aws.enterprisesearch.c5d   | Enterprisesearch nodes have been “upgraded” to use 2x the CPU with more memory and disk space as they had when based on “aws.enterprisesearch.m5d” config.                                                                                                                                                  |