﻿---
title: Selecting the right configuration for you on AWS
description: While far from being a comprehensive guide for performance tuning, the following advice is provided for selecting the hot tier instance configuration:...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec_selecting_the_right_configuration_for_you
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Selecting the right configuration for you on AWS
While far from being a comprehensive guide for performance tuning, the following advice is provided for selecting the hot tier instance configuration:

| Deployment template           | Hot data tier instance configuration | Notes                                                                                                                                                                                                                                                                 |
|-------------------------------|--------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Storage Optimized             | aws.es.datahot.i3                    | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
| Storage Optimized (Dense)     | aws.es.datahot.i3en                  | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also, good for light search use cases with very large data sets.                                                                                                              |
| CPU Optimized                 | aws.es.datahot.c5d                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
| CPU Optimized (ARM)           | aws.es.datahot.c6gd                  | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
| Vector Search Optimized (ARM) | aws.es.datahot.r6gd                  | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
| General Purpose               | aws.es.datahot.m5d                   | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
| General Purpose (ARM)         | aws.es.datahot.m6gd                  | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |