﻿---
title: Available regions, deployment templates, and instance configurations
description: Click any row to view the details for that region. 
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-regions-templates-instances
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Available regions, deployment templates, and instance configurations
Click any row to view the details for that region.

## Google Cloud Platform

<dropdown title="Taiwan (asia-east1), gcp-asia-east1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v4           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v6           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v2           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v8           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v2     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v6     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v8     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v4     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v4             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v6             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v2             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v8             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v8               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v6               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v2               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v4               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datahot.n2d.64x32x45          | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** gcp.es.datahot.n2d.64x8x95           | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2d family.                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** gcp.es.datahot.n2d.64x16x45          | General purpose Elasticsearch instances for hot data. Based on GCP’s n2d family.                                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** gcp.es.datahot.n2d.64x8x45           | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2d family.                                   | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Tokyo (asia-northeast1), gcp-asia-northeast1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n1.64x10x95        | Data nodes running on GCP n1 VM family that acts as a cache for the frozen tier.                                     | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Seoul (asia-northeast3), gcp-asia-northeast3">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v4           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v6           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v2           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v8           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v2     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v6     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v8     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v4     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v4             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v6             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v2             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v8             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v8               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v6               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v2               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v4               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** data.frozen                          | An instance configuration to be used for high storage Elasticsearch frozen data tier nodes                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n1.64x10x95        | Data nodes running on GCP n1 VM family that acts as a cache for the frozen tier.                                     | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** data.highstorage                     | Instance configuration to be used for a higher disk/memory ratio                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master                               | Instance configuration to be used for dedicated masters                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** coordinating                         | Instance configuration to be used for dedicated request coordination instances                                       | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** ml                                   | Instance configuration to be used for ML instances                                                                   | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** kibana                               | Instance configuration to be used for Kibana                                                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** apm                                  | Instance configuration to be used for APM                                                                            | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** appsearch                            | The instance configuration to be used for AppSearch nodes running as both app server and worker                      | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
  | **(DEPRECATED)** enterprise.search                    | The instance configuration to be used for Elastic Enterprise Search nodes                                            | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Mumbai (asia-south1), gcp-asia-south1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | gcp.es.datahot.n2d.64x32x45                           | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2d.64x8x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2d family.                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2d.64x16x45                           | General purpose Elasticsearch instances for hot data. Based on GCP’s n2d family.                                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2d.64x8x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2d family.                                   | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** coordinator                          | Instance configuration to be used for dedicated request coordination instances                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n1.64x10x95        | Data nodes running on GCP n1 VM family that acts as a cache for the frozen tier.                                     | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** data.highstorage                     | Instance configuration to be used for a higher disk/memory ratio                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master                               | Instance configuration to be used for dedicated masters                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** ingest                               | Instance configuration to be used for dedicated ingest instances                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** ml                                   | Instance configuration to be used for ML instances                                                                   | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** kibana                               | Instance configuration to be used for Kibana                                                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** apm                                  | Instance configuration to be used for APM                                                                            | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Singapore (asia-southeast1), gcp-asia-southeast1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Jakarta (asia-southeast2), gcp-asia-southeast2">
  **Available templates**

  | Template ID                                     | Name                      | Description                                                                                                                                                                                                                     |
  |-------------------------------------------------|---------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | gcp-cpu-optimized                               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | gcp-storage-optimized-dense                     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | gcp-general-purpose                             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** gcp-storage-optimized-v7       | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7 | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** gcp-general-purpose-v7         | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** gcp-cpu-optimized-v7           | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** data.highstorage                     | Instance configuration to be used for a higher disk/memory ratio                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master                               | Instance configuration to be used for dedicated masters                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** data.frozen                          | An instance configuration to be used for high storage Elasticsearch frozen data tier nodes                           | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** coordinating                         | Instance configuration to be used for dedicated request coordination instances                                       | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** ml                                   | Instance configuration to be used for ML instances                                                                   | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** kibana                               | Instance configuration to be used for Kibana                                                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** apm                                  | Instance configuration to be used for APM                                                                            | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** integrations.server                  | Instance configuration to be used for Integrations Server                                                            | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** enterprise.search                    | The instance configuration to be used for Elastic Enterprise Search nodes                                            | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Sydney (australia-southeast1), gcp-australia-southeast1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n1.64x10x95        | Data nodes running on GCP n1 VM family that acts as a cache for the frozen tier.                                     | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Finland (europe-north1), gcp-europe-north1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n1.64x10x95        | Data nodes running on GCP n1 VM family that acts as a cache for the frozen tier.                                     | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Belgium (europe-west1), gcp-europe-west1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ingest.1                         | An Elasticsearch ingest instance.                                                                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinator.1                    | An Elasticsearch coordinator instance.                                                                               | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="London (europe-west2), gcp-europe-west2">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Frankfurt (europe-west3), gcp-europe-west3">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ingest.1                         | An Elasticsearch ingest instance.                                                                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n1.64x10x95        | Data nodes running on GCP n1 VM family that acts as a cache for the frozen tier.                                     | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinator.1                    | An Elasticsearch coordinator instance.                                                                               | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Netherlands (europe-west4), gcp-europe-west4">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Paris (europe-west9), gcp-europe-west9">
  **Available templates**

  | Template ID                                     | Name                      | Description                                                                                                                                                                                                                                                           |
  |-------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                     | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-storage-optimized-v7       | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7 | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v7         | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v7           | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** data.highstorage                     | Instance configuration to be used for a higher disk/memory ratio                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master                               | Instance configuration to be used for dedicated masters                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** data.frozen                          | An instance configuration to be used for high storage Elasticsearch frozen data tier nodes                           | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** coordinating                         | Instance configuration to be used for dedicated request coordination instances                                       | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** ml                                   | Instance configuration to be used for ML instances                                                                   | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** kibana                               | Instance configuration to be used for Kibana                                                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** apm                                  | Instance configuration to be used for APM                                                                            | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** integrations.server                  | Instance configuration to be used for Integrations Server                                                            | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** enterprise.search                    | The instance configuration to be used for Elastic Enterprise Search nodes                                            | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Tel Aviv (me-west1), gcp-me-west1">
  **Available templates**

  | Template ID                                | Name                      | Description                                                                                                                                                                                                                                                           |
  |--------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                      | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                          | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                        | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** default                   | Default                   | Default deployment template for clusters                                                                                                                                                                                                                              |
  | **(DEPRECATED)** default.enterprise.search | Elastic Enterprise Search | Default deployment template for Elastic Enterprise Search                                                                                                                                                                                                             |
  **Available Instances**

  | Instance ID                          | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |--------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.datahot.n2.68x32x45           | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.coordinating.n2.68x16x45      | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190         | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.ml.n2.68x32x45                | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45           | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190         | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datafrozen.n2.68x10x90        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.master.n2.68x32x45            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2d.64x8x11           | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45           | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95           | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.kibana.n2.68x32x45               | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                  | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45   | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45     | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** data.highstorage    | Instance configuration to be used for a higher disk/memory ratio                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master              | Instance configuration to be used for dedicated masters                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** data.frozen         | An instance configuration to be used for high storage Elasticsearch frozen data tier nodes                           | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** coordinating        | Instance configuration to be used for dedicated request coordination instances                                       | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** ml                  | Instance configuration to be used for ML instances                                                                   | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** kibana              | Instance configuration to be used for Kibana                                                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** apm                 | Instance configuration to be used for APM                                                                            | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** integrations.server | Instance configuration to be used for Integrations Server                                                            | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** enterprise.search   | The instance configuration to be used for Elastic Enterprise Search nodes                                            | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Montreal (northamerica-northeast1), gcp-northamerica-northeast1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ingest.1                         | An Elasticsearch ingest instance.                                                                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n1.64x10x95        | Data nodes running on GCP n1 VM family that acts as a cache for the frozen tier.                                     | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinator.1                    | An Elasticsearch coordinator instance.                                                                               | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** kibana                               | Instance configuration to be used for Kibana                                                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Sao Paulo (southamerica-east1), gcp-southamerica-east1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n1.64x10x95        | Data nodes running on GCP n1 VM family that acts as a cache for the frozen tier.                                     | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Iowa (us-central1), gcp-us-central1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ingest.1                         | An Elasticsearch ingest instance.                                                                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.coordinator.1                    | An Elasticsearch coordinator instance.                                                                               | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="South Carolina (us-east1), gcp-us-east1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="N. Virginia (us-east4), gcp-us-east4">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Oregon (us-west1), gcp-us-west1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                                                           |
  |-----------------------------------------------------|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | gcp-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | gcp-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | gcp-vector-search-optimized                         | Vector Search optimized   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | gcp-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | gcp-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-compute-optimized              | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v7           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-memory-optimized               | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-storage-optimized-dense-v7     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** gcp-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v7             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** gcp-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-cpu-optimized-v7               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** gcp-hot-warm                       | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** gcp-appsearch-dedicated            | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-appsearch-dedicated-v2         | App Search                | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-cross-cluster-search           | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated    | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** gcp-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** gcp-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** gcp-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized                   | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** gcp-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                           | Description                                                                                                          | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | gcp.es.master.n2.68x32x45                             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.ml.n2.68x32x45                                 | CPU-optimized Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                  | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x95                            | Storage-optimized (dense) Elasticsearch instances for hot data. Based on GCP’s n2 family.                            | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x10x45                            | Storage-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datahot.n2.68x32x45                            | CPU-optimized Elasticsearch instances for hot data. Based on GCP’s n2 family.                                        | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datafrozen.n2.68x10x90                         | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | gcp.es.coordinating.n2.68x16x45                       | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datawarm.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.es.datahot.n2d.64x8x11                            | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.         | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | gcp.es.datahot.n2.68x16x45                            | General purpose Elasticsearch instances for hot data. Based on GCP’s n2 family.                                      | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | gcp.es.datacold.n2.68x10x190                          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on GCP’s n2 family.                       | 2048, 4096, 8192, 16384, 32768, 65536       |
  | gcp.kibana.n2.68x32x45                                | CPU-optimized instances serving as kibana nodes. Based on GCP’s n2 family.                                           | 1024, 2048, 4096, 8192                      |
  | gcp.apm.n2.68x32x45                                   | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.integrationsserver.n2.68x32x45                    | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | gcp.enterprisesearch.n2.68x32x45                      | CPU-optimized instances serving as Enterprise Search nodes. Based on GCP’s n2 family.                                | 2048, 4096, 8192, 16384                     |
  | **(DEPRECATED)** gcp.ml.1                             | An Elasticsearch machine learning instance.                                                                          | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ingest.1                         | An Elasticsearch ingest instance.                                                                                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2d.64x8x95        | Data nodes running on GCP n2d VM family that acts as a cache for the frozen tier.                                    | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** gcp.master.2                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highmem.1                   | A memory optimized Elasticsearch instance.                                                                           | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.coordinating.n2.68x16x45.2    | General purpose Elasticsearch instance serving as a coordinating node. Based on GCP’s n2 family.                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highio.1                    | An I/O optimized Elasticsearch instance.                                                                             | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.2                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.data.highstorage.1               | A storage optimized Elasticsearch instance.                                                                          | 2048, 4096, 8192, 16384, 32768, 65536       |
  | **(DEPRECATED)** gcp.es.master.n2.68x32x45.2          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on GCP’s n2 family.                    | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinating.1                   | An Elasticsearch coordinating instance.                                                                              | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.master.1                         | An Elasticsearch master eligible instance.                                                                           | 1024, 2048, 4096, 8192, 16384               |
  | **(DEPRECATED)** gcp.es.ml.n2.68x16x45                | General purpose Elasticsearch instance serving as ML nodes. Based on GCP’s n2 family.                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.coordinator.1                    | An Elasticsearch coordinator instance.                                                                               | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.es.datafrozen.n2.68x10x95        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on GCP’s n2 family. | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** gcp.data.highcpu.1                   | A CPU optimized Elasticsearch instance.                                                                              | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** gcp.ccs.1                            | A cross cluster search optimized Elasticsearch instance.                                                             | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.kibana.1                         | A Kibana instance.                                                                                                   | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** gcp.apm.2                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.apm.n2.68x32x45.2                | CPU-optimized instances serving as apm nodes. Based on GCP’s n2 family.                                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.apm.1                            | An APM instance.                                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.integrationsserver.2             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192, 16384, 32768   |
  | **(DEPRECATED)** gcp.integrationsserver.n2.68x32x45.2 | CPU-optimized instances serving as Integrations Server nodes. Based on GCP’s n2 family.                              | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** gcp.integrationsserver.1             | An Integrations Server instance.                                                                                     | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** gcp.appsearch.1                      | A CPU optimized App Search instance.                                                                                 | 2048, 4096, 8192                            |
  | **(DEPRECATED)** gcp.enterprisesearch.1               | A CPU optimized Elastic Enterprise Search instance.                                                                  | 2048, 4096, 8192                            |
</dropdown>


## Amazon Web Services

<dropdown title="Tokyo (ap-northeast-1), ap-northeast-1">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                                                           |
  |--------------------------------------------------------|---------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-vector-search-optimized-arm                        | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-vector-search-optimized-faster-warm-arm            | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-faster-warm-arm                    | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-arm                                | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-compute-optimized-v3              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized                 | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v2              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v4              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v2              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v3              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v7              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-memory-optimized                  | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v2               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v3               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v4               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-general-purpose-v2                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v3                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v3            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v6            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v4            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v5            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v4                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v3                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v2                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v6              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v3              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v5              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v4              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v8  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v10 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v4  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v6  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v2  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v12 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-hot-warm-v2                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm-v3                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm                          | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-appsearch-dedicated-v3            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated-v2            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated               | App Search                      | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v2           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search              | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v3           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v7            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-observability                     | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-observability-v2                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-security-v2                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-security                          | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-io-optimized-v2                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized                      | I/O Optimized                   | Ideal for time-series data, such as logs and metrics.                                                                                                                                                                                                                 |
  | **(DEPRECATED)** aws-io-optimized-v3                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v4                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datahot.r6gd                              | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m6gd                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datacold.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datawarm.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.datahot.m6gd                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2          | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d            | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.coordinating.m5.2           | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datawarm.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5             | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highmem.r5d            | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highmem.r4             | A memory optimized Elasticsearch instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.ml.m5d                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r4.2                 | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.master.r5d                  | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ingest.m5                   | An Elasticsearch ingest instance running on an AWS m5.                                                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r4                   | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.ml.m5                       | An Elasticsearch machine learning instance running on an AWS m5.                                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2         | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ccs.r5d                     | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m6gd.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                      | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2                | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datacold.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ccs.r4                      | A cross cluster search optimized Elasticsearch instance running on an AWS r4.                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highio.i3              | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.coordinator.r4              | An Elasticsearch coordinator instance running on an AWS r4.                                                            | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.data.highcpu.m5             | A CPU optimized Elasticsearch instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highcpu.m5d            | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                  | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r4                   | A Kibana instance running on an AWS r4.                                                                                | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                   | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.r4.2                    | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                     | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.r4                      | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r4.2     | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2    | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d      | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.integrationsserver.r4       | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.appsearch.m5                | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.appsearch.m5d               | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.enterprisesearch.m5d        | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Singapore (ap-southeast-1), ap-southeast-1">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                                                           |
  |--------------------------------------------------------|---------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-vector-search-optimized-arm                        | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-vector-search-optimized-faster-warm-arm            | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-faster-warm-arm                    | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-arm                                | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-compute-optimized-v3              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized                 | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v2              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v4              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v2              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v6              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v3              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v7              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-memory-optimized                  | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v2               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v3               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v4               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v6        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-general-purpose-v2                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v6                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v3                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v3            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v2            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v6            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v4            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v5            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v4                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v3                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v7                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v6              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v3              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v5              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v4              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v2                  | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v8  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v10 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v2              | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v4  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v6  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v2  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v12 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-hot-warm-v2                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm-v3                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm                          | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-appsearch-dedicated-v3            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated-v2            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated               | App Search                      | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v2           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search              | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v3           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v7            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-observability                     | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-observability-v2                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-security-v2                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-security                          | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-io-optimized                      | I/O Optimized                   | Ideal for time-series data, such as logs and metrics.                                                                                                                                                                                                                 |
  | **(DEPRECATED)** aws-io-optimized-v2                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v3                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v4                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datahot.r6gd                              | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m6gd                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datacold.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datawarm.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.datahot.m6gd                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2          | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d            | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.coordinating.m5.2           | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datawarm.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5             | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highmem.r5d            | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highmem.r4             | A memory optimized Elasticsearch instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.ml.m5d                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r4.2                 | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.master.r5d                  | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ingest.m5                   | An Elasticsearch ingest instance running on an AWS m5.                                                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r4                   | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.ml.m5                       | An Elasticsearch machine learning instance running on an AWS m5.                                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2         | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ccs.r5d                     | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m6gd.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                      | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2                | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datacold.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ccs.r4                      | A cross cluster search optimized Elasticsearch instance running on an AWS r4.                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highio.i3              | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.coordinator.r4              | An Elasticsearch coordinator instance running on an AWS r4.                                                            | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.data.highcpu.m5             | A CPU optimized Elasticsearch instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highcpu.m5d            | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                  | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r4                   | A Kibana instance running on an AWS r4.                                                                                | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                   | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.r4.2                    | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                     | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.r4                      | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r4.2     | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2    | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d      | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.integrationsserver.r4       | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.appsearch.m5                | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.appsearch.m5d               | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.enterprisesearch.m5d        | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Sydney (ap-southeast-2), ap-southeast-2">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                                                           |
  |--------------------------------------------------------|---------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-vector-search-optimized-arm                        | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-vector-search-optimized-faster-warm-arm            | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-faster-warm-arm                    | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-arm                                | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-compute-optimized-v3              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized                 | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v2              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v4              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v2              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v3              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v7              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-memory-optimized                  | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v2               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v3               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v4               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-general-purpose-v2                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v3                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v3            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v6            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v4            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v5            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v4                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v3                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v2                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v6              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v3              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v5              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v4              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v8  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v10 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v4  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v6  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v2  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v12 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-hot-warm-v2                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm-v3                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm                          | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-appsearch-dedicated-v3            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated-v2            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated               | App Search                      | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v2           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search              | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v3           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v7            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-observability                     | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-observability-v2                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-security-v2                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-security                          | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-io-optimized-v2                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized                      | I/O Optimized                   | Ideal for time-series data, such as logs and metrics.                                                                                                                                                                                                                 |
  | **(DEPRECATED)** aws-io-optimized-v3                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v4                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datahot.r6gd                              | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m6gd                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datacold.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datawarm.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.datahot.m6gd                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2          | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d            | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.coordinating.m5.2           | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datawarm.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5             | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highmem.r5d            | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highmem.r4             | A memory optimized Elasticsearch instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.ml.m5d                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r4.2                 | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.master.r5d                  | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ingest.m5                   | An Elasticsearch ingest instance running on an AWS m5.                                                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r4                   | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.ml.m5                       | An Elasticsearch machine learning instance running on an AWS m5.                                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2         | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ccs.r5d                     | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m6gd.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                      | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2                | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datacold.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ccs.r4                      | A cross cluster search optimized Elasticsearch instance running on an AWS r4.                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highio.i3              | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.coordinator.r4              | An Elasticsearch coordinator instance running on an AWS r4.                                                            | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.data.highcpu.m5             | A CPU optimized Elasticsearch instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highcpu.m5d            | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                  | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r4                   | A Kibana instance running on an AWS r4.                                                                                | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                   | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.r4.2                    | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                     | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.r4                      | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r4.2     | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2    | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d      | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.integrationsserver.r4       | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.appsearch.m5                | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.appsearch.m5d               | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.enterprisesearch.m5d        | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Cape Town (af-south-1), aws-af-south-1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                     |
  |-----------------------------------------------------|---------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                   | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm                       | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-storage-optimized-dense-faster-warm             | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-general-purpose-faster-warm                     | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v4           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-storage-optimized-v4           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v2           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v4            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v2             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v4             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-cpu-optimized-v2               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v4               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v6               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-hot-warm-v3                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-cross-cluster-search-v3        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v4                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  **Available Instances**

  | Instance ID                                     | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datawarm.i3en                            | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                            | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.i3en                             | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.m5d                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                               | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datawarm.d2                              | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.es.datahot.c5d                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.coordinating.m5d                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                          | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.master.c5d                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datacold.d2                              | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.kibana.c5d                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.integrationsserver.c5d                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c5d                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2         | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highio.i3             | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1       | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d           | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2         | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ingest.m5d                 | An Elasticsearch ingest instance running on an AWS m5d.                                                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highmem.r5d           | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.d2.1.1         | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c5d.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m5d                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.coordinator.r5d            | An Elasticsearch coordinator instance running on an AWS r5d.                                                           | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2           | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r5d                 | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2        | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.ccs.r5d                    | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1          | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                     | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2               | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2       | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1     | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1       | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.d2.1.1         | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highcpu.m5d           | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.kibana.r5d                 | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                  | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.c5d.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                    | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2   | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d     | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.enterprisesearch.m5d       | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Hong Kong (ap-east-1), aws-ap-east-1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                     |
  |-----------------------------------------------------|---------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                   | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm                       | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-storage-optimized-dense-faster-warm             | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-general-purpose-faster-warm                     | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v4           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v4           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v2           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v4            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v2             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v4             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-cpu-optimized-v2               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v4               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v6               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-hot-warm-v3                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-cross-cluster-search-v3        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v4                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  **Available Instances**

  | Instance ID                                     | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datawarm.i3en                            | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                            | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.i3en                             | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.m5d                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                               | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datawarm.d2                              | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.es.datahot.c5d                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.coordinating.m5d                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                          | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.master.c5d                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datacold.d2                              | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.kibana.c5d                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.integrationsserver.c5d                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c5d                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** master                         | Instance configuration to be used for dedicated masters                                                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.coordinating.m5d.2         | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1       | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d           | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2         | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ingest.m5d                 | An Elasticsearch ingest instance running on an AWS m5d.                                                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** data.highstorage               | Instance configuration to be used for a higher disk/memory ratio                                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highmem.r5d           | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.d2.1.1         | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c5d.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** coordinating                   | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.ml.m5d                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.coordinator.r5d            | An Elasticsearch coordinator instance running on an AWS r5d.                                                           | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2           | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r5d                 | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2        | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.ccs.r5d                    | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** ml                             | Instance configuration to be used for ML instances                                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1          | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                     | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2               | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.data.highio.i3             | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2       | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1     | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1       | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.d2.1.1         | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highcpu.m5d           | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** kibana                         | Instance configuration to be used for Kibana                                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                 | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                  | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** apm                            | Instance configuration to be used for APM                                                                              | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                    | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2   | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d     | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** appsearch                      | The instance configuration to be used for AppSearch nodes running as both app server and worker                        | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** enterprise.search              | The instance configuration to be used for Elastic Enterprise Search nodes                                              | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.m5d       | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Seoul (ap-northeast-2), aws-ap-northeast-2">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                     |
  |-----------------------------------------------------|---------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                   | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm                       | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-storage-optimized-dense-faster-warm             | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-general-purpose-faster-warm                     | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v4           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-storage-optimized-v4           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v2           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v4            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v2             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v4             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-cpu-optimized-v2               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v4               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v6               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-hot-warm-v3                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-appsearch-dedicated-v3         | App Search                | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-appsearch-dedicated-v2         | App Search                | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-cross-cluster-search-v3        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v4                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  **Available Instances**

  | Instance ID                                     | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datawarm.i3en                            | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                            | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.i3en                             | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.m5d                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                               | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datawarm.d2                              | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.es.datahot.c5d                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.coordinating.m5d                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                          | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.master.c5d                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datacold.d2                              | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.kibana.c5d                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.integrationsserver.c5d                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c5d                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** master                         | Instance configuration to be used for dedicated masters                                                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.coordinating.m5d.2         | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1       | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d           | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2         | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ingest.m5d                 | An Elasticsearch ingest instance running on an AWS m5d.                                                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** data.highstorage               | Instance configuration to be used for a higher disk/memory ratio                                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highmem.r5d           | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.d2.1.1         | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c5d.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** coordinating                   | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.ml.m5d                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.coordinator.r5d            | An Elasticsearch coordinator instance running on an AWS r5d.                                                           | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2           | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r5d                 | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2        | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.ccs.r5d                    | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** ml                             | Instance configuration to be used for ML instances                                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1          | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                     | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2               | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.data.highio.i3             | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2       | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1     | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1       | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.d2.1.1         | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highcpu.m5d           | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** kibana                         | Instance configuration to be used for Kibana                                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                 | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                  | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** apm                            | Instance configuration to be used for APM                                                                              | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                    | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2   | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d     | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** appsearch                      | The instance configuration to be used for AppSearch nodes running as both app server and worker                        | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.appsearch.m5d              | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** enterprise.search              | The instance configuration to be used for Elastic Enterprise Search nodes                                              | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.m5d       | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Mumbai (ap-south-1), aws-ap-south-1">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                                                           |
  |--------------------------------------------------------|---------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-vector-search-optimized-arm                        | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-vector-search-optimized-faster-warm-arm            | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-faster-warm-arm                    | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-arm                                | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-compute-optimized-v3              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v2              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v4              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v2              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v3              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v7              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-memory-optimized-v2               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v3               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v4               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-general-purpose-v2                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v3                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v3            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v6            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v4            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v5            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v4                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v3                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v2                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v11             | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v3              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v5              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v9              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v4  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v8  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v10 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v6  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v2  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v12 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-hot-warm-v2                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm-v3                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-cross-cluster-search-v2           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v3           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v7            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-observability                     | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-observability-v2                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-security-v2                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-security                          | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-io-optimized-v2                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v3                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v4                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datahot.r6gd                              | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m6gd                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.d2                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datacold.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datawarm.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.datahot.m6gd                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datacold.d2                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2          | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d            | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ingest.m5d                  | An Elasticsearch ingest instance running on an AWS m5d.                                                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** data.highstorage                | Instance configuration to be used for a higher disk/memory ratio                                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master                          | Instance configuration to be used for dedicated masters                                                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highmem.r5d            | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.d2.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** coordinating                    | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.ml.m6gd                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.m5d                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.coordinator.r5d             | An Elasticsearch coordinator instance running on an AWS r5d.                                                           | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r5d                  | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2         | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ccs.r5d                     | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** ml                              | Instance configuration to be used for ML instances                                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datahot.m6gd.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                      | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2                | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.data.highio.i3              | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.d2.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highcpu.m5d            | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** kibana                          | Instance configuration to be used for Kibana                                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                  | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                   | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** apm                             | Instance configuration to be used for APM                                                                              | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                     | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2    | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d      | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** appsearch                       | The instance configuration to be used for AppSearch nodes running as both app server and worker                        | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** enterprise.search               | The instance configuration to be used for Elastic Enterprise Search nodes                                              | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.m5d        | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Canada (ca-central-1), aws-ca-central-1">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                                                           |
  |--------------------------------------------------------|---------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-vector-search-optimized-arm                        | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-vector-search-optimized-faster-warm-arm            | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-compute-optimized-v3              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized                 | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v2              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v4              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v2              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v3              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v12             | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-memory-optimized                  | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v2               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v3               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v4               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-general-purpose-v2                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v3                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v4                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v3                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v2                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v6              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v10             | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v8              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v4              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v5  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v11 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v3  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v9  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v13 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v7  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-hot-warm-v2                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm-v3                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm                          | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-appsearch-dedicated-v3            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated-v2            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated               | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-cross-cluster-search-v2           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search              | Cross Cluster Search            | Search data across one or more associated deployments.                                                                                                                                                                                                                |
  | **(DEPRECATED)** aws-cross-cluster-search-v3           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-observability                     | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-observability-v2                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-security-v2                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-security                          | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-io-optimized-v2                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized                      | I/O Optimized                   | Ideal for time-series data, such as logs and metrics.                                                                                                                                                                                                                 |
  | **(DEPRECATED)** aws-io-optimized-v3                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v4                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datahot.r6gd                              | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.d2                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datacold.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datawarm.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datacold.d2                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2          | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d            | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ingest.m5d                  | An Elasticsearch ingest instance running on an AWS m5d.                                                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** data.highstorage                | Instance configuration to be used for a higher disk/memory ratio                                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master                          | Instance configuration to be used for dedicated masters                                                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highmem.r5d            | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.d2.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** coordinating                    | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.ml.m5d                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.coordinator.r5d             | An Elasticsearch coordinator instance running on an AWS r5d.                                                           | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r5d                  | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2         | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ccs.r5d                     | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** ml                              | Instance configuration to be used for ML instances                                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                      | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2                | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.data.highio.i3              | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.d2.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highcpu.m5d            | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** kibana                          | Instance configuration to be used for Kibana                                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                  | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                   | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** apm                             | Instance configuration to be used for APM                                                                              | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                     | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2    | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d      | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** appsearch                       | The instance configuration to be used for AppSearch nodes running as both app server and worker                        | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.appsearch.m5d               | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** enterprise.search               | The instance configuration to be used for Elastic Enterprise Search nodes                                              | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.m5d        | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Frankfurt (eu-central-1), aws-eu-central-1">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                                                           |
  |--------------------------------------------------------|---------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-vector-search-optimized-arm                        | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-vector-search-optimized-faster-warm-arm            | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-faster-warm-arm                    | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose-arm                                | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-compute-optimized-v5              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v3              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized                 | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v2              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v4              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v2              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v3              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v7              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-memory-optimized                  | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v2               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v3               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v5               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v4               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-general-purpose-v2                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v3                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v3            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v6            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v4            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v5            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v4                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v3                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v2                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v6              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v3              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v5              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v4              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v8  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v4  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v6  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v2  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v10 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v12 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-hot-warm-v2                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm-v3                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm                          | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm-v4                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-appsearch-dedicated-v3            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated-v2            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated               | App Search                      | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                                                         |
  | **(DEPRECATED)** aws-appsearch-dedicated-v4            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-cross-cluster-search-v4           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v2           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search              | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v3           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-arm-v7            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v4    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-observability-v3                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-observability                     | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-observability-v2                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-security-v2                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-security                          | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-security-v3                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-io-optimized-v2                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized                      | I/O Optimized                   | Ideal for time-series data, such as logs and metrics.                                                                                                                                                                                                                 |
  | **(DEPRECATED)** aws-io-optimized-v3                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v4                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v5                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datahot.r6gd                              | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m6gd                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datacold.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datawarm.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.datahot.m6gd                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2          | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d            | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.coordinating.m5.2           | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datawarm.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5             | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highmem.r5d            | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highmem.r4             | A memory optimized Elasticsearch instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.ml.m5d                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r4.2                 | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.master.r5d                  | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ingest.m5                   | An Elasticsearch ingest instance running on an AWS m5.                                                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r4                   | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.ml.m5                       | An Elasticsearch machine learning instance running on an AWS m5.                                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2         | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ccs.r5d                     | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m6gd.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                      | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2                | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datacold.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ccs.r4                      | A cross cluster search optimized Elasticsearch instance running on an AWS r4.                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highio.i3              | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.coordinator.r4              | An Elasticsearch coordinator instance running on an AWS r4.                                                            | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.data.highcpu.m5             | A CPU optimized Elasticsearch instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highcpu.m5d            | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                  | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r4                   | A Kibana instance running on an AWS r4.                                                                                | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                   | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.r4.2                    | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                     | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.r4                      | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r4.2     | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2    | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d      | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.integrationsserver.r4       | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.appsearch.m5                | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.appsearch.m5d               | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.enterprisesearch.m5d        | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Zurich (eu-central-2), aws-eu-central-2">
  **Available templates**

  | Template ID                                | Name                      | Description                                                                                                                                                                                                                     |
  |--------------------------------------------|---------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized                      | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-storage-optimized-faster-warm          | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-cpu-optimized                          | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm              | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm-arm          | CPU optimized (ARM)       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-arm                      | CPU optimized (ARM)       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-storage-optimized-dense-faster-warm    | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-storage-optimized-dense                | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-general-purpose-faster-warm            | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose                        | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose-faster-warm-arm        | General purpose (ARM)     | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose-arm                    | General purpose (ARM)     | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** default                   | Default                   | Default deployment template for clusters                                                                                                                                                                                        |
  | **(DEPRECATED)** default.enterprise.search | Elastic Enterprise Search | Default deployment template for Elastic Enterprise Search                                                                                                                                                                       |
  **Available Instances**

  | Instance ID                          | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datawarm.i3en                 | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m6gd             | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datacold.d3                   | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d              | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3en                  | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en               | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.datahot.m6gd                  | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c5d                    | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datahot.m5d                   | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                    | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datahot.c6gd                  | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.c5d                   | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                        | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datawarm.d3                   | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                 | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.master.c6gd                   | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.kibana.c6gd                      | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                       | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c6gd                         | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.apm.c5d                          | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.integrationsserver.c6gd          | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d           | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd            | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d             | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** data.highstorage    | Instance configuration to be used for a higher disk/memory ratio                                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** data.frozen         | An instance configuration to be used for high storage Elasticsearch frozen data tier nodes                             | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** coordinating        | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** master              | Instance configuration to be used for dedicated masters                                                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** ml                  | Instance configuration to be used for ML instances                                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** kibana              | Instance configuration to be used for Kibana                                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** apm                 | Instance configuration to be used for APM                                                                              | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** integrations.server | Instance configuration to be used for Integrations Server                                                              | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** enterprise.search   | The instance configuration to be used for Elastic Enterprise Search nodes                                              | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="Stockholm (eu-north-1), aws-eu-north-1">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                     |
  |--------------------------------------------------------|---------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose-faster-warm-arm                    | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose-arm                                | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-arm-v7            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-arm-v6            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v11             | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v9              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v10 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v12 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m6gd                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.d2                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.datahot.m6gd                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datacold.d2                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** data.frozen                     | An instance configuration to be used for high storage Elasticsearch frozen data tier nodes                             | 4096, 8192, 16384, 32768, 65536             |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** data.highstorage                | Instance configuration to be used for a higher disk/memory ratio                                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master                          | Instance configuration to be used for dedicated masters                                                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datawarm.d2.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** coordinating                    | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.ml.m6gd                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** ml                              | Instance configuration to be used for ML instances                                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datahot.m6gd.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.datacold.d2.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** kibana                          | Instance configuration to be used for Kibana                                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** apm                             | Instance configuration to be used for APM                                                                              | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** integrations.server             | Instance configuration to be used for Integrations Server                                                              | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** enterprise.search               | The instance configuration to be used for Elastic Enterprise Search nodes                                              | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Milan (eu-south-1), aws-eu-south-1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                     |
  |-----------------------------------------------------|---------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                   | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm                       | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-storage-optimized-dense-faster-warm             | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-general-purpose-faster-warm                     | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v4           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-storage-optimized-v4           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v2           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v3           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v2            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v3            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v4            | Memory Optimized          | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2     | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v2             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v4             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v3             | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-cpu-optimized-v2               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v5               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v4               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v3               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v6               | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5   | CPU optimized faster warm | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-hot-warm-v2                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-hot-warm-v3                    | Hot-Warm Architecture     | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-cross-cluster-search-v2        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-cross-cluster-search-v3        | Cross Cluster Search      | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3 | Enterprise Search         | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-observability                  | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-observability-v2               | Observability             | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-security-v2                    | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-security                       | Security                  | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-io-optimized-v2                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v3                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v4                | I/O Optimized             | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  **Available Instances**

  | Instance ID                                     | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |-------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datawarm.i3en                            | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                            | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.i3en                             | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.m5d                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                               | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datawarm.d2                              | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.es.datahot.c5d                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.coordinating.m5d                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                          | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.master.c5d                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datacold.d2                              | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.kibana.c5d                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.integrationsserver.c5d                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c5d                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2         | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highio.i3             | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1       | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d           | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2         | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ingest.m5d                 | An Elasticsearch ingest instance running on an AWS m5d.                                                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highmem.r5d           | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.d2.1.1         | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c5d.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m5d                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.coordinator.r5d            | An Elasticsearch coordinator instance running on an AWS r5d.                                                           | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2           | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r5d                 | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2        | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.ccs.r5d                    | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1          | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                     | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2               | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2       | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1     | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1       | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.d2.1.1         | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highcpu.m5d           | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.kibana.r5d                 | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                  | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.c5d.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                    | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2   | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d     | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.enterprisesearch.m5d       | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
</dropdown>

<dropdown title="London (eu-west-2), aws-eu-west-2">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                     |
  |--------------------------------------------------------|---------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose-faster-warm-arm                    | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose-arm                                | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-compute-optimized-v5              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v3              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized                 | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v2              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v4              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v2              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v3              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-memory-optimized                  | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v2               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v3               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v5               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-memory-optimized-v4               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v2                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-v3                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-arm-v3            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-arm-v7            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-arm-v6            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-arm-v4            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-general-purpose-arm-v5            | General purpose (ARM)           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v4                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v3                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v2                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v6              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v7              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v3              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v5              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v4              | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v8  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v4  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v6  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v2  | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v10 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v12 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | **(DEPRECATED)** aws-hot-warm-v2                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-hot-warm-v3                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-hot-warm                          | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-hot-warm-v4                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-hot-warm-v5                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                    |
  | **(DEPRECATED)** aws-appsearch-dedicated-v3            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-appsearch-dedicated-v2            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-appsearch-dedicated               | App Search                      | Easily implement powerful search experiences for your website, app, or workplace with refined APIs and tools.                                                                                                                   |
  | **(DEPRECATED)** aws-cross-cluster-search-v2           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-cross-cluster-search              | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-cross-cluster-search-v3           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                   |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v5    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v4    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                      |
  | **(DEPRECATED)** aws-observability-v3                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-observability                     | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-observability-v2                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                          |
  | **(DEPRECATED)** aws-security-v2                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-security                          | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                       |
  | **(DEPRECATED)** aws-io-optimized                      | I/O Optimized                   | Ideal for time-series data, such as logs and metrics.                                                                                                                                                                           |
  | **(DEPRECATED)** aws-io-optimized-v2                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v3                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v4                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  | **(DEPRECATED)** aws-io-optimized-v5                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                            |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m6gd                         | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datacold.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datawarm.d3                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.datahot.m6gd                              | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2          | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d            | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highstorage.i3en       | A storage optimized Elasticsearch instance running on an AWS i3en.                                                     | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.coordinating.m5.2           | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** coordinator                     | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2      | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datawarm.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ingest.m5d                  | An Elasticsearch ingest instance running on an AWS m5d.                                                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** data.highstorage                | Instance configuration to be used for a higher disk/memory ratio                                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** master                          | Instance configuration to be used for dedicated masters                                                                | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.coordinating.m5             | An Elasticsearch coordinating instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highmem.r5d            | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd                  | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highmem.r4             | A memory optimized Elasticsearch instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.ml.m5d                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r4.2                 | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.master.r5d                  | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ingest.m5                   | An Elasticsearch ingest instance running on an AWS m5.                                                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r4                   | An Elasticsearch master eligible instance running on an AWS r4.                                                        | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.ml.m5                       | An Elasticsearch machine learning instance running on an AWS m5.                                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2         | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ccs.r5d                     | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** ingest                          | Instance configuration to be used for dedicated ingest instances                                                       | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** ml                              | Instance configuration to be used for ML instances                                                                     | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.datahot.m6gd.1.1         | General purpose Elasticsearch instances for hot data. Based on AWS’s m6gd family.                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                      | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2                | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datacold.d3.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d3 family.                         | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ccs.r4                      | A cross cluster search optimized Elasticsearch instance running on an AWS r4.                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.data.highio.i3              | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.coordinator.r4              | An Elasticsearch coordinator instance running on an AWS r4.                                                            | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.data.highcpu.m5             | A CPU optimized Elasticsearch instance running on an AWS m5.                                                           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.ml.m6gd.1.1              | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m6gd family.                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m6gd.2.1    | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m6gd family.                     | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highcpu.m5d            | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** kibana                          | Instance configuration to be used for Kibana                                                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                  | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r4                   | A Kibana instance running on an AWS r4.                                                                                | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                   | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.r4.2                    | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                     | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.r4                      | An APM instance running on an AWS r4.                                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r4.2     | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2    | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d      | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.integrationsserver.r4       | An Integrations Server instance running on an AWS r4.                                                                  | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.appsearch.m5                | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.appsearch.m5d               | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.enterprisesearch.m5d        | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Paris (eu-west-3), aws-eu-west-3">
  **Available templates**

  | Template ID                                            | Name                            | Description                                                                                                                                                                                                                                                           |
  |--------------------------------------------------------|---------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                      | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-storage-optimized                                  | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | aws-cpu-optimized                                      | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm                          | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-faster-warm-arm                      | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-cpu-optimized-arm                                  | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | aws-vector-search-optimized-arm                        | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-vector-search-optimized-faster-warm-arm            | Vector search optimized (ARM)   | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
  | aws-storage-optimized-dense-faster-warm                | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-storage-optimized-dense                            | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | aws-general-purpose-faster-warm                        | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | aws-general-purpose                                    | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-compute-optimized-v3              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v2              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-compute-optimized-v4              | Compute Optimized               | Designed for search-heavy workloads.                                                                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-storage-optimized-v4              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v5              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v2              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-v3              | Storage optimized               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
  | **(DEPRECATED)** aws-cpu-optimized-v6                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v12             | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-memory-optimized-v2               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v3               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-memory-optimized-v4               | Memory Optimized                | Best for small data sets and low query loads.                                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-storage-optimized-dense-v3        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v4        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-storage-optimized-dense-v2        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-general-purpose-v2                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v4                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-general-purpose-v3                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-cpu-optimized-v5                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v4                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v3                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-v2                  | CPU optimized                   | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-arm-v10             | CPU optimized (ARM)             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v3      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v6      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v2      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v5      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-v4      | CPU optimized faster warm       | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v11 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-cpu-optimized-faster-warm-arm-v13 | CPU optimized faster warm (ARM) | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
  | **(DEPRECATED)** aws-hot-warm-v2                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-hot-warm-v3                       | Hot-Warm Architecture           | Useful for time-series analytics that benefit from automatic index curation.                                                                                                                                                                                          |
  | **(DEPRECATED)** aws-storage-optimized-dense-v5        | Storage optimized (dense)       | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                                                               |
  | **(DEPRECATED)** aws-appsearch-dedicated-v3            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-appsearch-dedicated-v2            | App Search                      | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-cross-cluster-search-v2           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-cross-cluster-search-v3           | Cross Cluster Search            | Search data across one or more associated remote deployments.                                                                                                                                                                                                         |
  | **(DEPRECATED)** aws-general-purpose-v5                | General purpose                 | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v2    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-enterprise-search-dedicated-v3    | Enterprise Search               | Add a search experience to your website, applications, or search the apps you use at work.                                                                                                                                                                            |
  | **(DEPRECATED)** aws-observability                     | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-observability-v2                  | Observability                   | Use logs, metrics, and APM data to monitor and react to to events in your environment.                                                                                                                                                                                |
  | **(DEPRECATED)** aws-security-v2                       | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-security                          | Security                        | Prevent, detect, and respond to threats with SIEM, endpoint security, and threat hunting.                                                                                                                                                                             |
  | **(DEPRECATED)** aws-io-optimized-v2                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v3                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  | **(DEPRECATED)** aws-io-optimized-v4                   | I/O Optimized                   | Use for for all-purpose workloads, including time-series data like logs and metrics.                                                                                                                                                                                  |
  **Available Instances**

  | Instance ID                                      | Description                                                                                                            | Available Memory Sizes(MBytes)              |
  |--------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|---------------------------------------------|
  | aws.es.datahot.c6gd                              | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3en                              | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.m5d                               | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datahot.i3                                | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | aws.es.datahot.r6gd                              | Vector Search, Generative AI or semantic search applications optimized Elasticsearch instances for hot data.           | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datawarm.i3en                             | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.datawarm.d2                               | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.es.datahot.c5d                               | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.ml.c5d                                    | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | aws.es.datacold.i3en                             | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | aws.es.coordinating.m5d                          | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.master.c6gd                               | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | aws.es.datafrozen.i3en                           | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | aws.es.master.c5d                                | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | aws.es.datacold.d2                               | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | aws.kibana.c6gd                                  | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | aws.kibana.c5d                                   | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | aws.apm.c5d                                      | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.apm.c6gd                                     | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c6gd                      | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | aws.integrationsserver.c5d                       | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | aws.enterprisesearch.c6gd                        | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
  | aws.enterprisesearch.c5d                         | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** aws.coordinating.m5d.2          | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2.1        | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.coordinating.m5d            | An Elasticsearch coordinating instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2       | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.ml.c5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s c5d family.                                 | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** coordinator                     | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.es.master.c6gd.2            | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.i3en.2          | Storage-optimized (dense) Elasticsearch instances for cold data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.ingest.m5d                  | An Elasticsearch ingest instance running on an AWS m5d.                                                                | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.data.highmem.r5d            | A memory optimized Elasticsearch instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datawarm.d2.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for warm data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c5d.2             | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** coordinating                    | Instance configuration to be used for dedicated request coordination instances                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.ml.m5d                   | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.coordinator.r5d             | An Elasticsearch coordinator instance running on an AWS r5d.                                                           | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datahot.c5d.2            | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.master.r5d                  | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360               |
  | **(DEPRECATED)** aws.es.datahot.i3en.1.1         | Storage-optimized (dense) Elasticsearch instances for hot data. Based on AWS’s i3en family.                            | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.coordinating.m5d.2.1     | General purpose Elasticsearch instance serving as a coordinating node. Based on AWS’s m5d family.                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.master.c5d.2.1           | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c5d family.                     | 1024, 2048, 4096, 8192, 17408, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highstorage.d2         | A storage optimized Elasticsearch instance running on an AWS d2.                                                       | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.master.c6gd.2.1          | CPU-optimized Elasticsearch instances serving as master-eligible nodes. Based on AWS’s c6gd family.                    | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.ccs.r5d                     | A cross cluster search optimized Elasticsearch instance running on an AWS r5d.                                         | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.es.datahot.c6gd.1.1         | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c6gd family.                                        | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.i3.1.1           | Storage-optimized Elasticsearch instances for hot data. Based on AWS’s i3 family.                                      | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.ml.m5d                      | An Elasticsearch machine learning instance running on an AWS m5d.                                                      | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.master.r5d.2                | An Elasticsearch master eligible instance running on an AWS r5d.                                                       | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.data.highio.i3              | An I/O optimized Elasticsearch instance running on an AWS i3.                                                          | 1024, 2048, 4096, 8192, 15360, 29696, 59392 |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2        | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datafrozen.i3en.2.1      | Storage-optimized (dense) Elasticsearch instances serving as a cache tier for frozen data. Based on AWS’s i3en family. | 4096, 8192, 15360, 30720, 61440             |
  | **(DEPRECATED)** aws.es.datawarm.i3en.1.1        | Storage-optimized (dense) Elasticsearch instances for warm data. Based on AWS’s i3en family.                           | 2048, 4096, 8192, 15360, 30720, 61440       |
  | **(DEPRECATED)** aws.es.ml.m5d.1.1               | General purpose Elasticsearch instance serving as ML nodes. Based on AWS’s m5d family.                                 | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datacold.d2.1.1          | Storage-optimized (dense HDD) Elasticsearch instances for cold data. Based on AWS’s d2 family.                         | 2048, 4096, 8192, 15360, 29696, 59392       |
  | **(DEPRECATED)** aws.es.datahot.c5d.2.1          | CPU-optimized Elasticsearch instances for hot data. Based on AWS’s c5d family.                                         | 1024, 2048, 4096, 8192, 16384, 32768, 65536 |
  | **(DEPRECATED)** aws.data.highcpu.m5d            | A CPU optimized Elasticsearch instance running on an AWS m5d.                                                          | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.es.datahot.m5d.1.1          | General purpose Elasticsearch instances for hot data. Based on AWS’s m5d family.                                       | 1024, 2048, 4096, 8192, 15360, 30720, 61440 |
  | **(DEPRECATED)** aws.kibana.c6gd.1.1             | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c6gd family.                                           | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.r5d                  | A Kibana instance running on an AWS r5d.                                                                               | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.kibana.c5d.1.1              | CPU-optimized instances serving as Kibana nodes. Based on AWS’s c5d family.                                            | 1024, 2048, 4096, 8192                      |
  | **(DEPRECATED)** aws.apm.r5d.2                   | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.apm.c6gd.2                  | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.apm.c5d.2                   | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.r5d                     | An APM instance running on an AWS r5d.                                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.apm.c5d.2.1                 | CPU-optimized instances serving as APM nodes. Based on AWS’s c5d family.                                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.apm.c6gd.2.1                | CPU-optimized instances serving as APM nodes. Based on AWS’s c6gd family.                                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2.1 | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2.1  | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.c6gd.2   | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c6gd family.                              | 1024, 2048, 4096, 8192, 15360, 30720        |
  | **(DEPRECATED)** aws.integrationsserver.r5d.2    | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192, 15360, 29696   |
  | **(DEPRECATED)** aws.integrationsserver.c5d.2    | CPU-optimized instances serving as Integrations Server nodes. Based on AWS’s c5d family.                               | 1024, 2048, 4096, 8192, 16384, 32768        |
  | **(DEPRECATED)** aws.integrationsserver.r5d      | An Integrations Server instance running on an AWS r5d.                                                                 | 512, 1024, 2048, 4096, 8192                 |
  | **(DEPRECATED)** aws.appsearch.m5d               | A CPU optimized App Search instance.                                                                                   | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c5d.1.1    | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c5d family.                                 | 2048, 4096, 8192, 17408                     |
  | **(DEPRECATED)** enterprise.search               | The instance configuration to be used for Elastic Enterprise Search nodes                                              | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.m5d        | A CPU optimized Elastic Enterprise Search instance.                                                                    | 2048, 4096, 8192                            |
  | **(DEPRECATED)** aws.enterprisesearch.c6gd.1.1   | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS’s c6gd family.                                | 2048, 4096, 8192, 15360                     |
</dropdown>

<dropdown title="Bahrain (me-south-1), aws-me-south-1">
  **Available templates**

  | Template ID                                         | Name                      | Description                                                                                                                                                                                                                     |
  |-----------------------------------------------------|---------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | aws-storage-optimized-faster-warm                   | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-storage-optimized                               | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | aws-cpu-optimized                                   | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-cpu-optimized-faster-warm                       | CPU optimized             | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                |
  | aws-storage-optimized-dense-faster-warm             | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-storage-optimized-dense                         | Storage optimized (dense) | Ideal for ingestion use cases with more than 10 days of data available for fast access. Also good for light search use cases with very large data sets.                                                                         |
  | aws-general-purpose-faster-warm                     | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | aws-general-purpose                                 | General purpose           | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU. |
  | **(DEPRECATED)** aws-compute-optimized-v3           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v2           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-compute-optimized-v4           | Compute Optimized         | Designed for search-heavy workloads.                                                                                                                                                                                            |
  | **(DEPRECATED)** aws-storage-optimized-v4           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                   |
  | **(DEPRECATED)** aws-storage-optimized-v5           | Storage optimized         | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search