﻿---
title: Selecting the right configuration for you on GCP
description: While far from being a comprehensive guide for performance tuning, the following advice is provided for selecting the hot tier instance configuration:...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-gcp-configuration-choose
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Selecting the right configuration for you on GCP
While far from being a comprehensive guide for performance tuning, the following advice is provided for selecting the hot tier instance configuration:

| Deployment template       | Hot data tier instance configuration | Notes                                                                                                                                                                                                                                                                 |
|---------------------------|--------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Storage Optimized         | gcp.es.datahot.n2.68x10x45           | Consider this default configuration for ingest use cases that require ~7-10 days of retention, or for light search use cases that don’t have significant index changes or CPU utilization.                                                                            |
| Storage Optimized (Dense) | gcp.es.datahot.n2.68x10x95           | Consider this dense storage option for ingest use cases that have a longer retention period of the hot tier, or for light search use cases that have a significant catalog size.                                                                                      |
| CPU Optimized             | gcp.es.datahot.n2.68x32x45           | Consider this configuration for ingest use cases that require ~1-4 days of retention, or for heavyweight search use cases that require significant and consistent indexing or high query load.                                                                        |
| Vector Search Optimized   | gcp.es.datahot.n2d.64x8x11           | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
| General Purpose           | gcp.es.datahot.n2.68x16x45           | Consider this configuration for ingest use cases that require ~5-7 days of retention, or for moderate load search use cases that require occasional indexing or medium to high query load.                                                                            |