﻿---
title: Selecting the right configuration for you on Azure
description: While far from being a comprehensive guide for performance tuning, the following advice is provided for selecting the hot tier instance configuration:...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-azure-configuration-choose
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Selecting the right configuration for you on Azure
While far from being a comprehensive guide for performance tuning, the following advice is provided for selecting the hot tier instance configuration:

| Deployment template     | Hot data tier instance configuration | Notes                                                                                                                                                                                                                                                                 |
|-------------------------|--------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Storage Optimized       | azure.es.datahot.edsv4               | Good for most ingestion use cases with 7-10 days of data available for fast access. Also good for light search use cases without heavy indexing or CPU needs.                                                                                                         |
| CPU Optimized           | azure.es.datahot.fsv2                | Suitable for ingestion use cases with 1-4 days of data available for fast access and for search use cases with indexing and querying workloads. Provides the most CPU resources per unit of RAM.                                                                      |
| Vector Search Optimized | azure.es.datahot.lsv3                | Optimized for applications that leverage Vector Search and/or Generative AI. Also the optimal choice for utilizing ELSER for semantic search applications. Broadly suitable for all semantic search, text embedding, image search, and other Vector Search use cases. |
| General Purpose         | azure.es.datahot.ddv4                | Suitable for ingestion use cases with 5-7 days of data available for fast access. Also good for search workloads with less-frequent indexing and medium to high querying loads. Provides a balance of storage, memory, and CPU.                                       |