﻿---
title: VM configurations (FedRAMP Moderate Authorized)
description: For the AWS infrastructure upgrade, we use the default instance type configurations provided by AWS which are unique to them. To make it easy to identify...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-aws-fedramp-moderate-vm-configurations
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# VM configurations (FedRAMP Moderate Authorized)
For the AWS infrastructure upgrade, we use the default instance type configurations provided by AWS which are unique to them.
To make it easy to identify each instance type in AWS, a new common nomenclature is introduced.
For example, Instance ID / SKU: `aws.es.datahot.i3`

|                   |                                                                                                                                                                                                                                                            |
|-------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `aws.*`           | Denotes the cloud provider, AWS in this case with Azure in future cases.                                                                                                                                                                                   |
| `\*.es.datahot.*` | Denotes that this configuration is an Elasticsearch (`es`) cluster component that serves as a data node for hot content. Other options may be `datawarm`, `datacold`, `datafrozen` for data nodes, and `kibana`, `master`, and so on for other components. |
| `*.i3`            | Denotes that this configuration is running on the AWS i3 instance family.                                                                                                                                                                                  |

The configuration naming convention aligns with the [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) intended for each configuration type, replacing prior naming conventions of “highio”, “highcpu”, and so on. The following table details configurations for data nodes.

| Config Name            | Notes                                                                                                                                                                                                                                      |
|------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| aws.es.datahot.i3en    | This is a configuration that is similar to the “aws.data.datahot.i3” config, but with more disk space to allow for longer retention in ingest use cases, or larger catalog in search use cases.                                            |
| aws.es.datahot.m5dn    | General purpose Elasticsearch instances for hot data. Based on AWS's m5dn family.                                                                                                                                                          |
| aws.es.datahot.c7gd    | This is a new configuration that is similar to the “aws.es.datahot.c5n” config but with more disk space and similar RAM:CPU ratios. It is powered by AWS Graviton3 which offers a better price-performance over comparable Intel chipsets. |
| aws.es.datawarm.i3en   | Elasticsearch instances for warm data. Based on AWS's i3en family.                                                                                                                                                                         |
| aws.es.datacold.i3en   | Elasticsearch instances for cold data. Based on AWS's i3en family.                                                                                                                                                                         |
| aws.es.datafrozen.i3en | Elasticsearch instances for frozen data. Based on AWS's i3en family.                                                                                                                                                                       |

For a detailed price list, check the [Elastic Cloud price list](https://console.us-gov-east-1.aws.elastic-cloud.com/cloud-pricing-table?productType=stack_hosted&provider=aws&region=us-gov-east-1). For a detailed specification of the new configurations, check [Elasticsearch Service default provider instance configurations](https://www.elastic.co/docs/reference/cloud/cloud-hosted/aws-default).
In addition to data nodes for storage and search, Elasticsearch nodes also have machine learning nodes, master nodes, and coordinating nodes. Both auxiliary node and application node configurations are based on Elasticsearch data node configuration types shown in the previous table.

| Config Name                | Notes                                                                                     |
|----------------------------|-------------------------------------------------------------------------------------------|
| aws.es.master.c7gd         | CPU-optimized instances serving as Master nodes. Based on AWS's c7gd family.              |
| aws.kibana.c7gd            | CPU-optimized instances serving as Kibana nodes. Based on AWS's c7gd family.              |
| aws.apm.c7gd               | CPU-optimized instances serving as APM nodes. Based on AWS's c7gd family.                 |
| aws.enterprisesearch.c7gd  | CPU-optimized instances serving as Enterprise Search nodes. Based on AWS's c7gd family.   |
| aws.integrationserver.c7gd | CPU-optimized instances serving as Integrations Server nodes. Based on AWS's c7gd family. |
| aws.es.coordinating.m5dn   | General purpose instances serving as Coordinating nodes. Based on AWS's m5dn family.      |
| aws.es.ml.m5dn             | General purpose instances serving as ML nodes. Based on AWS's m5dn family.                |