﻿---
title: Work with Elastic APIs in Elastic Cloud
description: Most Elastic resources can be accessed and managed through RESTful APIs. While the Elastic Cloud API is used to manage your deployments and their components,...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-work
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Work with Elastic APIs in Elastic Cloud
Most Elastic resources can be accessed and managed through RESTful APIs. While the Elastic Cloud API is used to manage your deployments and their components, the Elasticsearch and Kibana APIs provide direct access to your data and your visualizations, respectively.

## Elastic Cloud API

You can use the Elastic Cloud API to manage your deployments and all of the resources associated with them. This includes performing deployment CRUD operations, scaling or autoscaling resources, and managing network security, deployment extensions, remote clusters, and Elastic Stack versions. You can also access cost data by deployment and by organization.
To learn more about the Elastic Cloud API, read through the [API overview](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-restful), try out some [getting started examples](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-examples), and check our [API reference documentation](https://www.elastic.co/docs/api/doc/cloud/).
Calls to the Elastic Cloud API are subject to [rate limiting](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-rate-limiting).

## Elasticsearch APIs

This set of APIs allows you to interact directly with the Elasticsearch nodes in your deployment. You can ingest data, run search queries, check the health of your clusters, manage snapshots, and more.
To use these APIs in Elastic Cloud read our topic [Access the Elasticsearch API console](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-console), and to learn about all of the available endpoints check the [Elasticsearch API reference documentation](https://www.elastic.co/docs/api/doc/elasticsearch/).
Some [restrictions](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/restrictions-known-problems#ec-restrictions-apis-elasticsearch) apply when using the Elasticsearch APIs in Elastic Cloud.

## Kibana APIs

Many Kibana features can be accessed through these APIs, including Kibana objects, patterns, and dashboards, as well as user roles and user sessions. You can use these APIs to configure alerts and actions, and to access health details for the Kibana Task Manager.
The Kibana APIs cannot be accessed directly from the Elastic Cloud console; you need to use `curl` or another HTTP tool to connect. Check the [Kibana API reference documentation](https://www.elastic.co/docs/api/doc/kibana/) to learn about using the APIs and for details about all available endpoints.
Some [restrictions](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/restrictions-known-problems#ec-restrictions-apis) apply when using these APIs with an Elastic Cloud Kibana instance as compared to an on-prem installation.

## Other Products

Most other Elastic products have APIs to support machine-to-machine operations. You can find the documentation for these at the following links:
- [APM event intake API Reference](https://www.elastic.co/docs/solutions/observability/apm/elastic-apm-events-intake-api)
- [App Search API Reference](https://www.elastic.co/guide/en/app-search/current/api-reference.html)
- [Enterprise Search management APIs](https://www.elastic.co/guide/en/enterprise-search/current/management-apis.html)
- [Logstash APIs](https://www.elastic.co/docs/api/doc/logstash/)
- [Workplace Search API Reference](https://www.elastic.co/guide/en/workplace-search/current/workplace-search-api-overview.html)