﻿---
title: Elastic Cloud RESTful API
description: A RESTful API is available with Elastic Cloud, allowing you to perform most of the operations available in the UI console through API calls. You can create...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-restful
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Elastic Cloud RESTful API
A RESTful API is available with Elastic Cloud, allowing you to perform most of the operations available in the UI console through API calls.
You can [create an API key](https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-api-keys) to quickly and easily authenticate, and then use the API to create and manage deployments, configure remote clusters, set up network security, manage extensions, and much more.
**Use the API endpoint applicable to your deployment:**
- The Elastic Cloud API is available from its base URL at `api.elastic-cloud.com`
- The Elastic GovCloud API is available from its base URL at `api.us-gov-east-1.aws.elastic-cloud.com`

This section contains the following information to supplement the [Elastic Cloud](https://www.elastic.co/docs/api/doc/cloud) and [Elastic Cloud Serverless](https://www.elastic.co/docs/api/doc/elastic-cloud-serverless) API reference information:
- [Principles](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-principles) - The basics of how the RESTful API works
- [Access and authentication](https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-api-keys) - How to obtain an API key
- [Rate limiting](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-rate-limiting) - Time limits and quotas for API calls
- [Accessing the API](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-access) - Different methods for you to use the API
- [API examples](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-examples) - Several examples to help you get started

To get started using the Elasticsearch Service API, either directly or through the Elastic Cloud Control (ecctl) CLI, try out this [introductory guide](https://elastic.co/blog/elastic-cloud-elasticsearch-service-api-is-now-ga).

## OpenAPI specification

The Elasticsearch Service API is documented using the OpenAPI specification. The current supported version of the specification is `2.0`. View the documentation at [[https://www.elastic.co/docs/api/doc/cloud](https://www.elastic.co/docs/api/doc/cloud)](https://www.elastic.co/docs/api/doc/cloud).
A machine readable specification is available at [[https://api.elastic-cloud.com/api/v1/api-docs-user/swagger.json](https://api.elastic-cloud.com/api/v1/api-docs-user/swagger.json)](https://api.elastic-cloud.com/api/v1/api-docs-user/swagger.json).
<note>
  When using the API, use `api.elastic-cloud.com` as the host for all endpoints (for example, use `https://api.elastic-cloud.com/api/v1/deployments` and not `https://cloud.elastic.co/api/v1/deployments`).
</note>