﻿---
title: Elastic Cloud API principles
description: The Elastic Cloud API is built on REST. This means that: URLs are based on resource IDs.JSON is the data interchange format.Standard HTTP response codes...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-principles
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Elastic Cloud API principles
The Elastic Cloud API is built on REST. This means that:
- URLs are based on resource IDs.
- JSON is the data interchange format.
- Standard HTTP response codes and verbs are used.

RESTful API calls are stateless. Every request that you make happens in isolation from other calls and must include all the information necessary for Elastic Cloud to fulfill the request. API requests return JSON output, which is a format that is machine-readable and works well for automation.
Calls to API endpoints require different request methods, depending on what they do. You use these four request methods to communicate with the Elastic Cloud RESTful API:
- To fetch a resource: `GET`
- To create a new resource: `POST`
- To update an existing resource: `PUT` or `PATCH`
- To delete a resource: `DELETE`