﻿---
title: Organization operations in Elastic Cloud
description: Get information about your Elasticsearch Service organization. Invite members to your Elasticsearch Service organization. View pending invitations to...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-organizations
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Organization operations in Elastic Cloud
## Get information about your organization

Get information about your Elasticsearch Service organization.
```sh
curl -XGET \
-H "Authorization: ApiKey $EC_API_KEY" \
"https://api.elastic-cloud.com/api/v1/organizations"
```


## Invite members to your organization

Invite members to your Elasticsearch Service organization.
```sh
curl -XPOST \
-H 'Content-Type: application/json' \
-H "Authorization: ApiKey $EC_API_KEY" \
"https://api.elastic-cloud.com/api/v1/organizations/$ORGANIZATION_ID/invitations" \
-d '
{
  "emails": [
    "test@test.com" 
  ]
}'
```


## View pending invitations to your organization

View pending invitations to your Elasticsearch Service organization.
```sh
curl -XGET \
-H 'Content-Type: application/json' \
-H "Authorization: ApiKey $EC_API_KEY" \
"https://api.elastic-cloud.com/api/v1/organizations/$ORGANIZATION_ID/invitations"
```


## View members in your organization

View members in your Elasticsearch Service organization.
```sh
curl -XGET \
-H "Authorization: ApiKey $EC_API_KEY" \
"https://api.elastic-cloud.com/api/v1/organizations/$ORGANIZATION_ID/members"
```


## Remove members from your organization

Remove members from your Elasticsearch Service organization.
```sh
curl -XDELETE \
-H "Authorization: ApiKey $EC_API_KEY" \
"https://api.elastic-cloud.com/api/v1/organizations/$ORGANIZATION_ID/members/$USER_IDS"
```

`USER_IDS`  One or more comma-delimited user ids to remove from the organization