﻿---
title: Changes to index allocation and Elastic Cloud API
description: Starting in Elasticsearch version 7.10, a node_roles field was added to each Elasticsearch element in a deployment plan. The node_roles field is used...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-node-types
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Changes to index allocation and Elastic Cloud API
Starting in Elasticsearch version 7.10, a `node_roles` field was added to each Elasticsearch element in a deployment plan. The `node_roles` field is used in place of the original `node_types` field when you enable a new feature such as autoscaling, or when you add a new warm and cold data tier.
<important>
  This change might affect your index allocation and you need to take certain actions to ensure your index allocation and index lifecycle policies will continue to work as expected. Check [Migrate index allocation filters to node roles](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/migrate-index-allocation-filters-to-node-roles) for instructions.
</important>

**If you use the Deployment API to manage your deployment**, you need to update your integration to support the new `node_roles` field. There are a few important things to note:
- When migrating from `node_type` to `node_roles`, it is not possible to go back to using `node_type`.
- The Elasticsearch topology elements must either all use `node_type` or all use `node_roles`.
- The `node_roles` field is supported only on Elasticsearch version 7.10 and above.
- The deployment templates have been updated to also include other elements (for example, `id`, `node_attributes`, `topology_element_controller`). These elements should also be sent when updating the deployment through the API.

**If you manage your deployment through the UI**, the deployment will automatically update to use the new `node_roles` field when you enable autoscaling or add a warm or cold data tier.