﻿---
title: Elastic Cloud API examples
description: You can use the RESTful API to manage your Elastic Cloud deployments and account. Deployment CRUD operations - Create, read, update and delete operations...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-examples
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Elastic Cloud API examples
You can use the RESTful API to manage your Elastic Cloud deployments and account.
- [Deployment CRUD operations](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-deployment-crud) - Create, read, update and delete operations on a deployment
- [Other deployment operations](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-deployment-other) - Non-CRUD operations, such as restarting or shutting down a deployment
- [Organization operations](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-organizations) - Organization related operations
- [Autoscaling through the API](https://www.elastic.co/docs/deploy-manage/autoscaling/autoscaling-in-ece-and-ech) - Create a deployment with autoscaling enabled
- [Manage network security through the API](https://www.elastic.co/docs/deploy-manage/security/network-security-api) - Create a network security policy, associate it with a deployment.
- [Enable Integrations Server through the API](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/manage-integrations-server#ec-integrations-server-api-example) - Create a deployment with Integrations Service enabled
- [Switch from APM to Integrations Server payload](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/switch-from-apm-to-integrations-server-payload) - Start using Integrations Server while maintaining all APM endpoints and credentials
- [Managing plugins and extensions through the API](https://www.elastic.co/docs/reference/elasticsearch/plugins/cloud/ec-plugins-guide) - Use the API to create, update, and delete your deployment plugins and extensions.

A complete list of available API operations and request/response models are available in the [API reference documentation](https://www.elastic.co/docs/api/doc/cloud).