﻿---
title: Access the Elasticsearch API console in Elastic Cloud
description: Interact with a specific Elasticsearch cluster directly from the Elastic Cloud Console without having to authenticate again. This RESTful API access is...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-console
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Access the Elasticsearch API console in Elastic Cloud
Interact with a specific Elasticsearch cluster directly from the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body) without having to authenticate again. This RESTful API access is limited to the specific cluster and works only for Elasticsearch API calls.
<note>
  API console is intended for admin purposes. Avoid running normal workload like indexing or search request.
</note>

You are unable to make Elasticsearch Service platform changes from the Elasticsearch API.
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Find your deployment on the home page in the Elasticsearch Service card and select **Manage** to access it directly. Or, select **Hosted deployments** to go to the deployments page to view all of your deployments.
   On the deployments page you can narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.
3. From the Elasticsearch menu, go to the **API Console** page.
4. Make a selection from the operation drop-down list and complete the path.
   For example, select `GET`, then use the `_cluster/health?pretty=true` path for cluster status and other pertinent details.
5. If needed, add the body information.
   <tip>
   To display the body area, select PUT, POST, or DELETE from the drop-down list.
   </tip>
6. Select **Submit**.

The results of the API operation are displayed, along with the time it took to complete the operation.
To learn more about what kinds of Elasticsearch API calls you can make from the Cloud UI, check the [Elasticsearch Reference](https://www.elastic.co/docs/reference).