﻿---
title: Access the Elastic Cloud API from the command line
description: You can interact with the full RESTful API for Elastic Cloud directly from the command line through the curl command. To authenticate, you just need to...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-command-line
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Access the Elastic Cloud API from the command line
You can interact with the full RESTful API for Elastic Cloud directly from the command line through the `curl` command. To authenticate, you just need to include your API key in the request header.
For convenience, you can export your API key into your shell environment:
```sh
export EC_API_KEY="YOUR_GENERATED_API_KEY"
```

This example curl command retrieves a list of your Elasticsearch Service deployments:
```sh
curl -H "Authorization: ApiKey $EC_API_KEY" https://api.elastic-cloud.com/api/v1/deployments
```

If this is your first time exploring the API, you can take a look at our [API examples](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-examples) to learn more.