﻿---
title: Access the Elastic Cloud API using a REST application
description: You can interact with the full Elastic Cloud API using a REST client application such as Postman. These steps show how to import the OpenAPI specification...
url: https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-client-app
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Access the Elastic Cloud API using a REST application
You can interact with the full Elastic Cloud API using a REST client application such as [Postman](https://www.postman.com/). These steps show how to import the OpenAPI specification into a client and then run API requests. This can be a convenient alternative to using either a terminal session or the Cloud UI to manage your deployments.
Follow these steps to set up your REST application:
1. If you don’t already have one, create an [API key](https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-api-keys).
2. Run the following `curl` command to download the current API specification:
   ```sh
   curl -o swagger.json https://api.elastic-cloud.com/api/v1/api-docs-user/swagger.json
   ```
3. Visit the [Postman download page](https://www.postman.com/downloads/) and follow the instructions to install the application version that matches your operating system.
4. Open Postman and select **Import**. Then, drag and drop your downloaded `swagger.json` file into the **Upload Files** field.
   ![The Import dialog and Upload Files field in Postman](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app01.png)
5. Leave all settings at the default values and select **Import** to add the API specification as a new collection. Since you’re not saving the document as an API, you can ignore the warning about needing to be signed in.
   ![The Confirm your import window in Postman](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app02.png)
6. Open the `Environments` tab, select **Create a new Environment**, and rename it to `Elastic Cloud API`.
7. Add a variable `hostname` and set it to `api.elastic-cloud.com`.
8. Select **Save** to apply the change. Note that in the following graphic, the **Initial Value** column is hidden for clarity. You need to set only the **Current Value**.
   ![The Environments tab](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app04.png)
9. Open the `Collections` tab, hover over the Elastic Cloud API collection, and select **View more actions** → **Edit**.
10. Under the **Variables** tab:
   1. Set `baseUrl` to `https://api.elastic-cloud.com/api/v1`. Note that if the variable is set by default it may need to be updated to have a trailing `/` character deleted.
2. Any other variables can be deselected.
   ![The Edit Collection window](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app05.png)
11. Under the **Authorization** tab:
   1. Set **Type** to **API Key**.
2. Set **Key** to `Authorization`.
3. Set **Value** to `ApiKey` plus the value of your key, for example `ApiKey V0VtQnEzY0Jpd2l6dk10RW9SeXQ6ajNjSDY2b0FUVldtVHJmTTgxQ2hKQQ==`.
4. Set **Add to** to `Header`.
   ![API Key authorization with Key](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app06.png)
5. Save your settings.

Now that the Postman application has been configured to work with the Elastic Cloud API, you can try a test API request:
1. Make sure that the drop-down box for your environment is set to `Elastic Cloud API`.
   ![Elastic Cloud API environment is selected](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app08.png)
2. Expand the `Elastic Cloud API` collection, scroll to the `deployments` section, and select the `List Deployments` GET request.
   ![The 'List Deployments' GET request in the request collection](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app09.png)
3. Select **Send**.
4. If the request connects successfully, the status pane shows a status of `200 OK` along with the response time and response size. The `Body` tab displays the JSON response from the API.
   ![The status for the submitted request showing '200 OK' and the JSON response](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app10.png)
5. You’ll use part of this JSON response for your next API request. Copy the value of `id` from the `deployments` instance.
   ![The 'id' value in the 'deployments' instance of the JSON response](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app11.png)
6. Expand the `Elastic Cloud API` collection, and under `deployments` → `{deployment id}` choose the `Get Deployment` GET request.
7. Note that the request includes a `deployment_id` path variable.
   ![Details for the Get Deployment request](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app12.png)
8. You can try a test run of the Get Deployment request. The request should fail with a `requested resource could not be found error` because the required `deployment_id` variable is not set.
9. Under **Path Variables**:
   1. Set `deployment_id` to the value for `id` that was returned in the previous `List Deployments` GET request.
   ![Details for the Get Deployment request](https://www.elastic.co/docs/reference/cloud/cloud-hosted/images/ec-rest-app13.png)
10. Select **Send**.
11. If the request connects successfully, the status pane shows a status of `200 OK` and the `Body` tab displays the JSON response from the API, with details about the deployment configuration and its current state.

You can now use all of the other requests available in the collection that you created from the Elastic Cloud OpenAPI specification. To learn more about all of the available API endpoints, check the [API reference](https://www.elastic.co/docs/api/doc/cloud/) and [examples](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-examples).