﻿---
title: Setting up your environment for ECE APIs
description: These examples contain a few variables to help you test in your own environment. These include: You can use an export command to set these variables in...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-setting-up-environment
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Setting up your environment for ECE APIs
These examples contain a few variables to help you test in your own environment. These include:
<definitions>
  <definition term="$ECE_API_KEY">
    The API key used to authenticate API calls on Elastic Cloud Enterprise. For details on generating and using an API key, check [Authenticate using an API key](https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-enterprise-api-keys#ece-api-keys).
  </definition>
  <definition term="$COORDINATOR_HOST">
    The address for the host that holds the coordinator role in your ECE installation. For example, in an AWS environment your coordinator host address would be in a format like `ec2-x-xx-xxx-xx.compute-1.amazonaws.com`.
  </definition>
  <definition term="$DEPLOYMENT_ID">
    The ID used to uniquely identify an ECE deployment. The first [What deployments are there?](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-get-deployments) example shows you how to display the existing deployments and their IDs.
  </definition>
  <definition term="$REF_ID">
    The unique ID for a resource in a deployment. This is first used in our [Checking on progress](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-progress-checking) example.
  </definition>
</definitions>

You can use an `export` command to set these variables in your shell environment, so that you can cut and paste each example into a terminal shell:
```sh
export ECE_API_KEY="YOUR_GENERATED_API_KEY"
export COORDINATOR_HOST="ec2-x-xx-xxx-xx.compute-1.amazonaws.com"
```

<tip>
  These API examples all use HTTPS over port 12443 and run against a host that holds the coordinator role. Using HTTPS requires that you have [a TLS certificate already installed](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates). For testing purposes only, you can specify the `-k` option to turn off certificate verification, as shown in our examples, or use HTTP over port 12400 until you get your TLS certificate sorted out.
</tip>