﻿---
title: ECE API examples: Applying a new deployment configuration to upgrade
description: One of the many useful aspects of an API is that you can automate changes across a large number of deployments. Let’s say you have many deployments that...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-upgrade
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE API examples: Applying a new deployment configuration to upgrade
One of the many useful aspects of an API is that you can automate changes across a large number of deployments. Let’s say you have many deployments that are at a specific version of the Elastic Stack that need to be upgraded to a later release. You can either manually change the version of each deployment through the Cloud UI, or you can automate finding all the deployments at the specific version level and then upgrade them through a script.

## Before you begin

This example requires a deployment with an Elasticsearch cluster to work with that is not being used for anything important. If you don’t already have one, you can follow [our `My First Deployment` example](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-create-deployment) to create one.
Each version of ECE ships with some versions of the Elastic Stack, but you can add new versions as they become available. If you need to add a new version before trying out this example, check [Manage Elastic Stack versions](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-elastic-stack-versions), and then create a new deployment using the selected version. If you’re using environment variables, remember to set `$DEPLOYMENT_ID` to the ID of your new deployment.
You can search for deployments that are at a specific version through the RESTful API or you can iterate over the JSON output from the API to get the list you need, similar to what Step 1 shows.

## Steps

To upgrade a deployment:
1. Use the `_search` endpoint to get a list of the deployments which have Elasticsearch resources that need upgrading. Here, we query for deployments on Elastic Stack version 8.12.0, and we find a deployment `Upgrade Deployment`. To test try this example, you can use the API or the UI to create a deployment on a previous stack version, and then search for it as shown:
   ```sh
   curl -k -X POST -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/_search -H 'content-type: application/json' -d '{
   "query": {
       "nested" : {
           "path" : "resources.elasticsearch",
           "query" : {
               "bool" : {
                   "must" : [{
                       "match" : {"resources.elasticsearch.info.plan_info.current.plan.elasticsearch.version" : { "query" : "8.12.0"}}
                   }]
               }
           }
       }
    },
    "size": 100,
    "sort": [{"metadata.last_modified": { "order": "desc"}}]
   }
   '
   ```
   ```text
   {
     "return_count" : 1,
     "match_count" : 1,
     "deployments" : [
       {
         "id" : "DEPLOYMENT_ID",
         "name" : "Upgrade Deployment",
         "healthy" : true,
         "resources" : {

       ...

             "elasticsearch": {
               "version": "8.12.0"
             },

       ...

   }
   ```
2. For each of the deployments that you want to upgrade, make a PUT request updating the `version` setting (in this case `version` is updated to `8.13.2`). Note that both the `elasticsearch` and `kibana` resources are present in the request:
   ```sh
   curl -k -X PUT -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID -H 'content-type: application/json' -d '
   {
     "prune_orphans": false,
     "resources": {
       "elasticsearch": [
         {
           "region": "ece-region",
           "ref_id": "main-elasticsearch",
           "plan": {
             "cluster_topology": [
               {
                 "id": "hot_content",
                 "node_roles": [
                   "data_hot",
                   "data_content",
                   "master",
                   "ingest",
                   "remote_cluster_client",
                   "transform"
                 ],
                 "zone_count": 1,
                 "elasticsearch": {
                   "enabled_built_in_plugins": [],
                   "node_attributes": {
                     "data": "hot"
                   }
                 },
                 "instance_configuration_id": "data.default",
                 "size": {
                   "value": 4096,
                   "resource": "memory"
                 }
               },
               {
                 "id": "warm",
                 "node_roles": [
                   "data_warm",
                   "remote_cluster_client"
                 ],
                 "zone_count": 1,
                 "elasticsearch": {
                   "enabled_built_in_plugins": [],
                   "node_attributes": {
                     "data": "warm"
                   }
                 },
                 "instance_configuration_id": "data.highstorage",
                 "size": {
                   "value": 0,
                   "resource": "memory"
                 }
               },
               {
                 "id": "cold",
                 "node_roles": [
                   "data_cold",
                   "remote_cluster_client"
                 ],
                 "zone_count": 1,
                 "elasticsearch": {
                   "enabled_built_in_plugins": [],
                   "node_attributes": {
                     "data": "cold"
                   }
                 },
                 "instance_configuration_id": "data.highstorage",
                 "size": {
                   "value": 0,
                   "resource": "memory"
                 }
               },
               {
                 "id": "coordinating",
                 "node_roles": [
                   "ingest",
                   "remote_cluster_client"
                 ],
                 "zone_count": 1,
                 "elasticsearch": {
                   "enabled_built_in_plugins": []
                 },
                 "instance_configuration_id": "coordinating",
                 "size": {
                   "value": 0,
                   "resource": "memory"
                 }
               },
               {
                 "id": "master",
                 "node_roles": [
                   "master",
                   "remote_cluster_client"
                 ],
                 "zone_count": 1,
                 "elasticsearch": {
                   "enabled_built_in_plugins": []
                 },
                 "instance_configuration_id": "master",
                 "size": {
                   "value": 0,
                   "resource": "memory"
                 }
               },
               {
                 "id": "ml",
                 "node_roles": [
                   "ml",
                   "remote_cluster_client"
                 ],
                 "zone_count": 1,
                 "elasticsearch": {
                   "enabled_built_in_plugins": []
                 },
                 "instance_configuration_id": "ml",
                 "size": {
                   "value": 0,
                   "resource": "memory"
                 }
               }
             ],
             "elasticsearch": {
               "version": "8.13.2"
             },
             "deployment_template": {
               "id": "default"
             },
             "autoscaling_enabled": false
           }
         }
       ],
       "kibana": [
         {
           "ref_id": "main-kibana",
           "elasticsearch_cluster_ref_id": "main-elasticsearch",
           "region": "ece-region",
           "plan": {
             "zone_count": 1,
             "cluster_topology": [
               {
                 "instance_configuration_id": "kibana",
                 "size": {
                   "value": 1024,
                   "resource": "memory"
                 },
                 "zone_count": 1
               }
             ],
             "kibana": {
               "version": "8.13.2"
             }
           }
         }
       ]
     }
   }
   '
   ```
   <definitions>
   <definition term="DEPLOYMENT_ID">
   The deployment ID for the deployment that you want to upgrade.
   </definition>
   </definitions>
3. After the upgrade operation completes, the Elasticsearch and Kibana resource will be at version 8.13.2. You can confirm that by running:
   ```json
   curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID
   ```
   ```json
           "elasticsearch" : {
             "version" : "8.13.2"
           },
           ...
           "kibana" : {
             "version" : "8.13.2",
           }
   ```
4. Optional: Repeat Step 1 to verify that there are no more deployments with Elasticsearch resources at the old version that need to be upgraded:
   ```json
   {
     "return_count": 0,
     "match_count": 0,
     "deployments": []
   }
   ```

We recommend keeping all of the components in your deployments at the same version. For that reason, our upgrade example includes both enabled resources: `elasticsearch` and `kibana`. If a deployment includes other resources, such as APM & Fleet, they should also be part of the upgrade request.