﻿---
title: ECE API examples: Remove unwanted deployment templates and instance configurations
description: If you configure the deployment templates in ECE and find that you created instance configurations or deployment templates that you no longer need, you...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-remove-deplopyment-instances-templates
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE API examples: Remove unwanted deployment templates and instance configurations
If you [configure the deployment templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-deployment-templates) in ECE and find that you created instance configurations or deployment templates that you no longer need, you can use these steps to delete them through the RESTful API. Alternatively, you can also use the UI to delete these artifacts.

## Before you begin

Make sure that your deployment template is no longer in use by any deployment. You cannot delete system-owned instance configurations or deployment templates.

## Steps

To remove an instance configuration:
1. List the available instance configurations to find out the ID for the instance configuration you want to delete:
   ```sh
   curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/platform/configuration/instances
   ```
2. Delete the instance configuration using the ID:
   ```sh
   curl -k -X  DELETE -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/platform/configuration/instances/INSTANCE_CONFIGURATION_ID
   ```
   <definitions>
   <definition term="INSTANCE_CONFIGURATION_ID">
   The instance configuration ID as returned by the `instance_configuration_id` field
   </definition>
   </definitions>

To remove a deployment template through the RESTful API:
1. List the available deployment templates to find out the ID:
   ```sh
   curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/platform/configuration/templates/deployments
   ```
2. Delete the deployment templates using the ID:
   ```sh
   curl -k -X DELETE -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/platform/configuration/templates/deployments/DEPLOYMENT_TEMPLATE_ID
   ```
   <definitions>
   <definition term="DEPLOYMENT_TEMPLATE_ID">
   The deployment template ID as returned by the `id` field
   </definition>
   </definitions>