﻿---
title: ECE API examples: Updating a deployment and checking on progress
description: For smaller deployments, changes in the configuration of resources might take only a minute, but larger deployments might take quite a while, especially...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-progress-checking
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE API examples: Updating a deployment and checking on progress
For smaller deployments, changes in the configuration of resources might take only a minute, but larger deployments might take quite a while, especially if data needs to be migrated to new nodes.
Switching to the ECE UI to check on progress is not feasible if you plan to use the RESTful API for automation, so the API also lets you check on the progress of changes when obtaining information about a deployment. Each resource contains an `info` field with the current plan (the current configuration), and potentially pending plans still to be applied.
This information can be obtained by querying the full deployment, as shown:
```sh
curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID
```

To get information about just one of the resources in the deployment, specify its `kind` and `ref_id`:
```sh
curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID/elasticsearch/$REF_ID
```

```text
{
  "ref_id" : "main-elasticsearch",
  "id" : "f6917af4c5504dc9938cea403bda7c44",
  "region" : "ece-region",
  "info" : {
    "cluster_id" : "f6917af4c7506dc9938bfb408bdb3e69",
    "cluster_name" : "My First Deployment",
    "deployment_id" : "$DEPLOYMENT_ID",
    "healthy" : false,
    "status" : "reconfiguring",
    "plan_info" : {
      "healthy" : true,
      "current" : {
        "healthy" : true,
        "plan" : {
    ...
      "pending" : {
        "plan_attempt_id" : "da0a04aa-dd78-43bc-bb8e-d29c8cedbd98",
        "healthy" : true,
        "attempt_start_time" : "2021-08-10T22:18:00.719Z",
        "plan" : {
    ...
  }
}
```

<definitions>
  <definition term="REF_ID">
    The reference ID introduced when creating the resource. In our example, the value of `ref_id` is `main-elasticsearch`.
  </definition>
</definitions>

For each resource, an `info` field contains a `plan_info` field. Inside this object, the `pending` field shows the plan that is currently pending to be applied, in this case the plan from [our previous example](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-resize-ha). After the configuration change completes, the `pending` field is replaced by a `current` field that shows the new configuration.
For long-running changes that might involve large clusters, this "yes" or "no" answer to the question whether there are still pending configuration changes might not always be sufficiently granular. If you need more detailed information, you can also get the activity log returned back to you:
```sh
curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID?show_plan_logs=true
```

```sh
curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID/elasticsearch/$REF_ID?show_plan_logs=true
```

Beware that the activity log can be quite long, as it lists every step in the deployment configuration process. To simplify the output, you can grep on `"message": "Completed step:` to get the highlights of how each step in the plan is getting applied. The output will look similar to this very abridged example:
```sh
"message": "Starting step: [plan-validator]: [cluster=ElasticsearchCluster(1e5675defe924b14af39136bd476fe36), stat=4294980506,4294980506,1544207967588,1544207967588,0,0,0,0,1403,0,4294980506\n]"
...
"message": "Plan successfully constructed: [PlanSuccessful()]"
```