﻿---
title: A first ECE API call: What deployments are there?
description: As a first API call, let’s use a GET request to retrieve information about existing deployments: There are three deployments, security-cluster, logging-and-metrics,...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-get-deployments
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# A first ECE API call: What deployments are there?
As a first API call, let’s use a GET request to retrieve information about existing deployments:
```sh
curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments
```

```json
{
  "deployments" : [
    {
      "id" : "c7d139e789864bf4a6e41819ece19741",
      "name" : "security-cluster",
      "resources" : [
        {
          "ref_id" : "elasticsearch",
          "id" : "c7d139e789864bf4a6e41819ece19741",
          "kind" : "elasticsearch",
          "region" : "ece-region",
          "cloud_id" : "security-cluster:MTkyLjE2OC40NC4xMC5pcC5lcy5pbzo5MjQzJGM3ZDEzOWU3ODk4NjRiZjRhNmU0MTgxOWVjZTE5NzQxJA=="
        }
      ]
    },
    {
      "id" : "93de3a6caf8d4e4c8e66e1127277cead",
      "name" : "logging-and-metrics",
      "resources" : [
        {
          "ref_id" : "elasticsearch",
          "id" : "93de3a6caf8d4e4c8e66e1127277cead",
          "kind" : "elasticsearch",
          "region" : "ece-region",
          "cloud_id" : "logging-and-metrics:MTkyLjE2OC40NC4xMC5pcC5lcy5pbzo5MjQzJDkzZGUzYTZjYWY4ZDRlNGM4ZTY2ZTExMjcyNzdjZWFkJDIwOWE4ZDM4ZGUwNDRmNzhhYjFhMWFlODNiODE2MWY0"
        },
        {
          "ref_id" : "kibana",
          "elasticsearch_cluster_ref_id" : "elasticsearch",
          "id" : "209a8d38de044f78ab1a1ae83b8161f4",
          "kind" : "kibana",
          "region" : "ece-region"
        }
      ]
    },
    {
      "id" : "3e31526f42b74776a3c715e0f5277a5c",
      "name" : "admin-console-elasticsearch",
      "resources" : [
        {
          "ref_id" : "elasticsearch",
          "id" : "3e31526f42b74776a3c715e0f5277a5c",
          "kind" : "elasticsearch",
          "region" : "ece-region",
          "cloud_id" : "admin-console-elasticsearch:MTkyLjE2OC40NC4xMC5pcC5lcy5pbzo5MjQzJDNlMzE1MjZmNDJiNzQ3NzZhM2M3MTVlMGY1Mjc3YTVjJA=="
        }
      ]
    }
  ]
}
```

There are three deployments, `security-cluster`, `logging-and-metrics`, and `admin-console-elasticsearch`, which get created with every installation of Elastic Cloud Enterprise. Take care when modifying these deployments, as they are part of the control plane of ECE. To keep your installation safe, some operations are not allowed on these deployments, but we do recommend that you enable fault tolerance for their Elasticsearch resources and resize them.
In order to obtain more detail about a specific deployment, we can use a GET request using one of the deployment IDs from the previous response (in this example, you could set $DEPLOYMENT_ID to the ID of the `admin-console-elasticsearch` deployment: `3e31526f42b74776a3c715e0f5277a5c`):
```sh
curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID
```

```json
{
  "id" : "3e31526f42b74776a3c715e0f5277a5c",
  "name" : "admin-console-elasticsearch",
  "healthy" : true,
  "resources" : {
    "elasticsearch" : [
      {
        "ref_id" : "elasticsearch",
        "id" : "3e31526f42b74776a3c715e0f5277a5c",
        "region" : "ece-region",
        "info" : {
          "cluster_id" : "3e31526f42b74776a3c715e0f5277a5c",
          "cluster_name" : "admin-console-elasticsearch",
          "deployment_id" : "3e31526f42b74776a3c715e0f5277a5c",
          "healthy" : true,
          "status" : "started",
          "plan_info" : {
            "healthy" : true,
            ...
          },
          "topology": {
            ...
          }
        }
      }
    ]
  },
  "metadata" : {
    "owner_id" : "admin",
    "organization_id" : "platform",
    "system_owned" : true,
    "hidden" : false,
    "last_modified" : "2021-07-28T21:32:47.508Z",
    "last_resource_plan_modified" : "2021-07-28T21:32:09.659Z"
  }
}
```

To simplify things, we’ve omitted some sections from the JSON output.

## A note on terminology

If this is your first time using the ECE API, some of the terminology in the JSON output will likely be unfamiliar. For example, there is a reference to the term “plan” in output fields such as `plan_info`. A plan is just a resource configuration that gets applied to a resource, such as an Elasticsearch cluster or a Kibana instance. When you change an Elasticsearch cluster to resize it, for example, you are applying a new plan.
A deployment is a group of different resources such as Elasticsearch clusters, a Kibana instance, and other products of the Elastic Stack. In the previous example, the `admin-console-elasticsearch` deployment only had an Elasticsearch resource, and the `logging-and-metrics` deployment had both Elasticsearch and Kibana resources.