﻿---
title: ECE API examples: Dipping a toe into platform automation to generate a roles token
description: When you install Elastic Cloud Enterprise on additional hosts, you must specify a valid roles token. This requirement is a security feature designed to...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-generate-roles-token
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE API examples: Dipping a toe into platform automation to generate a roles token
When you install Elastic Cloud Enterprise on additional hosts, you must specify a valid roles token. This requirement is a security feature designed to prevent unauthorized hosts from joining your ECE installation. In this example, we show how you can generate a roles token for allocators and use it to install ECE on an additional host.

## Before you begin

To make it easier to use roles tokens, you automatically get several tokens after installation on the first host. If you revoke these tokens or no longer have access to them, you can use the RESTful API to generate a new token. With the new token, you can install ECE on additional hosts and add the right roles at the same time.
Additional documentation for roles tokens is available, including information on generating ephemeral tokens that expire after a set period. To learn more about how the process works, check [Generate Roles Tokens](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/generate-roles-tokens).

## Steps

To generate a roles token:
1. Create a persistent token that can be used to assign the allocator role to hosts you install ECE on:
   ```sh
   curl -k -H 'Content-Type: application/json' -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/platform/configuration/security/enrollment-tokens -d '{ "persistent": true, "roles": [ "allocator"] }'
   ```
   ```
   {
     "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI3YTRkYjVhMC1kMDViLTQzZjctODRhMy1jZGRiODFmNTI1NGYiLCJyb2xlcyI6WyJhbGxvY2F0b3IiXSwiaXNzIjoiY3VycmVudCIsInBlcnNpc3RlbnQiOnRydWV9.L4jb_2U26IjvxLtVjlYYAjCZDrokd14o9dFOb--9wlQ",
     "token_id": "7a4db5a0-d05b-43f7-84a3-cddb81f5254f"
   }
   ```
   You are shown the new generated token only once, so make sure you keep it somewhere safe.
2. When installing ECE on the additional host, include the token and specify the allocator role:
   ```sh
   bash elastic-cloud-enterprise.sh install --coordinator-host $COORDINATOR_HOST --roles-token 'ROLES_TOKEN' --roles "allocator"
   ```
   <definitions>
   <definition term="ROLES_TOKEN">
   The roles token you generated in Step 1
   </definition>
   </definitions>
3. After installation completes, you can use the new host’s IP address, here `192.168.40.79`, to verify through the RESTful API that the new allocator is available (some output was omitted for brevity):
   ```sh
   curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/platform/infrastructure/allocators
   ```
   ```text
   {
     "zones": [{
       ...
       "zone_id": "ece-region-1b",
       "allocators": [{
         "public_hostname": "192.168.40.79",
         "instances": [],
         "status": {
           "connected": true
         },
         "host_ip": "192.168.40.79",
         "allocator_id": "192.168.40.79",
         "capacity": {
           "memory": {
             "total": 12398,
             "used": 0
           }
         }
       }]
     }]
   }
   ```
   Alternatively, you can also check in the Cloud UI that the new allocator is available.