﻿---
title: ECE API examples: Customize your deployment
description: To meet your unique deployment needs, you can customize your existing deployment by adding more features. This example requires a deployment with an Elasticsearch...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-customize-deployment
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE API examples: Customize your deployment
To meet your unique deployment needs, you can customize your existing deployment by adding more features.

## Before you begin

This example requires a deployment with an Elasticsearch cluster to work with that is not being used for anything important. If you don’t already have one, you can follow [our `My First Deployment` example](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-create-deployment) to create one.

## Steps

1. To add snapshot repository configurations, specify the `snapshot` values:
   ```sh
   "elasticsearch": [{
       ...,
       "settings": {
         "snapshot" : {
              "enabled" : true,
              "interval" : "24",
              "pending_interval" : "24",
              "repository" : {
                 "default" : {},
                 "reference" : {
                    "repository_name" : "my_repository_name"
                 },
                 "static" : {
                    "repository_type" : "S3",
                    "settings" : {}
                 }
              },
              "repository_name" : "my_repository_name",
              "retention" : {
                 "max_age" : "24",
                 "snapshots" : 0
              },
               "wait_time_after_snapshotting" : "10"
            }
         }
      },
      ...
   }]
   ```
2. To add bundles to the deployment template, specify the `user_bundles` values:
   ```sh
   "plan" : {
       ... ,
       "elasticsearch": {
           "user_bundles" : [
             {
                 "elasticsearch_version" : "7.13.3",
                 "name" : "uber_plugin",
                 "url" : "uber_plugin_v1.zip"
             }
           ]
       }
   }
   ```
3. To add specific Elasticsearch plugins, specify the `user_plugins` values:
   ```sh
   "plan" : {
       ... ,
       "elasticsearch": {
           "user_plugins" : [
             {
                 "elasticsearch_version" : "7.13.3",
                 "name" : "repository-azure",
                 "url" : "https://artifacts.elastic.co/downloads/elasticsearch-plugins/repository-azure/repository-azure-6.6.0.zip"
             }
           ]
       }
   }
   ```
4. Apply deployment [logging and monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring):
   ```sh
   "settings": {
       "logging": {
           "destination": {
               "deployment_id": "DESTINATION_DEPLOYMENT_ID",
               "ref_id": `main-elasticsearch`
           }
       },
       "metrics": {
           "destination": {
               "deployment_id": "DESTINATION_DEPLOYMENT_ID",
               "ref_id": `main-elasticsearch`
           }
       }
   }
   ```
   <definitions>
   <definition term="DESTINATION_DEPLOYMENT_ID">
   The deployment ID for `My First Deployment`. The deployment’s logs and metrics will be sent to itself, or they can be sent to a different deployment by specifying that deployment’s ID.
   </definition>
   </definitions>
5. Apply the updated deployment configuration with a PUT request:
   ```sh
   curl -k -X PUT -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID -H 'content-type: application/json' -d '{
       "prune_orphans" : false,
       "resources":{
          "elasticsearch": [{
             "region": "ece-region",
             "ref_id": "main-elasticsearch",
             "plan":{
               ...
                 "elasticsearch":{
                     "version": "7.13.3",
                     "user_plugins" : [],
                     "user_bundles" : [],
                       ...
                 },
                 "deployment_template":{
                     "id": "default"
                 }
             },
             "settings":{
                 ... 
             }
         }]
      },
      "settings": {
          ...
      }
   }'
   ```