﻿---
title: elastic-cloud-enterprise.sh install command
description: NAME bash elastic-cloud-enterprise.sh install — Install Elastic Cloud Enterprise SYNOPSIS REQUIRED PRIVILEGES To run this script, a user must be part...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-installation-script
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# elastic-cloud-enterprise.sh install command
**NAME**
bash elastic-cloud-enterprise.sh install — Install Elastic Cloud Enterprise
**SYNOPSIS**
```sh
bash elastic-cloud-enterprise.sh [install] [--coordinator-host C_HOST_IP]
[--roles-token 'TOKEN'] [--roles "ROLE_LIST"]
[--host-docker-host "PATH_NAME/docker.sock"] [--host-storage-path PATH_NAME]
[--cloud-enterprise-version VERSION_NAME] [--debug]
[--timeout-factor NUMBER]
[--docker-registry REGISTRY] [--ece-docker-repository REPOSITORY] [--overwrite-existing-image]
[--runner-id ID] [--host-ip HOST_IP] [--availability-zone ZONE_NAME]
[--capacity MB_VALUE] [--memory-settings JVM_SETTINGS] [--force] [--podman]
```

**REQUIRED PRIVILEGES**
To run this script, a user must be part of the `docker` group. You must not install Elastic Cloud Enterprise as the `root` user.
**DESCRIPTION**
Installs Elastic Cloud Enterprise according to the specified parameters, both to start a new Elastic Cloud Enterprise installation and to add hosts to an existing installation. Can be used to automate installation or to customize how you install Elastic Cloud Enterprise. The script defaults to this action, if no other action is specified.
**PARAMETERS**
<definitions>
  <definition term="--coordinator-host COORDINATOR_HOST_IP">
    Specifies the IP address of the first host used to start a new Elastic Cloud Enterprise installation. Must be specified together with --roles-token `'TOKEN'` when installing Elastic Cloud Enterprise on additional hosts to add them to an existing installation.
  </definition>
  <definition term="--roles-token 'TOKEN'">
    Specifies a token that enables the host to join an existing Elastic Cloud Enterprise installation. A basic token is provided after installation on the first host. For automation purposes, a [token you generate](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/generate-roles-tokens) with additional role permissions is preferred. Required when --coordinator-host `COORDINATOR_HOST_IP` is also specified.
  </definition>
  <definition term="--roles "ROLE_LIST"">
    Assigns a comma-separated list of roles to the host during installation. The supported roles are `director`, `coordinator`, `allocator`, and `proxy`.
  </definition>
  <definition term="--host-docker-host /PATH_NAME/docker.sock">
    Specifies the location of the Docker socket used to communicate with the Docker daemon. Defaults to /var/run/docker.sock.
  </definition>
  <definition term="--host-storage-path PATH_NAME">
    Specifies the host storage path used by the Elastic Cloud Enterprise installation. Defaults to `/mnt/data/elastic`. **WARNING:** This path cannot be the exact XFS volume mount point, it **must be the subdirectory of it**. By default, the XFS volume should be mounted at `/mnt/data`.
  </definition>
  <definition term="--cloud-enterprise-version VERSION_NAME">
    Specifies the version of Elastic Cloud Enterprise to install. Defaults to `:version:`.
  </definition>
  <definition term="--debug">
    If specified, outputs debugging information.
  </definition>
  <definition term="--timeout-factor NUMBER">
    If specified, increases all timeout values used during installation by multiplying with this number. Defaults to `1.0`.
  </definition>
  <definition term="--docker-registry REGISTRY">
    Specifies the Docker registry from where Elastic Cloud Enterprise assets are retrieved during installation. Defaults to `docker.elastic.co`.
  </definition>
  <definition term="--ece-docker-repository REPOSITORY">
    Specifies the docker repository prefix for Elastic Cloud Enterprise docker image. Defaults to `cloud-enterprise`
  </definition>
  <definition term="--overwrite-existing-image">
    Overwrites any existing local image when retrieving the Elastic Cloud Enterprise installation image from the repository. Defaults to false.
  </definition>
  <definition term="--runner-id ID">
    Assigns an arbitrary ID to the host (runner) that you are installing Elastic Cloud Enterprise on. Runners provide a supervisor service on all nodes and deploy containers based on their role definitions. Using the machine name or IP address can help identify which host the runner ID refers to. Defaults to `host-ip`.
  </definition>
  <definition term="--host-ip HOST_IP">
    Specifies an IP address for the host that you are installing Elastic Cloud Enterprise on. Used for internal communication within the cluster. This must be a routable IP in your network. On AWS, the private IP of the host must be used. In VirtualBox, it is the eth0 inet address of the virtual machine. If a route to the default gateway can be determined, defaults to the IP address for the network interface.1
  </definition>
  <definition term="--availability-zone ZONE_NAME">
    Specifies an availability zone for the host that you are installing Elastic Cloud Enterprise on. Zones are defined by your use case, and although the zone name is arbitrary, it must be identical among all machines in a given zone. For AWS users, the zones are predefined and Elastic recommends a two or three zone deployment. The default zone name is `ece-zone-1`.
  </definition>
  <definition term="--capacity MB_VALUE">
    Specifies the amount of RAM in megabytes this host makes available for Elasticsearch clusters. Must be at least 8192 MB. For future coordinators, set this value relatively low. For future allocators, set this value to the total memory available on the machine minus some memory reserved for Elastic Cloud Enterprise and any other systems running on this host. Defaults to 85% of total RAM if not specified.
  </definition>
  <definition term="--memory-settings JVM_SETTINGS">
    Specifies a custom JVM setting for a service, such as heap size. Settings must be specified in JSON format. Supported services include: `admin-console`, `zookeeper`, `client-forwarder`, `client-observer`, `runner`, `director`, `blueprint`, `constructor`, `allocator`, `services-forwarder`, `beats-runner`, and `cloud-ui`. Note: This has effect only during install of the initial host. Any additional hosts will pull the values for the existing installation and ignore this parameter.
  </definition>
  <definition term="--force">
    Checks the installation requirements, but does not exit the installation process if a check fails. If not specified, a failed installation check causes the installation process to exit.
  </definition>
  <definition term="--podman">
    Flags for installing using podman.
  </definition>
  <definition term="--external-hostname">
    Comma separated list of names to include in the SAN extension of the self generated TLS certificates for HTTP.
  </definition>
</definitions>

1The default value for `host-ip` is passed in by the installation script. If you perform installation through some other method such as Ansible, you must specify a value for `host-ip` or an error is returned.

## Examples

Install Elastic Cloud Enterprise on the first host to start a new installation, using a single combined cURL and bash command:
```
bash <(curl -fsSL https://download.elastic.co/cloud/elastic-cloud-enterprise.sh) install
```

Install Elastic Cloud Enterprise on additional hosts by including the `--coordinator-host` parameter to add them to an existing installation, using a single combined cURL and bash command. No availability zone is specified, so the installer will assign a default zone. The token specified with `--roles-token`is required to enable the host to join the existing Elastic Cloud Enterprise installation.
```
bash <(curl -fsSL https://download.elastic.co/cloud/elastic-cloud-enterprise.sh) install --coordinator-host 192.168.50.10 --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk'
```

Install Elastic Cloud Enterprise on the first host  to start a new installation with additional parameters to set the runner ID, the host IP address, an availability zone, and capacity. The token specified with `--roles-token`is required to enable the host to join the existing Elastic Cloud Enterprise installation.
```
bash <(curl -fsSL https://download.elastic.co/cloud/elastic-cloud-enterprise.sh) install --runner-id runner-1 --host-ip 10.142.0.4 --availability-zone zone-1a --capacity 30000 --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk'
```

Download the script and run it separately to start a new Elastic Cloud Enterprise installation:
```
curl -L -O https://download.elastic.co/cloud/elastic-cloud-enterprise.sh
bash elastic-cloud-enterprise.sh install
```

Install Elastic Cloud Enterprise on nine hosts, placing them into three different availability zones. These steps require that you first download the installation script with `curl -L -O https://download.elastic.co/cloud/elastic-cloud-enterprise.sh` on each host or make it available somewhere on your network. Alternatively, you can modify these commands to download and run the script in one step as shown in some of the other examples.
1. Start your installation by installing Elastic Cloud Enterprise on your first host and specify the runner ID and availability zone:
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.1 --availability-zone zone-1a
   ```
2. Add eight more hosts to the installation and specify a runner ID, availability zone, and the required token, so that you end up with three hosts in each of the availability zones:
   1. Add two more hosts to different availability-zones, here `zone-1b` and `zone-1c`, include the required token, and assign them the `director` and `coordinator` roles (run one of these commands on each host; requires a [generated roles token](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/generate-roles-tokens) with the correct permissions):
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.2 --coordinator-host 10.142.0.4 --availability-zone zone-1b --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk' --roles "director,coordinator"
   ```
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.3 --coordinator-host 10.142.0.4 --availability-zone zone-1c --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk' --roles "director,coordinator"
   ```
2. Add three to six more hosts spread across the availability-zones to handle the Elasticsearch and Kibana workload, include the required token, and assign them the `allocator` role (run one of these commands on each host):
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.4 --coordinator-host 10.142.0.4 --availability-zone zone-1a --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk' --roles "allocator"
   ```
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.5 --coordinator-host 10.142.0.4 --availability-zone zone-1b --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk' --roles "allocator"
   ```
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.6 --coordinator-host 10.142.0.4 --availability-zone zone-1c --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk' --roles "allocator"
   ```
3. Add three more hosts spread across the availability-zones to handle the routing of user requests, include the required token, and assign them the `proxy` role (run one of these commands on each host; requires a [generated roles token](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/generate-roles-tokens) with the correct permissions):
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.7 --coordinator-host 10.142.0.4 --availability-zone zone-1a --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk' --roles "proxy"
   ```
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.8 --coordinator-host 10.142.0.4 --availability-zone zone-1b --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk' --roles "proxy"
   ```
   ```
   bash elastic-cloud-enterprise.sh install --runner-id runner-10.142.0.9 --coordinator-host 10.142.0.4 --availability-zone zone-1c --roles-token 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiI2ZDE2ZDY3YS01NGUzLTQ0MzMtYTlmZC05MTJjYzQwZmIxYmQiLCJyb2xlcyI6W10sImlzcyI6ImN1cnJlbnQiLCJwZXJzaXN0ZW50Ijp0cnVlfQ.MGEpEj0JmUGuucazf55sURNX-Q6QIMhKP0gdNJ2-vnk' --roles "proxy"
   ```
3. If you are using these examples to create your own version of the playbook, some roles need to be removed from the first host that you installed on. To learn more, check [Deploy a large installation](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/deploy-large-installation).

Specify a custom JVM heap size of 1 GB for the `admin-console` service and 512 MB for the `proxy` service when you install Elastic Cloud Enterprise on the first host:
```
bash elastic-cloud-enterprise.sh install  --memory-settings '{"admin-console":{"xmx":"1024M","xms":"1024M"}'
```

Specify custom JVM settings that assign 80% of memory to the `admin-console` service and set heap size to 512 MB for the `proxy` service when you install Elastic Cloud Enterprise on the first host.
```
bash elastic-cloud-enterprise.sh install --memory-settings '{"admin-console":{"percentage":"80"}'
```