﻿---
title: elastic-cloud-enterprise.sh upgrade command
description: NAME bash elastic-cloud-enterprise.sh upgrade — Upgrade an existing Elastic Cloud Enterprise installation to a new version. SYNOPSIS REQUIRED PRIVILEGES...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-installation-script-upgrade
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# elastic-cloud-enterprise.sh upgrade command
**NAME**
bash elastic-cloud-enterprise.sh upgrade — Upgrade an existing Elastic Cloud Enterprise installation to a new version.
**SYNOPSIS**
```sh
bash elastic-cloud-enterprise.sh upgrade
[--host-docker-host "PATH_NAME/docker.sock"]
[--docker-registry REGISTRY] [--ece-docker-repository REPOSITORY]
[--overwrite-existing-image] [--cloud-enterprise-version VERSION_NAME]
[--debug] [--timeout-factor NUMBER]
[--user USER_NAME] [--pass PASSWORD]
[--secrets PATH_TO_SECRETS_FILE]
[--podman]
[[--]help]
```

**REQUIRED PRIVILEGES**
To run this script, a user must be part of the `docker` group. The host that you run this script on must be the first host that you installed Elastic Cloud Enterprise on or a host that holds the director role.
**DESCRIPTION**
Upgrades an existing Elastic Cloud installation to a newer version.
**PARAMETERS**
<definitions>
  <definition term="--host-docker-host /PATH_NAME/docker.sock">
    Specifies the location of the Docker socket used to communicate with the Docker daemon. Defaults to /var/run/docker.sock.
  </definition>
  <definition term="--docker-registry REGISTRY">
    Specifies the Docker registry from where Elastic Cloud Enterprise assets are retrieved during installation. Defaults to `docker.elastic.co`.
  </definition>
  <definition term="--ece-docker-repository REPOSITORY">
    Specifies the docker repository prefix for Elastic Cloud Enterprise docker image. Defaults to `cloud-enterprise`
  </definition>
  <definition term="--overwrite-existing-image">
    Overwrites any existing local image when retrieving the Elastic Cloud Enterprise image from the repository. Defaults to false.
  </definition>
  <definition term="--cloud-enterprise-version VERSION_NAME">
    Specifies the version of Elastic Cloud Enterprise to install. Defaults to `:version:`.
  </definition>
  <definition term="--debug">
    If specified, outputs debugging information.
  </definition>
  <definition term="--timeout-factor NUMBER">
    If specified, increases all timeout values used during installation by multiplying with this number. Defaults to `1.0`.
  </definition>
</definitions>

--user `USER_NAME`
Use the built-in `admin` user.
<definitions>
  <definition term="--pass PASSWORD">
    The password for the `user` specified.
  </definition>
  <definition term="--secrets PATH_TO_SECRETS_FILE">
    An alternative to specifying `user` and `pass`. Specifies a path to a file with secrets. If not specified, attempts to use `HOST_STORAGE_PATH/bootstrap-state/bootstrap-secrets.json`, where `HOST_STORAGE_PATH` is the host storage path used by the Elastic Cloud Enterprise installation.
  </definition>
  <definition term="--podman">
    Use this flag when upgrading ECE installations that use Podman as the container runtime instead of Docker.
  </definition>
</definitions>


## Example

Upgrade an existing Elastic Cloud Enterprise installation to the latest version:
```
bash elastic-cloud-enterprise.sh upgrade --user admin --pass pGX5DwKzVAAIeCIpTwwAkCuJDu0ASdFP33UmYpfogfF
```

Upgrade an existing Elastic Cloud Enterprise installation to a specific version:
```sh
bash elastic-cloud-enterprise.sh upgrade --user admin --pass pGX5DwKzVAAIeCIpTwwAkCuJDu0ASdFP33UmYpfogf --cloud-enterprise-version 3.8.1
```