﻿---
title: elastic-cloud-enterprise.sh reset-adminconsole-password command
description: NAME bash elastic-cloud-enterprise.sh reset-adminconsole-password — Reset administration console user passwords SYNOPSIS REQUIRED PRIVILEGES To run this...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-installation-script-reset
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# elastic-cloud-enterprise.sh reset-adminconsole-password command
**NAME**
bash elastic-cloud-enterprise.sh reset-adminconsole-password — Reset administration console user passwords
**SYNOPSIS**
```sh
bash elastic-cloud-enterprise.sh reset-adminconsole-password
[--host-docker-host "PATH_NAME/docker.sock"]
[--secrets PATH_TO_SECRETS_FILE] [--pwd NEW_PASSWORD] [--user USER_NAME]
[--host-storage-path PATH_NAME] [[--]help]
```

**REQUIRED PRIVILEGES**
To run this script, a user must be part of the `docker` group. The host that you run this script on must be the first host that you installed Elastic Cloud Enterprise on or a host that holds the director role.
**DESCRIPTION**
Resets the password for an administration console user that you use to log into the Cloud UI.
**PARAMETERS**
<definitions>
  <definition term="--host-docker-host /PATH_NAME/docker.sock">
    Specifies the location of the Docker socket used to communicate with the Docker daemon. Defaults to /var/run/docker.sock.
  </definition>
  <definition term="--secrets PATH_TO_SECRETS_FILE">
    Specifies a path to a file with secrets. If not specified, attempts to use `HOST_STORAGE_PATH/bootstrap-state/bootstrap-secrets.json`, where `HOST_STORAGE_PATH` is the host storage path used by the Elastic Cloud Enterprise installation.
  </definition>
  <definition term="--host-storage-path PATH_NAME">
    Specifies the host storage path used by the Elastic Cloud Enterprise installation. Defaults to `/mnt/data/elastic`. Used for determining the default locations of the secrets file and log files. **WARNING:** This path cannot be the exact XFS volume mount point, it **has to be subdirectory of it**. By default, the XFS volume should be mounted at `/mnt/data`.
  </definition>
  <definition term="--user USER_NAME">
    Specifies the user whose password is changed. Defaults to `admin`.
  </definition>
  <definition term="--pwd NEW_PASSWORD">
    Specifies a new password for the user specified. Defaults to generating a new strong password.
  </definition>
</definitions>


## Examples

Reset the password for the user `admin` on the administration console based on the secrets in `/mnt/data/elastic/bootstrap-state/bootstrap-secrets.json`:
```
bash elastic-cloud-enterprise.sh reset-adminconsole-password --user admin
```

Set the password for the user `admin` in the administration console based on the secrets in `/mnt/data/elastic/bootstrap-state/bootstrap-secrets.json`:
```
bash elastic-cloud-enterprise.sh reset-adminconsole-password --user admin --pwd NEW_PASSWORD
```

Reset the password for the read-only user `readonly` on the administration console based on the secrets file in a specified location:
```
bash elastic-cloud-enterprise.sh reset-adminconsole-password --secrets /data/secrets/boostrap-secrets.json --user readonly
```

Specifies the password for the default user (`admin`) on the administration console if the secrets file `/mnt/data/elastic/bootstrap-state/bootstrap-secrets.json` does not exist:
```
bash elastic-cloud-enterprise.sh reset-adminconsole-password
```