﻿---
title: elastic-cloud-enterprise.sh add-stack-version commmand
description: NAME bash elastic-cloud-enterprise.sh add-stack-version — Make a new Elastic Stack version available SYNOPSIS REQUIRED PRIVILEGES To run this script,...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-installation-script-add-stacks
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# elastic-cloud-enterprise.sh add-stack-version commmand
**NAME**
bash elastic-cloud-enterprise.sh add-stack-version — Make a new Elastic Stack version available
**SYNOPSIS**
```sh
bash elastic-cloud-enterprise.sh add-stack-version
[--host-docker-host "PATH_NAME/docker.sock"] [--secrets PATH_TO_SECRETS_FILE]
[--pass PASSWORD] [--user USER_NAME]
[--version X.Y.Z] [[--]help]
```

**REQUIRED PRIVILEGES**
To run this script, a user must be part of the `docker` group. The host that you run this script on must be a part of an existing Elastic Cloud Enterprise installation.
**DESCRIPTION**
Downloads and adds a new Elastic Stack version from Elastic and makes it available on your Elastic Cloud Enterprise installation.
**PARAMETERS**
<definitions>
  <definition term="--host-docker-host /PATH_NAME/docker.sock">
    Specifies the location of the Docker socket used to communicate with the Docker daemon. Defaults to /var/run/docker.sock.
  </definition>
  <definition term="--secrets PATH_TO_SECRETS_FILE">
    Alternate method to specifying `user` and `pass`. Specifies a path to a file with secrets. If not specified, attempts to use `HOST_STORAGE_PATH/bootstrap-state/bootstrap-secrets.json`, where `HOST_STORAGE_PATH` is the host storage path used by the Elastic Cloud Enterprise installation.
  </definition>
  <definition term="--user USER_NAME">
    A user with the `Platform admin` role. The `admin` user created during installation or one of the native users with the `Platform admin` role is sufficient.
  </definition>
  <definition term="--pass PASSWORD">
    The password for the specified user.
  </definition>
  <definition term="--version X.Y.Z">
    Specifies a supported Elastic Stack version, where `Z` is the major version, `Y` is the minor version, and `Z` is the patch level (`8.12.2`, for example).
  </definition>
</definitions>


## Example

Add the Elastic Stack version 8.12.2 to an existing Elastic Cloud Enterprise installation:
```
bash elastic-cloud-enterprise.sh add-stack-version --version 8.12.2 --user admin --pass pGX5DwKzVAAIeCIpTwwAkCuJDu0ASdFP33UmYpfogfF
```