﻿---
title: Create an ECE API client
description: You can build an API client in the language of your choice or use your favorite OpenAPI-enabled development tool. You can obtain the RESTful API specification...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-api-generate-client
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Create an ECE API client
You can build an API client in the language of your choice or use your favorite OpenAPI-enabled development tool.
You can obtain the RESTful API specification directly from Elastic Cloud Enterprise:
```sh
curl -k -X GET -H "Authorization: Bearer TOKEN" https://$COORDINATOR_HOST:12443/api/v1/api-docs/swagger.json
```

<definitions>
  <definition term="TOKEN">
    A token for a user with sufficient privileges, such as the `admin` user.
  </definition>
</definitions>

We use the OpenAPI specification to generate our own API Reference, but you can also use it for automation and to develop your own software layer around Elastic Cloud Enterprise. For example, you can use the API specification in the [Swagger Editor](https://editor.swagger.io) to read through our reference content and to generate a client in many different languages.
To learn more, check [Generating an Elastic Cloud Enterprise Client](https://www.elastic.co/blog/generating-an-elastic-cloud-enterprise-client).