﻿---
title: Access the ECE API from the command line
description: You can interact with the full RESTful API for Elastic Cloud Enterprise directly from the command line through the curl command. When you use the command...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-api-command-line
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Access the ECE API from the command line
You can interact with the full RESTful API for Elastic Cloud Enterprise directly from the command line through the `curl` command. When you use the command line to interact with the API, two authentication methods are available: key-based and token-based.
<definitions>
  <definition term="Using an API key">
    You can [generate an API key](https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-enterprise-api-keys#ece-api-keys) from the ECE UI, and then specify that key in the header of your API calls. This method has the advantage that, once set, the API key lasts indefinitely.
    Once you’ve generated your API key, you need to include it in an HTTP "Authentication" header when making API requests:
    ```sh
    curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments
    ```
    <note>
      Our API examples use the HTTPS protocol, which requires that you have a [TLS certificate already installed](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates). For testing purposes only, you can specify the `-k` option to turn off certificate verification, as shown in our examples, or use HTTP over port 12400 until you get your TLS certificate sorted out.
    </note>
  </definition>
  <definition term="Using a bearer token">
    You can also authenticate using a temporary bearer token. First, follow the steps to [generate a bearer token](https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-enterprise-api-keys#ece-restful-api-authentication-token).
    You then need to include this token in an HTTP "Authentication" header when making API requests:
    ```sh
    curl -k -X GET -H "Authorization: Bearer $TOKEN" https://$COORDINATOR_HOST:12443/api/v1/deployments
    ```
    Tokens have a short life span, so you should not save them for the long term, and should expect to handle HTTP responses that indicate that you need to reauthenticate e.g. 401.
  </definition>
</definitions>

If this is your first time exploring the API, you can take a look at our [API examples](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/api-examples) to learn more.