﻿---
title: Access the ECE API using a REST application
description: You can interact with the full Elastic Cloud Enterprise API using a REST client application such as Postman. These steps show how to import the ECE OpenAPI...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-api-client-app
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Access the ECE API using a REST application
You can interact with the full Elastic Cloud Enterprise API using a REST client application such as [Postman](https://www.postman.com/). These steps show how to import the ECE OpenAPI specification into a client and then run API requests. This can be a convenient alternative to using either  a terminal session or the Cloud UI to manage your deployments and the ECE platform.
Follow these steps to set up your REST application:
1. If you don't already have one, create an [API key](https://www.elastic.co/docs/deploy-manage/api-keys/elastic-cloud-enterprise-api-keys#ece-api-keys). If you are using a built-in account such as `admin`, you can use your account username and password to authenticate instead.
2. Open a terminal and set `$COORDINATOR_HOST` to the address for the host that holds the coordinator role in your ECE installation. For example, in an AWS environment your coordinator host address would be in a format like `ec2-x-xx-xxx-xx.compute-1.amazonaws.com`:
   ```sh
   export COORDINATOR_HOST="ec2-x-xx-xxx-xx.compute-1.amazonaws.com"
   ```
3. Run the following `curl` command to download the current API specification:
   - If you are using an API key:
  ```sh
  curl -o swagger.json  -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/api-docs/swagger.json
  ```
- If you are using a system account such as `admin`:
  ```sh
  curl -o swagger.json -k -u admin:{yourpassword} https://$COORDINATOR_HOST:12443/api/v1/api-docs/swagger.json
  ```
4. Visit the [Postman download page](https://www.postman.com/downloads/) and follow the instructions to install the application version that matches your operating system.
5. Open Postman and select **Import**. Then, drag and drop your downloaded `swagger.json` file into the **Upload Files** field.
   ![The Import dialog and Upload Files field in Postman](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app01.png)
6. Leave all settings at the default values and select **Import** to add the API specification as a new collection. Since you're not saving the document as an API, you can ignore the warning about needing to be signed in.
   ![The Confirm your import window in Postman](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app02.png)
7. Optionally, you can open the contextual menu on the imported collection and rename it to indicate the version level of the collection, for example `Elastic Cloud Enterprise 2.8.0 API`.
   ![The collection renamed to Elastic Cloud Enterprise 2.8.0 API](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app03.png)
8. Open the `Environments` tab, select **Create a new Environment**, and rename it to `ECE API`.
9. Add a variable `hostname` and set the current value to your coordinator host, including the port number. For example, `ec2-54-224-79-64.compute-1.amazonaws.com:12443`.
10. Select **Save** to apply the change. Note that in the following graphic, the **Initial Value** column is hidden for clarity. You need to set only the **Current Value**.
   ![The Environments tab](https://www.elastic.co/docs/reference/cloud/images/cloud-enterprise-ece-rest-app04.png)
11. Open the `Collections` tab, hover over the Elastic Cloud Enterprise collection, and select **View more actions** → **Edit**.
12. Under the **Variables** tab:
   1. Confirm that `baseUrl` is set to `https://{{hostname}}/api/v1/`. This variable should be set by default. Any other variables can be deselected.
   ![The Edit Collection window](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app05.png)
13. Under the **Authorization** tab:
   - If you are using an API key:
  1. Set **Type** to **API Key**.
2. Set **Key** to `Authorization`.
3. Set **Value** to `ApiKey` plus the value of your key, for example `ApiKey V0VtQnEzY0Jpd2l6dk10RW9SeXQ6ajNjSDY2b0FUVldtVHJmTTgxQ2hKQQ==`.
4. Set **Add to** to `Header`.
   ![API Key authorization with Key](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app06.png)
- If you are using a system account such as `admin`:
  1. Set **Type** to **Basic Auth**.
2. Set **Username** to `admin` or your account username.
3. Set **Password** to your account password.
   ![Basic Auth authorization with Username and Password set](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app07.png)
4. Save your settings.

Now that the Postman application has been configured to work with the Elastic Cloud Enterprise API, you can try a test API request:
1. Make sure that the drop-down box for your environment is set to `ECE API`.
   ![ECE API environment is selected](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app08.png)
2. Expand the `Elastic Cloud Enterprise` collection, scroll to the `deployments` section, and choose the `List Deployments` GET request.
   ![The 'List Deployments' GET request in the request collection](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app09.png)
3. Select **Send**.
4. If the request connects successfully, the status pane shows a status of `200 OK` along with the response time and response size. The `Body` tab displays the JSON response from the API.
   ![The status for the submitted request showing '200 OK' and the JSON response](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app10.png)
5. You'll use part of this JSON response for our next API request. Copy the value of `id` from the `deployments` instance.
   ![The 'id' value in the 'deployments' instance of the JSON response](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app11.png)
6. Expand the `Elastic Cloud Enterprise` collection, and under `deployments` → `{deployment id}` choose the `Get Deployment` GET request.
7. Note that the request includes a `deployment_id` path variable.
   ![Details for the Get Deployment request](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app12.png)
8. You can try a test run of the Get Deployment request. The request should fail with a `requested resource could not be found error` because the required `deployment_id` variable is not set.
9. Under **Path Variables**:
   1. Set `deployment_id` to the value for `id` that was returned in the previous `List Deployments` GET request.
   ![Details for the Get Deployment request](https://www.elastic.co/docs/reference/cloud/images/ece-rest-app13.png)
10. Select **Send**.
11. If the request connects successfully, the status pane shows a status of `200 OK` and the `Body` tab displays the JSON response from the API, with details about the deployment configuration and its current state.

You can now use all of the other requests available in the collection that you created from the Elastic Cloud Enterprise OpenAPI specification. To learn more about all of the available API endpoints, check the [API reference](https://www.elastic.co/docs/api/doc/cloud-enterprise) and [examples](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/api-examples).