﻿---
title: ECE 4.0 third party dependencies
description: The following tables list the third-party open source components that Elastic includes with Elastic Cloud Enterprise 4.0, separated into two categories:...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/dependencies-4-0
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available in 4.0
---

# ECE 4.0 third party dependencies
The following tables list the third-party open source components that Elastic includes with Elastic Cloud Enterprise 4.0, separated into two categories:
- [Dependencies of the Docker images used by ECE](#ece-image-dependencies)
- [Dependencies of ECE](#ece-platform-dependencies)


## Dependencies of the Docker images used by ECE

| Library                | Version      | License                                                                                                                                                                 | URL                                       | Optional/Required | Packaged |
|------------------------|--------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------|-------------------|----------|
| PyYAML                 | 6.0.2        | MIT                                                                                                                                                                     | https://pyyaml.org/                       | Required          | Yes      |
| apk-tools              | 2.14.10-r8   | GPL-2.0-only                                                                                                                                                            | N/A                                       | Required          | Yes      |
| argh                   | 0.26.2       | GNU Lesser General Public License (LGPL), Version 3                                                                                                                     | http://github.com/neithere/argh/          | Required          | Yes      |
| args                   | 0.1.0        | BSD                                                                                                                                                                     | https://github.com/kennethreitz/args      | Required          | Yes      |
| bash                   | 5.3-r3       | GPL-3.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| busybox                | 1.37.0-r50   | GPL-2.0-only                                                                                                                                                            | N/A                                       | Required          | Yes      |
| ca-certificates-bundle | 20250619-r6  | MPL-2.0 AND MIT                                                                                                                                                         | N/A                                       | Required          | Yes      |
| certifi                | 2025.10.5    | MPL-2.0                                                                                                                                                                 | https://github.com/certifi/python-certifi | Required          | Yes      |
| chainguard-baselayout  | 20230214-r15 | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| charset-normalizer     | 3.4.4        | MIT                                                                                                                                                                     |                                           | Required          | Yes      |
| clint                  | 0.5.1        | ISC                                                                                                                                                                     | https://github.com/kennethreitz/clint     | Required          | Yes      |
| coreutils              | 9.8-r0       | GPL-3.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| curl                   | 8.16.0-r2    | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| docker                 | 7.1.0        |                                                                                                                                                                         | https://github.com/docker/docker-py       | Required          | Yes      |
| e2fsprogs              | 1.47.3-r1    | GPL-2.0-or-later AND LGPL-2.0-or-later AND BSD-3-Clause AND MIT                                                                                                         | N/A                                       | Required          | Yes      |
| findmnt                | 2.41.2-r0    | GPL-3.0-or-later AND GPL-2.0-or-later AND GPL-2.0-only AND GPL-1.0-only AND LGPL-2.1-or-later AND BSD-1-Clause AND BSD-3-Clause AND BSD-4-Clause-UC AND MIT AND CC-PDDC | N/A                                       | Required          | Yes      |
| fscrypt                | 0.3.5-r10    | Apache-2.0                                                                                                                                                              | N/A                                       | Required          | Yes      |
| glibc                  | 2.42-r1      | LGPL-2.1-or-later                                                                                                                                                       | N/A                                       | Required          | Yes      |
| glibc-locale-posix     | 2.42-r1      | LGPL-2.1-or-later                                                                                                                                                       | N/A                                       | Required          | Yes      |
| grep                   | 3.12-r3      | GPL-3.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| haproxy-3.0            | 3.0.6-r0     | GPL-2.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| icu-libs               | 75.1-r42     | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| idna                   | 3.11         | N/A                                                                                                                                                                     |                                           | Required          | Yes      |
| iproute2               | 6.17.0-r1    | GPL-2.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| iptables               | 1.8.11-r28   | GPL-2.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| jq                     | 1.8.1-r3     | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| ld-linux               | 2.42-r1      | LGPL-2.1-or-later                                                                                                                                                       | N/A                                       | Required          | Yes      |
| less                   | 684-r0       | GPL-3.0-or-later OR BSD-2-Clause                                                                                                                                        | N/A                                       | Required          | Yes      |
| libcap-utils           | 2.76-r6      | BSD-3-Clause OR GPL-2.0-only                                                                                                                                            | N/A                                       | Required          | Yes      |
| libcrypt1              | 2.42-r1      | LGPL-2.1-or-later                                                                                                                                                       | N/A                                       | Required          | Yes      |
| libcrypto3             | 3.6.0-r0     | Apache-2.0                                                                                                                                                              | N/A                                       | Required          | Yes      |
| libgcc                 | 15.2.0-r2    | GPL-3.0-or-later WITH GCC-exception-3.1                                                                                                                                 | N/A                                       | Required          | Yes      |
| libssl3                | 3.6.0-r0     | Apache-2.0                                                                                                                                                              | N/A                                       | Required          | Yes      |
| libxcrypt              | 4.4.38-r4    | GPL-2.0-or-later AND LGPL-2.1-or-later                                                                                                                                  | N/A                                       | Required          | Yes      |
| logrotate              | 3.22.0-r40   | GPL-2.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| net-tools              | 2.10-r30     | GPL-2.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| nodejs-20              | 20.19.5-r0   | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| openjdk-17             | 17.0.16-r4   | GPL-2.0-with-classpath-exception                                                                                                                                        | N/A                                       | Required          | Yes      |
| openjdk-17-default-jdk | 17.0.16-r4   | GPL-2.0-with-classpath-exception                                                                                                                                        | N/A                                       | Required          | Yes      |
| patch                  | 2.8-r3       | GPL-3.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| pathtools              | 0.1.2        | MIT License                                                                                                                                                             | http://github.com/gorakhargosh/pathtools  | Required          | Yes      |
| posix-libc-utils       | 2.42-r1      | LGPL-2.1-or-later                                                                                                                                                       | N/A                                       | Required          | Yes      |
| py3.10-pip             | 25.2-r1      | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| python-3.10            | 3.10.19-r0   | PSF-2.0                                                                                                                                                                 | N/A                                       | Required          | Yes      |
| quota-tools            | 4.10-r1      | GPL-2.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| requests               | 2.32.5       | Apache-2.0                                                                                                                                                              | https://requests.readthedocs.io           | Required          | Yes      |
| runit                  | 2.2.0-r22    | BSD-3-Clause                                                                                                                                                            | N/A                                       | Required          | Yes      |
| shadow                 | 4.18.0-r5    | BSD-3-Clause                                                                                                                                                            | N/A                                       | Required          | Yes      |
| socat                  | 1.8.0.2-r0   | GPL-2.0-only                                                                                                                                                            | N/A                                       | Required          | Yes      |
| stunnel                | 5.75-r2      | GPL-2.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| sudo                   | 1.9.17-r3    | BSD-2-Clause AND BSD-2-Clause-NetBSD AND Zlib AND BSD-3-Clause AND BSD-2-Clause AND ISC                                                                                 | N/A                                       | Required          | Yes      |
| supercronic            | 0.2.38-r0    | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| sysstat                | 12.7.8-r0    | GPL-2.0-or-later                                                                                                                                                        | N/A                                       | Required          | Yes      |
| unzip                  | 6.0-r3       | Info-ZIP                                                                                                                                                                | N/A                                       | Required          | Yes      |
| urllib3                | 2.5.0        | N/A                                                                                                                                                                     |                                           | Required          | Yes      |
| watchdog               | 0.10.0       | Apache License 2.0                                                                                                                                                      | http://github.com/gorakhargosh/watchdog   | Required          | Yes      |
| wget                   | 1.25.0-r6    | GPL-3.0                                                                                                                                                                 | N/A                                       | Required          | Yes      |
| wolfi-base             | 1-r7         | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| wolfi-baselayout       | 20230201-r24 | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| wolfi-keys             | 1-r12        | MIT                                                                                                                                                                     | N/A                                       | Required          | Yes      |
| xfsprogs-extra         | 6.16.0-r0    | LGPL-2.1-or-later                                                                                                                                                       | N/A                                       | Required          | Yes      |
| zlib                   | 1.3.1-r51    | MPL-2.0 AND MIT                                                                                                                                                         | N/A                                       | Required          | Yes      |


## Dependencies of ECE

| Library                                                                       | Version                                   | License                                                                              | URL                                                                                                 | Optional/Required | Packaged |
|-------------------------------------------------------------------------------|-------------------------------------------|--------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------|-------------------|----------|
| algebra                                                                       | 1.5                                       | N/A                                                                                  | N/A                                                                                                 | Required          | Yes      |
| alleycats-core_2.13                                                           | 2.6.1                                     | MIT                                                                                  | https://github.com/typelevel/cats                                                                   | Required          | Yes      |
| ammonite-compiler-interface_2.13.16                                           | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite-compiler_2.13.16                                                     | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite-interp-api_2.13.16                                                   | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite-interp_2.13.16                                                       | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite-repl-api_2.13.16                                                     | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite-repl_2.13.16                                                         | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite-runtime_2.13.16                                                      | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite-terminal_2.13                                                        | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite-util_2.13                                                            | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| ammonite_2.13.16                                                              | 3.0.2                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Ammonite                                                             | Required          | Yes      |
| angus-activation                                                              | 2.0.2                                     | GNU General Public License, version 2 with the GNU Classpath Exception               | https://www.eclipse.org                                                                             | Required          | Yes      |
| animal-sniffer-annotations                                                    | 1.24                                      | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| annotations                                                                   | 4.1.1.4                                   | Apache 2.0                                                                           | http://source.android.com/                                                                          | Required          | Yes      |
| annotations                                                                   | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| aopalliance-repackaged                                                        | 2.6.1                                     | GPL2 w/ CPE                                                                          | http://www.oracle.com                                                                               | Required          | Yes      |
| apache-client                                                                 | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| api-common                                                                    | 2.53.3                                    | BSD-3-Clause                                                                         | N/A                                                                                                 | Required          | Yes      |
| apm-agent-api                                                                 | 1.55.1                                    | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| apm-agent-attach                                                              | 1.55.1                                    | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| arns                                                                          | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| asm                                                                           | 9.7.1                                     | The Apache Software License, Version 2.0                                             | http://asm.ow2.org                                                                                  | Required          | Yes      |
| asm-analysis                                                                  | 9.7.1                                     | The Apache Software License, Version 2.0                                             | http://asm.ow2.org                                                                                  | Required          | Yes      |
| asm-commons                                                                   | 9.7.1                                     | The Apache Software License, Version 2.0                                             | http://asm.ow2.org                                                                                  | Required          | Yes      |
| asm-tree                                                                      | 9.7.1                                     | The Apache Software License, Version 2.0                                             | http://asm.ow2.org                                                                                  | Required          | Yes      |
| asm-util                                                                      | 9.7.1                                     | The Apache Software License, Version 2.0                                             | http://asm.ow2.org                                                                                  | Required          | Yes      |
| audience-annotations                                                          | 0.12.0                                    | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| auth                                                                          | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| auto-value-annotations                                                        | 1.11.0                                    | Apache 2.0                                                                           | https://github.com/google/auto/tree/main/value                                                      | Required          | Yes      |
| aws-core                                                                      | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-java-sdk-core                                                             | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-java-sdk-iam                                                              | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-java-sdk-kms                                                              | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-java-sdk-marketplacedeployment                                            | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-java-sdk-marketplacemeteringservice                                       | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-java-sdk-s3                                                               | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-java-sdk-secretsmanager                                                   | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-java-sdk-sts                                                              | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-query-protocol                                                            | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| aws-xml-protocol                                                              | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| awt-color-factory                                                             | 1.0.1                                     | GNU General Public License, version 2, with the Classpath Exception                  | https://github.com/beryx/awt-color-factory                                                          | Required          | Yes      |
| azure-core                                                                    | 1.56.1                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-core-http-netty                                                         | 1.16.1                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-core-management                                                         | 1.19.1                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-identity                                                                | 1.18.0                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-json                                                                    | 1.5.0                                     | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-keyvault-core                                                           | 1.2.4                                     | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager                                                         | 2.55.0                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-appplatform                                             | 2.51.0                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-appservice                                              | 2.53.4                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-authorization                                           | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-cdn                                                     | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-compute                                                 | 2.54.0                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-containerinstance                                       | 2.53.4                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-containerregistry                                       | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-containerservice                                        | 2.54.1                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-cosmos                                                  | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-dns                                                     | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-eventhubs                                               | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-keyvault                                                | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-monitor                                                 | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-msi                                                     | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-network                                                 | 2.53.4                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-privatedns                                              | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-redis                                                   | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-resources                                               | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-search                                                  | 2.54.2                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-servicebus                                              | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-sql                                                     | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-storage                                                 | 2.54.1                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-resourcemanager-trafficmanager                                          | 2.53.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-security-keyvault-keys                                                  | 4.10.2                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-security-keyvault-secrets                                               | 4.10.3                                    | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-storage                                                                 | 8.6.6                                     | The Apache Software License, Version 2.0                                             | https://github.com/Azure/azure-storage-java                                                         | Required          | Yes      |
| azure-storage-blob                                                            | 12.31.2                                   | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-storage-common                                                          | 12.30.3                                   | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-storage-file-share                                                      | 12.27.3                                   | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-storage-internal-avro                                                   | 12.16.2                                   | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| azure-xml                                                                     | 1.2.0                                     | The MIT License (MIT)                                                                | https://github.com/Azure/azure-sdk-for-java                                                         | Required          | Yes      |
| bcpkix-jdk18on                                                                | 1.79                                      | Bouncy Castle Licence                                                                | https://www.bouncycastle.org/java.html                                                              | Required          | Yes      |
| bcprov-jdk18on                                                                | 1.79                                      | Bouncy Castle Licence                                                                | https://www.bouncycastle.org/java.html                                                              | Required          | Yes      |
| bcutil-jdk18on                                                                | 1.79                                      | Bouncy Castle Licence                                                                | https://www.bouncycastle.org/java.html                                                              | Required          | Yes      |
| big-math                                                                      | 2.0.0                                     | MIT License                                                                          | https://github.com/eobermuhlner/big-math                                                            | Required          | Yes      |
| bsp4j                                                                         | 2.1.1                                     | Apache-2.0                                                                           | https://github.com/build-server-protocol/build-server-protocol                                      | Required          | Yes      |
| caffeine                                                                      | 2.9.3                                     | Apache License, Version 2.0                                                          | https://github.com/ben-manes/caffeine                                                               | Required          | Yes      |
| cats-core_2.13                                                                | 2.13.0                                    | MIT                                                                                  | https://typelevel.org/cats                                                                          | Required          | Yes      |
| cats-kernel_2.13                                                              | 2.13.0                                    | MIT                                                                                  | https://typelevel.org/cats                                                                          | Required          | Yes      |
| checker-qual                                                                  | 3.49.3                                    | The MIT License                                                                      | https://checkerframework.org/                                                                       | Required          | Yes      |
| checksums                                                                     | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| checksums-spi                                                                 | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| chimney-macro-commons_2.13                                                    | 2.0.1                                     | Apache-2.0                                                                           | https://scalaland.io/chimney                                                                        | Required          | Yes      |
| chimney_2.13                                                                  | 1.8.2                                     | Apache-2.0                                                                           | https://scalaland.io/chimney                                                                        | Required          | Yes      |
| circe-core_2.13                                                               | 0.14.14                                   | Apache-2.0                                                                           | https://github.com/circe/circe                                                                      | Required          | Yes      |
| circe-derivation_2.13                                                         | 0.13.0.6                                  | Apache 2.0                                                                           | https://github.com/circe/circe-derivation                                                           | Required          | Yes      |
| circe-generic-extras_2.13                                                     | 0.14.4                                    | Apache-2.0                                                                           | https://github.com/circe/circe-generic-extras                                                       | Required          | Yes      |
| circe-generic_2.13                                                            | 0.14.14                                   | Apache-2.0                                                                           | https://github.com/circe/circe                                                                      | Required          | Yes      |
| circe-jackson28_2.13                                                          | 0.14.2                                    | Apache-2.0                                                                           | https://github.com/circe/circe-jackson                                                              | Required          | Yes      |
| circe-jawn_2.13                                                               | 0.14.14                                   | Apache-2.0                                                                           | https://github.com/circe/circe                                                                      | Required          | Yes      |
| circe-numbers_2.13                                                            | 0.14.14                                   | Apache-2.0                                                                           | https://github.com/circe/circe                                                                      | Required          | Yes      |
| circe-parser_2.13                                                             | 0.14.14                                   | Apache-2.0                                                                           | https://github.com/circe/circe                                                                      | Required          | Yes      |
| class-path-util_2.13                                                          | 0.1.4                                     | Apache-2.0                                                                           | https://github.com/coursier/class-path-util                                                         | Required          | Yes      |
| common_2.13                                                                   | 4.13.1.1                                  | BSD                                                                                  | https://github.com/scalameta/scalameta                                                              | Required          | Yes      |
| commons-beanutils                                                             | 1.11.0                                    | Apache-2.0                                                                           | https://commons.apache.org/proper/commons-beanutils                                                 | Required          | Yes      |
| commons-codec                                                                 | 1.18.0                                    | Apache-2.0                                                                           | https://commons.apache.org/proper/commons-codec/                                                    | Required          | Yes      |
| commons-collections                                                           | 3.2.2                                     | Apache License, Version 2.0                                                          | http://commons.apache.org/collections/                                                              | Required          | Yes      |
| commons-compiler                                                              | 3.0.8                                     | New BSD License                                                                      | N/A                                                                                                 | Required          | Yes      |
| commons-compress                                                              | 1.27.1                                    | Apache-2.0                                                                           | https://commons.apache.org/proper/commons-compress/                                                 | Required          | Yes      |
| commons-digester                                                              | 2.1                                       | The Apache Software License, Version 2.0                                             | http://commons.apache.org/digester/                                                                 | Required          | Yes      |
| commons-io                                                                    | 2.20.0                                    | Apache-2.0                                                                           | https://commons.apache.org/proper/commons-io/                                                       | Required          | Yes      |
| commons-lang3                                                                 | 3.19.0                                    | Apache-2.0                                                                           | https://commons.apache.org/proper/commons-lang/                                                     | Required          | Yes      |
| commons-logging                                                               | 1.3.5                                     | Apache-2.0                                                                           | https://commons.apache.org/proper/commons-logging/                                                  | Required          | Yes      |
| commons-net                                                                   | 3.9.0                                     | Apache License, Version 2.0                                                          | https://commons.apache.org/proper/commons-net/                                                      | Required          | Yes      |
| commons-text                                                                  | 1.14.0                                    | Apache-2.0                                                                           | https://commons.apache.org/proper/commons-text                                                      | Required          | Yes      |
| commons-validator                                                             | 1.10.0                                    | Apache-2.0                                                                           | http://commons.apache.org/proper/commons-validator/                                                 | Required          | Yes      |
| completable-futures                                                           | 0.3.6                                     | The Apache Software License, Version 2.0                                             | https://spotify.github.io/completable-futures                                                       | Required          | Yes      |
| config                                                                        | 1.4.5                                     | Apache-2.0                                                                           | https://github.com/lightbend/config                                                                 | Required          | Yes      |
| conscrypt-openjdk-uber                                                        | 2.5.2                                     | Apache 2                                                                             | https://conscrypt.org/                                                                              | Required          | Yes      |
| crt-core                                                                      | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| cryptacular                                                                   | 1.2.5                                     | GNU Lesser General Public License                                                    | http://www.cryptacular.org                                                                          | Required          | Yes      |
| curator-client                                                                | 5.9.0                                     | The Apache Software License, Version 2.0                                             | https://www.apache.org/                                                                             | Required          | Yes      |
| curator-framework                                                             | 5.9.0                                     | The Apache Software License, Version 2.0                                             | https://www.apache.org/                                                                             | Required          | Yes      |
| curator-recipes                                                               | 5.9.0                                     | The Apache Software License, Version 2.0                                             | https://www.apache.org/                                                                             | Required          | Yes      |
| curator-x-async                                                               | 5.9.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| dependency-interface_2.13                                                     | 0.3.2                                     | BSD-3-Clause                                                                         | https://github.com/coursier/dependency                                                              | Required          | Yes      |
| dependency_2.13                                                               | 0.3.2                                     | BSD-3-Clause                                                                         | https://github.com/coursier/dependency                                                              | Required          | Yes      |
| derive4j-annotation                                                           | 1.1.0                                     | The GNU Lesser General Public License                                                | https://github.com/derive4j/derive4j                                                                | Required          | Yes      |
| detector-resources-support                                                    | 0.33.0                                    | The Apache License, Version 2.0                                                      | https://github.com/GoogleCloudPlatform/opentelemetry-operations-java                                | Required          | Yes      |
| diagnostics                                                                   | 9.3.1                                     | Elastic License                                                                      | http://github.com/elastic/support-diagnostics                                                       | Required          | Yes      |
| dnsjava                                                                       | 3.6.3                                     | BSD-3-Clause;link="https://raw.githubusercontent.com/dnsjava/dnsjava/master/LICENSE" | https://javadoc.io/doc/dnsjava/dnsjava                                                              | Required          | Yes      |
| elasticsearch                                                                 | 7.17.27                                   | Server Side Public License, v 1                                                      | https://github.com/elastic/elasticsearch                                                            | Required          | Yes      |
| elasticsearch-cli                                                             | 7.17.27                                   | Server Side Public License, v 1                                                      | https://github.com/elastic/elasticsearch                                                            | Required          | Yes      |
| elasticsearch-core                                                            | 7.17.27                                   | Server Side Public License, v 1                                                      | https://github.com/elastic/elasticsearch                                                            | Required          | Yes      |
| elasticsearch-geo                                                             | 7.17.27                                   | Server Side Public License, v 1                                                      | https://github.com/elastic/elasticsearch                                                            | Required          | Yes      |
| elasticsearch-lz4                                                             | 7.17.27                                   | Server Side Public License, v 1                                                      | https://github.com/elastic/elasticsearch                                                            | Required          | Yes      |
| elasticsearch-plugin-classloader                                              | 7.17.27                                   | Server Side Public License, v 1                                                      | https://github.com/elastic/elasticsearch                                                            | Required          | Yes      |
| elasticsearch-secure-sm                                                       | 7.17.27                                   | Server Side Public License, v 1                                                      | https://github.com/elastic/elasticsearch                                                            | Required          | Yes      |
| elasticsearch-x-content                                                       | 7.17.27                                   | Server Side Public License, v 1                                                      | https://github.com/elastic/elasticsearch                                                            | Required          | Yes      |
| encode                                                                        | 2.5.6                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| endpoints-spi                                                                 | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| error_prone_annotations                                                       | 2.41.0                                    | Apache 2.0                                                                           | https://errorprone.info/error_prone_annotations                                                     | Required          | Yes      |
| eventstream                                                                   | 1.0.1                                     | Apache License, Version 2.0                                                          | https://github.com/awslabs/aws-eventstream-java                                                     | Required          | Yes      |
| exporter-metrics                                                              | 0.33.0                                    | The Apache License, Version 2.0                                                      | https://github.com/GoogleCloudPlatform/opentelemetry-operations-java                                | Required          | Yes      |
| failsafe                                                                      | 2.4.4                                     | Apache License, Version 2.0                                                          | https://failsafe.dev                                                                                | Required          | Yes      |
| failureaccess                                                                 | 1.0.2                                     | The Apache Software License, Version 2.0                                             | https://github.com/google/guava/                                                                    | Required          | Yes      |
| fansi_2.13                                                                    | 0.5.1                                     | MIT                                                                                  | https://github.com/com-lihaoyi/Fansi                                                                | Required          | Yes      |
| fastparse_2.13                                                                | 3.1.1                                     | MIT                                                                                  | https://github.com/lihaoyi/fastparse                                                                | Required          | Yes      |
| freemarker                                                                    | 2.3.34                                    | Apache License, Version 2.0; see: http://www.apache.org/licenses/LICENSE-2.0.txt     | https://freemarker.apache.org/                                                                      | Required          | Yes      |
| gapic-google-cloud-storage-v2                                                 | 2.58.1                                    | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| gax                                                                           | 2.70.3                                    | BSD-3-Clause                                                                         | N/A                                                                                                 | Required          | Yes      |
| gax-grpc                                                                      | 2.70.3                                    | BSD-3-Clause                                                                         | N/A                                                                                                 | Required          | Yes      |
| gax-httpjson                                                                  | 2.70.3                                    | BSD-3-Clause                                                                         | N/A                                                                                                 | Required          | Yes      |
| geny_2.13                                                                     | 1.1.1                                     | MIT                                                                                  | https://github.com/com-lihaoyi/geny                                                                 | Required          | Yes      |
| google-api-client                                                             | 2.7.2                                     | The Apache Software License, Version 2.0                                             | https://developers.google.com/api-client-library/java/                                              | Required          | Yes      |
| google-api-services-iam                                                       | v1-rev20250905-2.0.0                      | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| google-api-services-storage                                                   | v1-rev20250815-2.0.0                      | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| google-auth-library-credentials                                               | 1.39.1                                    | BSD New license                                                                      | N/A                                                                                                 | Required          | Yes      |
| google-auth-library-oauth2-http                                               | 1.39.0                                    | BSD New license                                                                      | N/A                                                                                                 | Required          | Yes      |
| google-cloud-core                                                             | 2.60.3                                    | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| google-cloud-core-grpc                                                        | 2.60.3                                    | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| google-cloud-core-http                                                        | 2.60.3                                    | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| google-cloud-kms                                                              | 2.78.0                                    | Apache-2.0                                                                           | https://github.com/googleapis/google-cloud-java                                                     | Required          | Yes      |
| google-cloud-monitoring                                                       | 3.52.0                                    | Apache-2.0                                                                           | https://github.com/googleapis/google-cloud-java                                                     | Required          | Yes      |
| google-cloud-storage                                                          | 2.58.1                                    | Apache-2.0                                                                           | https://github.com/googleapis/java-storage                                                          | Required          | Yes      |
| google-http-client                                                            | 1.47.1                                    | The Apache Software License, Version 2.0                                             | https://www.google.com/                                                                             | Required          | Yes      |
| google-http-client-apache-v2                                                  | 1.47.1                                    | The Apache Software License, Version 2.0                                             | https://www.google.com/                                                                             | Required          | Yes      |
| google-http-client-appengine                                                  | 1.47.1                                    | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| google-http-client-gson                                                       | 1.47.1                                    | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| google-http-client-jackson2                                                   | 1.47.1                                    | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| google-oauth-client                                                           | 1.39.0                                    | The Apache Software License, Version 2.0                                             | https://www.google.com/                                                                             | Required          | Yes      |
| grpc-alts                                                                     | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-api                                                                      | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-auth                                                                     | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-context                                                                  | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-core                                                                     | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-google-cloud-storage-v2                                                  | 2.58.1                                    | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| grpc-googleapis                                                               | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-grpclb                                                                   | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-inprocess                                                                | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-netty-shaded                                                             | 1.71.0                                    | Apache License, Version 2.0                                                          | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-opentelemetry                                                            | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-protobuf                                                                 | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-protobuf-lite                                                            | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-rls                                                                      | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-services                                                                 | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-stub                                                                     | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-util                                                                     | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| grpc-xds                                                                      | 1.71.0                                    | Apache 2.0                                                                           | https://github.com/grpc/grpc-java                                                                   | Required          | Yes      |
| gson                                                                          | 2.13.2                                    | Apache-2.0                                                                           | https://github.com/google/gson                                                                      | Required          | Yes      |
| guava                                                                         | 32.1.3-jre                                | Apache License, Version 2.0                                                          | https://github.com/google/guava/                                                                    | Required          | Yes      |
| hamcrest-core                                                                 | 1.3                                       | New BSD License                                                                      | N/A                                                                                                 | Required          | Yes      |
| HdrHistogram                                                                  | 2.2.2                                     | Public Domain, per Creative Commons CC0                                              | http://hdrhistogram.github.io/HdrHistogram/                                                         | Required          | Yes      |
| HikariCP                                                                      | 3.2.0                                     | The Apache Software License, Version 2.0                                             | https://github.com/brettwooldridge/HikariCP                                                         | Required          | Yes      |
| hk2-api                                                                       | 2.6.1                                     | GPL2 w/ CPE                                                                          | http://www.oracle.com                                                                               | Required          | Yes      |
| hk2-locator                                                                   | 2.6.1                                     | GPL2 w/ CPE                                                                          | http://www.oracle.com                                                                               | Required          | Yes      |
| hk2-utils                                                                     | 2.6.1                                     | GPL2 w/ CPE                                                                          | http://www.oracle.com                                                                               | Required          | Yes      |
| hppc                                                                          | 0.8.1                                     | The Apache Software License, Version 2.0                                             | http://www.carrotsearch.com                                                                         | Required          | Yes      |
| http-auth                                                                     | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| http-auth-aws                                                                 | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| http-auth-aws-eventstream                                                     | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| http-auth-spi                                                                 | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| http-client-spi                                                               | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| httpclient                                                                    | 4.5.14                                    | Apache License, Version 2.0                                                          | http://hc.apache.org/httpcomponents-client-ga                                                       | Required          | Yes      |
| httpcore                                                                      | 4.4.16                                    | Apache License, Version 2.0                                                          | http://hc.apache.org/httpcomponents-core-ga                                                         | Required          | Yes      |
| hubspot-style                                                                 | 1.4                                       | N/A                                                                                  | N/A                                                                                                 | Required          | Yes      |
| identity-spi                                                                  | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| immutable-collection-encodings                                                | 1.4                                       | N/A                                                                                  | N/A                                                                                                 | Required          | Yes      |
| immutables-exceptions                                                         | 1.9                                       | N/A                                                                                  | N/A                                                                                                 | Required          | Yes      |
| interface                                                                     | 1.0.28                                    | Apache-2.0                                                                           | https://github.com/coursier/interface                                                               | Required          | Yes      |
| io_2.13                                                                       | 4.13.1.1                                  | BSD                                                                                  | https://github.com/scalameta/scalameta                                                              | Required          | Yes      |
| istack-commons-runtime                                                        | 4.1.2                                     | GNU General Public License, version 2 with the GNU Classpath Exception               | https://www.eclipse.org                                                                             | Required          | Yes      |
| izumi-reflect-thirdparty-boopickle-shaded_2.13                                | 3.0.3                                     | Apache-2.0                                                                           | https://zio.dev                                                                                     | Required          | Yes      |
| izumi-reflect_2.13                                                            | 3.0.3                                     | Apache-2.0                                                                           | https://zio.dev                                                                                     | Required          | Yes      |
| j2objc-annotations                                                            | 3.0.0                                     | Apache License, Version 2.0                                                          | https://github.com/google/j2objc/                                                                   | Required          | Yes      |
| jackson-annotations                                                           | 2.20                                      | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson                                                                | Required          | Yes      |
| jackson-bom                                                                   | 2.20.0                                    | N/A                                                                                  | N/A                                                                                                 | Required          | Yes      |
| jackson-core                                                                  | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-core                                                           | Required          | Yes      |
| jackson-databind                                                              | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson                                                                | Required          | Yes      |
| jackson-dataformat-cbor                                                       | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-dataformats-binary                                             | Required          | Yes      |
| jackson-dataformat-smile                                                      | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-dataformats-binary                                             | Required          | Yes      |
| jackson-dataformat-yaml                                                       | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-dataformats-text                                               | Required          | Yes      |
| jackson-datatype-jdk8                                                         | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-modules-java8/jackson-datatype-jdk8                            | Required          | Yes      |
| jackson-datatype-joda                                                         | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-datatype-joda                                                  | Required          | Yes      |
| jackson-datatype-jsr310                                                       | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-modules-java8/jackson-datatype-jsr310                          | Required          | Yes      |
| jackson-jaxrs-base                                                            | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-jaxrs-providers/jackson-jaxrs-base                             | Required          | Yes      |
| jackson-jaxrs-json-provider                                                   | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-jaxrs-providers/jackson-jaxrs-json-provider                    | Required          | Yes      |
| jackson-module-jaxb-annotations                                               | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-modules-base                                                   | Required          | Yes      |
| jackson-module-scala_2.13                                                     | 2.20.0                                    | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/jackson-module-scala                                                   | Required          | Yes      |
| jakarta.activation-api                                                        | 2.1.3                                     | GNU General Public License, version 2 with the GNU Classpath Exception               | https://www.eclipse.org                                                                             | Required          | Yes      |
| jakarta.annotation-api                                                        | 1.3.5                                     | GPL2 w/ CPE                                                                          | https://www.eclipse.org                                                                             | Required          | Yes      |
| jakarta.inject                                                                | 2.6.1                                     | GPL2 w/ CPE                                                                          | http://www.oracle.com                                                                               | Required          | Yes      |
| jakarta.validation-api                                                        | 2.0.2                                     | GNU General Public License, version 2 with the GNU Classpath Exception               | https://www.eclipse.org                                                                             | Required          | Yes      |
| jakarta.ws.rs-api                                                             | 2.1.6                                     | GPL2 w/ CPE                                                                          | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jakarta.xml.bind-api                                                          | 4.0.2                                     | GNU General Public License, version 2 with the GNU Classpath Exception               | https://www.eclipse.org                                                                             | Required          | Yes      |
| janino                                                                        | 3.0.8                                     | New BSD License                                                                      | N/A                                                                                                 | Required          | Yes      |
| java-diff-utils                                                               | 4.15                                      | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| java-ipv6                                                                     | 0.17                                      | The Apache Software License, Version 2.0                                             | https://github.com/janvanbesien/java-ipv6/                                                          | Required          | Yes      |
| java-support                                                                  | 8.4.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| javaparser-core                                                               | 3.2.12                                    | GNU Lesser General Public License                                                    | N/A                                                                                                 | Required          | Yes      |
| javassist                                                                     | 3.30.2-GA                                 | MPL 1.1                                                                              | https://www.javassist.org/                                                                          | Required          | Yes      |
| javax.activation-api                                                          | 1.2.0                                     | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | http://www.oracle.com                                                                               | Required          | Yes      |
| javax.annotation-api                                                          | 1.3.2                                     | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | https://javaee.github.io/glassfish                                                                  | Required          | Yes      |
| javax.json                                                                    | 1.0.4                                     |                 Dual license consisting of the CDDL v1.1 and GPL v2                  | http://www.oracle.com                                                                               | Required          | Yes      |
| javax.servlet-api                                                             | 3.1.0                                     | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | https://glassfish.dev.java.net                                                                      | Required          | Yes      |
| javax.ws.rs-api                                                               | 2.1                                       | GPL2 w/ CPE                                                                          | http://www.oracle.com/                                                                              | Required          | Yes      |
| jawn-parser_2.13                                                              | 1.6.0                                     | MIT                                                                                  | https://github.com/typelevel/jawn                                                                   | Required          | Yes      |
| jaxb-api                                                                      | 2.3.1                                     | GPL2 w/ CPE                                                                          | http://www.oracle.com/                                                                              | Required          | Yes      |
| jaxb-core                                                                     | 4.0.5                                     | GNU General Public License, version 2 with the GNU Classpath Exception               | https://www.eclipse.org                                                                             | Required          | Yes      |
| jaxb-runtime                                                                  | 4.0.5                                     | GNU General Public License, version 2 with the GNU Classpath Exception               | https://www.eclipse.org                                                                             | Required          | Yes      |
| jBCrypt                                                                       | 0.4.1                                     | ISC/BSD licence                                                                      | http://www.mindrot.org/projects/jBCrypt                                                             | Required          | Yes      |
| jcommander                                                                    | 1.82                                      | Apache License, Version 2.0                                                          | https://jcommander.org                                                                              | Required          | Yes      |
| jersey-client                                                                 | 2.47                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jersey-common                                                                 | 2.47                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jersey-container-jetty-http                                                   | 2.47                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jersey-container-servlet-core                                                 | 2.46                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jersey-entity-filtering                                                       | 2.47                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jersey-hk2                                                                    | 2.47                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jersey-media-json-jackson                                                     | 2.47                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jersey-media-multipart                                                        | 2.46                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jersey-server                                                                 | 2.47                                      | jQuery license                                                                       | https://www.eclipse.org/org/foundation/                                                             | Required          | Yes      |
| jetty-continuation                                                            | 9.4.57.v20241219                          | Eclipse Public License - Version 1.0                                                 | https://jetty.org/                                                                                  | Required          | Yes      |
| jetty-http                                                                    | 9.4.58.v20250814                          | Eclipse Public License - Version 1.0                                                 | https://jetty.org/                                                                                  | Required          | Yes      |
| jetty-io                                                                      | 9.4.58.v20250814                          | Eclipse Public License - Version 1.0                                                 | https://jetty.org/                                                                                  | Required          | Yes      |
| jetty-server                                                                  | 9.4.58.v20250814                          | Eclipse Public License - Version 1.0                                                 | https://jetty.org/                                                                                  | Required          | Yes      |
| jetty-unixsocket                                                              | 9.4.58.v20250814                          | Eclipse Public License - Version 1.0                                                 | https://jetty.org/                                                                                  | Required          | Yes      |
| jetty-util                                                                    | 9.4.58.v20250814                          | Eclipse Public License - Version 1.0                                                 | https://jetty.org/                                                                                  | Required          | Yes      |
| jffi                                                                          | 1.3.13                                    | The Apache Software License, Version 2.0                                             | http://github.com/jnr/jffi                                                                          | Required          | Yes      |
| jinjava                                                                       | 2.8.1                                     | The Apache License, Version 2.0                                                      | https://github.com/HubSpot/jinjava                                                                  | Required          | Yes      |
| jline                                                                         | 2.14.6                                    | The BSD License                                                                      | N/A                                                                                                 | Required          | Yes      |
| jline                                                                         | 3.30.6                                    | The BSD License                                                                      | https://github.com/jline/jline3/jline                                                               | Required          | Yes      |
| jline-reader                                                                  | 3.14.1                                    | The BSD License                                                                      | N/A                                                                                                 | Required          | Yes      |
| jline-terminal                                                                | 3.14.1                                    | The BSD License                                                                      | N/A                                                                                                 | Required          | Yes      |
| jline-terminal-jna                                                            | 3.14.1                                    | The BSD License                                                                      | N/A                                                                                                 | Required          | Yes      |
| jmespath-java                                                                 | 1.12.791                                  | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| jna                                                                           | 5.17.0                                    | LGPL-2.1-or-later                                                                    | https://github.com/java-native-access/jna                                                           | Required          | Yes      |
| jna-platform                                                                  | 5.17.0                                    | LGPL-2.1-or-later                                                                    | https://github.com/java-native-access/jna                                                           | Required          | Yes      |
| jnr-constants                                                                 | 0.10.4                                    | The Apache Software License, Version 2.0                                             | http://github.com/jnr/jnr-constants                                                                 | Required          | Yes      |
| jnr-enxio                                                                     | 0.32.18                                   | The Apache Software License, Version 2.0                                             | http://github.com/jnr/jnr-enxio                                                                     | Required          | Yes      |
| jnr-ffi                                                                       | 2.2.17                                    | The Apache Software License, Version 2.0                                             | http://github.com/jnr/jnr-ffi                                                                       | Required          | Yes      |
| jnr-posix                                                                     | 3.1.20                                    | GNU Lesser General Public License Version 2.1                                        | N/A                                                                                                 | Required          | Yes      |
| jnr-unixsocket                                                                | 0.38.23                                   | The Apache Software License, Version 2.0                                             | http://github.com/jnr/jnr-unixsocket                                                                | Required          | Yes      |
| jnr-x86asm                                                                    | 1.0.2                                     | MIT License                                                                          | http://github.com/jnr/jnr-x86asm                                                                    | Required          | Yes      |
| joda-convert                                                                  | 1.9.2                                     | Apache License, Version 2.0                                                          | http://www.joda.org/joda-convert/                                                                   | Required          | Yes      |
| joda-time                                                                     | 2.14.0                                    | Apache License, Version 2.0                                                          | https://www.joda.org/joda-time/                                                                     | Required          | Yes      |
| jopt-simple                                                                   | 5.0.2                                     | The MIT License                                                                      | http://pholser.github.io/jopt-simple                                                                | Required          | Yes      |
| jsch                                                                          | 2.27.0                                    | Revised BSD                                                                          | https://github.com/mwiede/jsch                                                                      | Required          | Yes      |
| json-utils                                                                    | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| jspecify                                                                      | 1.0.0                                     | The Apache License, Version 2.0                                                      | https://jspecify.dev/docs/start-here                                                                | Required          | Yes      |
| jsr305                                                                        | 1.3.9                                     | The Apache Software License, Version 2.0                                             | http://findbugs.sourceforge.net/                                                                    | Required          | Yes      |
| jul-to-slf4j                                                                  | 2.0.17                                    | MIT                                                                                  | http://www.slf4j.org                                                                                | Required          | Yes      |
| junit                                                                         | 4.13.2                                    | Eclipse Public License 1.0                                                           | http://junit.org                                                                                    | Required          | Yes      |
| junit-4-13_2.13                                                               | 3.2.19.1                                  | Apache-2.0                                                                           | https://github.com/scalatest/scalatestplus-junit                                                    | Required          | Yes      |
| kittens_2.13                                                                  | 2.3.2                                     | Apache 2                                                                             | https://github.com/typelevel/kittens                                                                | Required          | Yes      |
| LatencyUtils                                                                  | 2.0.3                                     | Public Domain, per Creative Commons CC0                                              | http://latencyutils.github.io/LatencyUtils/                                                         | Required          | Yes      |
| launchdarkly-java-server-sdk                                                  | 7.10.2                                    | The Apache License, Version 2.0                                                      | https://github.com/launchdarkly/java-server-sdk                                                     | Required          | Yes      |
| lenses_2.13                                                                   | 0.11.15                                   | Apache 2                                                                             | https://github.com/scalapb/ScalaPB                                                                  | Required          | Yes      |
| libraries-bom                                                                 | 26.48.0                                   | N/A                                                                                  | N/A                                                                                                 | Required          | Yes      |
| listenablefuture                                                              | 9999.0-empty-to-avoid-conflict-with-guava | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| log4j-api                                                                     | 2.25.2                                    | Apache-2.0                                                                           | https://logging.apache.org/log4j/2.x/                                                               | Required          | Yes      |
| log4j-core                                                                    | 2.25.2                                    | Apache-2.0                                                                           | https://logging.apache.org/log4j/2.x/                                                               | Required          | Yes      |
| logback-classic                                                               | 1.5.19                                    | GNU Lesser General Public License                                                    | http://www.qos.ch                                                                                   | Required          | Yes      |
| logback-core                                                                  | 1.5.19                                    | GNU Lesser General Public License                                                    | http://www.qos.ch                                                                                   | Required          | Yes      |
| logstash-logback-encoder                                                      | 7.4                                       | MIT License                                                                          | https://github.com/logfellow/logstash-logback-encoder                                               | Required          | Yes      |
| lucene-analyzers-common                                                       | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-backward-codecs                                                        | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-core                                                                   | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-grouping                                                               | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-highlighter                                                            | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-join                                                                   | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-memory                                                                 | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-misc                                                                   | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-queries                                                                | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-queryparser                                                            | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-sandbox                                                                | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-spatial3d                                                              | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lucene-suggest                                                                | 8.11.3                                    | COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0                       | N/A                                                                                                 | Required          | Yes      |
| lz4-java                                                                      | 1.8.0                                     | The Apache Software License, Version 2.0                                             | https://github.com/lz4/lz4-java                                                                     | Required          | Yes      |
| mainargs_2.13                                                                 | 0.7.6                                     | MIT                                                                                  | https://github.com/com-lihaoyi/mainargs                                                             | Required          | Yes      |
| metrics-core                                                                  | 4.2.37                                    | Apache License 2.0                                                                   | N/A                                                                                                 | Required          | Yes      |
| metrics-healthchecks                                                          | 4.2.37                                    | Apache License 2.0                                                                   | N/A                                                                                                 | Required          | Yes      |
| metrics-json                                                                  | 4.2.37                                    | Apache License 2.0                                                                   | N/A                                                                                                 | Required          | Yes      |
| metrics-jvm                                                                   | 4.2.37                                    | Apache License 2.0                                                                   | N/A                                                                                                 | Required          | Yes      |
| metrics-spi                                                                   | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| micrometer-commons                                                            | 1.15.4                                    | The Apache Software License, Version 2.0                                             | https://github.com/micrometer-metrics/micrometer                                                    | Required          | Yes      |
| micrometer-core                                                               | 1.15.4                                    | The Apache Software License, Version 2.0                                             | https://github.com/micrometer-metrics/micrometer                                                    | Required          | Yes      |
| micrometer-observation                                                        | 1.15.4                                    | The Apache Software License, Version 2.0                                             | https://github.com/micrometer-metrics/micrometer                                                    | Required          | Yes      |
| mimepull                                                                      | 1.9.15                                    | GNU General Public License, version 2 with the GNU Classpath Exception               | https://www.eclipse.org                                                                             | Required          | Yes      |
| msal4j                                                                        | 1.23.1                                    | MIT License                                                                          | https://github.com/AzureAD/microsoft-authentication-library-for-java                                | Required          | Yes      |
| msal4j-persistence-extension                                                  | 1.3.0                                     | MIT License                                                                          | https://github.com/AzureAD/microsoft-authentication-library-for-java                                | Required          | Yes      |
| netty-buffer                                                                  | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec                                                                   | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec-base                                                              | 4.2.5.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec-compression                                                       | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec-dns                                                               | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec-http                                                              | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec-http2                                                             | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec-marshalling                                                       | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec-protobuf                                                          | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-codec-socks                                                             | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-common                                                                  | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-handler                                                                 | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-handler-proxy                                                           | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-nio-client                                                              | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| netty-resolver                                                                | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-resolver-dns                                                            | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-resolver-dns-classes-macos                                              | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-resolver-dns-native-macos                                               | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-tcnative-boringssl-static                                               | 2.0.73.Final                              | The Apache Software License, Version 2.0                                             | https://netty.io/                                                                                   | Required          | Yes      |
| netty-tcnative-classes                                                        | 2.0.73.Final                              | The Apache Software License, Version 2.0                                             | https://netty.io/                                                                                   | Required          | Yes      |
| netty-transport                                                               | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-transport-classes-epoll                                                 | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-transport-classes-kqueue                                                | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-transport-native-epoll                                                  | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-transport-native-kqueue                                                 | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| netty-transport-native-unix-common                                            | 4.2.6.Final                               | Apache License, Version 2.0                                                          | https://netty.io/                                                                                   | Required          | Yes      |
| nimbus-jose-jwt                                                               | 10.5                                      | The Apache Software License, Version 2.0                                             | https://connect2id.com                                                                              | Required          | Yes      |
| opencensus-api                                                                | 0.31.1                                    | The Apache License, Version 2.0                                                      | https://github.com/census-instrumentation/opencensus-java                                           | Required          | Yes      |
| opencensus-contrib-http-util                                                  | 0.31.1                                    | The Apache License, Version 2.0                                                      | https://github.com/census-instrumentation/opencensus-java                                           | Required          | Yes      |
| opensaml-core                                                                 | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-messaging-api                                                        | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-profile-api                                                          | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-saml-api                                                             | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-saml-impl                                                            | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-security-api                                                         | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-security-impl                                                        | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-soap-api                                                             | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-soap-impl                                                            | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-storage-api                                                          | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-xmlsec-api                                                           | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opensaml-xmlsec-impl                                                          | 4.3.0                                     | The Apache Software License, Version 2.0                                             | N/A                                                                                                 | Required          | Yes      |
| opentelemetry-api                                                             | 1.47.0                                    | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java                                                | Required          | Yes      |
| opentelemetry-bom                                                             | 1.42.1                                    | N/A                                                                                  | N/A                                                                                                 | Required          | Yes      |
| opentelemetry-context                                                         | 1.47.0                                    | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java                                                | Required          | Yes      |
| opentelemetry-gcp-resources                                                   | 1.37.0-alpha                              | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java-contrib                                        | Required          | Yes      |
| opentelemetry-sdk                                                             | 1.47.0                                    | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java                                                | Required          | Yes      |
| opentelemetry-sdk-common                                                      | 1.47.0                                    | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java                                                | Required          | Yes      |
| opentelemetry-sdk-extension-autoconfigure-spi                                 | 1.47.0                                    | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java                                                | Required          | Yes      |
| opentelemetry-sdk-logs                                                        | 1.47.0                                    | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java                                                | Required          | Yes      |
| opentelemetry-sdk-metrics                                                     | 1.47.0                                    | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java                                                | Required          | Yes      |
| opentelemetry-sdk-trace                                                       | 1.47.0                                    | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/opentelemetry-java                                                | Required          | Yes      |
| opentelemetry-semconv                                                         | 1.29.0-alpha                              | The Apache License, Version 2.0                                                      | https://github.com/open-telemetry/semantic-conventions-java                                         | Required          | Yes      |
| org.eclipse.lsp4j.generator                                                   | 0.20.1                                    | Eclipse Public License, Version 2.0                                                  | https://github.com/eclipse/lsp4j                                                                    | Required          | Yes      |
| org.eclipse.lsp4j.jsonrpc                                                     | 0.20.1                                    | Eclipse Public License, Version 2.0                                                  | https://github.com/eclipse/lsp4j                                                                    | Required          | Yes      |
| org.eclipse.xtend.lib                                                         | 2.28.0                                    | Eclipse Public License, Version 2.0                                                  | https://www.eclipse.org/Xtext/                                                                      | Required          | Yes      |
| org.eclipse.xtend.lib.macro                                                   | 2.28.0                                    | Eclipse Public License, Version 2.0                                                  | https://www.eclipse.org/Xtext/                                                                      | Required          | Yes      |
| org.eclipse.xtext.xbase.lib                                                   | 2.28.0                                    | Eclipse Public License, Version 2.0                                                  | https://www.eclipse.org/Xtext/                                                                      | Required          | Yes      |
| os-lib_2.13                                                                   | 0.11.3                                    | MIT                                                                                  | https://github.com/com-lihaoyi/os-lib                                                               | Required          | Yes      |
| osgi-resource-locator                                                         | 1.0.3                                     | GPL2 w/ CPE                                                                          | https://www.eclipse.org                                                                             | Required          | Yes      |
| oshi-core                                                                     | 3.13.6                                    | MIT License                                                                          | https://github.com/oshi/oshi/oshi-core                                                              | Required          | Yes      |
| oshi-json                                                                     | 3.13.6                                    | MIT License                                                                          | https://github.com/oshi/oshi/oshi-json                                                              | Required          | Yes      |
| paranamer                                                                     | 2.8.3                                     | BSD                                                                                  | N/A                                                                                                 | Required          | Yes      |
| parboiled-core                                                                | 1.4.1                                     | Apache 2                                                                             | http://parboiled.org                                                                                | Required          | Yes      |
| parboiled_2.13                                                                | 2.5.1                                     | Apache-2.0                                                                           | http://parboiled.org                                                                                | Required          | Yes      |
| parsers_2.13                                                                  | 4.13.1.1                                  | BSD                                                                                  | https://github.com/scalameta/scalameta                                                              | Required          | Yes      |
| pekko-actor_2.13                                                              | 1.2.0                                     | Apache-2.0                                                                           | https://pekko.apache.org/api/pekko/1.2.0                                                            | Required          | Yes      |
| pekko-http-core_2.13                                                          | 1.2.0                                     | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| pekko-http_2.13                                                               | 1.2.0                                     | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| pekko-parsing_2.13                                                            | 1.2.0                                     | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| pekko-protobuf-v3_2.13                                                        | 1.2.0                                     | Apache-2.0                                                                           | https://pekko.apache.org/api/pekko/1.2.0                                                            | Required          | Yes      |
| pekko-slf4j_2.13                                                              | 1.2.0                                     | Apache-2.0                                                                           | https://pekko.apache.org/api/pekko/1.2.0                                                            | Required          | Yes      |
| pekko-stream_2.13                                                             | 1.2.0                                     | Apache-2.0                                                                           | https://pekko.apache.org/api/pekko/1.2.0                                                            | Required          | Yes      |
| perfmark-api                                                                  | 0.27.0                                    | Apache 2.0                                                                           | https://github.com/perfmark/perfmark                                                                | Required          | Yes      |
| postgresql                                                                    | 42.7.7                                    | BSD-2-Clause                                                                         | https://jdbc.postgresql.org/                                                                        | Required          | Yes      |
| pprint_2.13                                                                   | 0.9.3                                     | MIT                                                                                  | https://github.com/com-lihaoyi/PPrint                                                               | Required          | Yes      |
| profiles                                                                      | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| proto-google-cloud-kms-v1                                                     | 0.169.0                                   | Apache-2.0                                                                           | https://github.com/googleapis/google-cloud-java                                                     | Required          | Yes      |
| proto-google-cloud-monitoring-v3                                              | 3.52.0                                    | Apache-2.0                                                                           | https://github.com/googleapis/google-cloud-java                                                     | Required          | Yes      |
| proto-google-cloud-storage-v2                                                 | 2.58.1                                    | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| proto-google-common-protos                                                    | 2.61.3                                    | Apache-2.0                                                                           | https://github.com/googleapis/sdk-platform-java                                                     | Required          | Yes      |
| proto-google-iam-v1                                                           | 1.56.3                                    | Apache-2.0                                                                           | https://github.com/googleapis/sdk-platform-java                                                     | Required          | Yes      |
| protobuf-java                                                                 | 3.25.8                                    | BSD-3-Clause                                                                         | https://developers.google.com/protocol-buffers/                                                     | Required          | Yes      |
| protobuf-java-util                                                            | 3.25.8                                    | BSD-3-Clause                                                                         | https://developers.google.com/protocol-buffers/                                                     | Required          | Yes      |
| protocol-core                                                                 | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| quartz                                                                        | 2.5.0                                     | The Apache License, Version 2.0                                                      | https://www.quartz-scheduler.org/                                                                   | Required          | Yes      |
| quicklens_2.13                                                                | 1.9.12                                    | Apache 2.0                                                                           | http://softwaremill.com/open-source                                                                 | Required          | Yes      |
| re2j                                                                          | 1.8                                       | Go License                                                                           | http://github.com/google/re2j                                                                       | Required          | Yes      |
| reactive-streams                                                              | 1.0.4                                     | MIT-0                                                                                | http://www.reactive-streams.org/                                                                    | Required          | Yes      |
| reactor-core                                                                  | 3.7.9                                     | Apache License, Version 2.0                                                          | https://github.com/reactor/reactor-core                                                             | Required          | Yes      |
| reactor-netty-core                                                            | 1.2.9                                     | The Apache Software License, Version 2.0                                             | https://github.com/reactor/reactor-netty                                                            | Required          | Yes      |
| reactor-netty-http                                                            | 1.2.9                                     | The Apache Software License, Version 2.0                                             | https://github.com/reactor/reactor-netty                                                            | Required          | Yes      |
| reflections                                                                   | 0.10.2                                    | WTFPL                                                                                | http://github.com/ronmamo/reflections                                                               | Required          | Yes      |
| regions                                                                       | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| requests_2.13                                                                 | 0.9.0                                     | MIT                                                                                  | https://github.com/com-lihaoyi/requests-scala                                                       | Required          | Yes      |
| retries                                                                       | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| retries-spi                                                                   | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| s3                                                                            | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| saml-client                                                                   | 5.0.0                                     | MIT                                                                                  | https://github.com/coveo/saml-client                                                                | Required          | Yes      |
| scala-collection-compat_2.13                                                  | 2.13.0                                    | Apache-2.0                                                                           | http://www.scala-lang.org/                                                                          | Required          | Yes      |
| scala-compiler                                                                | 2.13.16                                   | Apache-2.0                                                                           | https://www.scala-lang.org/                                                                         | Required          | Yes      |
| scala-java8-compat_2.13                                                       | 0.9.1                                     | Apache-2.0                                                                           | http://www.scala-lang.org/                                                                          | Required          | Yes      |
| scala-library                                                                 | 2.13.16                                   | Apache-2.0                                                                           | https://www.scala-lang.org/                                                                         | Required          | Yes      |
| scala-parser-combinators_2.13                                                 | 1.1.2                                     | Apache-2.0                                                                           | http://www.scala-lang.org/                                                                          | Required          | Yes      |
| scala-reflect                                                                 | 2.13.16                                   | Apache-2.0                                                                           | https://www.scala-lang.org/                                                                         | Required          | Yes      |
| scala-xml_2.13                                                                | 2.1.0                                     | Apache-2.0                                                                           | http://www.scala-lang.org/                                                                          | Required          | Yes      |
| scalactic_2.13                                                                | 3.2.19                                    | the Apache License, ASL Version 2.0                                                  | http://www.scalatest.org                                                                            | Required          | Yes      |
| scalameta_2.13                                                                | 4.13.1.1                                  | BSD                                                                                  | https://github.com/scalameta/scalameta                                                              | Required          | Yes      |
| scalamock_2.13                                                                | 6.2.0                                     | MIT                                                                                  | http://scalamock.org/                                                                               | Required          | Yes      |
| scalap                                                                        | 2.13.13                                   | Apache-2.0                                                                           | https://www.scala-lang.org/                                                                         | Required          | Yes      |
| scalaparse_2.13                                                               | 3.1.1                                     | MIT                                                                                  | https://github.com/lihaoyi/fastparse                                                                | Required          | Yes      |
| scalapb-runtime_2.13                                                          | 0.11.15                                   | Apache 2                                                                             | https://github.com/scalapb/ScalaPB                                                                  | Required          | Yes      |
| scalatest-compatible                                                          | 3.2.19                                    | the Apache License, ASL Version 2.0                                                  | http://www.scalatest.org/                                                                           | Required          | Yes      |
| scalatest-core_2.13                                                           | 3.2.19                                    | the Apache License, ASL Version 2.0                                                  | http://www.scalatest.org/                                                                           | Required          | Yes      |
| sdk-core                                                                      | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| semanticdb-shared_2.13                                                        | 4.13.1.1                                  | BSD                                                                                  | https://github.com/scalameta/scalameta                                                              | Required          | Yes      |
| semver4j                                                                      | 5.7.0                                     | The MIT License                                                                      | https://github.com/semver4j/semver4j                                                                | Required          | Yes      |
| shapeless_2.13                                                                | 2.3.13                                    | Apache 2                                                                             | https://github.com/milessabin/shapeless                                                             | Required          | Yes      |
| shared-resourcemapping                                                        | 0.33.0                                    | The Apache License, Version 2.0                                                      | https://github.com/GoogleCloudPlatform/opentelemetry-operations-java                                | Required          | Yes      |
| simulacrum-scalafix-annotations_2.13                                          | 0.5.4                                     | Apache 2.0                                                                           | https://github.com/typelevel/simulacrum-scalafix                                                    | Required          | Yes      |
| slf4j-api                                                                     | 2.0.17                                    | MIT                                                                                  | http://www.slf4j.org                                                                                | Required          | Yes      |
| slick-pg_2.13                                                                 | 0.23.1                                    | BSD-style                                                                            | https://github.com/tminglei/slick-pg                                                                | Required          | Yes      |
| slick-pg_core_2.13                                                            | 0.23.1                                    | BSD-style                                                                            | https://github.com/tminglei/slick-pg                                                                | Required          | Yes      |
| slick-pg_joda-time_2.13                                                       | 0.23.1                                    | BSD-style                                                                            | https://github.com/tminglei/slick-pg                                                                | Required          | Yes      |
| slick_2.13                                                                    | 3.6.1                                     | Two-clause BSD-style license                                                         | https://scala-slick.org                                                                             | Required          | Yes      |
| snakeyaml                                                                     | 2.5                                       | Apache License, Version 2.0                                                          | https://bitbucket.org/snakeyaml/snakeyaml                                                           | Required          | Yes      |
| snappy-java                                                                   | 1.1.10.8                                  | Apache-2.0                                                                           | https://github.com/xerial/snappy-java                                                               | Required          | Yes      |
| sourcecode_2.13                                                               | 0.4.3-M5                                  | MIT                                                                                  | https://github.com/com-lihaoyi/sourcecode                                                           | Required          | Yes      |
| ssl-config-core_2.13                                                          | 0.6.1                                     | Apache-2.0                                                                           | https://github.com/lightbend/ssl-config                                                             | Required          | Yes      |
| stax2-api                                                                     | 4.2.1                                     | The BSD License                                                                      | http://github.com/FasterXML/stax2-api                                                               | Required          | Yes      |
| swagger-annotations                                                           | 1.6.16                                    | Apache License 2.0                                                                   | https://github.com/swagger-api/swagger-core/modules/swagger-annotations                             | Required          | Yes      |
| swagger-core                                                                  | 1.6.16                                    | Apache License 2.0                                                                   | https://github.com/swagger-api/swagger-core/modules/swagger-core                                    | Required          | Yes      |
| swagger-jaxrs                                                                 | 1.6.16                                    | Apache License 2.0                                                                   | https://github.com/swagger-api/swagger-core/modules/swagger-jaxrs                                   | Required          | Yes      |
| swagger-jersey2-jaxrs                                                         | 1.6.16                                    | Apache License 2.0                                                                   | https://github.com/swagger-api/swagger-core/modules/swagger-jersey2-jaxrs                           | Required          | Yes      |
| swagger-models                                                                | 1.6.16                                    | Apache License 2.0                                                                   | https://github.com/swagger-api/swagger-core/modules/swagger-models                                  | Required          | Yes      |
| swagger-parser                                                                | 1.0.75                                    | Apache License 2.0                                                                   | N/A                                                                                                 | Required          | Yes      |
| swagger-parser-safe-url-resolver                                              | 1.0.75                                    | Apache License 2.0                                                                   | N/A                                                                                                 | Required          | Yes      |
| t-digest                                                                      | 3.2                                       | The Apache Software License, Version 2.0                                             | https://github.com/tdunning/t-digest                                                                | Required          | Yes      |
| text-io                                                                       | 3.4.1                                     | The Apache Software License, Version 2.0                                             | https://github.com/beryx/text-io                                                                    | Required          | Yes      |
| third-party-jackson-core                                                      | 2.33.13                                   | Apache License, Version 2.0                                                          | https://aws.amazon.com/sdkforjava                                                                   | Required          | Yes      |
| threetenbp                                                                    | 1.7.0                                     | BSD-3-Clause                                                                         | https://www.threeten.org/threetenbp                                                                 | Required          | Yes      |
| trees_2.13                                                                    | 4.13.1.1                                  | BSD                                                                                  | https://github.com/scalameta/scalameta                                                              | Required          | Yes      |
| txw2                                                                          | 4.0.5                                     | GNU General Public License, version 2 with the GNU Classpath Exception               | https://eclipse-ee4j.github.io/jaxb-ri/                                                             | Required          | Yes      |
| typename_2.13                                                                 | 1.1.0                                     | MIT                                                                                  | https://github.com/tpolecat/typename                                                                | Required          | Yes      |
| ujson_2.13                                                                    | 4.1.0                                     | MIT                                                                                  | https://github.com/lihaoyi/upickle                                                                  | Required          | Yes      |
| upack_2.13                                                                    | 4.1.0                                     | MIT                                                                                  | https://github.com/lihaoyi/upickle                                                                  | Required          | Yes      |
| upickle-core_2.13                                                             | 4.1.0                                     | MIT                                                                                  | https://github.com/lihaoyi/upickle                                                                  | Required          | Yes      |
| upickle-implicits_2.13                                                        | 4.1.0                                     | MIT                                                                                  | https://github.com/lihaoyi/upickle                                                                  | Required          | Yes      |
| upickle_2.13                                                                  | 4.1.0                                     | MIT                                                                                  | https://github.com/lihaoyi/upickle                                                                  | Required          | Yes      |
| utils                                                                         | 2.33.13                                   | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| validation-api                                                                | 1.1.0.Final                               | The Apache Software License, Version 2.0                                             | http://beanvalidation.org                                                                           | Required          | Yes      |
| value                                                                         | 2.11.4                                    | The Apache Software License, Version 2.0                                             | https://github.com/immutables/immutables/tree/value                                                 | Required          | Yes      |
| velocity-engine-core                                                          | 2.4.1                                     | Apache-2.0                                                                           | https://www.apache.org/                                                                             | Required          | Yes      |
| wartremover_2.13                                                              | 3.4.1                                     | The Apache Software License, Version 2.0                                             | https://github.com/wartremover/wartremover                                                          | Required          | Yes      |
| woodstox-core                                                                 | 6.5.0                                     | The Apache Software License, Version 2.0                                             | https://github.com/FasterXML/woodstox                                                               | Required          | Yes      |
| xmlsec                                                                        | 2.3.5                                     | Apache-2.0                                                                           | https://www.apache.org/                                                                             | Required          | Yes      |
| zookeeper                                                                     | 3.9.4                                     | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| zookeeper-jute                                                                | 3.9.4                                     | Apache License, Version 2.0                                                          | N/A                                                                                                 | Required          | Yes      |
| zxcvbn                                                                        | 1.9.0                                     | MIT License                                                                          | https://github.com/nulab/zxcvbn4j                                                                   | Required          | Yes      |
| @adobe/css-tools                                                              | 4.4.0                                     | MIT                                                                                  | https://github.com/adobe/css-tools                                                                  | Required          | Yes      |
| @ampproject/remapping                                                         | 2.3.0                                     | Apache-2.0                                                                           | https://github.com/ampproject/remapping                                                             | Required          | Yes      |
| @babel/cli                                                                    | 7.26.4                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/code-frame                                                             | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/code-frame                                                             | 7.26.2                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/compat-data                                                            | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/compat-data                                                            | 7.25.4                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/compat-data                                                            | 7.26.2                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/core                                                                   | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/core                                                                   | 7.25.2                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/core                                                                   | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/eslint-parser                                                          | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/eslint-plugin                                                          | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/generator                                                              | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/generator                                                              | 7.25.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/generator                                                              | 7.26.2                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-annotate-as-pure                                                | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-annotate-as-pure                                                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-builder-binary-assignment-operator-visitor                      | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-compilation-targets                                             | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-compilation-targets                                             | 7.25.2                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-compilation-targets                                             | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-create-class-features-plugin                                    | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-create-class-features-plugin                                    | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-create-regexp-features-plugin                                   | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-create-regexp-features-plugin                                   | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-define-polyfill-provider                                        | 0.6.2                                     | MIT                                                                                  | https://github.com/babel/babel-polyfills                                                            | Required          | Yes      |
| @babel/helper-environment-visitor                                             | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-function-name                                                   | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-hoist-variables                                                 | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-member-expression-to-functions                                  | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-member-expression-to-functions                                  | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-module-imports                                                  | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-module-imports                                                  | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-module-transforms                                               | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-module-transforms                                               | 7.25.2                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-module-transforms                                               | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-optimise-call-expression                                        | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-optimise-call-expression                                        | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-plugin-utils                                                    | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-plugin-utils                                                    | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-remap-async-to-generator                                        | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-replace-supers                                                  | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-replace-supers                                                  | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-simple-access                                                   | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-simple-access                                                   | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-skip-transparent-expression-wrappers                            | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-skip-transparent-expression-wrappers                            | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-split-export-declaration                                        | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-string-parser                                                   | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-string-parser                                                   | 7.24.8                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-string-parser                                                   | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-validator-identifier                                            | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-validator-identifier                                            | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-validator-option                                                | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-validator-option                                                | 7.24.8                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-validator-option                                                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helper-wrap-function                                                   | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helpers                                                                | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helpers                                                                | 7.25.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/helpers                                                                | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/highlight                                                              | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/node                                                                   | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/parser                                                                 | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/parser                                                                 | 7.25.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/parser                                                                 | 7.26.2                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-bugfix-firefox-class-in-computed-class-key                      | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-bugfix-safari-class-field-initializer-scope                     | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-bugfix-safari-id-destructuring-collision-in-function-expression | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-bugfix-v8-spread-parameters-in-optional-chaining                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-bugfix-v8-static-class-fields-redefine-readonly                 | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-proposal-class-properties                                       | 7.18.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-proposal-object-rest-spread                                     | 7.20.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-proposal-optional-chaining                                      | 7.21.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-proposal-private-property-in-object                             | 7.21.0-placeholder-for-preset-env.2       | MIT                                                                                  | https://github.com/babel/babel-plugin-proposal-private-property-in-object                           | Required          | Yes      |
| @babel/plugin-syntax-async-generators                                         | 7.8.4                                     | MIT                                                                                  | https://github.com/babel/babel/tree/master/packages/babel-plugin-syntax-async-generators            | Required          | Yes      |
| @babel/plugin-syntax-bigint                                                   | 7.8.3                                     | MIT                                                                                  | https://github.com/babel/babel/tree/master/packages/babel-plugin-syntax-bigint                      | Required          | Yes      |
| @babel/plugin-syntax-class-properties                                         | 7.12.13                                   | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-dynamic-import                                           | 7.8.3                                     | MIT                                                                                  | https://github.com/babel/babel/tree/master/packages/babel-plugin-syntax-dynamic-import              | Required          | Yes      |
| @babel/plugin-syntax-flow                                                     | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-import-assertions                                        | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-import-attributes                                        | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-import-meta                                              | 7.10.4                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-json-strings                                             | 7.8.3                                     | MIT                                                                                  | https://github.com/babel/babel/tree/master/packages/babel-plugin-syntax-json-strings                | Required          | Yes      |
| @babel/plugin-syntax-jsx                                                      | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-jsx                                                      | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-logical-assignment-operators                             | 7.10.4                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-nullish-coalescing-operator                              | 7.8.3                                     | MIT                                                                                  | https://github.com/babel/babel/tree/master/packages/babel-plugin-syntax-nullish-coalescing-operator | Required          | Yes      |
| @babel/plugin-syntax-numeric-separator                                        | 7.10.4                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-object-rest-spread                                       | 7.8.3                                     | MIT                                                                                  | https://github.com/babel/babel/tree/master/packages/babel-plugin-syntax-object-rest-spread          | Required          | Yes      |
| @babel/plugin-syntax-optional-catch-binding                                   | 7.8.3                                     | MIT                                                                                  | https://github.com/babel/babel/tree/master/packages/babel-plugin-syntax-optional-catch-binding      | Required          | Yes      |
| @babel/plugin-syntax-optional-chaining                                        | 7.8.3                                     | MIT                                                                                  | https://github.com/babel/babel/tree/master/packages/babel-plugin-syntax-optional-chaining           | Required          | Yes      |
| @babel/plugin-syntax-top-level-await                                          | 7.14.5                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-typescript                                               | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-typescript                                               | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-syntax-unicode-sets-regex                                       | 7.18.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-arrow-functions                                       | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-async-generator-functions                             | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-async-to-generator                                    | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-block-scoped-functions                                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-block-scoping                                         | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-class-properties                                      | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-class-properties                                      | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-class-static-block                                    | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-classes                                               | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-computed-properties                                   | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-destructuring                                         | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-dotall-regex                                          | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-duplicate-keys                                        | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-duplicate-named-capturing-groups-regex                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-dynamic-import                                        | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-exponentiation-operator                               | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-export-namespace-from                                 | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-flow-strip-types                                      | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-for-of                                                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-function-name                                         | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-json-strings                                          | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-literals                                              | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-logical-assignment-operators                          | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-member-expression-literals                            | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-modules-amd                                           | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-modules-commonjs                                      | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-modules-commonjs                                      | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-modules-systemjs                                      | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-modules-umd                                           | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-named-capturing-groups-regex                          | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-new-target                                            | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-nullish-coalescing-operator                           | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-nullish-coalescing-operator                           | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-numeric-separator                                     | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-object-rest-spread                                    | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-object-super                                          | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-optional-catch-binding                                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-optional-chaining                                     | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-optional-chaining                                     | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-parameters                                            | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-parameters                                            | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-private-methods                                       | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-private-methods                                       | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-private-property-in-object                            | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-property-literals                                     | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-react-display-name                                    | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-react-jsx-development                                 | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-react-jsx                                             | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-react-pure-annotations                                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-regenerator                                           | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-regexp-modifiers                                      | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-reserved-words                                        | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-runtime                                               | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-shorthand-properties                                  | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-spread                                                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-sticky-regex                                          | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-template-literals                                     | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-typeof-symbol                                         | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-typescript                                            | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-typescript                                            | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-unicode-escapes                                       | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-unicode-property-regex                                | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-unicode-regex                                         | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/plugin-transform-unicode-sets-regex                                    | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/preset-env                                                             | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/preset-flow                                                            | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/preset-modules                                                         | 0.1.6-no-external-plugins                 | MIT                                                                                  | https://github.com/babel/preset-modules                                                             | Required          | Yes      |
| @babel/preset-react                                                           | 7.26.3                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/preset-typescript                                                      | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/preset-typescript                                                      | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/register                                                               | 7.24.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/register                                                               | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/regjsgen                                                               | 0.8.0                                     | MIT                                                                                  | https://github.com/bnjmnt4n/regjsgen                                                                | Required          | Yes      |
| @babel/runtime                                                                | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/runtime                                                                | 7.24.8                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/runtime                                                                | 7.25.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/runtime                                                                | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/template                                                               | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/template                                                               | 7.25.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/template                                                               | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/traverse                                                               | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/traverse                                                               | 7.25.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/traverse                                                               | 7.25.9                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/types                                                                  | 7.24.7                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/types                                                                  | 7.25.6                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @babel/types                                                                  | 7.26.0                                    | MIT                                                                                  | https://github.com/babel/babel                                                                      | Required          | Yes      |
| @base2/pretty-print-object                                                    | 1.0.1                                     | BSD-2-Clause                                                                         | https://github.com/Chris-Baker/pretty-print-object                                                  | Required          | Yes      |
| @bcoe/v8-coverage                                                             | 0.2.3                                     | MIT                                                                                  | https://github.com/demurgos/v8-coverage                                                             | Required          | Yes      |
| @bufbuild/protobuf                                                            | 2.2.2                                     | (Apache-2.0 AND BSD-3-Clause)                                                        | https://github.com/bufbuild/protobuf-es                                                             | Required          | Yes      |
| @colors/colors                                                                | 1.5.0                                     | MIT                                                                                  | https://github.com/DABH/colors.js                                                                   | Required          | Yes      |
| @cspotcode/source-map-support                                                 | 0.8.1                                     | MIT                                                                                  | https://github.com/cspotcode/node-source-map-support                                                | Required          | Yes      |
| @csstools/css-parser-algorithms                                               | 2.6.3                                     | MIT                                                                                  | https://github.com/csstools/postcss-plugins                                                         | Required          | Yes      |
| @csstools/css-tokenizer                                                       | 2.3.1                                     | MIT                                                                                  | https://github.com/csstools/postcss-plugins                                                         | Required          | Yes      |
| @csstools/media-query-list-parser                                             | 2.1.11                                    | MIT                                                                                  | https://github.com/csstools/postcss-plugins                                                         | Required          | Yes      |
| @csstools/selector-specificity                                                | 3.1.1                                     | MIT-0                                                                                | https://github.com/csstools/postcss-plugins                                                         | Required          | Yes      |
| @cypress/request                                                              | 3.0.6                                     | Apache-2.0                                                                           | https://github.com/cypress-io/request                                                               | Required          | Yes      |
| @cypress/webpack-preprocessor                                                 | 5.17.1                                    | MIT                                                                                  | https://github.com/cypress-io/cypress                                                               | Required          | Yes      |
| @cypress/xvfb                                                                 | 1.2.4                                     | MIT                                                                                  | https://github.com/cypress-io/xvfb                                                                  | Required          | Yes      |
| @discoveryjs/json-ext                                                         | 0.5.7                                     | MIT                                                                                  | https://github.com/discoveryjs/json-ext                                                             | Required          | Yes      |
| @elastic/apm-rum-core                                                         | 5.21.0                                    | MIT                                                                                  | https://github.com/elastic/apm-agent-rum-js                                                         | Required          | Yes      |
| @elastic/apm-rum-core                                                         | 5.22.1                                    | MIT                                                                                  | https://github.com/elastic/apm-agent-rum-js                                                         | Required          | Yes      |
| @elastic/apm-rum-react                                                        | 1.4.4                                     | MIT                                                                                  | https://github.com/elastic/apm-agent-rum-js                                                         | Required          | Yes      |
| @elastic/apm-rum                                                              | 5.16.0                                    | MIT                                                                                  | https://github.com/elastic/apm-agent-rum-js                                                         | Required          | Yes      |
| @elastic/apm-rum                                                              | 5.16.3                                    | MIT                                                                                  | https://github.com/elastic/apm-agent-rum-js                                                         | Required          | Yes      |
| @elastic/charts                                                               | 68.1.0                                    | Apache*                                                                              | https://github.com/elastic/elastic-charts                                                           | Required          | Yes      |
| @elastic/datemath                                                             | 5.0.3                                     | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| @elastic/ebt                                                                  | 1.1.1                                     | Apache*                                                                              | https://github.com/elastic/ebt                                                                      | Required          | Yes      |
| @elastic/ecs-helpers                                                          | 2.1.1                                     | Apache-2.0                                                                           | https://github.com/elastic/ecs-logging-nodejs                                                       | Required          | Yes      |
| @elastic/ecs-pino-format                                                      | 1.5.0                                     | Apache-2.0                                                                           | https://github.com/elastic/ecs-logging-nodejs                                                       | Required          | Yes      |
| @elastic/eslint-plugin-eui                                                    | 0.0.3                                     | Apache-2.0                                                                           | https://github.com/elastic/eui                                                                      | Required          | Yes      |
| @elastic/eslint-plugin-react-intl                                             | 1.2.0                                     | MIT                                                                                  | https://github.com/elastic/eslint-plugin-react-intl                                                 | Required          | Yes      |
| @elastic/eui-theme-borealis                                                   | 0.0.11                                    | Apache*                                                                              | https://github.com/elastic/eui                                                                      | Required          | Yes      |
| @elastic/eui-theme-common                                                     | 0.0.11                                    | Apache*                                                                              | https://github.com/elastic/eui                                                                      | Required          | Yes      |
| @elastic/eui                                                                  | 100.0.0                                   | Apache*                                                                              | https://github.com/elastic/eui                                                                      | Required          | Yes      |
| @elastic/kibana-d3-color                                                      | 2.0.1                                     | BSD-3-Clause                                                                         | https://github.com/elastic/d3-color                                                                 | Required          | Yes      |
| @elastic/micro-jq                                                             | 1.8.0                                     | Apache-2.0                                                                           | N/A                                                                                                 | Required          | Yes      |
| @elastic/prismjs-esql                                                         | 1.0.0                                     | MIT                                                                                  | https://github.com/elastic/prismjs-esql                                                             | Required          | Yes      |
| @emotion/babel-plugin                                                         | 11.13.5                                   | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/babel-plugin                               | Required          | Yes      |
| @emotion/cache                                                                | 11.14.0                                   | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/cache                                      | Required          | Yes      |
| @emotion/css                                                                  | 11.13.5                                   | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/css                                        | Required          | Yes      |
| @emotion/hash                                                                 | 0.9.2                                     | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/hash                                       | Required          | Yes      |
| @emotion/memoize                                                              | 0.9.0                                     | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/memoize                                    | Required          | Yes      |
| @emotion/react                                                                | 11.14.0                                   | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/react                                      | Required          | Yes      |
| @emotion/serialize                                                            | 1.3.3                                     | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/serialize                                  | Required          | Yes      |
| @emotion/sheet                                                                | 1.4.0                                     | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/sheet                                      | Required          | Yes      |
| @emotion/unitless                                                             | 0.10.0                                    | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/unitless                                   | Required          | Yes      |
| @emotion/use-insertion-effect-with-fallbacks                                  | 1.2.0                                     | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/use-insertion-effect-with-fallbacks        | Required          | Yes      |
| @emotion/utils                                                                | 1.4.2                                     | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/utils                                      | Required          | Yes      |
| @emotion/weak-memoize                                                         | 0.4.0                                     | MIT                                                                                  | https://github.com/emotion-js/emotion/tree/main/packages/weak-memoize                               | Required          | Yes      |
| @eslint-community/eslint-utils                                                | 4.4.0                                     | MIT                                                                                  | https://github.com/eslint-community/eslint-utils                                                    | Required          | Yes      |
| @eslint-community/regexpp                                                     | 4.10.1                                    | MIT                                                                                  | https://github.com/eslint-community/regexpp                                                         | Required          | Yes      |
| @eslint-community/regexpp                                                     | 4.11.0                                    | MIT                                                                                  | https://github.com/eslint-community/regexpp                                                         | Required          | Yes      |
| @eslint/eslintrc                                                              | 2.1.4                                     | MIT                                                                                  | https://github.com/eslint/eslintrc                                                                  | Required          | Yes      |
| @eslint/js                                                                    | 8.57.0                                    | MIT                                                                                  | https://github.com/eslint/eslint                                                                    | Required          | Yes      |
| @fastify/busboy                                                               | 2.1.1                                     | MIT                                                                                  | https://github.com/fastify/busboy                                                                   | Required          | Yes      |
| @formatjs/cli                                                                 | 6.5.1                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/ecma402-abstract                                                    | 2.2.4                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/ecma402-abstract                                                    | 2.3.2                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/fast-memoize                                                        | 2.2.3                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/fast-memoize                                                        | 2.2.6                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/icu-messageformat-parser                                            | 2.11.0                                    | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/icu-messageformat-parser                                            | 2.9.4                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/icu-skeleton-parser                                                 | 1.8.12                                    | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/icu-skeleton-parser                                                 | 1.8.8                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/intl-displaynames                                                   | 6.8.5                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/intl-listformat                                                     | 7.7.5                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/intl-localematcher                                                  | 0.5.10                                    | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/intl-localematcher                                                  | 0.5.8                                     | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/intl                                                                | 2.10.15                                   | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @formatjs/ts-transformer                                                      | 3.13.31                                   | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| @gar/promisify                                                                | 1.1.3                                     | MIT                                                                                  | https://github.com/wraithgar/gar-promisify                                                          | Required          | Yes      |
| @getify/eslint-plugin-proper-ternary                                          | 3.1.1                                     | MIT                                                                                  | https://github.com/getify/eslint-plugin-proper-ternary                                              | Required          | Yes      |
| @hello-pangea/dnd                                                             | 16.6.0                                    | Apache-2.0                                                                           | https://github.com/hello-pangea/dnd                                                                 | Required          | Yes      |
| @humanwhocodes/config-array                                                   | 0.11.14                                   | Apache-2.0                                                                           | https://github.com/humanwhocodes/config-array                                                       | Required          | Yes      |
| @humanwhocodes/module-importer                                                | 1.0.1                                     | Apache-2.0                                                                           | https://github.com/humanwhocodes/module-importer                                                    | Required          | Yes      |
| @humanwhocodes/object-schema                                                  | 2.0.3                                     | BSD-3-Clause                                                                         | https://github.com/humanwhocodes/object-schema                                                      | Required          | Yes      |
| @isaacs/cliui                                                                 | 8.0.2                                     | ISC                                                                                  | https://github.com/yargs/cliui                                                                      | Required          | Yes      |
| @istanbuljs/load-nyc-config                                                   | 1.1.0                                     | ISC                                                                                  | https://github.com/istanbuljs/load-nyc-config                                                       | Required          | Yes      |
| @istanbuljs/schema                                                            | 0.1.3                                     | MIT                                                                                  | https://github.com/istanbuljs/schema                                                                | Required          | Yes      |
| @jest/console                                                                 | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/core                                                                    | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/environment                                                             | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/expect-utils                                                            | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/expect                                                                  | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/fake-timers                                                             | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/globals                                                                 | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/reporters                                                               | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/schemas                                                                 | 29.6.3                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/source-map                                                              | 29.6.3                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/test-result                                                             | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/test-sequencer                                                          | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/transform                                                               | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jest/types                                                                   | 29.6.3                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| @jridgewell/gen-mapping                                                       | 0.3.5                                     | MIT                                                                                  | https://github.com/jridgewell/gen-mapping                                                           | Required          | Yes      |
| @jridgewell/resolve-uri                                                       | 3.1.2                                     | MIT                                                                                  | https://github.com/jridgewell/resolve-uri                                                           | Required          | Yes      |
| @jridgewell/set-array                                                         | 1.2.1                                     | MIT                                                                                  | https://github.com/jridgewell/set-array                                                             | Required          | Yes      |
| @jridgewell/source-map                                                        | 0.3.6                                     | MIT                                                                                  | https://github.com/jridgewell/source-map                                                            | Required          | Yes      |
| @jridgewell/sourcemap-codec                                                   | 1.4.15                                    | MIT                                                                                  | https://github.com/jridgewell/sourcemap-codec                                                       | Required          | Yes      |
| @jridgewell/trace-mapping                                                     | 0.3.15                                    | MIT                                                                                  | https://github.com/jridgewell/trace-mapping                                                         | Required          | Yes      |
| @jridgewell/trace-mapping                                                     | 0.3.25                                    | MIT                                                                                  | https://github.com/jridgewell/trace-mapping                                                         | Required          | Yes      |
| @jridgewell/trace-mapping                                                     | 0.3.9                                     | MIT                                                                                  | https://github.com/jridgewell/trace-mapping                                                         | Required          | Yes      |
| @loadable/component                                                           | 5.16.4                                    | MIT                                                                                  | https://github.com/gregberge/loadable-components                                                    | Required          | Yes      |
| @mapbox/hast-util-table-cell-style                                            | 0.2.1                                     | BSD-2-Clause                                                                         | https://github.com/mapbox/hast-util-table-cell-style                                                | Required          | Yes      |
| @nicolo-ribaudo/chokidar-2                                                    | 2.1.8-no-fsevents.3                       | MIT                                                                                  | https://github.com/nicolo-ribaudo/chokidar-2                                                        | Required          | Yes      |
| @nicolo-ribaudo/eslint-scope-5-internals                                      | 5.1.1-v1                                  | MIT                                                                                  | N/A                                                                                                 | Required          | Yes      |
| @nodelib/fs.scandir                                                           | 2.1.5                                     | MIT                                                                                  | https://github.com/nodelib/nodelib/tree/master/packages/fs/fs.scandir                               | Required          | Yes      |
| @nodelib/fs.stat                                                              | 2.0.5                                     | MIT                                                                                  | https://github.com/nodelib/nodelib/tree/master/packages/fs/fs.stat                                  | Required          | Yes      |
| @nodelib/fs.walk                                                              | 1.2.8                                     | MIT                                                                                  | https://github.com/nodelib/nodelib/tree/master/packages/fs/fs.walk                                  | Required          | Yes      |
| @nolyfill/is-core-module                                                      | 1.0.39                                    | MIT                                                                                  | https://github.com/SukkaW/nolyfill                                                                  | Required          | Yes      |
| @npmcli/fs                                                                    | 2.1.2                                     | ISC                                                                                  | https://github.com/npm/fs                                                                           | Required          | Yes      |
| @npmcli/fs                                                                    | 3.1.1                                     | ISC                                                                                  | https://github.com/npm/fs                                                                           | Required          | Yes      |
| @npmcli/git                                                                   | 4.1.0                                     | ISC                                                                                  | https://github.com/npm/git                                                                          | Required          | Yes      |
| @npmcli/installed-package-contents                                            | 2.1.0                                     | ISC                                                                                  | https://github.com/npm/installed-package-contents                                                   | Required          | Yes      |
| @npmcli/move-file                                                             | 2.0.1                                     | MIT                                                                                  | https://github.com/npm/move-file                                                                    | Required          | Yes      |
| @npmcli/node-gyp                                                              | 3.0.0                                     | ISC                                                                                  | https://github.com/npm/node-gyp                                                                     | Required          | Yes      |
| @npmcli/promise-spawn                                                         | 6.0.2                                     | ISC                                                                                  | https://github.com/npm/promise-spawn                                                                | Required          | Yes      |
| @npmcli/run-script                                                            | 6.0.2                                     | ISC                                                                                  | https://github.com/npm/run-script                                                                   | Required          | Yes      |
| @one-ini/wasm                                                                 | 0.1.1                                     | MIT                                                                                  | https://github.com/one-ini/core                                                                     | Required          | Yes      |
| @oozcitak/dom                                                                 | 1.15.10                                   | MIT                                                                                  | https://github.com/oozcitak/dom                                                                     | Required          | Yes      |
| @oozcitak/infra                                                               | 1.0.8                                     | MIT                                                                                  | https://github.com/oozcitak/infra                                                                   | Required          | Yes      |
| @oozcitak/url                                                                 | 1.0.4                                     | MIT                                                                                  | https://github.com/oozcitak/url                                                                     | Required          | Yes      |
| @oozcitak/util                                                                | 8.3.8                                     | MIT                                                                                  | https://github.com/oozcitak/util                                                                    | Required          | Yes      |
| @otplib/core                                                                  | 12.0.1                                    | MIT                                                                                  | https://github.com/yeojz/otplib/tree/master/packages/otplib-core                                    | Required          | Yes      |
| @otplib/plugin-crypto                                                         | 12.0.1                                    | MIT                                                                                  | https://github.com/yeojz/otplib/tree/master/packages/otplib-plugin-crypto                           | Required          | Yes      |
| @otplib/plugin-thirty-two                                                     | 12.0.1                                    | MIT                                                                                  | https://github.com/yeojz/otplib/tree/master/packages/otplib-plugin-thirty-two                       | Required          | Yes      |
| @otplib/preset-default                                                        | 12.0.1                                    | MIT                                                                                  | https://github.com/yeojz/otplib/tree/master/packages/otplib-preset-default                          | Required          | Yes      |
| @otplib/preset-v11                                                            | 12.0.1                                    | MIT                                                                                  | https://github.com/yeojz/otplib/tree/master/packages/otplib-preset-v11                              | Required          | Yes      |
| @pkgjs/parseargs                                                              | 0.11.0                                    | MIT                                                                                  | https://github.com/pkgjs/parseargs                                                                  | Required          | Yes      |
| @pmmmwh/react-refresh-webpack-plugin                                          | 0.5.15                                    | MIT                                                                                  | https://github.com/pmmmwh/react-refresh-webpack-plugin                                              | Required          | Yes      |
| @pnpm/config.env-replace                                                      | 1.1.0                                     | MIT                                                                                  | https://github.com/pnpm/components                                                                  | Required          | Yes      |
| @pnpm/network.ca-file                                                         | 1.0.2                                     | MIT                                                                                  | https://github.com/pnpm/components                                                                  | Required          | Yes      |
| @pnpm/npm-conf                                                                | 2.2.2                                     | MIT                                                                                  | https://github.com/pnpm/npm-conf                                                                    | Required          | Yes      |
| @popperjs/core                                                                | 2.11.8                                    | MIT                                                                                  | https://github.com/popperjs/popper-core                                                             | Required          | Yes      |
| @rtsao/scc                                                                    | 1.1.0                                     | MIT                                                                                  | https://github.com/rtsao/scc                                                                        | Required          | Yes      |
| @shopify/eslint-plugin                                                        | 42.1.0                                    | MIT                                                                                  | https://github.com/Shopify/web-configs                                                              | Required          | Yes      |
| @sigstore/bundle                                                              | 1.1.0                                     | Apache-2.0                                                                           | https://github.com/sigstore/sigstore-js                                                             | Required          | Yes      |
| @sigstore/protobuf-specs                                                      | 0.2.1                                     | Apache-2.0                                                                           | https://github.com/sigstore/protobuf-specs                                                          | Required          | Yes      |
| @sigstore/sign                                                                | 1.0.0                                     | Apache-2.0                                                                           | https://github.com/sigstore/sigstore-js                                                             | Required          | Yes      |
| @sigstore/tuf                                                                 | 1.0.3                                     | Apache-2.0                                                                           | https://github.com/sigstore/sigstore-js                                                             | Required          | Yes      |
| @sinclair/typebox                                                             | 0.27.8                                    | MIT                                                                                  | https://github.com/sinclairzx81/typebox                                                             | Required          | Yes      |
| @sindresorhus/is                                                              | 5.6.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is                                                                  | Required          | Yes      |
| @sinonjs/commons                                                              | 3.0.1                                     | BSD-3-Clause                                                                         | https://github.com/sinonjs/commons                                                                  | Required          | Yes      |
| @sinonjs/fake-timers                                                          | 10.3.0                                    | BSD-3-Clause                                                                         | https://github.com/sinonjs/fake-timers                                                              | Required          | Yes      |
| @szmarczak/http-timer                                                         | 5.0.1                                     | MIT                                                                                  | https://github.com/szmarczak/http-timer                                                             | Required          | Yes      |
| @testing-library/cypress                                                      | 10.0.2                                    | MIT                                                                                  | https://github.com/testing-library/cypress-testing-library                                          | Required          | Yes      |
| @testing-library/dom                                                          | 10.1.0                                    | MIT                                                                                  | https://github.com/testing-library/dom-testing-library                                              | Required          | Yes      |
| @testing-library/dom                                                          | 8.20.1                                    | MIT                                                                                  | https://github.com/testing-library/dom-testing-library                                              | Required          | Yes      |
| @testing-library/jest-dom                                                     | 5.17.0                                    | MIT                                                                                  | https://github.com/testing-library/jest-dom                                                         | Required          | Yes      |
| @testing-library/react-hooks                                                  | 8.0.1                                     | MIT                                                                                  | https://github.com/testing-library/react-hooks-testing-library                                      | Required          | Yes      |
| @testing-library/react                                                        | 12.1.5                                    | MIT                                                                                  | https://github.com/testing-library/react-testing-library                                            | Required          | Yes      |
| @testing-library/user-event                                                   | 14.6.1                                    | MIT                                                                                  | https://github.com/testing-library/user-event                                                       | Required          | Yes      |
| @tootallnate/once                                                             | 2.0.0                                     | MIT                                                                                  | https://github.com/TooTallNate/once                                                                 | Required          | Yes      |
| @trysound/sax                                                                 | 0.2.0                                     | ISC                                                                                  | https://github.com/svg/sax                                                                          | Required          | Yes      |
| @tsconfig/node10                                                              | 1.0.11                                    | MIT                                                                                  | https://github.com/tsconfig/bases                                                                   | Required          | Yes      |
| @tsconfig/node12                                                              | 1.0.11                                    | MIT                                                                                  | https://github.com/tsconfig/bases                                                                   | Required          | Yes      |
| @tsconfig/node14                                                              | 1.0.3                                     | MIT                                                                                  | https://github.com/tsconfig/bases                                                                   | Required          | Yes      |
| @tsconfig/node16                                                              | 1.0.4                                     | MIT                                                                                  | https://github.com/tsconfig/bases                                                                   | Required          | Yes      |
| @tufjs/canonical-json                                                         | 1.0.0                                     | MIT                                                                                  | https://github.com/theupdateframework/tuf-js                                                        | Required          | Yes      |
| @tufjs/models                                                                 | 1.0.4                                     | MIT                                                                                  | https://github.com/theupdateframework/tuf-js                                                        | Required          | Yes      |
| @types/aria-query                                                             | 5.0.4                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/babel__core                                                            | 7.20.5                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/babel__generator                                                       | 7.6.8                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/babel__helper-plugin-utils                                             | 7.10.3                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/babel__template                                                        | 7.4.4                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/babel__traverse                                                        | 7.20.6                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/bcryptjs                                                               | 2.4.6                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/body-parser                                                            | 1.19.5                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/cheerio                                                                | 0.22.35                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/connect                                                                | 3.4.38                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/d3-hexbin                                                              | 0.2.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/deep-diff                                                              | 1.0.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/deep-equal                                                             | 1.0.4                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/diff                                                                   | 5.2.3                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/enzyme                                                                 | 3.10.18                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/estree                                                                 | 1.0.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/express-serve-static-core                                              | 4.19.3                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/express                                                                | 4.17.21                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/fetch-mock                                                             | 7.3.8                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/glob                                                                   | 8.1.0                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/graceful-fs                                                            | 4.1.9                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/grecaptcha                                                             | 3.0.9                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/gtag.js                                                                | 0.0.20                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/hast                                                                   | 2.3.10                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/history                                                                | 4.7.11                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/hoist-non-react-statics                                                | 3.3.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/hoist-non-react-statics                                                | 3.3.6                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/html-minifier-terser                                                   | 6.1.0                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/http-cache-semantics                                                   | 4.0.4                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/http-errors                                                            | 2.0.4                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/http-proxy                                                             | 1.17.15                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/istanbul-lib-coverage                                                  | 2.0.6                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/istanbul-lib-report                                                    | 3.0.3                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/istanbul-reports                                                       | 3.0.4                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/jest-axe                                                               | 3.5.9                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/jest                                                                   | 29.5.12                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/jest                                                                   | 29.5.14                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/js-cookie                                                              | 3.0.6                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/js-yaml                                                                | 4.0.9                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/jscodeshift                                                            | 0.12.0                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/jsdom                                                                  | 20.0.1                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/json-schema                                                            | 7.0.15                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/json-stable-stringify                                                  | 1.1.0                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/json5                                                                  | 0.0.29                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/linkify-it                                                             | 3.0.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/lodash                                                                 | 4.17.14                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/lodash                                                                 | 4.17.4                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/markdown-it                                                            | 13.0.9                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/mdast                                                                  | 3.0.15                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/mdurl                                                                  | 1.0.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/mime                                                                   | 1.3.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/minimatch                                                              | 5.1.2                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/minimist                                                               | 1.2.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/node-fetch                                                             | 2.6.12                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/node-forge                                                             | 1.3.11                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/node                                                                   | 20.14.2                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/node                                                                   | 20.17.16                                  | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/node                                                                   | 22.9.0                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/normalize-package-data                                                 | 2.4.4                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/numeral                                                                | 2.0.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/parse-json                                                             | 4.0.2                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/parse5                                                                 | 5.0.3                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/prismjs                                                                | 1.26.4                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/prop-types                                                             | 15.7.12                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/qs                                                                     | 6.9.15                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/range-parser                                                           | 1.2.7                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-dom                                                              | 17.0.16                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-dom                                                              | 17.0.25                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-redux                                                            | 7.1.33                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-redux                                                            | 7.1.34                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-router-config                                                    | 5.0.11                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-router-dom                                                       | 5.3.3                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-router                                                           | 5.1.20                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-test-renderer                                                    | 17.0.9                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react-window                                                           | 1.8.8                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/react                                                                  | 17.0.2                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/redux-mock-store                                                       | 1.5.0                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/refractor                                                              | 3.4.1                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/semver-utils                                                           | 1.1.3                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/semver                                                                 | 7.5.8                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/send                                                                   | 0.17.4                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/serve-static                                                           | 1.15.7                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/shallowequal                                                           | 1.1.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/sinonjs__fake-timers                                                   | 8.1.1                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/sizzle                                                                 | 2.3.8                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/stack-utils                                                            | 2.0.3                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/testing-library__jest-dom                                              | 5.14.9                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/tough-cookie                                                           | 4.0.5                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/trusted-types                                                          | 2.0.7                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/unist                                                                  | 2.0.10                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/url-template                                                           | 2.0.31                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/use-sync-external-store                                                | 0.0.3                                     | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/webpack-env                                                            | 1.18.5                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/webpack-hot-middleware                                                 | 2.25.9                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/webpack                                                                | 5.28.5                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/yargs-parser                                                           | 21.0.3                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/yargs                                                                  | 17.0.32                                   | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @types/yauzl                                                                  | 2.10.3                                    | MIT                                                                                  | https://github.com/DefinitelyTyped/DefinitelyTyped                                                  | Required          | Yes      |
| @typescript-eslint/eslint-plugin                                              | 5.62.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/eslint-plugin                                              | 7.18.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/experimental-utils                                         | 5.62.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/parser                                                     | 5.62.0                                    | BSD-2-Clause                                                                         | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/parser                                                     | 7.18.0                                    | BSD-2-Clause                                                                         | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/scope-manager                                              | 5.62.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/scope-manager                                              | 7.18.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/type-utils                                                 | 5.62.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/type-utils                                                 | 7.18.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/types                                                      | 5.62.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/types                                                      | 7.18.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/typescript-estree                                          | 5.62.0                                    | BSD-2-Clause                                                                         | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/typescript-estree                                          | 7.18.0                                    | BSD-2-Clause                                                                         | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/utils                                                      | 5.62.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/utils                                                      | 7.18.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/visitor-keys                                               | 5.62.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @typescript-eslint/visitor-keys                                               | 7.18.0                                    | MIT                                                                                  | https://github.com/typescript-eslint/typescript-eslint                                              | Required          | Yes      |
| @ungap/structured-clone                                                       | 1.2.0                                     | ISC                                                                                  | https://github.com/ungap/structured-clone                                                           | Required          | Yes      |
| @webassemblyjs/ast                                                            | 1.12.1                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/floating-point-hex-parser                                      | 1.11.6                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/helper-api-error                                               | 1.11.6                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/helper-buffer                                                  | 1.12.1                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/helper-numbers                                                 | 1.11.6                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/helper-wasm-bytecode                                           | 1.11.6                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/helper-wasm-section                                            | 1.12.1                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/ieee754                                                        | 1.11.6                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/leb128                                                         | 1.11.6                                    | Apache-2.0                                                                           | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/utf8                                                           | 1.11.6                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/wasm-edit                                                      | 1.12.1                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/wasm-gen                                                       | 1.12.1                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/wasm-opt                                                       | 1.12.1                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/wasm-parser                                                    | 1.12.1                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webassemblyjs/wast-printer                                                   | 1.12.1                                    | MIT                                                                                  | https://github.com/xtuc/webassemblyjs                                                               | Required          | Yes      |
| @webpack-cli/configtest                                                       | 2.1.1                                     | MIT                                                                                  | https://github.com/webpack/webpack-cli                                                              | Required          | Yes      |
| @webpack-cli/info                                                             | 2.0.2                                     | MIT                                                                                  | https://github.com/webpack/webpack-cli                                                              | Required          | Yes      |
| @webpack-cli/serve                                                            | 2.0.5                                     | MIT                                                                                  | https://github.com/webpack/webpack-cli                                                              | Required          | Yes      |
| @wojtekmaj/enzyme-adapter-react-17                                            | 0.8.0                                     | MIT                                                                                  | https://github.com/wojtekmaj/enzyme-adapter-react-17                                                | Required          | Yes      |
| @wojtekmaj/enzyme-adapter-utils                                               | 0.2.0                                     | MIT                                                                                  | https://github.com/wojtekmaj/enzyme-adapter-utils                                                   | Required          | Yes      |
| @xtuc/ieee754                                                                 | 1.2.0                                     | BSD-3-Clause                                                                         | https://github.com/feross/ieee754                                                                   | Required          | Yes      |
| @xtuc/long                                                                    | 4.2.2                                     | Apache-2.0                                                                           | https://github.com/dcodeIO/long.js                                                                  | Required          | Yes      |
| abab                                                                          | 2.0.6                                     | BSD-3-Clause                                                                         | https://github.com/jsdom/abab                                                                       | Required          | Yes      |
| abbrev                                                                        | 1.1.1                                     | ISC                                                                                  | https://github.com/isaacs/abbrev-js                                                                 | Required          | Yes      |
| abbrev                                                                        | 2.0.0                                     | ISC                                                                                  | https://github.com/npm/abbrev-js                                                                    | Required          | Yes      |
| abort-controller                                                              | 3.0.0                                     | MIT                                                                                  | https://github.com/mysticatea/abort-controller                                                      | Required          | Yes      |
| accepts                                                                       | 1.3.8                                     | MIT                                                                                  | https://github.com/jshttp/accepts                                                                   | Required          | Yes      |
| acorn-globals                                                                 | 7.0.1                                     | MIT                                                                                  | https://github.com/ForbesLindesay/acorn-globals                                                     | Required          | Yes      |
| acorn-import-attributes                                                       | 1.9.5                                     | MIT                                                                                  | https://github.com/xtuc/acorn-import-attributes                                                     | Required          | Yes      |
| acorn-jsx                                                                     | 5.3.2                                     | MIT                                                                                  | https://github.com/acornjs/acorn-jsx                                                                | Required          | Yes      |
| acorn-walk                                                                    | 8.3.2                                     | MIT                                                                                  | https://github.com/acornjs/acorn                                                                    | Required          | Yes      |
| acorn                                                                         | 8.11.3                                    | MIT                                                                                  | https://github.com/acornjs/acorn                                                                    | Required          | Yes      |
| agent-base                                                                    | 6.0.2                                     | MIT                                                                                  | https://github.com/TooTallNate/node-agent-base                                                      | Required          | Yes      |
| agentkeepalive                                                                | 4.5.0                                     | MIT                                                                                  | https://github.com/node-modules/agentkeepalive                                                      | Required          | Yes      |
| agentkeepalive                                                                | 4.6.0                                     | MIT                                                                                  | https://github.com/node-modules/agentkeepalive                                                      | Required          | Yes      |
| aggregate-error                                                               | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/aggregate-error                                                     | Required          | Yes      |
| ajv-formats                                                                   | 2.1.1                                     | MIT                                                                                  | https://github.com/ajv-validator/ajv-formats                                                        | Required          | Yes      |
| ajv-keywords                                                                  | 3.5.2                                     | MIT                                                                                  | https://github.com/epoberezkin/ajv-keywords                                                         | Required          | Yes      |
| ajv-keywords                                                                  | 5.1.0                                     | MIT                                                                                  | https://github.com/epoberezkin/ajv-keywords                                                         | Required          | Yes      |
| ajv                                                                           | 6.12.6                                    | MIT                                                                                  | https://github.com/ajv-validator/ajv                                                                | Required          | Yes      |
| ajv                                                                           | 8.16.0                                    | MIT                                                                                  | https://github.com/ajv-validator/ajv                                                                | Required          | Yes      |
| ansi-align                                                                    | 3.0.1                                     | ISC                                                                                  | https://github.com/nexdrew/ansi-align                                                               | Required          | Yes      |
| ansi-colors                                                                   | 4.1.3                                     | MIT                                                                                  | https://github.com/doowb/ansi-colors                                                                | Required          | Yes      |
| ansi-escapes                                                                  | 4.3.2                                     | MIT                                                                                  | https://github.com/sindresorhus/ansi-escapes                                                        | Required          | Yes      |
| ansi-html-community                                                           | 0.0.8                                     | Apache-2.0                                                                           | https://github.com/mahdyar/ansi-html-community                                                      | Required          | Yes      |
| ansi-html                                                                     | 0.0.9                                     | Apache-2.0                                                                           | https://github.com/Tjatse/ansi-html                                                                 | Required          | Yes      |
| ansi-regex                                                                    | 5.0.1                                     | MIT                                                                                  | https://github.com/chalk/ansi-regex                                                                 | Required          | Yes      |
| ansi-regex                                                                    | 6.0.1                                     | MIT                                                                                  | https://github.com/chalk/ansi-regex                                                                 | Required          | Yes      |
| ansi-styles                                                                   | 3.2.1                                     | MIT                                                                                  | https://github.com/chalk/ansi-styles                                                                | Required          | Yes      |
| ansi-styles                                                                   | 4.3.0                                     | MIT                                                                                  | https://github.com/chalk/ansi-styles                                                                | Required          | Yes      |
| ansi-styles                                                                   | 5.2.0                                     | MIT                                                                                  | https://github.com/chalk/ansi-styles                                                                | Required          | Yes      |
| ansi-styles                                                                   | 6.2.1                                     | MIT                                                                                  | https://github.com/chalk/ansi-styles                                                                | Required          | Yes      |
| any-promise                                                                   | 1.3.0                                     | MIT                                                                                  | https://github.com/kevinbeaty/any-promise                                                           | Required          | Yes      |
| anymatch                                                                      | 3.1.3                                     | ISC                                                                                  | https://github.com/micromatch/anymatch                                                              | Required          | Yes      |
| aproba                                                                        | 2.0.0                                     | ISC                                                                                  | https://github.com/iarna/aproba                                                                     | Required          | Yes      |
| arch                                                                          | 2.2.0                                     | MIT                                                                                  | https://github.com/feross/arch                                                                      | Required          | Yes      |
| are-we-there-yet                                                              | 3.0.1                                     | ISC                                                                                  | https://github.com/npm/are-we-there-yet                                                             | Required          | Yes      |
| arg                                                                           | 4.1.3                                     | MIT                                                                                  | https://github.com/zeit/arg                                                                         | Required          | Yes      |
| argparse                                                                      | 1.0.10                                    | MIT                                                                                  | https://github.com/nodeca/argparse                                                                  | Required          | Yes      |
| argparse                                                                      | 2.0.1                                     | Python-2.0                                                                           | https://github.com/nodeca/argparse                                                                  | Required          | Yes      |
| aria-hidden                                                                   | 1.2.4                                     | MIT                                                                                  | https://github.com/theKashey/aria-hidden                                                            | Required          | Yes      |
| aria-query                                                                    | 5.1.3                                     | Apache-2.0                                                                           | https://github.com/A11yance/aria-query                                                              | Required          | Yes      |
| aria-query                                                                    | 5.3.0                                     | Apache-2.0                                                                           | https://github.com/A11yance/aria-query                                                              | Required          | Yes      |
| array-buffer-byte-length                                                      | 1.0.1                                     | MIT                                                                                  | https://github.com/inspect-js/array-buffer-byte-length                                              | Required          | Yes      |
| array-buffer-byte-length                                                      | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/array-buffer-byte-length                                              | Required          | Yes      |
| array-find-index                                                              | 1.0.2                                     | MIT                                                                                  | https://github.com/sindresorhus/array-find-index                                                    | Required          | Yes      |
| array-flatten                                                                 | 1.1.1                                     | MIT                                                                                  | https://github.com/blakeembrey/array-flatten                                                        | Required          | Yes      |
| array-includes                                                                | 3.1.8                                     | MIT                                                                                  | https://github.com/es-shims/array-includes                                                          | Required          | Yes      |
| array-union                                                                   | 2.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/array-union                                                         | Required          | Yes      |
| array.prototype.filter                                                        | 1.0.4                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.filter                                                  | Required          | Yes      |
| array.prototype.findlast                                                      | 1.2.5                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.findLast                                                | Required          | Yes      |
| array.prototype.findlastindex                                                 | 1.2.5                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.findLastIndex                                           | Required          | Yes      |
| array.prototype.flat                                                          | 1.3.2                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.flat                                                    | Required          | Yes      |
| array.prototype.flatmap                                                       | 1.3.2                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.flatMap                                                 | Required          | Yes      |
| array.prototype.flatmap                                                       | 1.3.3                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.flatMap                                                 | Required          | Yes      |
| array.prototype.reduce                                                        | 1.0.7                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.reduce                                                  | Required          | Yes      |
| array.prototype.toreversed                                                    | 1.1.2                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.toReversed                                              | Required          | Yes      |
| array.prototype.tosorted                                                      | 1.1.4                                     | MIT                                                                                  | https://github.com/es-shims/Array.prototype.toSorted                                                | Required          | Yes      |
| arraybuffer.prototype.slice                                                   | 1.0.3                                     | MIT                                                                                  | https://github.com/es-shims/ArrayBuffer.prototype.slice                                             | Required          | Yes      |
| arraybuffer.prototype.slice                                                   | 1.0.4                                     | MIT                                                                                  | https://github.com/es-shims/ArrayBuffer.prototype.slice                                             | Required          | Yes      |
| arrify                                                                        | 1.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/arrify                                                              | Required          | Yes      |
| asap                                                                          | 2.0.6                                     | MIT                                                                                  | https://github.com/kriskowal/asap                                                                   | Required          | Yes      |
| asn1.js                                                                       | 4.10.1                                    | MIT                                                                                  | https://github.com/indutny/asn1.js                                                                  | Required          | Yes      |
| asn1                                                                          | 0.2.6                                     | MIT                                                                                  | https://github.com/joyent/node-asn1                                                                 | Required          | Yes      |
| assert-plus                                                                   | 1.0.0                                     | MIT                                                                                  | https://github.com/mcavage/node-assert-plus                                                         | Required          | Yes      |
| assertion-error                                                               | 1.1.0                                     | MIT                                                                                  | https://github.com/chaijs/assertion-error                                                           | Required          | Yes      |
| ast-types-flow                                                                | 0.0.8                                     | MIT                                                                                  | https://github.com/kyldvs/ast-types-flow                                                            | Required          | Yes      |
| ast-types                                                                     | 0.14.2                                    | MIT                                                                                  | https://github.com/benjamn/ast-types                                                                | Required          | Yes      |
| ast-types                                                                     | 0.16.1                                    | MIT                                                                                  | https://github.com/benjamn/ast-types                                                                | Required          | Yes      |
| astral-regex                                                                  | 2.0.0                                     | MIT                                                                                  | https://github.com/kevva/astral-regex                                                               | Required          | Yes      |
| async                                                                         | 3.2.5                                     | MIT                                                                                  | https://github.com/caolan/async                                                                     | Required          | Yes      |
| async                                                                         | 3.2.6                                     | MIT                                                                                  | https://github.com/caolan/async                                                                     | Required          | Yes      |
| asynckit                                                                      | 0.4.0                                     | MIT                                                                                  | https://github.com/alexindigo/asynckit                                                              | Required          | Yes      |
| at-least-node                                                                 | 1.0.0                                     | ISC                                                                                  | https://github.com/RyanZim/at-least-node                                                            | Required          | Yes      |
| atomic-sleep                                                                  | 1.0.0                                     | MIT                                                                                  | https://github.com/davidmarkclements/atomic-sleep                                                   | Required          | Yes      |
| attr-accept                                                                   | 2.2.2                                     | MIT                                                                                  | https://github.com/react-dropzone/attr-accept                                                       | Required          | Yes      |
| autoprefixer                                                                  | 10.4.20                                   | MIT                                                                                  | https://github.com/postcss/autoprefixer                                                             | Required          | Yes      |
| available-typed-arrays                                                        | 1.0.7                                     | MIT                                                                                  | https://github.com/inspect-js/available-typed-arrays                                                | Required          | Yes      |
| aws-sign2                                                                     | 0.7.0                                     | Apache-2.0                                                                           | https://github.com/mikeal/aws-sign                                                                  | Required          | Yes      |
| aws4                                                                          | 1.13.0                                    | MIT                                                                                  | https://github.com/mhart/aws4                                                                       | Required          | Yes      |
| axe-core                                                                      | 3.5.6                                     | MPL-2.0                                                                              | https://github.com/dequelabs/axe-core                                                               | Required          | Yes      |
| axe-core                                                                      | 4.10.2                                    | MPL-2.0                                                                              | https://github.com/dequelabs/axe-core                                                               | Required          | Yes      |
| axe-core                                                                      | 4.5.1                                     | MPL-2.0                                                                              | https://github.com/dequelabs/axe-core                                                               | Required          | Yes      |
| axe-core                                                                      | 4.7.0                                     | MPL-2.0                                                                              | https://github.com/dequelabs/axe-core                                                               | Required          | Yes      |
| axios                                                                         | 1.8.4                                     | MIT                                                                                  | https://github.com/axios/axios                                                                      | Required          | Yes      |
| axobject-query                                                                | 3.2.1                                     | Apache-2.0                                                                           | https://github.com/A11yance/axobject-query                                                          | Required          | Yes      |
| babel-core                                                                    | 7.0.0-bridge.0                            | MIT                                                                                  | N/A                                                                                                 | Required          | Yes      |
| babel-jest                                                                    | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| babel-loader                                                                  | 9.2.1                                     | MIT                                                                                  | https://github.com/babel/babel-loader                                                               | Required          | Yes      |
| babel-plugin-dynamic-import-node                                              | 2.3.3                                     | MIT                                                                                  | https://github.com/airbnb/babel-plugin-dynamic-import-node                                          | Required          | Yes      |
| babel-plugin-formatjs                                                         | 10.5.34                                   | MIT                                                                                  | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| babel-plugin-istanbul                                                         | 6.1.1                                     | BSD-3-Clause                                                                         | https://github.com/istanbuljs/babel-plugin-istanbul                                                 | Required          | Yes      |
| babel-plugin-jest-hoist                                                       | 29.6.3                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| babel-plugin-lodash                                                           | 3.3.4                                     | MIT                                                                                  | https://github.com/lodash/babel-plugin-lodash                                                       | Required          | Yes      |
| babel-plugin-macros                                                           | 3.1.0                                     | MIT                                                                                  | https://github.com/kentcdodds/babel-plugin-macros                                                   | Required          | Yes      |
| babel-plugin-polyfill-corejs2                                                 | 0.4.11                                    | MIT                                                                                  | https://github.com/babel/babel-polyfills                                                            | Required          | Yes      |
| babel-plugin-polyfill-corejs3                                                 | 0.10.6                                    | MIT                                                                                  | https://github.com/babel/babel-polyfills                                                            | Required          | Yes      |
| babel-plugin-polyfill-regenerator                                             | 0.6.2                                     | MIT                                                                                  | https://github.com/babel/babel-polyfills                                                            | Required          | Yes      |
| babel-preset-current-node-syntax                                              | 1.0.1                                     | MIT                                                                                  | https://github.com/nicolo-ribaudo/babel-preset-current-node-syntax                                  | Required          | Yes      |
| babel-preset-jest                                                             | 29.6.3                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| bail                                                                          | 1.0.5                                     | MIT                                                                                  | https://github.com/wooorm/bail                                                                      | Required          | Yes      |
| balanced-match                                                                | 1.0.2                                     | MIT                                                                                  | https://github.com/juliangruber/balanced-match                                                      | Required          | Yes      |
| balanced-match                                                                | 2.0.0                                     | MIT                                                                                  | https://github.com/juliangruber/balanced-match                                                      | Required          | Yes      |
| base-64                                                                       | 1.0.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/base64                                                             | Required          | Yes      |
| base64-js                                                                     | 1.5.1                                     | MIT                                                                                  | https://github.com/beatgammit/base64-js                                                             | Required          | Yes      |
| basic-auth                                                                    | 2.0.1                                     | MIT                                                                                  | https://github.com/jshttp/basic-auth                                                                | Required          | Yes      |
| bcrypt-pbkdf                                                                  | 1.0.2                                     | BSD-3-Clause                                                                         | https://github.com/joyent/node-bcrypt-pbkdf                                                         | Required          | Yes      |
| bcryptjs                                                                      | 2.4.3                                     | MIT                                                                                  | https://github.com/dcodeIO/bcrypt.js                                                                | Required          | Yes      |
| bezier-easing                                                                 | 2.1.0                                     | MIT                                                                                  | https://github.com/gre/bezier-easing                                                                | Required          | Yes      |
| big-integer                                                                   | 1.6.52                                    | Unlicense                                                                            | https://github.com/peterolson/BigInteger.js                                                         | Required          | Yes      |
| big.js                                                                        | 5.2.2                                     | MIT                                                                                  | https://github.com/MikeMcl/big.js                                                                   | Required          | Yes      |
| binary-extensions                                                             | 2.3.0                                     | MIT                                                                                  | https://github.com/sindresorhus/binary-extensions                                                   | Required          | Yes      |
| blob-util                                                                     | 2.0.2                                     | Apache-2.0                                                                           | https://github.com/nolanlawson/blob-util                                                            | Required          | Yes      |
| bluebird                                                                      | 3.7.1                                     | MIT                                                                                  | https://github.com/petkaantonov/bluebird                                                            | Required          | Yes      |
| bluebird                                                                      | 3.7.2                                     | MIT                                                                                  | https://github.com/petkaantonov/bluebird                                                            | Required          | Yes      |
| bn.js                                                                         | 4.12.0                                    | MIT                                                                                  | https://github.com/indutny/bn.js                                                                    | Required          | Yes      |
| bn.js                                                                         | 5.2.1                                     | MIT                                                                                  | https://github.com/indutny/bn.js                                                                    | Required          | Yes      |
| body-parser                                                                   | 1.20.3                                    | MIT                                                                                  | https://github.com/expressjs/body-parser                                                            | Required          | Yes      |
| boolbase                                                                      | 1.0.0                                     | ISC                                                                                  | https://github.com/fb55/boolbase                                                                    | Required          | Yes      |
| boxen                                                                         | 7.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/boxen                                                               | Required          | Yes      |
| brace-expansion                                                               | 1.1.11                                    | MIT                                                                                  | https://github.com/juliangruber/brace-expansion                                                     | Required          | Yes      |
| brace-expansion                                                               | 2.0.1                                     | MIT                                                                                  | https://github.com/juliangruber/brace-expansion                                                     | Required          | Yes      |
| brace                                                                         | 0.11.1                                    | MIT                                                                                  | https://github.com/thlorenz/brace                                                                   | Required          | Yes      |
| braces                                                                        | 3.0.3                                     | MIT                                                                                  | https://github.com/micromatch/braces                                                                | Required          | Yes      |
| broadcast-channel                                                             | 3.7.0                                     | MIT                                                                                  | https://github.com/pubkey/broadcast-channel                                                         | Required          | Yes      |
| brorand                                                                       | 1.1.0                                     | MIT                                                                                  | https://github.com/indutny/brorand                                                                  | Required          | Yes      |
| browserify-aes                                                                | 1.2.0                                     | MIT                                                                                  | https://github.com/crypto-browserify/browserify-aes                                                 | Required          | Yes      |
| browserify-cipher                                                             | 1.0.1                                     | MIT                                                                                  | https://github.com/crypto-browserify/browserify-cipher                                              | Required          | Yes      |
| browserify-des                                                                | 1.0.2                                     | MIT                                                                                  | https://github.com/crypto-browserify/browserify-des                                                 | Required          | Yes      |
| browserify-rsa                                                                | 4.1.0                                     | MIT                                                                                  | https://github.com/crypto-browserify/browserify-rsa                                                 | Required          | Yes      |
| browserify-sign                                                               | 4.2.3                                     | ISC                                                                                  | https://github.com/crypto-browserify/browserify-sign                                                | Required          | Yes      |
| browserslist                                                                  | 4.21.4                                    | MIT                                                                                  | https://github.com/browserslist/browserslist                                                        | Required          | Yes      |
| browserslist                                                                  | 4.23.0                                    | MIT                                                                                  | https://github.com/browserslist/browserslist                                                        | Required          | Yes      |
| browserslist                                                                  | 4.23.1                                    | MIT                                                                                  | https://github.com/browserslist/browserslist                                                        | Required          | Yes      |
| browserslist                                                                  | 4.23.2                                    | MIT                                                                                  | https://github.com/browserslist/browserslist                                                        | Required          | Yes      |
| browserslist                                                                  | 4.24.2                                    | MIT                                                                                  | https://github.com/browserslist/browserslist                                                        | Required          | Yes      |
| bser                                                                          | 2.1.1                                     | Apache-2.0                                                                           | https://github.com/facebook/watchman                                                                | Required          | Yes      |
| buffer-builder                                                                | 0.2.0                                     | MIT*                                                                                 | https://github.com/PeterReid/node-buffer-builder                                                    | Required          | Yes      |
| buffer-crc32                                                                  | 0.2.13                                    | MIT                                                                                  | https://github.com/brianloveswords/buffer-crc32                                                     | Required          | Yes      |
| buffer-from                                                                   | 1.1.2                                     | MIT                                                                                  | https://github.com/LinusU/buffer-from                                                               | Required          | Yes      |
| buffer-xor                                                                    | 1.0.3                                     | MIT                                                                                  | https://github.com/crypto-browserify/buffer-xor                                                     | Required          | Yes      |
| buffer                                                                        | 5.7.1                                     | MIT                                                                                  | https://github.com/feross/buffer                                                                    | Required          | Yes      |
| buffer                                                                        | 6.0.3                                     | MIT                                                                                  | https://github.com/feross/buffer                                                                    | Required          | Yes      |
| bytes                                                                         | 3.1.2                                     | MIT                                                                                  | https://github.com/visionmedia/bytes.js                                                             | Required          | Yes      |
| cacache                                                                       | 16.1.3                                    | ISC                                                                                  | https://github.com/npm/cacache                                                                      | Required          | Yes      |
| cacache                                                                       | 17.1.4                                    | ISC                                                                                  | https://github.com/npm/cacache                                                                      | Required          | Yes      |
| cacheable-lookup                                                              | 7.0.0                                     | MIT                                                                                  | https://github.com/szmarczak/cacheable-lookup                                                       | Required          | Yes      |
| cacheable-request                                                             | 10.2.14                                   | MIT                                                                                  | https://github.com/jaredwray/cacheable                                                              | Required          | Yes      |
| cachedir                                                                      | 2.4.0                                     | MIT                                                                                  | https://github.com/LinusU/node-cachedir                                                             | Required          | Yes      |
| call-bind-apply-helpers                                                       | 1.0.1                                     | MIT                                                                                  | https://github.com/ljharb/call-bind-apply-helpers                                                   | Required          | Yes      |
| call-bind                                                                     | 1.0.7                                     | MIT                                                                                  | https://github.com/ljharb/call-bind                                                                 | Required          | Yes      |
| call-bind                                                                     | 1.0.8                                     | MIT                                                                                  | https://github.com/ljharb/call-bind                                                                 | Required          | Yes      |
| call-bound                                                                    | 1.0.3                                     | MIT                                                                                  | https://github.com/ljharb/call-bound                                                                | Required          | Yes      |
| callsites                                                                     | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/callsites                                                           | Required          | Yes      |
| camel-case                                                                    | 4.1.2                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| camelcase-keys                                                                | 6.2.2                                     | MIT                                                                                  | https://github.com/sindresorhus/camelcase-keys                                                      | Required          | Yes      |
| camelcase-keys                                                                | 7.0.2                                     | MIT                                                                                  | https://github.com/sindresorhus/camelcase-keys                                                      | Required          | Yes      |
| camelcase                                                                     | 5.3.1                                     | MIT                                                                                  | https://github.com/sindresorhus/camelcase                                                           | Required          | Yes      |
| camelcase                                                                     | 6.3.0                                     | MIT                                                                                  | https://github.com/sindresorhus/camelcase                                                           | Required          | Yes      |
| camelcase                                                                     | 7.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/camelcase                                                           | Required          | Yes      |
| caniuse-api                                                                   | 3.0.0                                     | MIT                                                                                  | https://github.com/nyalab/caniuse-api                                                               | Required          | Yes      |
| caniuse-lite                                                                  | 1.0.30001629                              | CC-BY-4.0                                                                            | https://github.com/browserslist/caniuse-lite                                                        | Required          | Yes      |
| caniuse-lite                                                                  | 1.0.30001632                              | CC-BY-4.0                                                                            | https://github.com/browserslist/caniuse-lite                                                        | Required          | Yes      |
| caniuse-lite                                                                  | 1.0.30001642                              | CC-BY-4.0                                                                            | https://github.com/browserslist/caniuse-lite                                                        | Required          | Yes      |
| caniuse-lite                                                                  | 1.0.30001680                              | CC-BY-4.0                                                                            | https://github.com/browserslist/caniuse-lite                                                        | Required          | Yes      |
| capital-case                                                                  | 1.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| caseless                                                                      | 0.12.0                                    | Apache-2.0                                                                           | https://github.com/mikeal/caseless                                                                  | Required          | Yes      |
| ccount                                                                        | 1.1.0                                     | MIT                                                                                  | https://github.com/wooorm/ccount                                                                    | Required          | Yes      |
| chalk                                                                         | 2.4.2                                     | MIT                                                                                  | https://github.com/chalk/chalk                                                                      | Required          | Yes      |
| chalk                                                                         | 3.0.0                                     | MIT                                                                                  | https://github.com/chalk/chalk                                                                      | Required          | Yes      |
| chalk                                                                         | 4.1.2                                     | MIT                                                                                  | https://github.com/chalk/chalk                                                                      | Required          | Yes      |
| chalk                                                                         | 5.3.0                                     | MIT                                                                                  | https://github.com/chalk/chalk                                                                      | Required          | Yes      |
| change-case                                                                   | 4.1.2                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| char-regex                                                                    | 1.0.2                                     | MIT                                                                                  | https://github.com/Richienb/char-regex                                                              | Required          | Yes      |
| character-entities-html4                                                      | 1.1.4                                     | MIT                                                                                  | https://github.com/wooorm/character-entities-html4                                                  | Required          | Yes      |
| character-entities-legacy                                                     | 1.1.4                                     | MIT                                                                                  | https://github.com/wooorm/character-entities-legacy                                                 | Required          | Yes      |
| character-entities                                                            | 1.2.4                                     | MIT                                                                                  | https://github.com/wooorm/character-entities                                                        | Required          | Yes      |
| character-reference-invalid                                                   | 1.1.4                                     | MIT                                                                                  | https://github.com/wooorm/character-reference-invalid                                               | Required          | Yes      |
| charenc                                                                       | 0.0.2                                     | BSD-3-Clause                                                                         | https://github.com/pvorb/node-charenc                                                               | Required          | Yes      |
| check-more-types                                                              | 2.24.0                                    | MIT                                                                                  | https://github.com/kensho/check-more-types                                                          | Required          | Yes      |
| cheerio-select                                                                | 2.1.0                                     | BSD-2-Clause                                                                         | https://github.com/cheeriojs/cheerio-select                                                         | Required          | Yes      |
| cheerio                                                                       | 1.0.0-rc.12                               | MIT                                                                                  | https://github.com/cheeriojs/cheerio                                                                | Required          | Yes      |
| chokidar                                                                      | 3.6.0                                     | MIT                                                                                  | https://github.com/paulmillr/chokidar                                                               | Required          | Yes      |
| chownr                                                                        | 2.0.0                                     | ISC                                                                                  | https://github.com/isaacs/chownr                                                                    | Required          | Yes      |
| chroma-js                                                                     | 2.4.2                                     | (BSD-3-Clause AND Apache-2.0)                                                        | https://github.com/gka/chroma.js                                                                    | Required          | Yes      |
| chrome-trace-event                                                            | 1.0.4                                     | MIT                                                                                  | https://github.com/samccone/chrome-trace-event                                                      | Required          | Yes      |
| ci-info                                                                       | 3.9.0                                     | MIT                                                                                  | https://github.com/watson/ci-info                                                                   | Required          | Yes      |
| cipher-base                                                                   | 1.0.4                                     | MIT                                                                                  | https://github.com/crypto-browserify/cipher-base                                                    | Required          | Yes      |
| circular-dependency-plugin                                                    | 5.2.2                                     | ISC                                                                                  | https://github.com/aackerman/circular-dependency-plugin                                             | Required          | Yes      |
| cjs-module-lexer                                                              | 1.3.1                                     | MIT                                                                                  | https://github.com/nodejs/cjs-module-lexer                                                          | Required          | Yes      |
| classnames                                                                    | 2.5.1                                     | MIT                                                                                  | https://github.com/JedWatson/classnames                                                             | Required          | Yes      |
| clean-css                                                                     | 5.3.3                                     | MIT                                                                                  | https://github.com/clean-css/clean-css                                                              | Required          | Yes      |
| clean-stack                                                                   | 2.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/clean-stack                                                         | Required          | Yes      |
| cli-boxes                                                                     | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/cli-boxes                                                           | Required          | Yes      |
| cli-cursor                                                                    | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/cli-cursor                                                          | Required          | Yes      |
| cli-highlight                                                                 | 2.1.11                                    | ISC                                                                                  | https://github.com/felixfbecker/cli-highlight                                                       | Required          | Yes      |
| cli-table3                                                                    | 0.6.5                                     | MIT                                                                                  | https://github.com/cli-table/cli-table3                                                             | Required          | Yes      |
| cli-truncate                                                                  | 2.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/cli-truncate                                                        | Required          | Yes      |
| cliui                                                                         | 7.0.4                                     | ISC                                                                                  | https://github.com/yargs/cliui                                                                      | Required          | Yes      |
| cliui                                                                         | 8.0.1                                     | ISC                                                                                  | https://github.com/yargs/cliui                                                                      | Required          | Yes      |
| clone-deep                                                                    | 4.0.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/clone-deep                                                         | Required          | Yes      |
| co                                                                            | 4.6.0                                     | MIT                                                                                  | https://github.com/tj/co                                                                            | Required          | Yes      |
| collapse-white-space                                                          | 1.0.6                                     | MIT                                                                                  | https://github.com/wooorm/collapse-white-space                                                      | Required          | Yes      |
| collect-v8-coverage                                                           | 1.0.2                                     | MIT                                                                                  | https://github.com/SimenB/collect-v8-coverage                                                       | Required          | Yes      |
| color-convert                                                                 | 1.9.3                                     | MIT                                                                                  | https://github.com/Qix-/color-convert                                                               | Required          | Yes      |
| color-convert                                                                 | 2.0.1                                     | MIT                                                                                  | https://github.com/Qix-/color-convert                                                               | Required          | Yes      |
| color-name                                                                    | 1.1.3                                     | MIT                                                                                  | https://github.com/dfcreative/color-name                                                            | Required          | Yes      |
| color-name                                                                    | 1.1.4                                     | MIT                                                                                  | https://github.com/colorjs/color-name                                                               | Required          | Yes      |
| color-support                                                                 | 1.1.3                                     | ISC                                                                                  | https://github.com/isaacs/color-support                                                             | Required          | Yes      |
| colord                                                                        | 2.9.3                                     | MIT                                                                                  | https://github.com/omgovich/colord                                                                  | Required          | Yes      |
| colorette                                                                     | 2.0.20                                    | MIT                                                                                  | https://github.com/jorgebucaran/colorette                                                           | Required          | Yes      |
| colorjs.io                                                                    | 0.5.2                                     | MIT                                                                                  | https://github.com/LeaVerou/color.js                                                                | Required          | Yes      |
| combined-stream                                                               | 1.0.8                                     | MIT                                                                                  | https://github.com/felixge/node-combined-stream                                                     | Required          | Yes      |
| comma-separated-tokens                                                        | 1.0.8                                     | MIT                                                                                  | https://github.com/wooorm/comma-separated-tokens                                                    | Required          | Yes      |
| commander                                                                     | 10.0.1                                    | MIT                                                                                  | https://github.com/tj/commander.js                                                                  | Required          | Yes      |
| commander                                                                     | 11.1.0                                    | MIT                                                                                  | https://github.com/tj/commander.js                                                                  | Required          | Yes      |
| commander                                                                     | 2.20.3                                    | MIT                                                                                  | https://github.com/tj/commander.js                                                                  | Required          | Yes      |
| commander                                                                     | 6.2.1                                     | MIT                                                                                  | https://github.com/tj/commander.js                                                                  | Required          | Yes      |
| commander                                                                     | 7.2.0                                     | MIT                                                                                  | https://github.com/tj/commander.js                                                                  | Required          | Yes      |
| commander                                                                     | 8.3.0                                     | MIT                                                                                  | https://github.com/tj/commander.js                                                                  | Required          | Yes      |
| common-path-prefix                                                            | 3.0.0                                     | ISC                                                                                  | https://github.com/novemberborn/common-path-prefix                                                  | Required          | Yes      |
| common-tags                                                                   | 1.8.2                                     | MIT                                                                                  | https://github.com/zspecza/common-tags                                                              | Required          | Yes      |
| commondir                                                                     | 1.0.1                                     | MIT                                                                                  | https://github.com/substack/node-commondir                                                          | Required          | Yes      |
| compressible                                                                  | 2.0.18                                    | MIT                                                                                  | https://github.com/jshttp/compressible                                                              | Required          | Yes      |
| compression                                                                   | 1.7.5                                     | MIT                                                                                  | https://github.com/expressjs/compression                                                            | Required          | Yes      |
| compute-scroll-into-view                                                      | 3.1.0                                     | MIT                                                                                  | https://github.com/scroll-into-view/compute-scroll-into-view                                        | Required          | Yes      |
| concat-map                                                                    | 0.0.1                                     | MIT                                                                                  | https://github.com/substack/node-concat-map                                                         | Required          | Yes      |
| concurrently                                                                  | 9.1.2                                     | MIT                                                                                  | https://github.com/open-cli-tools/concurrently                                                      | Required          | Yes      |
| condense-newlines                                                             | 0.2.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/condense-newlines                                                  | Required          | Yes      |
| config-chain                                                                  | 1.1.13                                    | MIT                                                                                  | https://github.com/dominictarr/config-chain                                                         | Required          | Yes      |
| configstore                                                                   | 6.0.0                                     | BSD-2-Clause                                                                         | https://github.com/yeoman/configstore                                                               | Required          | Yes      |
| console-control-strings                                                       | 1.1.0                                     | ISC                                                                                  | https://github.com/iarna/console-control-strings                                                    | Required          | Yes      |
| constant-case                                                                 | 3.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| content-disposition                                                           | 0.5.4                                     | MIT                                                                                  | https://github.com/jshttp/content-disposition                                                       | Required          | Yes      |
| content-type                                                                  | 1.0.5                                     | MIT                                                                                  | https://github.com/jshttp/content-type                                                              | Required          | Yes      |
| convert-source-map                                                            | 1.9.0                                     | MIT                                                                                  | https://github.com/thlorenz/convert-source-map                                                      | Required          | Yes      |
| convert-source-map                                                            | 2.0.0                                     | MIT                                                                                  | https://github.com/thlorenz/convert-source-map                                                      | Required          | Yes      |
| cookie-parser                                                                 | 1.4.7                                     | MIT                                                                                  | https://github.com/expressjs/cookie-parser                                                          | Required          | Yes      |
| cookie-signature                                                              | 1.0.6                                     | MIT                                                                                  | https://github.com/visionmedia/node-cookie-signature                                                | Required          | Yes      |
| cookie                                                                        | 0.7.1                                     | MIT                                                                                  | https://github.com/jshttp/cookie                                                                    | Required          | Yes      |
| cookie                                                                        | 0.7.2                                     | MIT                                                                                  | https://github.com/jshttp/cookie                                                                    | Required          | Yes      |
| copy-to-clipboard                                                             | 3.3.3                                     | MIT                                                                                  | https://github.com/sudodoki/copy-to-clipboard                                                       | Required          | Yes      |
| copy-webpack-plugin                                                           | 11.0.0                                    | MIT                                                                                  | https://github.com/webpack-contrib/copy-webpack-plugin                                              | Required          | Yes      |
| core-js-compat                                                                | 3.39.0                                    | MIT                                                                                  | https://github.com/zloirock/core-js                                                                 | Required          | Yes      |
| core-js-pure                                                                  | 3.37.1                                    | MIT                                                                                  | https://github.com/zloirock/core-js                                                                 | Required          | Yes      |
| core-js                                                                       | 3.37.1                                    | MIT                                                                                  | https://github.com/zloirock/core-js                                                                 | Required          | Yes      |
| core-js                                                                       | 3.38.1                                    | MIT                                                                                  | https://github.com/zloirock/core-js                                                                 | Required          | Yes      |
| core-js                                                                       | 3.40.0                                    | MIT                                                                                  | https://github.com/zloirock/core-js                                                                 | Required          | Yes      |
| core-util-is                                                                  | 1.0.2                                     | MIT                                                                                  | https://github.com/isaacs/core-util-is                                                              | Required          | Yes      |
| core-util-is                                                                  | 1.0.3                                     | MIT                                                                                  | https://github.com/isaacs/core-util-is                                                              | Required          | Yes      |
| cosmiconfig                                                                   | 7.1.0                                     | MIT                                                                                  | https://github.com/davidtheclark/cosmiconfig                                                        | Required          | Yes      |
| cosmiconfig                                                                   | 8.3.6                                     | MIT                                                                                  | https://github.com/cosmiconfig/cosmiconfig                                                          | Required          | Yes      |
| country-code-to-flag-emoji                                                    | 1.3.3                                     | MIT                                                                                  | https://github.com/wojtekmaj/country-code-to-flag-emoji                                             | Required          | Yes      |
| create-ecdh                                                                   | 4.0.4                                     | MIT                                                                                  | https://github.com/crypto-browserify/createECDH                                                     | Required          | Yes      |
| create-hash                                                                   | 1.2.0                                     | MIT                                                                                  | https://github.com/crypto-browserify/createHash                                                     | Required          | Yes      |
| create-hmac                                                                   | 1.1.7                                     | MIT                                                                                  | https://github.com/crypto-browserify/createHmac                                                     | Required          | Yes      |
| create-jest                                                                   | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| create-react-class                                                            | 15.7.0                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| create-require                                                                | 1.1.1                                     | MIT                                                                                  | https://github.com/nuxt-contrib/create-require                                                      | Required          | Yes      |
| cross-spawn                                                                   | 7.0.5                                     | MIT                                                                                  | https://github.com/moxystudio/node-cross-spawn                                                      | Required          | Yes      |
| crypt                                                                         | 0.0.2                                     | BSD-3-Clause                                                                         | https://github.com/pvorb/node-crypt                                                                 | Required          | Yes      |
| crypto-browserify                                                             | 3.12.1                                    | MIT                                                                                  | https://github.com/browserify/crypto-browserify                                                     | Required          | Yes      |
| crypto-random-string                                                          | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/crypto-random-string                                                | Required          | Yes      |
| css-box-model                                                                 | 1.2.1                                     | MIT                                                                                  | https://github.com/alexreardon/css-box-model                                                        | Required          | Yes      |
| css-declaration-sorter                                                        | 7.2.0                                     | ISC                                                                                  | https://github.com/Siilwyn/css-declaration-sorter                                                   | Required          | Yes      |
| css-functions-list                                                            | 3.2.2                                     | MIT                                                                                  | https://github.com/niksy/css-functions-list                                                         | Required          | Yes      |
| css-loader                                                                    | 6.11.0                                    | MIT                                                                                  | https://github.com/webpack-contrib/css-loader                                                       | Required          | Yes      |
| css-mediaquery                                                                | 0.1.2                                     | BSD*                                                                                 | https://github.com/ericf/css-mediaquery                                                             | Required          | Yes      |
| css-select                                                                    | 4.3.0                                     | BSD-2-Clause                                                                         | https://github.com/fb55/css-select                                                                  | Required          | Yes      |
| css-select                                                                    | 5.1.0                                     | BSD-2-Clause                                                                         | https://github.com/fb55/css-select                                                                  | Required          | Yes      |
| css-tree                                                                      | 2.2.1                                     | MIT                                                                                  | https://github.com/csstree/csstree                                                                  | Required          | Yes      |
| css-tree                                                                      | 2.3.1                                     | MIT                                                                                  | https://github.com/csstree/csstree                                                                  | Required          | Yes      |
| css-what                                                                      | 6.1.0                                     | BSD-2-Clause                                                                         | https://github.com/fb55/css-what                                                                    | Required          | Yes      |
| css.escape                                                                    | 1.5.1                                     | MIT                                                                                  | https://github.com/mathiasbynens/CSS.escape                                                         | Required          | Yes      |
| cssesc                                                                        | 3.0.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/cssesc                                                             | Required          | Yes      |
| cssfontparser                                                                 | 1.2.1                                     | MIT                                                                                  | https://github.com/tmpvar/cssfontparser                                                             | Required          | Yes      |
| cssnano-preset-default                                                        | 6.1.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| cssnano-utils                                                                 | 4.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| cssnano                                                                       | 6.1.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| csso                                                                          | 5.0.5                                     | MIT                                                                                  | https://github.com/css/csso                                                                         | Required          | Yes      |
| cssom                                                                         | 0.3.8                                     | MIT                                                                                  | https://github.com/NV/CSSOM                                                                         | Required          | Yes      |
| cssom                                                                         | 0.5.0                                     | MIT                                                                                  | https://github.com/NV/CSSOM                                                                         | Required          | Yes      |
| cssstyle                                                                      | 2.3.0                                     | MIT                                                                                  | https://github.com/jsdom/cssstyle                                                                   | Required          | Yes      |
| csstype                                                                       | 3.1.3                                     | MIT                                                                                  | https://github.com/frenic/csstype                                                                   | Required          | Yes      |
| cypress-otp                                                                   | 1.0.3                                     | MIT                                                                                  | https://github.com/NoriSte/cypress-otp                                                              | Required          | Yes      |
| cypress-recurse                                                               | 1.35.3                                    | MIT                                                                                  | https://github.com/bahmutov/cypress-recurse                                                         | Required          | Yes      |
| cypress                                                                       | 13.13.0                                   | MIT                                                                                  | https://github.com/cypress-io/cypress                                                               | Required          | Yes      |
| d3-array                                                                      | 1.2.4                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-array                                                                      | Required          | Yes      |
| d3-array                                                                      | 2.12.1                                    | BSD-3-Clause                                                                         | https://github.com/d3/d3-array                                                                      | Required          | Yes      |
| d3-cloud                                                                      | 1.2.7                                     | BSD-3-Clause                                                                         | https://github.com/jasondavies/d3-cloud                                                             | Required          | Yes      |
| d3-collection                                                                 | 1.0.7                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-collection                                                                 | Required          | Yes      |
| d3-dispatch                                                                   | 1.0.6                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-dispatch                                                                   | Required          | Yes      |
| d3-format                                                                     | 2.0.0                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-format                                                                     | Required          | Yes      |
| d3-hexbin                                                                     | 0.2.2                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-hexbin                                                                     | Required          | Yes      |
| d3-interpolate                                                                | 2.0.1                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-interpolate                                                                | Required          | Yes      |
| d3-interpolate                                                                | 3.0.1                                     | ISC                                                                                  | https://github.com/d3/d3-interpolate                                                                | Required          | Yes      |
| d3-path                                                                       | 2.0.0                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-path                                                                       | Required          | Yes      |
| d3-scale                                                                      | 3.3.0                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-scale                                                                      | Required          | Yes      |
| d3-shape                                                                      | 2.1.0                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-shape                                                                      | Required          | Yes      |
| d3-time-format                                                                | 3.0.0                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-time-format                                                                | Required          | Yes      |
| d3-time                                                                       | 2.1.1                                     | BSD-3-Clause                                                                         | https://github.com/d3/d3-time                                                                       | Required          | Yes      |
| damerau-levenshtein                                                           | 1.0.8                                     | BSD-2-Clause                                                                         | https://github.com/tad-lispy/node-damerau-levenshtein                                               | Required          | Yes      |
| dashdash                                                                      | 1.14.1                                    | MIT                                                                                  | https://github.com/trentm/node-dashdash                                                             | Required          | Yes      |
| data-urls                                                                     | 3.0.2                                     | MIT                                                                                  | https://github.com/jsdom/data-urls                                                                  | Required          | Yes      |
| data-view-buffer                                                              | 1.0.1                                     | MIT                                                                                  | https://github.com/ljharb/data-view-buffer                                                          | Required          | Yes      |
| data-view-buffer                                                              | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/data-view-buffer                                                      | Required          | Yes      |
| data-view-byte-length                                                         | 1.0.1                                     | MIT                                                                                  | https://github.com/ljharb/data-view-byte-length                                                     | Required          | Yes      |
| data-view-byte-length                                                         | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/data-view-byte-length                                                 | Required          | Yes      |
| data-view-byte-offset                                                         | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/data-view-byte-offset                                                     | Required          | Yes      |
| data-view-byte-offset                                                         | 1.0.1                                     | MIT                                                                                  | https://github.com/inspect-js/data-view-byte-offset                                                 | Required          | Yes      |
| dateformat                                                                    | 4.6.3                                     | MIT                                                                                  | https://github.com/felixge/node-dateformat                                                          | Required          | Yes      |
| dayjs                                                                         | 1.11.11                                   | MIT                                                                                  | https://github.com/iamkun/dayjs                                                                     | Required          | Yes      |
| debug                                                                         | 2.6.9                                     | MIT                                                                                  | https://github.com/visionmedia/debug                                                                | Required          | Yes      |
| debug                                                                         | 3.2.7                                     | MIT                                                                                  | https://github.com/visionmedia/debug                                                                | Required          | Yes      |
| debug                                                                         | 4.3.5                                     | MIT                                                                                  | https://github.com/debug-js/debug                                                                   | Required          | Yes      |
| debug                                                                         | 4.3.7                                     | MIT                                                                                  | https://github.com/debug-js/debug                                                                   | Required          | Yes      |
| debug                                                                         | 4.4.0                                     | MIT                                                                                  | https://github.com/debug-js/debug                                                                   | Required          | Yes      |
| debuglog                                                                      | 1.0.1                                     | MIT                                                                                  | https://github.com/sam-github/node-debuglog                                                         | Required          | Yes      |
| decamelize-keys                                                               | 1.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/decamelize-keys                                                     | Required          | Yes      |
| decamelize                                                                    | 1.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/decamelize                                                          | Required          | Yes      |
| decamelize                                                                    | 5.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/decamelize                                                          | Required          | Yes      |
| decimal.js                                                                    | 10.4.3                                    | MIT                                                                                  | https://github.com/MikeMcl/decimal.js                                                               | Required          | Yes      |
| decode-uri-component                                                          | 0.2.2                                     | MIT                                                                                  | https://github.com/SamVerschueren/decode-uri-component                                              | Required          | Yes      |
| decompress-response                                                           | 6.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/decompress-response                                                 | Required          | Yes      |
| dedent                                                                        | 1.5.3                                     | MIT                                                                                  | https://github.com/dmnd/dedent                                                                      | Required          | Yes      |
| deep-diff                                                                     | 0.3.8                                     | MIT                                                                                  | https://github.com/flitbit/diff                                                                     | Required          | Yes      |
| deep-diff                                                                     | 1.0.2                                     | MIT                                                                                  | https://github.com/flitbit/diff                                                                     | Required          | Yes      |
| deep-equal                                                                    | 2.2.3                                     | MIT                                                                                  | https://github.com/inspect-js/node-deep-equal                                                       | Required          | Yes      |
| deep-extend                                                                   | 0.6.0                                     | MIT                                                                                  | https://github.com/unclechu/node-deep-extend                                                        | Required          | Yes      |
| deep-is                                                                       | 0.1.4                                     | MIT                                                                                  | https://github.com/thlorenz/deep-is                                                                 | Required          | Yes      |
| deepmerge                                                                     | 2.2.1                                     | MIT                                                                                  | https://github.com/KyleAMathews/deepmerge                                                           | Required          | Yes      |
| deepmerge                                                                     | 4.3.1                                     | MIT                                                                                  | https://github.com/TehShrike/deepmerge                                                              | Required          | Yes      |
| defer-to-connect                                                              | 2.0.1                                     | MIT                                                                                  | https://github.com/szmarczak/defer-to-connect                                                       | Required          | Yes      |
| define-data-property                                                          | 1.1.4                                     | MIT                                                                                  | https://github.com/ljharb/define-data-property                                                      | Required          | Yes      |
| define-properties                                                             | 1.2.1                                     | MIT                                                                                  | https://github.com/ljharb/define-properties                                                         | Required          | Yes      |
| delayed-stream                                                                | 1.0.0                                     | MIT                                                                                  | https://github.com/felixge/node-delayed-stream                                                      | Required          | Yes      |
| delegates                                                                     | 1.0.0                                     | MIT                                                                                  | https://github.com/visionmedia/node-delegates                                                       | Required          | Yes      |
| depd                                                                          | 2.0.0                                     | MIT                                                                                  | https://github.com/dougwilson/nodejs-depd                                                           | Required          | Yes      |
| dequal                                                                        | 2.0.3                                     | MIT                                                                                  | https://github.com/lukeed/dequal                                                                    | Required          | Yes      |
| des.js                                                                        | 1.1.0                                     | MIT                                                                                  | https://github.com/indutny/des.js                                                                   | Required          | Yes      |
| destroy                                                                       | 1.2.0                                     | MIT                                                                                  | https://github.com/stream-utils/destroy                                                             | Required          | Yes      |
| detect-newline                                                                | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/detect-newline                                                      | Required          | Yes      |
| detect-node-es                                                                | 1.1.0                                     | MIT                                                                                  | https://github.com/thekashey/detect-node                                                            | Required          | Yes      |
| detect-node                                                                   | 2.1.0                                     | MIT                                                                                  | https://github.com/iliakan/detect-node                                                              | Required          | Yes      |
| dezalgo                                                                       | 1.0.4                                     | ISC                                                                                  | https://github.com/npm/dezalgo                                                                      | Required          | Yes      |
| diacritics                                                                    | 1.3.0                                     | MIT                                                                                  | https://github.com/andrewrk/node-diacritics                                                         | Required          | Yes      |
| diff-match-patch                                                              | 1.0.5                                     | Apache-2.0                                                                           | https://github.com/JackuB/diff-match-patch                                                          | Required          | Yes      |
| diff-sequences                                                                | 29.6.3                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| diff                                                                          | 4.0.2                                     | BSD-3-Clause                                                                         | https://github.com/kpdecker/jsdiff                                                                  | Required          | Yes      |
| diff                                                                          | 5.2.0                                     | BSD-3-Clause                                                                         | https://github.com/kpdecker/jsdiff                                                                  | Required          | Yes      |
| diffie-hellman                                                                | 5.0.3                                     | MIT                                                                                  | https://github.com/crypto-browserify/diffie-hellman                                                 | Required          | Yes      |
| dir-glob                                                                      | 3.0.1                                     | MIT                                                                                  | https://github.com/kevva/dir-glob                                                                   | Required          | Yes      |
| discontinuous-range                                                           | 1.0.0                                     | MIT                                                                                  | https://github.com/dtudury/discontinuous-range                                                      | Required          | Yes      |
| doctrine                                                                      | 2.1.0                                     | Apache-2.0                                                                           | https://github.com/eslint/doctrine                                                                  | Required          | Yes      |
| doctrine                                                                      | 3.0.0                                     | Apache-2.0                                                                           | https://github.com/eslint/doctrine                                                                  | Required          | Yes      |
| dom-accessibility-api                                                         | 0.5.16                                    | MIT                                                                                  | https://github.com/eps1lon/dom-accessibility-api                                                    | Required          | Yes      |
| dom-converter                                                                 | 0.2.0                                     | MIT                                                                                  | https://github.com/AriaMinaei/dom-converter                                                         | Required          | Yes      |
| dom-serializer                                                                | 1.4.1                                     | MIT                                                                                  | https://github.com/cheeriojs/dom-renderer                                                           | Required          | Yes      |
| dom-serializer                                                                | 2.0.0                                     | MIT                                                                                  | https://github.com/cheeriojs/dom-serializer                                                         | Required          | Yes      |
| domelementtype                                                                | 2.3.0                                     | BSD-2-Clause                                                                         | https://github.com/fb55/domelementtype                                                              | Required          | Yes      |
| domexception                                                                  | 4.0.0                                     | MIT                                                                                  | https://github.com/jsdom/domexception                                                               | Required          | Yes      |
| domhandler                                                                    | 4.3.1                                     | BSD-2-Clause                                                                         | https://github.com/fb55/domhandler                                                                  | Required          | Yes      |
| domhandler                                                                    | 5.0.3                                     | BSD-2-Clause                                                                         | https://github.com/fb55/domhandler                                                                  | Required          | Yes      |
| dompurify                                                                     | 3.2.4                                     | (MPL-2.0 OR Apache-2.0)                                                              | https://github.com/cure53/DOMPurify                                                                 | Required          | Yes      |
| domutils                                                                      | 2.8.0                                     | BSD-2-Clause                                                                         | https://github.com/fb55/domutils                                                                    | Required          | Yes      |
| domutils                                                                      | 3.1.0                                     | BSD-2-Clause                                                                         | https://github.com/fb55/domutils                                                                    | Required          | Yes      |
| dot-case                                                                      | 3.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| dot-prop                                                                      | 6.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/dot-prop                                                            | Required          | Yes      |
| downloadjs                                                                    | 1.4.7                                     | MIT                                                                                  | https://github.com/rndme/download                                                                   | Required          | Yes      |
| dunder-proto                                                                  | 1.0.1                                     | MIT                                                                                  | https://github.com/es-shims/dunder-proto                                                            | Required          | Yes      |
| eastasianwidth                                                                | 0.2.0                                     | MIT                                                                                  | https://github.com/komagata/eastasianwidth                                                          | Required          | Yes      |
| ecc-jsbn                                                                      | 0.1.2                                     | MIT                                                                                  | https://github.com/quartzjer/ecc-jsbn                                                               | Required          | Yes      |
| editorconfig                                                                  | 1.0.4                                     | MIT                                                                                  | https://github.com/editorconfig/editorconfig-core-js                                                | Required          | Yes      |
| ee-first                                                                      | 1.1.1                                     | MIT                                                                                  | https://github.com/jonathanong/ee-first                                                             | Required          | Yes      |
| ejs                                                                           | 3.1.10                                    | Apache-2.0                                                                           | https://github.com/mde/ejs                                                                          | Required          | Yes      |
| electron-to-chromium                                                          | 1.4.795                                   | ISC                                                                                  | https://github.com/kilian/electron-to-chromium                                                      | Required          | Yes      |
| electron-to-chromium                                                          | 1.4.796                                   | ISC                                                                                  | https://github.com/kilian/electron-to-chromium                                                      | Required          | Yes      |
| electron-to-chromium                                                          | 1.4.828                                   | ISC                                                                                  | https://github.com/kilian/electron-to-chromium                                                      | Required          | Yes      |
| electron-to-chromium                                                          | 1.5.56                                    | ISC                                                                                  | https://github.com/kilian/electron-to-chromium                                                      | Required          | Yes      |
| elliptic                                                                      | 6.6.1                                     | MIT                                                                                  | https://github.com/indutny/elliptic                                                                 | Required          | Yes      |
| emittery                                                                      | 0.13.1                                    | MIT                                                                                  | https://github.com/sindresorhus/emittery                                                            | Required          | Yes      |
| emoji-regex                                                                   | 8.0.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/emoji-regex                                                        | Required          | Yes      |
| emoji-regex                                                                   | 9.2.2                                     | MIT                                                                                  | https://github.com/mathiasbynens/emoji-regex                                                        | Required          | Yes      |
| emojis-list                                                                   | 3.0.0                                     | MIT                                                                                  | https://github.com/kikobeats/emojis-list                                                            | Required          | Yes      |
| emoticon                                                                      | 3.2.0                                     | MIT                                                                                  | https://github.com/wooorm/emoticon                                                                  | Required          | Yes      |
| encodeurl                                                                     | 1.0.2                                     | MIT                                                                                  | https://github.com/pillarjs/encodeurl                                                               | Required          | Yes      |
| encodeurl                                                                     | 2.0.0                                     | MIT                                                                                  | https://github.com/pillarjs/encodeurl                                                               | Required          | Yes      |
| encoding                                                                      | 0.1.13                                    | MIT                                                                                  | https://github.com/andris9/encoding                                                                 | Required          | Yes      |
| end-of-stream                                                                 | 1.4.4                                     | MIT                                                                                  | https://github.com/mafintosh/end-of-stream                                                          | Required          | Yes      |
| enhanced-resolve                                                              | 5.10.0                                    | MIT                                                                                  | https://github.com/webpack/enhanced-resolve                                                         | Required          | Yes      |
| enhanced-resolve                                                              | 5.17.1                                    | MIT                                                                                  | https://github.com/webpack/enhanced-resolve                                                         | Required          | Yes      |
| enquirer                                                                      | 2.4.1                                     | MIT                                                                                  | https://github.com/enquirer/enquirer                                                                | Required          | Yes      |
| entities                                                                      | 2.2.0                                     | BSD-2-Clause                                                                         | https://github.com/fb55/entities                                                                    | Required          | Yes      |
| entities                                                                      | 3.0.1                                     | BSD-2-Clause                                                                         | https://github.com/fb55/entities                                                                    | Required          | Yes      |
| entities                                                                      | 4.5.0                                     | BSD-2-Clause                                                                         | https://github.com/fb55/entities                                                                    | Required          | Yes      |
| env-paths                                                                     | 2.2.1                                     | MIT                                                                                  | https://github.com/sindresorhus/env-paths                                                           | Required          | Yes      |
| envinfo                                                                       | 7.13.0                                    | MIT                                                                                  | https://github.com/tabrindle/envinfo                                                                | Required          | Yes      |
| enzyme-shallow-equal                                                          | 1.0.7                                     | MIT                                                                                  | https://github.com/enzymejs/enzyme                                                                  | Required          | Yes      |
| enzyme-to-json                                                                | 3.6.2                                     | MIT                                                                                  | https://github.com/adriantoine/enzyme-to-json                                                       | Required          | Yes      |
| enzyme-wait                                                                   | 1.0.9                                     | MIT                                                                                  | https://github.com/etiennedi/enzyme-wait                                                            | Required          | Yes      |
| enzyme                                                                        | 3.11.0                                    | MIT                                                                                  | https://github.com/airbnb/enzyme                                                                    | Required          | Yes      |
| err-code                                                                      | 2.0.3                                     | MIT                                                                                  | https://github.com/IndigoUnited/js-err-code                                                         | Required          | Yes      |
| errno                                                                         | 0.1.8                                     | MIT                                                                                  | https://github.com/rvagg/node-errno                                                                 | Required          | Yes      |
| error-ex                                                                      | 1.3.2                                     | MIT                                                                                  | https://github.com/qix-/node-error-ex                                                               | Required          | Yes      |
| error-stack-parser                                                            | 1.3.6                                     | Unlicense                                                                            | https://github.com/stacktracejs/error-stack-parser                                                  | Required          | Yes      |
| error-stack-parser                                                            | 2.1.4                                     | MIT                                                                                  | https://github.com/stacktracejs/error-stack-parser                                                  | Required          | Yes      |
| es-abstract                                                                   | 1.23.3                                    | MIT                                                                                  | https://github.com/ljharb/es-abstract                                                               | Required          | Yes      |
| es-abstract                                                                   | 1.23.9                                    | MIT                                                                                  | https://github.com/ljharb/es-abstract                                                               | Required          | Yes      |
| es-array-method-boxes-properly                                                | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/es-array-method-boxes-properly                                            | Required          | Yes      |
| es-define-property                                                            | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/es-define-property                                                        | Required          | Yes      |
| es-define-property                                                            | 1.0.1                                     | MIT                                                                                  | https://github.com/ljharb/es-define-property                                                        | Required          | Yes      |
| es-errors                                                                     | 1.3.0                                     | MIT                                                                                  | https://github.com/ljharb/es-errors                                                                 | Required          | Yes      |
| es-get-iterator                                                               | 1.1.3                                     | MIT                                                                                  | https://github.com/ljharb/es-get-iterator                                                           | Required          | Yes      |
| es-iterator-helpers                                                           | 1.0.19                                    | MIT                                                                                  | https://github.com/es-shims/iterator-helpers                                                        | Required          | Yes      |
| es-iterator-helpers                                                           | 1.2.1                                     | MIT                                                                                  | https://github.com/es-shims/iterator-helpers                                                        | Required          | Yes      |
| es-module-lexer                                                               | 1.5.3                                     | MIT                                                                                  | https://github.com/guybedford/es-module-lexer                                                       | Required          | Yes      |
| es-object-atoms                                                               | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/es-object-atoms                                                           | Required          | Yes      |
| es-set-tostringtag                                                            | 2.0.3                                     | MIT                                                                                  | https://github.com/es-shims/es-set-tostringtag                                                      | Required          | Yes      |
| es-set-tostringtag                                                            | 2.1.0                                     | MIT                                                                                  | https://github.com/es-shims/es-set-tostringtag                                                      | Required          | Yes      |
| es-shim-unscopables                                                           | 1.0.2                                     | MIT                                                                                  | https://github.com/ljharb/es-shim-unscopables                                                       | Required          | Yes      |
| es-to-primitive                                                               | 1.2.1                                     | MIT                                                                                  | https://github.com/ljharb/es-to-primitive                                                           | Required          | Yes      |
| es-to-primitive                                                               | 1.3.0                                     | MIT                                                                                  | https://github.com/ljharb/es-to-primitive                                                           | Required          | Yes      |
| escalade                                                                      | 3.1.2                                     | MIT                                                                                  | https://github.com/lukeed/escalade                                                                  | Required          | Yes      |
| escalade                                                                      | 3.2.0                                     | MIT                                                                                  | https://github.com/lukeed/escalade                                                                  | Required          | Yes      |
| escape-goat                                                                   | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/escape-goat                                                         | Required          | Yes      |
| escape-html                                                                   | 1.0.3                                     | MIT                                                                                  | https://github.com/component/escape-html                                                            | Required          | Yes      |
| escape-string-regexp                                                          | 1.0.5                                     | MIT                                                                                  | https://github.com/sindresorhus/escape-string-regexp                                                | Required          | Yes      |
| escape-string-regexp                                                          | 2.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/escape-string-regexp                                                | Required          | Yes      |
| escape-string-regexp                                                          | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/escape-string-regexp                                                | Required          | Yes      |
| escodegen                                                                     | 2.1.0                                     | BSD-2-Clause                                                                         | https://github.com/estools/escodegen                                                                | Required          | Yes      |
| eslint-config-prettier                                                        | 8.10.0                                    | MIT                                                                                  | https://github.com/prettier/eslint-config-prettier                                                  | Required          | Yes      |
| eslint-import-resolver-node                                                   | 0.3.9                                     | MIT                                                                                  | https://github.com/import-js/eslint-plugin-import                                                   | Required          | Yes      |
| eslint-import-resolver-typescript                                             | 3.7.0                                     | ISC                                                                                  | https://github.com/import-js/eslint-import-resolver-typescript                                      | Required          | Yes      |
| eslint-module-utils                                                           | 2.12.0                                    | MIT                                                                                  | https://github.com/import-js/eslint-plugin-import                                                   | Required          | Yes      |
| eslint-module-utils                                                           | 2.8.1                                     | MIT                                                                                  | https://github.com/import-js/eslint-plugin-import                                                   | Required          | Yes      |
| eslint-plugin-babel                                                           | 5.3.1                                     | MIT                                                                                  | https://github.com/babel/eslint-plugin-babel                                                        | Required          | Yes      |
| eslint-plugin-cypress                                                         | 2.15.2                                    | MIT                                                                                  | https://github.com/cypress-io/eslint-plugin-cypress                                                 | Required          | Yes      |
| eslint-plugin-es                                                              | 3.0.1                                     | MIT                                                                                  | https://github.com/mysticatea/eslint-plugin-es                                                      | Required          | Yes      |
| eslint-plugin-eslint-comments                                                 | 3.2.0                                     | MIT                                                                                  | https://github.com/mysticatea/eslint-plugin-eslint-comments                                         | Required          | Yes      |
| eslint-plugin-import                                                          | 2.29.1                                    | MIT                                                                                  | https://github.com/import-js/eslint-plugin-import                                                   | Required          | Yes      |
| eslint-plugin-import                                                          | 2.31.0                                    | MIT                                                                                  | https://github.com/import-js/eslint-plugin-import                                                   | Required          | Yes      |
| eslint-plugin-jest-dom                                                        | 5.5.0                                     | MIT                                                                                  | https://github.com/testing-library/eslint-plugin-jest-dom                                           | Required          | Yes      |
| eslint-plugin-jest-formatting                                                 | 3.1.0                                     | MIT                                                                                  | https://github.com/dangreenisrael/eslint-plugin-jest-formatting                                     | Required          | Yes      |
| eslint-plugin-jest                                                            | 25.7.0                                    | MIT                                                                                  | https://github.com/jest-community/eslint-plugin-jest                                                | Required          | Yes      |
| eslint-plugin-jest                                                            | 27.9.0                                    | MIT                                                                                  | https://github.com/jest-community/eslint-plugin-jest                                                | Required          | Yes      |
| eslint-plugin-jsx-a11y                                                        | 6.8.0                                     | MIT                                                                                  | https://github.com/jsx-eslint/eslint-plugin-jsx-a11y                                                | Required          | Yes      |
| eslint-plugin-lodash                                                          | 7.4.0                                     | MIT                                                                                  | https://github.com/wix/eslint-plugin-lodash                                                         | Required          | Yes      |
| eslint-plugin-mocha                                                           | 10.5.0                                    | MIT                                                                                  | https://github.com/lo1tuma/eslint-plugin-mocha                                                      | Required          | Yes      |
| eslint-plugin-node                                                            | 11.1.0                                    | MIT                                                                                  | https://github.com/mysticatea/eslint-plugin-node                                                    | Required          | Yes      |
| eslint-plugin-notice                                                          | 0.9.10                                    | MIT                                                                                  | https://github.com/nickdeis/eslint-plugin-notice                                                    | Required          | Yes      |
| eslint-plugin-prettier                                                        | 4.2.1                                     | MIT                                                                                  | https://github.com/prettier/eslint-plugin-prettier                                                  | Required          | Yes      |
| eslint-plugin-promise                                                         | 6.2.0                                     | ISC                                                                                  | https://github.com/eslint-community/eslint-plugin-promise                                           | Required          | Yes      |
| eslint-plugin-promise                                                         | 6.6.0                                     | ISC                                                                                  | https://github.com/eslint-community/eslint-plugin-promise                                           | Required          | Yes      |
| eslint-plugin-react-hooks                                                     | 4.6.2                                     | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| eslint-plugin-react                                                           | 7.34.2                                    | MIT                                                                                  | https://github.com/jsx-eslint/eslint-plugin-react                                                   | Required          | Yes      |
| eslint-plugin-react                                                           | 7.37.4                                    | MIT                                                                                  | https://github.com/jsx-eslint/eslint-plugin-react                                                   | Required          | Yes      |
| eslint-plugin-sort-class-members                                              | 1.20.0                                    | MIT                                                                                  | https://github.com/bryanrsmith/eslint-plugin-sort-class-members                                     | Required          | Yes      |
| eslint-plugin-test-filenames                                                  | 0.0.1                                     | MIT                                                                                  | https://github.com/spalger/eslint-plugin-test-filenames                                             | Required          | Yes      |
| eslint-plugin-testing-library                                                 | 5.11.1                                    | MIT                                                                                  | https://github.com/testing-library/eslint-plugin-testing-library                                    | Required          | Yes      |
| eslint-rule-composer                                                          | 0.3.0                                     | MIT                                                                                  | https://github.com/not-an-aardvark/eslint-rule-composer                                             | Required          | Yes      |
| eslint-scope                                                                  | 5.1.1                                     | BSD-2-Clause                                                                         | https://github.com/eslint/eslint-scope                                                              | Required          | Yes      |
| eslint-scope                                                                  | 7.2.2                                     | BSD-2-Clause                                                                         | https://github.com/eslint/eslint-scope                                                              | Required          | Yes      |
| eslint-utils                                                                  | 2.1.0                                     | MIT                                                                                  | https://github.com/mysticatea/eslint-utils                                                          | Required          | Yes      |
| eslint-utils                                                                  | 3.0.0                                     | MIT                                                                                  | https://github.com/mysticatea/eslint-utils                                                          | Required          | Yes      |
| eslint-visitor-keys                                                           | 1.3.0                                     | Apache-2.0                                                                           | https://github.com/eslint/eslint-visitor-keys                                                       | Required          | Yes      |
| eslint-visitor-keys                                                           | 2.1.0                                     | Apache-2.0                                                                           | https://github.com/eslint/eslint-visitor-keys                                                       | Required          | Yes      |
| eslint-visitor-keys                                                           | 3.4.3                                     | Apache-2.0                                                                           | https://github.com/eslint/eslint-visitor-keys                                                       | Required          | Yes      |
| eslint                                                                        | 8.57.0                                    | MIT                                                                                  | https://github.com/eslint/eslint                                                                    | Required          | Yes      |
| espree                                                                        | 9.6.1                                     | BSD-2-Clause                                                                         | https://github.com/eslint/espree                                                                    | Required          | Yes      |
| esprima                                                                       | 4.0.1                                     | BSD-2-Clause                                                                         | https://github.com/jquery/esprima                                                                   | Required          | Yes      |
| esquery                                                                       | 1.5.0                                     | BSD-3-Clause                                                                         | https://github.com/estools/esquery                                                                  | Required          | Yes      |
| esrecurse                                                                     | 4.3.0                                     | BSD-2-Clause                                                                         | https://github.com/estools/esrecurse                                                                | Required          | Yes      |
| estraverse                                                                    | 4.3.0                                     | BSD-2-Clause                                                                         | https://github.com/estools/estraverse                                                               | Required          | Yes      |
| estraverse                                                                    | 5.3.0                                     | BSD-2-Clause                                                                         | https://github.com/estools/estraverse                                                               | Required          | Yes      |
| esutils                                                                       | 2.0.3                                     | BSD-2-Clause                                                                         | https://github.com/estools/esutils                                                                  | Required          | Yes      |
| etag                                                                          | 1.8.1                                     | MIT                                                                                  | https://github.com/jshttp/etag                                                                      | Required          | Yes      |
| event-target-shim                                                             | 5.0.1                                     | MIT                                                                                  | https://github.com/mysticatea/event-target-shim                                                     | Required          | Yes      |
| eventemitter2                                                                 | 6.4.7                                     | MIT                                                                                  | https://github.com/hij1nx/EventEmitter2                                                             | Required          | Yes      |
| eventemitter3                                                                 | 4.0.7                                     | MIT                                                                                  | https://github.com/primus/eventemitter3                                                             | Required          | Yes      |
| events                                                                        | 3.3.0                                     | MIT                                                                                  | https://github.com/Gozala/events                                                                    | Required          | Yes      |
| evp_bytestokey                                                                | 1.0.3                                     | MIT                                                                                  | https://github.com/crypto-browserify/EVP_BytesToKey                                                 | Required          | Yes      |
| execa                                                                         | 4.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/execa                                                               | Required          | Yes      |
| execa                                                                         | 5.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/execa                                                               | Required          | Yes      |
| executable                                                                    | 4.1.1                                     | MIT                                                                                  | https://github.com/kevva/executable                                                                 | Required          | Yes      |
| exit                                                                          | 0.1.2                                     | MIT                                                                                  | https://github.com/cowboy/node-exit                                                                 | Required          | Yes      |
| expect                                                                        | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| exponential-backoff                                                           | 3.1.1                                     | Apache-2.0                                                                           | https://github.com/coveo/exponential-backoff                                                        | Required          | Yes      |
| express                                                                       | 4.21.2                                    | MIT                                                                                  | https://github.com/expressjs/express                                                                | Required          | Yes      |
| extend-shallow                                                                | 2.0.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/extend-shallow                                                     | Required          | Yes      |
| extend                                                                        | 3.0.2                                     | MIT                                                                                  | https://github.com/justmoon/node-extend                                                             | Required          | Yes      |
| extract-zip                                                                   | 2.0.1                                     | BSD-2-Clause                                                                         | https://github.com/maxogden/extract-zip                                                             | Required          | Yes      |
| extsprintf                                                                    | 1.3.0                                     | MIT                                                                                  | https://github.com/davepacheco/node-extsprintf                                                      | Required          | Yes      |
| extsprintf                                                                    | 1.4.1                                     | MIT                                                                                  | https://github.com/davepacheco/node-extsprintf                                                      | Required          | Yes      |
| fast-copy                                                                     | 3.0.2                                     | MIT                                                                                  | https://github.com/planttheidea/fast-copy                                                           | Required          | Yes      |
| fast-deep-equal                                                               | 2.0.1                                     | MIT                                                                                  | https://github.com/epoberezkin/fast-deep-equal                                                      | Required          | Yes      |
| fast-deep-equal                                                               | 3.1.3                                     | MIT                                                                                  | https://github.com/epoberezkin/fast-deep-equal                                                      | Required          | Yes      |
| fast-diff                                                                     | 1.3.0                                     | Apache-2.0                                                                           | https://github.com/jhchen/fast-diff                                                                 | Required          | Yes      |
| fast-glob                                                                     | 3.3.2                                     | MIT                                                                                  | https://github.com/mrmlnc/fast-glob                                                                 | Required          | Yes      |
| fast-json-stable-stringify                                                    | 2.1.0                                     | MIT                                                                                  | https://github.com/epoberezkin/fast-json-stable-stringify                                           | Required          | Yes      |
| fast-levenshtein                                                              | 2.0.6                                     | MIT                                                                                  | https://github.com/hiddentao/fast-levenshtein                                                       | Required          | Yes      |
| fast-memoize                                                                  | 2.5.2                                     | MIT                                                                                  | https://github.com/caiogondim/fast-memoize                                                          | Required          | Yes      |
| fast-redact                                                                   | 3.5.0                                     | MIT                                                                                  | https://github.com/davidmarkclements/fast-redact                                                    | Required          | Yes      |
| fast-safe-stringify                                                           | 2.1.1                                     | MIT                                                                                  | https://github.com/davidmarkclements/fast-safe-stringify                                            | Required          | Yes      |
| fastest-levenshtein                                                           | 1.0.16                                    | MIT                                                                                  | https://github.com/ka-weihe/fastest-levenshtein                                                     | Required          | Yes      |
| fastq                                                                         | 1.17.1                                    | ISC                                                                                  | https://github.com/mcollina/fastq                                                                   | Required          | Yes      |
| fb-watchman                                                                   | 2.0.2                                     | Apache-2.0                                                                           | https://github.com/facebook/watchman                                                                | Required          | Yes      |
| fd-slicer                                                                     | 1.1.0                                     | MIT                                                                                  | https://github.com/andrewrk/node-fd-slicer                                                          | Required          | Yes      |
| fetch-mock                                                                    | 9.11.0                                    | MIT                                                                                  | https://github.com/wheresrhys/fetch-mock                                                            | Required          | Yes      |
| figures                                                                       | 3.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/figures                                                             | Required          | Yes      |
| file-entry-cache                                                              | 6.0.1                                     | MIT                                                                                  | https://github.com/royriojas/file-entry-cache                                                       | Required          | Yes      |
| file-entry-cache                                                              | 7.0.2                                     | MIT                                                                                  | https://github.com/jaredwray/file-entry-cache                                                       | Required          | Yes      |
| file-loader                                                                   | 6.2.0                                     | MIT                                                                                  | https://github.com/webpack-contrib/file-loader                                                      | Required          | Yes      |
| file-selector                                                                 | 0.4.0                                     | MIT                                                                                  | https://github.com/react-dropzone/file-selector                                                     | Required          | Yes      |
| filelist                                                                      | 1.0.4                                     | Apache-2.0                                                                           | https://github.com/mde/filelist                                                                     | Required          | Yes      |
| fill-range                                                                    | 7.1.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/fill-range                                                         | Required          | Yes      |
| filter-obj                                                                    | 1.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/filter-obj                                                          | Required          | Yes      |
| finalhandler                                                                  | 1.3.1                                     | MIT                                                                                  | https://github.com/pillarjs/finalhandler                                                            | Required          | Yes      |
| find-cache-dir                                                                | 2.1.0                                     | MIT                                                                                  | https://github.com/avajs/find-cache-dir                                                             | Required          | Yes      |
| find-cache-dir                                                                | 3.3.2                                     | MIT                                                                                  | https://github.com/avajs/find-cache-dir                                                             | Required          | Yes      |
| find-cache-dir                                                                | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/find-cache-dir                                                      | Required          | Yes      |
| find-root                                                                     | 1.1.0                                     | MIT                                                                                  | https://github.com/js-n/find-root                                                                   | Required          | Yes      |
| find-up                                                                       | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/find-up                                                             | Required          | Yes      |
| find-up                                                                       | 4.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/find-up                                                             | Required          | Yes      |
| find-up                                                                       | 5.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/find-up                                                             | Required          | Yes      |
| find-up                                                                       | 6.3.0                                     | MIT                                                                                  | https://github.com/sindresorhus/find-up                                                             | Required          | Yes      |
| flat-cache                                                                    | 3.2.0                                     | MIT                                                                                  | https://github.com/jaredwray/flat-cache                                                             | Required          | Yes      |
| flat                                                                          | 5.0.2                                     | BSD-3-Clause                                                                         | https://github.com/hughsk/flat                                                                      | Required          | Yes      |
| flatted                                                                       | 3.3.1                                     | ISC                                                                                  | https://github.com/WebReflection/flatted                                                            | Required          | Yes      |
| flow-parser                                                                   | 0.237.2                                   | MIT                                                                                  | https://github.com/facebook/flow                                                                    | Required          | Yes      |
| focus-lock                                                                    | 1.3.5                                     | MIT                                                                                  | https://github.com/theKashey/focus-lock                                                             | Required          | Yes      |
| follow-redirects                                                              | 1.15.6                                    | MIT                                                                                  | https://github.com/follow-redirects/follow-redirects                                                | Required          | Yes      |
| for-each                                                                      | 0.3.3                                     | MIT                                                                                  | https://github.com/Raynos/for-each                                                                  | Required          | Yes      |
| foreground-child                                                              | 3.1.1                                     | ISC                                                                                  | https://github.com/tapjs/foreground-child                                                           | Required          | Yes      |
| forever-agent                                                                 | 0.6.1                                     | Apache-2.0                                                                           | https://github.com/mikeal/forever-agent                                                             | Required          | Yes      |
| form-data-encoder                                                             | 2.1.4                                     | MIT                                                                                  | https://github.com/octet-stream/form-data-encoder                                                   | Required          | Yes      |
| form-data                                                                     | 4.0.0                                     | MIT                                                                                  | https://github.com/form-data/form-data                                                              | Required          | Yes      |
| form-data                                                                     | 4.0.1                                     | MIT                                                                                  | https://github.com/form-data/form-data                                                              | Required          | Yes      |
| formik                                                                        | 2.4.6                                     | Apache-2.0                                                                           | https://github.com/jaredpalmer/formik                                                               | Required          | Yes      |
| forwarded                                                                     | 0.2.0                                     | MIT                                                                                  | https://github.com/jshttp/forwarded                                                                 | Required          | Yes      |
| fp-and-or                                                                     | 0.1.4                                     | ISC                                                                                  | https://github.com/raineorshine/fp-and-or                                                           | Required          | Yes      |
| fp-ts                                                                         | 2.16.9                                    | MIT                                                                                  | https://github.com/gcanti/fp-ts                                                                     | Required          | Yes      |
| fraction.js                                                                   | 4.3.7                                     | MIT                                                                                  | https://github.com/rawify/Fraction.js                                                               | Required          | Yes      |
| fresh                                                                         | 0.5.2                                     | MIT                                                                                  | https://github.com/jshttp/fresh                                                                     | Required          | Yes      |
| fs-extra                                                                      | 11.3.0                                    | MIT                                                                                  | https://github.com/jprichardson/node-fs-extra                                                       | Required          | Yes      |
| fs-extra                                                                      | 9.1.0                                     | MIT                                                                                  | https://github.com/jprichardson/node-fs-extra                                                       | Required          | Yes      |
| fs-minipass                                                                   | 2.1.0                                     | ISC                                                                                  | https://github.com/npm/fs-minipass                                                                  | Required          | Yes      |
| fs-minipass                                                                   | 3.0.3                                     | ISC                                                                                  | https://github.com/npm/fs-minipass                                                                  | Required          | Yes      |
| fs-monkey                                                                     | 1.0.6                                     | Unlicense                                                                            | https://github.com/streamich/fs-monkey                                                              | Required          | Yes      |
| fs-readdir-recursive                                                          | 1.1.0                                     | MIT                                                                                  | https://github.com/fs-utils/fs-readdir-recursive                                                    | Required          | Yes      |
| fs.realpath                                                                   | 1.0.0                                     | ISC                                                                                  | https://github.com/isaacs/fs.realpath                                                               | Required          | Yes      |
| fsevents                                                                      | 2.3.3                                     | MIT                                                                                  | https://github.com/fsevents/fsevents                                                                | Required          | Yes      |
| function-bind                                                                 | 1.1.2                                     | MIT                                                                                  | https://github.com/Raynos/function-bind                                                             | Required          | Yes      |
| function.prototype.name                                                       | 1.1.6                                     | MIT                                                                                  | https://github.com/es-shims/Function.prototype.name                                                 | Required          | Yes      |
| function.prototype.name                                                       | 1.1.8                                     | MIT                                                                                  | https://github.com/es-shims/Function.prototype.name                                                 | Required          | Yes      |
| functions-have-names                                                          | 1.2.3                                     | MIT                                                                                  | https://github.com/inspect-js/functions-have-names                                                  | Required          | Yes      |
| gauge                                                                         | 4.0.4                                     | ISC                                                                                  | https://github.com/npm/gauge                                                                        | Required          | Yes      |
| gensync                                                                       | 1.0.0-beta.2                              | MIT                                                                                  | https://github.com/loganfsmyth/gensync                                                              | Required          | Yes      |
| get-caller-file                                                               | 2.0.5                                     | ISC                                                                                  | https://github.com/stefanpenner/get-caller-file                                                     | Required          | Yes      |
| get-intrinsic                                                                 | 1.2.4                                     | MIT                                                                                  | https://github.com/ljharb/get-intrinsic                                                             | Required          | Yes      |
| get-intrinsic                                                                 | 1.2.7                                     | MIT                                                                                  | https://github.com/ljharb/get-intrinsic                                                             | Required          | Yes      |
| get-nonce                                                                     | 1.0.1                                     | MIT                                                                                  | https://github.com/theKashey/get-nonce                                                              | Required          | Yes      |
| get-package-type                                                              | 0.1.0                                     | MIT                                                                                  | https://github.com/cfware/get-package-type                                                          | Required          | Yes      |
| get-proto                                                                     | 1.0.1                                     | MIT                                                                                  | https://github.com/ljharb/get-proto                                                                 | Required          | Yes      |
| get-stdin                                                                     | 8.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/get-stdin                                                           | Required          | Yes      |
| get-stream                                                                    | 5.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/get-stream                                                          | Required          | Yes      |
| get-stream                                                                    | 6.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/get-stream                                                          | Required          | Yes      |
| get-symbol-description                                                        | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/get-symbol-description                                                | Required          | Yes      |
| get-symbol-description                                                        | 1.1.0                                     | MIT                                                                                  | https://github.com/inspect-js/get-symbol-description                                                | Required          | Yes      |
| get-tsconfig                                                                  | 4.8.1                                     | MIT                                                                                  | https://github.com/privatenumber/get-tsconfig                                                       | Required          | Yes      |
| getos                                                                         | 3.2.1                                     | MIT                                                                                  | https://github.com/retrohacker/getos                                                                | Required          | Yes      |
| getpass                                                                       | 0.1.7                                     | MIT                                                                                  | https://github.com/arekinath/node-getpass                                                           | Required          | Yes      |
| glob-parent                                                                   | 5.1.2                                     | ISC                                                                                  | https://github.com/gulpjs/glob-parent                                                               | Required          | Yes      |
| glob-parent                                                                   | 6.0.2                                     | ISC                                                                                  | https://github.com/gulpjs/glob-parent                                                               | Required          | Yes      |
| glob-to-regexp                                                                | 0.4.1                                     | BSD-2-Clause                                                                         | https://github.com/fitzgen/glob-to-regexp                                                           | Required          | Yes      |
| glob                                                                          | 10.4.1                                    | ISC                                                                                  | https://github.com/isaacs/node-glob                                                                 | Required          | Yes      |
| glob                                                                          | 10.4.5                                    | ISC                                                                                  | https://github.com/isaacs/node-glob                                                                 | Required          | Yes      |
| glob                                                                          | 7.2.3                                     | ISC                                                                                  | https://github.com/isaacs/node-glob                                                                 | Required          | Yes      |
| glob                                                                          | 8.1.0                                     | ISC                                                                                  | https://github.com/isaacs/node-glob                                                                 | Required          | Yes      |
| global-dirs                                                                   | 3.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/global-dirs                                                         | Required          | Yes      |
| global-modules                                                                | 2.0.0                                     | MIT                                                                                  | https://github.com/jonschlinkert/global-modules                                                     | Required          | Yes      |
| global-prefix                                                                 | 3.0.0                                     | MIT                                                                                  | https://github.com/jonschlinkert/global-prefix                                                      | Required          | Yes      |
| globals                                                                       | 11.12.0                                   | MIT                                                                                  | https://github.com/sindresorhus/globals                                                             | Required          | Yes      |
| globals                                                                       | 13.24.0                                   | MIT                                                                                  | https://github.com/sindresorhus/globals                                                             | Required          | Yes      |
| globalthis                                                                    | 1.0.4                                     | MIT                                                                                  | https://github.com/ljharb/System.global                                                             | Required          | Yes      |
| globalyzer                                                                    | 0.1.0                                     | MIT                                                                                  | https://github.com/terkelg/globalyzer                                                               | Required          | Yes      |
| globby                                                                        | 11.1.0                                    | MIT                                                                                  | https://github.com/sindresorhus/globby                                                              | Required          | Yes      |
| globby                                                                        | 13.2.2                                    | MIT                                                                                  | https://github.com/sindresorhus/globby                                                              | Required          | Yes      |
| globjoin                                                                      | 0.1.4                                     | MIT                                                                                  | https://github.com/amobiz/globjoin                                                                  | Required          | Yes      |
| globrex                                                                       | 0.1.2                                     | MIT                                                                                  | https://github.com/terkelg/globrex                                                                  | Required          | Yes      |
| gopd                                                                          | 1.0.1                                     | MIT                                                                                  | https://github.com/ljharb/gopd                                                                      | Required          | Yes      |
| gopd                                                                          | 1.2.0                                     | MIT                                                                                  | https://github.com/ljharb/gopd                                                                      | Required          | Yes      |
| got                                                                           | 12.6.1                                    | MIT                                                                                  | https://github.com/sindresorhus/got                                                                 | Required          | Yes      |
| graceful-fs                                                                   | 4.2.10                                    | ISC                                                                                  | https://github.com/isaacs/node-graceful-fs                                                          | Required          | Yes      |
| graceful-fs                                                                   | 4.2.11                                    | ISC                                                                                  | https://github.com/isaacs/node-graceful-fs                                                          | Required          | Yes      |
| graphemer                                                                     | 1.4.0                                     | MIT                                                                                  | https://github.com/flmnt/graphemer                                                                  | Required          | Yes      |
| hard-rejection                                                                | 2.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/hard-rejection                                                      | Required          | Yes      |
| has-bigints                                                                   | 1.0.2                                     | MIT                                                                                  | https://github.com/ljharb/has-bigints                                                               | Required          | Yes      |
| has-flag                                                                      | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/has-flag                                                            | Required          | Yes      |
| has-flag                                                                      | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/has-flag                                                            | Required          | Yes      |
| has-property-descriptors                                                      | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/has-property-descriptors                                              | Required          | Yes      |
| has-proto                                                                     | 1.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/has-proto                                                             | Required          | Yes      |
| has-proto                                                                     | 1.2.0                                     | MIT                                                                                  | https://github.com/inspect-js/has-proto                                                             | Required          | Yes      |
| has-symbols                                                                   | 1.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/has-symbols                                                           | Required          | Yes      |
| has-symbols                                                                   | 1.1.0                                     | MIT                                                                                  | https://github.com/inspect-js/has-symbols                                                           | Required          | Yes      |
| has-tostringtag                                                               | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/has-tostringtag                                                       | Required          | Yes      |
| has-unicode                                                                   | 2.0.1                                     | ISC                                                                                  | https://github.com/iarna/has-unicode                                                                | Required          | Yes      |
| has-yarn                                                                      | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/has-yarn                                                            | Required          | Yes      |
| has                                                                           | 1.0.4                                     | MIT                                                                                  | https://github.com/tarruda/has                                                                      | Required          | Yes      |
| hash-base                                                                     | 3.0.4                                     | MIT                                                                                  | https://github.com/crypto-browserify/hash-base                                                      | Required          | Yes      |
| hash-base                                                                     | 3.1.0                                     | MIT                                                                                  | https://github.com/crypto-browserify/hash-base                                                      | Required          | Yes      |
| hash-sum                                                                      | 2.0.0                                     | MIT                                                                                  | https://github.com/bevacqua/hash-sum                                                                | Required          | Yes      |
| hash.js                                                                       | 1.1.7                                     | MIT                                                                                  | https://github.com/indutny/hash.js                                                                  | Required          | Yes      |
| hasown                                                                        | 2.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/hasOwn                                                                | Required          | Yes      |
| hast-to-hyperscript                                                           | 9.0.1                                     | MIT                                                                                  | https://github.com/syntax-tree/hast-to-hyperscript                                                  | Required          | Yes      |
| hast-util-from-parse5                                                         | 6.0.1                                     | MIT                                                                                  | https://github.com/syntax-tree/hast-util-from-parse5                                                | Required          | Yes      |
| hast-util-is-element                                                          | 1.1.0                                     | MIT                                                                                  | https://github.com/syntax-tree/hast-util-is-element                                                 | Required          | Yes      |
| hast-util-parse-selector                                                      | 2.2.5                                     | MIT                                                                                  | https://github.com/syntax-tree/hast-util-parse-selector                                             | Required          | Yes      |
| hast-util-raw                                                                 | 6.1.0                                     | MIT                                                                                  | https://github.com/syntax-tree/hast-util-raw                                                        | Required          | Yes      |
| hast-util-to-html                                                             | 7.1.3                                     | MIT                                                                                  | https://github.com/syntax-tree/hast-util-to-html                                                    | Required          | Yes      |
| hast-util-to-parse5                                                           | 6.0.0                                     | MIT                                                                                  | https://github.com/syntax-tree/hast-util-to-parse5                                                  | Required          | Yes      |
| hast-util-whitespace                                                          | 1.0.4                                     | MIT                                                                                  | https://github.com/syntax-tree/hast-util-whitespace                                                 | Required          | Yes      |
| hastscript                                                                    | 6.0.0                                     | MIT                                                                                  | https://github.com/syntax-tree/hastscript                                                           | Required          | Yes      |
| he                                                                            | 1.2.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/he                                                                 | Required          | Yes      |
| header-case                                                                   | 2.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| helmet                                                                        | 7.2.0                                     | MIT                                                                                  | https://github.com/helmetjs/helmet                                                                  | Required          | Yes      |
| help-me                                                                       | 5.0.0                                     | MIT                                                                                  | https://github.com/mcollina/help-me                                                                 | Required          | Yes      |
| highlight.js                                                                  | 10.7.3                                    | BSD-3-Clause                                                                         | https://github.com/highlightjs/highlight.js                                                         | Required          | Yes      |
| history                                                                       | 4.10.1                                    | MIT                                                                                  | https://github.com/ReactTraining/history                                                            | Required          | Yes      |
| hmac-drbg                                                                     | 1.0.1                                     | MIT                                                                                  | https://github.com/indutny/hmac-drbg                                                                | Required          | Yes      |
| hoist-non-react-statics                                                       | 2.5.5                                     | BSD-3-Clause                                                                         | https://github.com/mridgway/hoist-non-react-statics                                                 | Required          | Yes      |
| hoist-non-react-statics                                                       | 3.3.2                                     | BSD-3-Clause                                                                         | https://github.com/mridgway/hoist-non-react-statics                                                 | Required          | Yes      |
| homedir-polyfill                                                              | 1.0.3                                     | MIT                                                                                  | https://github.com/doowb/homedir-polyfill                                                           | Required          | Yes      |
| hosted-git-info                                                               | 2.8.9                                     | ISC                                                                                  | https://github.com/npm/hosted-git-info                                                              | Required          | Yes      |
| hosted-git-info                                                               | 3.0.8                                     | ISC                                                                                  | https://github.com/npm/hosted-git-info                                                              | Required          | Yes      |
| hosted-git-info                                                               | 4.1.0                                     | ISC                                                                                  | https://github.com/npm/hosted-git-info                                                              | Required          | Yes      |
| hosted-git-info                                                               | 5.2.1                                     | ISC                                                                                  | https://github.com/npm/hosted-git-info                                                              | Required          | Yes      |
| hosted-git-info                                                               | 6.1.1                                     | ISC                                                                                  | https://github.com/npm/hosted-git-info                                                              | Required          | Yes      |
| html-element-map                                                              | 1.3.1                                     | MIT                                                                                  | https://github.com/ljharb/html-element-map                                                          | Required          | Yes      |
| html-encoding-sniffer                                                         | 3.0.0                                     | MIT                                                                                  | https://github.com/jsdom/html-encoding-sniffer                                                      | Required          | Yes      |
| html-entities                                                                 | 2.5.2                                     | MIT                                                                                  | https://github.com/mdevils/html-entities                                                            | Required          | Yes      |
| html-escaper                                                                  | 2.0.2                                     | MIT                                                                                  | https://github.com/WebReflection/html-escaper                                                       | Required          | Yes      |
| html-minifier-terser                                                          | 6.1.0                                     | MIT                                                                                  | https://github.com/terser/html-minifier-terser                                                      | Required          | Yes      |
| html-tags                                                                     | 3.3.1                                     | MIT                                                                                  | https://github.com/sindresorhus/html-tags                                                           | Required          | Yes      |
| html-void-elements                                                            | 1.0.5                                     | MIT                                                                                  | https://github.com/wooorm/html-void-elements                                                        | Required          | Yes      |
| html-webpack-plugin                                                           | 5.6.3                                     | MIT                                                                                  | https://github.com/jantimon/html-webpack-plugin                                                     | Required          | Yes      |
| html-webpack-script-attributes-plugin                                         | 2.0.2                                     | ISC                                                                                  | https://github.com/zhouchengi/html-webpack-script-attributes-plugin                                 | Required          | Yes      |
| html-webpack-tags-plugin                                                      | 3.0.2                                     | MIT                                                                                  | https://github.com/jharris4/html-webpack-tags-plugin                                                | Required          | Yes      |
| htmlparser2                                                                   | 6.1.0                                     | MIT                                                                                  | https://github.com/fb55/htmlparser2                                                                 | Required          | Yes      |
| htmlparser2                                                                   | 8.0.2                                     | MIT                                                                                  | https://github.com/fb55/htmlparser2                                                                 | Required          | Yes      |
| http-cache-semantics                                                          | 4.1.1                                     | BSD-2-Clause                                                                         | https://github.com/kornelski/http-cache-semantics                                                   | Required          | Yes      |
| http-errors                                                                   | 2.0.0                                     | MIT                                                                                  | https://github.com/jshttp/http-errors                                                               | Required          | Yes      |
| http-proxy-agent                                                              | 5.0.0                                     | MIT                                                                                  | https://github.com/TooTallNate/node-http-proxy-agent                                                | Required          | Yes      |
| http-proxy                                                                    | 1.18.1                                    | MIT                                                                                  | https://github.com/http-party/node-http-proxy                                                       | Required          | Yes      |
| http-signature                                                                | 1.4.0                                     | MIT                                                                                  | https://github.com/TritonDataCenter/node-http-signature                                             | Required          | Yes      |
| http2-wrapper                                                                 | 2.2.1                                     | MIT                                                                                  | https://github.com/szmarczak/http2-wrapper                                                          | Required          | Yes      |
| https-proxy-agent                                                             | 5.0.1                                     | MIT                                                                                  | https://github.com/TooTallNate/node-https-proxy-agent                                               | Required          | Yes      |
| human-signals                                                                 | 1.1.1                                     | Apache-2.0                                                                           | https://github.com/ehmicky/human-signals                                                            | Required          | Yes      |
| human-signals                                                                 | 2.1.0                                     | Apache-2.0                                                                           | https://github.com/ehmicky/human-signals                                                            | Required          | Yes      |
| humanize-duration                                                             | 3.32.1                                    | Unlicense                                                                            | https://github.com/EvanHahn/HumanizeDuration.js                                                     | Required          | Yes      |
| humanize-ms                                                                   | 1.2.1                                     | MIT                                                                                  | https://github.com/node-modules/humanize-ms                                                         | Required          | Yes      |
| hyphenate-style-name                                                          | 1.0.5                                     | BSD-3-Clause                                                                         | https://github.com/rexxars/hyphenate-style-name                                                     | Required          | Yes      |
| i18n-iso-countries                                                            | 7.13.0                                    | MIT                                                                                  | https://github.com/michaelwittig/node-i18n-iso-countries                                            | Required          | Yes      |
| iconv-lite                                                                    | 0.4.24                                    | MIT                                                                                  | https://github.com/ashtuchkin/iconv-lite                                                            | Required          | Yes      |
| iconv-lite                                                                    | 0.6.3                                     | MIT                                                                                  | https://github.com/ashtuchkin/iconv-lite                                                            | Required          | Yes      |
| icss-utils                                                                    | 5.1.0                                     | ISC                                                                                  | https://github.com/css-modules/icss-utils                                                           | Required          | Yes      |
| ieee754                                                                       | 1.2.1                                     | BSD-3-Clause                                                                         | https://github.com/feross/ieee754                                                                   | Required          | Yes      |
| ignore-by-default                                                             | 1.0.1                                     | ISC                                                                                  | https://github.com/novemberborn/ignore-by-default                                                   | Required          | Yes      |
| ignore-walk                                                                   | 6.0.5                                     | ISC                                                                                  | https://github.com/npm/ignore-walk                                                                  | Required          | Yes      |
| ignore                                                                        | 5.3.1                                     | MIT                                                                                  | https://github.com/kaelzhang/node-ignore                                                            | Required          | Yes      |
| immediate                                                                     | 3.0.6                                     | MIT                                                                                  | https://github.com/calvinmetcalf/immediate                                                          | Required          | Yes      |
| immutable                                                                     | 5.0.3                                     | MIT                                                                                  | https://github.com/immutable-js/immutable-js                                                        | Required          | Yes      |
| import-fresh                                                                  | 3.3.0                                     | MIT                                                                                  | https://github.com/sindresorhus/import-fresh                                                        | Required          | Yes      |
| import-lazy                                                                   | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/import-lazy                                                         | Required          | Yes      |
| import-local                                                                  | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/import-local                                                        | Required          | Yes      |
| imports-visitor                                                               | 2.1.0                                     | MIT                                                                                  | https://github.com/suchipi/transform-imports                                                        | Required          | Yes      |
| imurmurhash                                                                   | 0.1.4                                     | MIT                                                                                  | https://github.com/jensyt/imurmurhash-js                                                            | Required          | Yes      |
| indent-string                                                                 | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/indent-string                                                       | Required          | Yes      |
| indent-string                                                                 | 5.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/indent-string                                                       | Required          | Yes      |
| infer-owner                                                                   | 1.0.4                                     | ISC                                                                                  | https://github.com/npm/infer-owner                                                                  | Required          | Yes      |
| inflight                                                                      | 1.0.6                                     | ISC                                                                                  | https://github.com/npm/inflight                                                                     | Required          | Yes      |
| inherits                                                                      | 2.0.4                                     | ISC                                                                                  | https://github.com/isaacs/inherits                                                                  | Required          | Yes      |
| ini                                                                           | 1.3.8                                     | ISC                                                                                  | https://github.com/isaacs/ini                                                                       | Required          | Yes      |
| ini                                                                           | 2.0.0                                     | ISC                                                                                  | https://github.com/isaacs/ini                                                                       | Required          | Yes      |
| ini                                                                           | 4.1.3                                     | ISC                                                                                  | https://github.com/npm/ini                                                                          | Required          | Yes      |
| inline-style-parser                                                           | 0.1.1                                     | MIT                                                                                  | https://github.com/remarkablemark/inline-style-parser                                               | Required          | Yes      |
| internal-slot                                                                 | 1.0.7                                     | MIT                                                                                  | https://github.com/ljharb/internal-slot                                                             | Required          | Yes      |
| internal-slot                                                                 | 1.1.0                                     | MIT                                                                                  | https://github.com/ljharb/internal-slot                                                             | Required          | Yes      |
| internmap                                                                     | 1.0.1                                     | ISC                                                                                  | https://github.com/mbostock/internmap                                                               | Required          | Yes      |
| interpret                                                                     | 3.1.1                                     | MIT                                                                                  | https://github.com/gulpjs/interpret                                                                 | Required          | Yes      |
| intl-messageformat-parser                                                     | 1.8.1                                     | BSD-3-Clause                                                                         | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| intl-messageformat                                                            | 10.7.7                                    | BSD-3-Clause                                                                         | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| intl-pluralrules                                                              | 2.0.1                                     | ISC                                                                                  | https://github.com/eemeli/intl-pluralrules                                                          | Required          | Yes      |
| invariant                                                                     | 2.2.4                                     | MIT                                                                                  | https://github.com/zertosh/invariant                                                                | Required          | Yes      |
| io-ts                                                                         | 2.2.21                                    | MIT                                                                                  | https://github.com/gcanti/io-ts                                                                     | Required          | Yes      |
| ip-address                                                                    | 8.1.0                                     | MIT                                                                                  | https://github.com/beaugunderson/ip-address                                                         | Required          | Yes      |
| ip-address                                                                    | 9.0.5                                     | MIT                                                                                  | https://github.com/beaugunderson/ip-address                                                         | Required          | Yes      |
| ipaddr.js                                                                     | 1.9.1                                     | MIT                                                                                  | https://github.com/whitequark/ipaddr.js                                                             | Required          | Yes      |
| is-alphabetical                                                               | 1.0.4                                     | MIT                                                                                  | https://github.com/wooorm/is-alphabetical                                                           | Required          | Yes      |
| is-alphanumerical                                                             | 1.0.4                                     | MIT                                                                                  | https://github.com/wooorm/is-alphanumerical                                                         | Required          | Yes      |
| is-arguments                                                                  | 1.1.1                                     | MIT                                                                                  | https://github.com/inspect-js/is-arguments                                                          | Required          | Yes      |
| is-array-buffer                                                               | 3.0.4                                     | MIT                                                                                  | https://github.com/inspect-js/is-array-buffer                                                       | Required          | Yes      |
| is-array-buffer                                                               | 3.0.5                                     | MIT                                                                                  | https://github.com/inspect-js/is-array-buffer                                                       | Required          | Yes      |
| is-arrayish                                                                   | 0.2.1                                     | MIT                                                                                  | https://github.com/qix-/node-is-arrayish                                                            | Required          | Yes      |
| is-async-function                                                             | 2.0.0                                     | MIT                                                                                  | https://github.com/inspect-js/is-async-function                                                     | Required          | Yes      |
| is-bigint                                                                     | 1.0.4                                     | MIT                                                                                  | https://github.com/inspect-js/is-bigint                                                             | Required          | Yes      |
| is-bigint                                                                     | 1.1.0                                     | MIT                                                                                  | https://github.com/inspect-js/is-bigint                                                             | Required          | Yes      |
| is-binary-path                                                                | 2.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-binary-path                                                      | Required          | Yes      |
| is-boolean-object                                                             | 1.1.2                                     | MIT                                                                                  | https://github.com/inspect-js/is-boolean-object                                                     | Required          | Yes      |
| is-boolean-object                                                             | 1.2.1                                     | MIT                                                                                  | https://github.com/inspect-js/is-boolean-object                                                     | Required          | Yes      |
| is-buffer                                                                     | 1.1.6                                     | MIT                                                                                  | https://github.com/feross/is-buffer                                                                 | Required          | Yes      |
| is-buffer                                                                     | 2.0.5                                     | MIT                                                                                  | https://github.com/feross/is-buffer                                                                 | Required          | Yes      |
| is-bun-module                                                                 | 1.2.1                                     | MIT                                                                                  | https://github.com/SunsetTechuila/is-bun-module                                                     | Required          | Yes      |
| is-callable                                                                   | 1.2.7                                     | MIT                                                                                  | https://github.com/inspect-js/is-callable                                                           | Required          | Yes      |
| is-ci                                                                         | 3.0.1                                     | MIT                                                                                  | https://github.com/watson/is-ci                                                                     | Required          | Yes      |
| is-core-module                                                                | 2.13.1                                    | MIT                                                                                  | https://github.com/inspect-js/is-core-module                                                        | Required          | Yes      |
| is-core-module                                                                | 2.15.1                                    | MIT                                                                                  | https://github.com/inspect-js/is-core-module                                                        | Required          | Yes      |
| is-data-view                                                                  | 1.0.1                                     | MIT                                                                                  | https://github.com/inspect-js/is-data-view                                                          | Required          | Yes      |
| is-data-view                                                                  | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/is-data-view                                                          | Required          | Yes      |
| is-date-object                                                                | 1.0.5                                     | MIT                                                                                  | https://github.com/inspect-js/is-date-object                                                        | Required          | Yes      |
| is-date-object                                                                | 1.1.0                                     | MIT                                                                                  | https://github.com/inspect-js/is-date-object                                                        | Required          | Yes      |
| is-decimal                                                                    | 1.0.4                                     | MIT                                                                                  | https://github.com/wooorm/is-decimal                                                                | Required          | Yes      |
| is-extendable                                                                 | 0.1.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/is-extendable                                                      | Required          | Yes      |
| is-extglob                                                                    | 2.1.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/is-extglob                                                         | Required          | Yes      |
| is-finalizationregistry                                                       | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/is-finalizationregistry                                               | Required          | Yes      |
| is-finalizationregistry                                                       | 1.1.1                                     | MIT                                                                                  | https://github.com/inspect-js/is-finalizationregistry                                               | Required          | Yes      |
| is-fullwidth-code-point                                                       | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-fullwidth-code-point                                             | Required          | Yes      |
| is-generator-fn                                                               | 2.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-generator-fn                                                     | Required          | Yes      |
| is-generator-function                                                         | 1.0.10                                    | MIT                                                                                  | https://github.com/inspect-js/is-generator-function                                                 | Required          | Yes      |
| is-glob                                                                       | 4.0.3                                     | MIT                                                                                  | https://github.com/micromatch/is-glob                                                               | Required          | Yes      |
| is-hexadecimal                                                                | 1.0.4                                     | MIT                                                                                  | https://github.com/wooorm/is-hexadecimal                                                            | Required          | Yes      |
| is-installed-globally                                                         | 0.4.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-installed-globally                                               | Required          | Yes      |
| is-lambda                                                                     | 1.0.1                                     | MIT                                                                                  | https://github.com/watson/is-lambda                                                                 | Required          | Yes      |
| is-map                                                                        | 2.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/is-map                                                                | Required          | Yes      |
| is-negative-zero                                                              | 2.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/is-negative-zero                                                      | Required          | Yes      |
| is-npm                                                                        | 6.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-npm                                                              | Required          | Yes      |
| is-number-object                                                              | 1.0.7                                     | MIT                                                                                  | https://github.com/inspect-js/is-number-object                                                      | Required          | Yes      |
| is-number-object                                                              | 1.1.1                                     | MIT                                                                                  | https://github.com/inspect-js/is-number-object                                                      | Required          | Yes      |
| is-number                                                                     | 7.0.0                                     | MIT                                                                                  | https://github.com/jonschlinkert/is-number                                                          | Required          | Yes      |
| is-obj                                                                        | 2.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-obj                                                              | Required          | Yes      |
| is-path-inside                                                                | 3.0.3                                     | MIT                                                                                  | https://github.com/sindresorhus/is-path-inside                                                      | Required          | Yes      |
| is-plain-obj                                                                  | 1.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-plain-obj                                                        | Required          | Yes      |
| is-plain-obj                                                                  | 2.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-plain-obj                                                        | Required          | Yes      |
| is-plain-object                                                               | 2.0.4                                     | MIT                                                                                  | https://github.com/jonschlinkert/is-plain-object                                                    | Required          | Yes      |
| is-plain-object                                                               | 5.0.0                                     | MIT                                                                                  | https://github.com/jonschlinkert/is-plain-object                                                    | Required          | Yes      |
| is-potential-custom-element-name                                              | 1.0.1                                     | MIT                                                                                  | https://github.com/mathiasbynens/is-potential-custom-element-name                                   | Required          | Yes      |
| is-promise                                                                    | 4.0.0                                     | MIT                                                                                  | https://github.com/then/is-promise                                                                  | Required          | Yes      |
| is-regex                                                                      | 1.1.4                                     | MIT                                                                                  | https://github.com/inspect-js/is-regex                                                              | Required          | Yes      |
| is-regex                                                                      | 1.2.1                                     | MIT                                                                                  | https://github.com/inspect-js/is-regex                                                              | Required          | Yes      |
| is-set                                                                        | 2.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/is-set                                                                | Required          | Yes      |
| is-shared-array-buffer                                                        | 1.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/is-shared-array-buffer                                                | Required          | Yes      |
| is-shared-array-buffer                                                        | 1.0.4                                     | MIT                                                                                  | https://github.com/inspect-js/is-shared-array-buffer                                                | Required          | Yes      |
| is-stream                                                                     | 2.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/is-stream                                                           | Required          | Yes      |
| is-string                                                                     | 1.0.7                                     | MIT                                                                                  | https://github.com/ljharb/is-string                                                                 | Required          | Yes      |
| is-string                                                                     | 1.1.1                                     | MIT                                                                                  | https://github.com/inspect-js/is-string                                                             | Required          | Yes      |
| is-subset                                                                     | 0.1.1                                     | MIT                                                                                  | https://github.com/studio-b12/is-subset                                                             | Required          | Yes      |
| is-symbol                                                                     | 1.0.4                                     | MIT                                                                                  | https://github.com/inspect-js/is-symbol                                                             | Required          | Yes      |
| is-symbol                                                                     | 1.1.1                                     | MIT                                                                                  | https://github.com/inspect-js/is-symbol                                                             | Required          | Yes      |
| is-typed-array                                                                | 1.1.13                                    | MIT                                                                                  | https://github.com/inspect-js/is-typed-array                                                        | Required          | Yes      |
| is-typed-array                                                                | 1.1.15                                    | MIT                                                                                  | https://github.com/inspect-js/is-typed-array                                                        | Required          | Yes      |
| is-typedarray                                                                 | 1.0.0                                     | MIT                                                                                  | https://github.com/hughsk/is-typedarray                                                             | Required          | Yes      |
| is-unicode-supported                                                          | 0.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/is-unicode-supported                                                | Required          | Yes      |
| is-weakmap                                                                    | 2.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/is-weakmap                                                            | Required          | Yes      |
| is-weakref                                                                    | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/is-weakref                                                            | Required          | Yes      |
| is-weakref                                                                    | 1.1.0                                     | MIT                                                                                  | https://github.com/inspect-js/is-weakref                                                            | Required          | Yes      |
| is-weakset                                                                    | 2.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/is-weakset                                                            | Required          | Yes      |
| is-whitespace-character                                                       | 1.0.4                                     | MIT                                                                                  | https://github.com/wooorm/is-whitespace-character                                                   | Required          | Yes      |
| is-whitespace                                                                 | 0.3.0                                     | MIT                                                                                  | https://github.com/jonschlinkert/is-whitespace                                                      | Required          | Yes      |
| is-word-character                                                             | 1.0.4                                     | MIT                                                                                  | https://github.com/wooorm/is-word-character                                                         | Required          | Yes      |
| is-yarn-global                                                                | 0.4.1                                     | MIT                                                                                  | https://github.com/LitoMore/is-yarn-global                                                          | Required          | Yes      |
| isarray                                                                       | 0.0.1                                     | MIT                                                                                  | https://github.com/juliangruber/isarray                                                             | Required          | Yes      |
| isarray                                                                       | 1.0.0                                     | MIT                                                                                  | https://github.com/juliangruber/isarray                                                             | Required          | Yes      |
| isarray                                                                       | 2.0.5                                     | MIT                                                                                  | https://github.com/juliangruber/isarray                                                             | Required          | Yes      |
| isexe                                                                         | 2.0.0                                     | ISC                                                                                  | https://github.com/isaacs/isexe                                                                     | Required          | Yes      |
| isobject                                                                      | 3.0.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/isobject                                                           | Required          | Yes      |
| isstream                                                                      | 0.1.2                                     | MIT                                                                                  | https://github.com/rvagg/isstream                                                                   | Required          | Yes      |
| istanbul-lib-coverage                                                         | 3.2.2                                     | BSD-3-Clause                                                                         | https://github.com/istanbuljs/istanbuljs                                                            | Required          | Yes      |
| istanbul-lib-instrument                                                       | 5.2.1                                     | BSD-3-Clause                                                                         | https://github.com/istanbuljs/istanbuljs                                                            | Required          | Yes      |
| istanbul-lib-instrument                                                       | 6.0.2                                     | BSD-3-Clause                                                                         | https://github.com/istanbuljs/istanbuljs                                                            | Required          | Yes      |
| istanbul-lib-report                                                           | 3.0.1                                     | BSD-3-Clause                                                                         | https://github.com/istanbuljs/istanbuljs                                                            | Required          | Yes      |
| istanbul-lib-source-maps                                                      | 4.0.1                                     | BSD-3-Clause                                                                         | https://github.com/istanbuljs/istanbuljs                                                            | Required          | Yes      |
| istanbul-reports                                                              | 3.1.7                                     | BSD-3-Clause                                                                         | https://github.com/istanbuljs/istanbuljs                                                            | Required          | Yes      |
| iterator.prototype                                                            | 1.1.2                                     | MIT                                                                                  | https://github.com/ljharb/Iterator.prototype                                                        | Required          | Yes      |
| iterator.prototype                                                            | 1.1.5                                     | MIT                                                                                  | https://github.com/ljharb/Iterator.prototype                                                        | Required          | Yes      |
| jackspeak                                                                     | 3.4.0                                     | BlueOak-1.0.0                                                                        | https://github.com/isaacs/jackspeak                                                                 | Required          | Yes      |
| jake                                                                          | 10.9.1                                    | Apache-2.0                                                                           | https://github.com/jakejs/jake                                                                      | Required          | Yes      |
| jest-axe                                                                      | 7.0.1                                     | MIT                                                                                  | https://github.com/nickcolley/jest-axe                                                              | Required          | Yes      |
| jest-canvas-mock                                                              | 2.5.2                                     | MIT                                                                                  | https://github.com/hustcc/jest-canvas-mock                                                          | Required          | Yes      |
| jest-changed-files                                                            | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-circus                                                                   | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-cli                                                                      | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-config                                                                   | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-diff                                                                     | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-docblock                                                                 | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-each                                                                     | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-environment-jsdom                                                        | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-environment-node                                                         | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-get-type                                                                 | 29.6.3                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-haste-map                                                                | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-junit                                                                    | 16.0.0                                    | Apache-2.0                                                                           | https://github.com/jest-community/jest-junit                                                        | Required          | Yes      |
| jest-launchdarkly-mock                                                        | 2.1.0                                     | Apache-2.0                                                                           | https://github.com/launchdarkly/jest-launchdarkly-mock                                              | Required          | Yes      |
| jest-leak-detector                                                            | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-localstorage-mock                                                        | 2.4.26                                    | BSD-3-Clause                                                                         | https://github.com/clarkbw/jest-localstorage-mock                                                   | Required          | Yes      |
| jest-matcher-utils                                                            | 29.2.2                                    | MIT                                                                                  | https://github.com/facebook/jest                                                                    | Required          | Yes      |
| jest-matcher-utils                                                            | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-message-util                                                             | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-mock                                                                     | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-pnp-resolver                                                             | 1.2.3                                     | MIT                                                                                  | https://github.com/arcanis/jest-pnp-resolver                                                        | Required          | Yes      |
| jest-regex-util                                                               | 29.6.3                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-resolve-dependencies                                                     | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-resolve                                                                  | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-runner                                                                   | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-runtime                                                                  | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-snapshot                                                                 | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-util                                                                     | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-validate                                                                 | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-watcher                                                                  | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest-worker                                                                   | 27.5.1                                    | MIT                                                                                  | https://github.com/facebook/jest                                                                    | Required          | Yes      |
| jest-worker                                                                   | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jest                                                                          | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| jiti                                                                          | 1.21.3                                    | MIT                                                                                  | https://github.com/unjs/jiti                                                                        | Required          | Yes      |
| jju                                                                           | 1.4.0                                     | MIT                                                                                  | https://github.com/rlidwka/jju                                                                      | Required          | Yes      |
| joycon                                                                        | 3.1.1                                     | MIT                                                                                  | https://github.com/egoist/joycon                                                                    | Required          | Yes      |
| js-beautify                                                                   | 1.15.1                                    | MIT                                                                                  | https://github.com/beautifier/js-beautify                                                           | Required          | Yes      |
| js-cookie                                                                     | 3.0.5                                     | MIT                                                                                  | https://github.com/js-cookie/js-cookie                                                              | Required          | Yes      |
| js-sha256                                                                     | 0.11.0                                    | MIT                                                                                  | https://github.com/emn178/js-sha256                                                                 | Required          | Yes      |
| js-sha3                                                                       | 0.8.0                                     | MIT                                                                                  | https://github.com/emn178/js-sha3                                                                   | Required          | Yes      |
| js-tokens                                                                     | 4.0.0                                     | MIT                                                                                  | https://github.com/lydell/js-tokens                                                                 | Required          | Yes      |
| js-yaml                                                                       | 3.14.1                                    | MIT                                                                                  | https://github.com/nodeca/js-yaml                                                                   | Required          | Yes      |
| js-yaml                                                                       | 4.1.0                                     | MIT                                                                                  | https://github.com/nodeca/js-yaml                                                                   | Required          | Yes      |
| jsbn                                                                          | 0.1.1                                     | MIT                                                                                  | https://github.com/andyperlitch/jsbn                                                                | Required          | Yes      |
| jsbn                                                                          | 1.1.0                                     | MIT                                                                                  | https://github.com/andyperlitch/jsbn                                                                | Required          | Yes      |
| jscodeshift                                                                   | 0.15.2                                    | MIT                                                                                  | https://github.com/facebook/jscodeshift                                                             | Required          | Yes      |
| jsdom                                                                         | 20.0.3                                    | MIT                                                                                  | https://github.com/jsdom/jsdom                                                                      | Required          | Yes      |
| jsesc                                                                         | 0.5.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/jsesc                                                              | Required          | Yes      |
| jsesc                                                                         | 2.5.2                                     | MIT                                                                                  | https://github.com/mathiasbynens/jsesc                                                              | Required          | Yes      |
| jsesc                                                                         | 3.0.2                                     | MIT                                                                                  | https://github.com/mathiasbynens/jsesc                                                              | Required          | Yes      |
| json-buffer                                                                   | 3.0.1                                     | MIT                                                                                  | https://github.com/dominictarr/json-buffer                                                          | Required          | Yes      |
| json-parse-even-better-errors                                                 | 2.3.1                                     | MIT                                                                                  | https://github.com/npm/json-parse-even-better-errors                                                | Required          | Yes      |
| json-parse-even-better-errors                                                 | 3.0.2                                     | MIT                                                                                  | https://github.com/npm/json-parse-even-better-errors                                                | Required          | Yes      |
| json-parse-helpfulerror                                                       | 1.0.3                                     | MIT                                                                                  | https://github.com/smikes/json-parse-helpfulerror                                                   | Required          | Yes      |
| json-schema-traverse                                                          | 0.4.1                                     | MIT                                                                                  | https://github.com/epoberezkin/json-schema-traverse                                                 | Required          | Yes      |
| json-schema-traverse                                                          | 1.0.0                                     | MIT                                                                                  | https://github.com/epoberezkin/json-schema-traverse                                                 | Required          | Yes      |
| json-schema                                                                   | 0.4.0                                     | (AFL-2.1 OR BSD-3-Clause)                                                            | https://github.com/kriszyp/json-schema                                                              | Required          | Yes      |
| json-stable-stringify-without-jsonify                                         | 1.0.1                                     | MIT                                                                                  | https://github.com/samn/json-stable-stringify                                                       | Required          | Yes      |
| json-stable-stringify                                                         | 1.1.1                                     | MIT                                                                                  | https://github.com/ljharb/json-stable-stringify                                                     | Required          | Yes      |
| json-stable-stringify                                                         | 1.2.1                                     | MIT                                                                                  | https://github.com/ljharb/json-stable-stringify                                                     | Required          | Yes      |
| json-stringify-safe                                                           | 5.0.1                                     | ISC                                                                                  | https://github.com/isaacs/json-stringify-safe                                                       | Required          | Yes      |
| json5                                                                         | 1.0.2                                     | MIT                                                                                  | https://github.com/json5/json5                                                                      | Required          | Yes      |
| json5                                                                         | 2.2.3                                     | MIT                                                                                  | https://github.com/json5/json5                                                                      | Required          | Yes      |
| jsonfile                                                                      | 6.1.0                                     | MIT                                                                                  | https://github.com/jprichardson/node-jsonfile                                                       | Required          | Yes      |
| jsonify                                                                       | 0.0.1                                     | Public Domain                                                                        | https://github.com/ljharb/jsonify                                                                   | Required          | Yes      |
| jsonlines                                                                     | 0.1.1                                     | MIT                                                                                  | https://github.com/LinusU/node-jsonlines                                                            | Required          | Yes      |
| jsonparse                                                                     | 1.3.1                                     | MIT                                                                                  | https://github.com/creationix/jsonparse                                                             | Required          | Yes      |
| jsprim                                                                        | 2.0.2                                     | MIT                                                                                  | https://github.com/joyent/node-jsprim                                                               | Required          | Yes      |
| jssha                                                                         | 3.3.1                                     | BSD-3-Clause                                                                         | https://github.com/Caligatio/jsSHA                                                                  | Required          | Yes      |
| jsx-ast-utils                                                                 | 3.3.5                                     | MIT                                                                                  | https://github.com/jsx-eslint/jsx-ast-utils                                                         | Required          | Yes      |
| jszip                                                                         | 3.10.1                                    | (MIT OR GPL-3.0-or-later)                                                            | https://github.com/Stuk/jszip                                                                       | Required          | Yes      |
| junit-report-merger                                                           | 6.0.4                                     | MIT                                                                                  | https://github.com/bhovhannes/junit-report-merger                                                   | Required          | Yes      |
| jwt-decode                                                                    | 3.1.2                                     | MIT                                                                                  | https://github.com/auth0/jwt-decode                                                                 | Required          | Yes      |
| keyv                                                                          | 4.5.4                                     | MIT                                                                                  | https://github.com/jaredwray/keyv                                                                   | Required          | Yes      |
| kind-of                                                                       | 3.2.2                                     | MIT                                                                                  | https://github.com/jonschlinkert/kind-of                                                            | Required          | Yes      |
| kind-of                                                                       | 6.0.3                                     | MIT                                                                                  | https://github.com/jonschlinkert/kind-of                                                            | Required          | Yes      |
| kleur                                                                         | 3.0.3                                     | MIT                                                                                  | https://github.com/lukeed/kleur                                                                     | Required          | Yes      |
| kleur                                                                         | 4.1.5                                     | MIT                                                                                  | https://github.com/lukeed/kleur                                                                     | Required          | Yes      |
| known-css-properties                                                          | 0.29.0                                    | MIT                                                                                  | https://github.com/known-css/known-css-properties                                                   | Required          | Yes      |
| language-subtag-registry                                                      | 0.3.23                                    | CC0-1.0                                                                              | https://github.com/mattcg/language-subtag-registry                                                  | Required          | Yes      |
| language-tags                                                                 | 1.0.9                                     | MIT                                                                                  | https://github.com/mattcg/language-tags                                                             | Required          | Yes      |
| latest-version                                                                | 7.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/latest-version                                                      | Required          | Yes      |
| launchdarkly-js-client-sdk                                                    | 3.5.0                                     | Apache-2.0                                                                           | https://github.com/launchdarkly/js-client-sdk                                                       | Required          | Yes      |
| launchdarkly-js-sdk-common                                                    | 5.4.0                                     | Apache-2.0                                                                           | https://github.com/launchdarkly/js-sdk-common                                                       | Required          | Yes      |
| launchdarkly-react-client-sdk                                                 | 3.6.0                                     | Apache-2.0                                                                           | https://github.com/launchdarkly/react-client-sdk                                                    | Required          | Yes      |
| lazy-ass                                                                      | 1.6.0                                     | MIT                                                                                  | https://github.com/bahmutov/lazy-ass                                                                | Required          | Yes      |
| leven                                                                         | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/leven                                                               | Required          | Yes      |
| levn                                                                          | 0.4.1                                     | MIT                                                                                  | https://github.com/gkz/levn                                                                         | Required          | Yes      |
| license-checker                                                               | 25.0.1                                    | BSD-3-Clause                                                                         | https://github.com/davglass/license-checker                                                         | Required          | Yes      |
| lie                                                                           | 3.3.0                                     | MIT                                                                                  | https://github.com/calvinmetcalf/lie                                                                | Required          | Yes      |
| lilconfig                                                                     | 3.1.1                                     | MIT                                                                                  | https://github.com/antonk52/lilconfig                                                               | Required          | Yes      |
| lines-and-columns                                                             | 1.2.4                                     | MIT                                                                                  | https://github.com/eventualbuddha/lines-and-columns                                                 | Required          | Yes      |
| linkify-it                                                                    | 4.0.1                                     | MIT                                                                                  | https://github.com/markdown-it/linkify-it                                                           | Required          | Yes      |
| listr2                                                                        | 3.14.0                                    | MIT                                                                                  | https://github.com/cenk1cenk2/listr2                                                                | Required          | Yes      |
| loader-runner                                                                 | 4.3.0                                     | MIT                                                                                  | https://github.com/webpack/loader-runner                                                            | Required          | Yes      |
| loader-utils                                                                  | 2.0.4                                     | MIT                                                                                  | https://github.com/webpack/loader-utils                                                             | Required          | Yes      |
| local-storage                                                                 | 2.0.0                                     | MIT                                                                                  | https://github.com/bevacqua/local-storage                                                           | Required          | Yes      |
| locate-path                                                                   | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/locate-path                                                         | Required          | Yes      |
| locate-path                                                                   | 5.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/locate-path                                                         | Required          | Yes      |
| locate-path                                                                   | 6.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/locate-path                                                         | Required          | Yes      |
| locate-path                                                                   | 7.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/locate-path                                                         | Required          | Yes      |
| lodash-es                                                                     | 4.17.21                                   | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.camelcase                                                              | 4.3.0                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.debounce                                                               | 4.0.8                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.escape                                                                 | 4.0.1                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.flattendeep                                                            | 4.4.0                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.get                                                                    | 4.4.2                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.has                                                                    | 4.5.2                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.isequal                                                                | 4.5.0                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.isplainobject                                                          | 4.0.6                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.kebabcase                                                              | 4.1.1                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.memoize                                                                | 4.1.2                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.merge                                                                  | 4.6.2                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.once                                                                   | 4.1.1                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.snakecase                                                              | 4.1.1                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.sortby                                                                 | 4.7.0                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.truncate                                                               | 4.4.2                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash.uniq                                                                   | 4.5.0                                     | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| lodash                                                                        | 4.17.21                                   | MIT                                                                                  | https://github.com/lodash/lodash                                                                    | Required          | Yes      |
| log-symbols                                                                   | 4.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/log-symbols                                                         | Required          | Yes      |
| log-update                                                                    | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/log-update                                                          | Required          | Yes      |
| loose-envify                                                                  | 1.4.0                                     | MIT                                                                                  | https://github.com/zertosh/loose-envify                                                             | Required          | Yes      |
| lower-case                                                                    | 2.0.2                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| lowercase-keys                                                                | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/lowercase-keys                                                      | Required          | Yes      |
| lru-cache                                                                     | 10.2.2                                    | ISC                                                                                  | https://github.com/isaacs/node-lru-cache                                                            | Required          | Yes      |
| lru-cache                                                                     | 5.1.1                                     | ISC                                                                                  | https://github.com/isaacs/node-lru-cache                                                            | Required          | Yes      |
| lru-cache                                                                     | 6.0.0                                     | ISC                                                                                  | https://github.com/isaacs/node-lru-cache                                                            | Required          | Yes      |
| lru-cache                                                                     | 7.18.3                                    | ISC                                                                                  | https://github.com/isaacs/node-lru-cache                                                            | Required          | Yes      |
| luxon                                                                         | 1.28.1                                    | MIT                                                                                  | https://github.com/moment/luxon                                                                     | Required          | Yes      |
| lz-string                                                                     | 1.5.0                                     | MIT                                                                                  | https://github.com/pieroxy/lz-string                                                                | Required          | Yes      |
| mailgun.js                                                                    | 12.0.1                                    | MIT                                                                                  | https://github.com/mailgun/mailgun.js                                                               | Required          | Yes      |
| make-dir                                                                      | 2.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/make-dir                                                            | Required          | Yes      |
| make-dir                                                                      | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/make-dir                                                            | Required          | Yes      |
| make-dir                                                                      | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/make-dir                                                            | Required          | Yes      |
| make-error                                                                    | 1.3.6                                     | ISC                                                                                  | https://github.com/JsCommunity/make-error                                                           | Required          | Yes      |
| make-fetch-happen                                                             | 10.2.1                                    | ISC                                                                                  | https://github.com/npm/make-fetch-happen                                                            | Required          | Yes      |
| make-fetch-happen                                                             | 11.1.1                                    | ISC                                                                                  | https://github.com/npm/make-fetch-happen                                                            | Required          | Yes      |
| makeerror                                                                     | 1.0.12                                    | BSD-3-Clause                                                                         | https://github.com/daaku/nodejs-makeerror                                                           | Required          | Yes      |
| map-obj                                                                       | 1.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/map-obj                                                             | Required          | Yes      |
| map-obj                                                                       | 4.3.0                                     | MIT                                                                                  | https://github.com/sindresorhus/map-obj                                                             | Required          | Yes      |
| markdown-escapes                                                              | 1.0.4                                     | MIT                                                                                  | https://github.com/wooorm/markdown-escapes                                                          | Required          | Yes      |
| markdown-it-link-attributes                                                   | 4.0.1                                     | MIT                                                                                  | https://github.com/crookedneighbor/markdown-it-link-attributes                                      | Required          | Yes      |
| markdown-it                                                                   | 13.0.2                                    | MIT                                                                                  | https://github.com/markdown-it/markdown-it                                                          | Required          | Yes      |
| match-sorter                                                                  | 6.3.4                                     | MIT                                                                                  | https://github.com/kentcdodds/match-sorter                                                          | Required          | Yes      |
| matchmediaquery                                                               | 0.3.1                                     | MIT                                                                                  | https://github.com/ncochard/matchmediaquery                                                         | Required          | Yes      |
| math-intrinsics                                                               | 1.1.0                                     | MIT                                                                                  | https://github.com/es-shims/math-intrinsics                                                         | Required          | Yes      |
| mathml-tag-names                                                              | 2.1.3                                     | MIT                                                                                  | https://github.com/wooorm/mathml-tag-names                                                          | Required          | Yes      |
| md5.js                                                                        | 1.3.5                                     | MIT                                                                                  | https://github.com/crypto-browserify/md5.js                                                         | Required          | Yes      |
| md5                                                                           | 2.3.0                                     | BSD-3-Clause                                                                         | https://github.com/pvorb/node-md5                                                                   | Required          | Yes      |
| mdast-util-definitions                                                        | 4.0.0                                     | MIT                                                                                  | https://github.com/syntax-tree/mdast-util-definitions                                               | Required          | Yes      |
| mdast-util-to-hast                                                            | 10.2.0                                    | MIT                                                                                  | https://github.com/syntax-tree/mdast-util-to-hast                                                   | Required          | Yes      |
| mdn-data                                                                      | 2.0.28                                    | CC0-1.0                                                                              | https://github.com/mdn/data                                                                         | Required          | Yes      |
| mdn-data                                                                      | 2.0.30                                    | CC0-1.0                                                                              | https://github.com/mdn/data                                                                         | Required          | Yes      |
| mdurl                                                                         | 1.0.1                                     | MIT                                                                                  | https://github.com/markdown-it/mdurl                                                                | Required          | Yes      |
| media-typer                                                                   | 0.3.0                                     | MIT                                                                                  | https://github.com/jshttp/media-typer                                                               | Required          | Yes      |
| memfs                                                                         | 3.6.0                                     | Unlicense                                                                            | https://github.com/streamich/memfs                                                                  | Required          | Yes      |
| memoize-one                                                                   | 5.2.1                                     | MIT                                                                                  | https://github.com/alexreardon/memoize-one                                                          | Required          | Yes      |
| memoize-one                                                                   | 6.0.0                                     | MIT                                                                                  | https://github.com/alexreardon/memoize-one                                                          | Required          | Yes      |
| memory-fs                                                                     | 0.5.0                                     | MIT                                                                                  | https://github.com/webpack/memory-fs                                                                | Required          | Yes      |
| meow                                                                          | 10.1.5                                    | MIT                                                                                  | https://github.com/sindresorhus/meow                                                                | Required          | Yes      |
| meow                                                                          | 9.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/meow                                                                | Required          | Yes      |
| merge-descriptors                                                             | 1.0.3                                     | MIT                                                                                  | https://github.com/sindresorhus/merge-descriptors                                                   | Required          | Yes      |
| merge-stream                                                                  | 2.0.0                                     | MIT                                                                                  | https://github.com/grncdr/merge-stream                                                              | Required          | Yes      |
| merge2                                                                        | 1.4.1                                     | MIT                                                                                  | https://github.com/teambition/merge2                                                                | Required          | Yes      |
| methods                                                                       | 1.1.2                                     | MIT                                                                                  | https://github.com/jshttp/methods                                                                   | Required          | Yes      |
| metric-lcs                                                                    | 0.1.2                                     | MIT                                                                                  | https://github.com/nickdeis/metric-lcs                                                              | Required          | Yes      |
| micromatch                                                                    | 4.0.8                                     | MIT                                                                                  | https://github.com/micromatch/micromatch                                                            | Required          | Yes      |
| microseconds                                                                  | 0.2.0                                     | MIT                                                                                  | https://github.com/kamicane/microseconds                                                            | Required          | Yes      |
| miller-rabin                                                                  | 4.0.1                                     | MIT                                                                                  | https://github.com/indutny/miller-rabin                                                             | Required          | Yes      |
| mime-db                                                                       | 1.52.0                                    | MIT                                                                                  | https://github.com/jshttp/mime-db                                                                   | Required          | Yes      |
| mime-types                                                                    | 2.1.35                                    | MIT                                                                                  | https://github.com/jshttp/mime-types                                                                | Required          | Yes      |
| mime                                                                          | 1.6.0                                     | MIT                                                                                  | https://github.com/broofa/node-mime                                                                 | Required          | Yes      |
| mime                                                                          | 3.0.0                                     | MIT                                                                                  | https://github.com/broofa/mime                                                                      | Required          | Yes      |
| mimic-fn                                                                      | 2.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/mimic-fn                                                            | Required          | Yes      |
| mimic-response                                                                | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/mimic-response                                                      | Required          | Yes      |
| mimic-response                                                                | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/mimic-response                                                      | Required          | Yes      |
| min-indent                                                                    | 1.0.1                                     | MIT                                                                                  | https://github.com/thejameskyle/min-indent                                                          | Required          | Yes      |
| mini-create-react-context                                                     | 0.4.1                                     | MIT                                                                                  | https://github.com/StringEpsilon/mini-create-react-context                                          | Required          | Yes      |
| mini-css-extract-plugin                                                       | 2.9.2                                     | MIT                                                                                  | https://github.com/webpack-contrib/mini-css-extract-plugin                                          | Required          | Yes      |
| mini-svg-data-uri                                                             | 1.4.4                                     | MIT                                                                                  | https://github.com/tigt/mini-svg-data-uri                                                           | Required          | Yes      |
| minimalistic-assert                                                           | 1.0.1                                     | ISC                                                                                  | https://github.com/calvinmetcalf/minimalistic-assert                                                | Required          | Yes      |
| minimalistic-crypto-utils                                                     | 1.0.1                                     | MIT                                                                                  | https://github.com/indutny/minimalistic-crypto-utils                                                | Required          | Yes      |
| minimatch                                                                     | 3.1.2                                     | ISC                                                                                  | https://github.com/isaacs/minimatch                                                                 | Required          | Yes      |
| minimatch                                                                     | 5.1.6                                     | ISC                                                                                  | https://github.com/isaacs/minimatch                                                                 | Required          | Yes      |
| minimatch                                                                     | 9.0.1                                     | ISC                                                                                  | https://github.com/isaacs/minimatch                                                                 | Required          | Yes      |
| minimatch                                                                     | 9.0.4                                     | ISC                                                                                  | https://github.com/isaacs/minimatch                                                                 | Required          | Yes      |
| minimist-options                                                              | 4.1.0                                     | MIT                                                                                  | https://github.com/vadimdemedes/minimist-options                                                    | Required          | Yes      |
| minimist                                                                      | 1.2.8                                     | MIT                                                                                  | https://github.com/minimistjs/minimist                                                              | Required          | Yes      |
| minipass-collect                                                              | 1.0.2                                     | ISC                                                                                  | N/A                                                                                                 | Required          | Yes      |
| minipass-fetch                                                                | 2.1.2                                     | MIT                                                                                  | https://github.com/npm/minipass-fetch                                                               | Required          | Yes      |
| minipass-fetch                                                                | 3.0.5                                     | MIT                                                                                  | https://github.com/npm/minipass-fetch                                                               | Required          | Yes      |
| minipass-flush                                                                | 1.0.5                                     | ISC                                                                                  | https://github.com/isaacs/minipass-flush                                                            | Required          | Yes      |
| minipass-json-stream                                                          | 1.0.1                                     | MIT                                                                                  | https://github.com/npm/minipass-json-stream                                                         | Required          | Yes      |
| minipass-pipeline                                                             | 1.2.4                                     | ISC                                                                                  | N/A                                                                                                 | Required          | Yes      |
| minipass-sized                                                                | 1.0.3                                     | ISC                                                                                  | https://github.com/isaacs/minipass-sized                                                            | Required          | Yes      |
| minipass                                                                      | 3.3.6                                     | ISC                                                                                  | https://github.com/isaacs/minipass                                                                  | Required          | Yes      |
| minipass                                                                      | 5.0.0                                     | ISC                                                                                  | https://github.com/isaacs/minipass                                                                  | Required          | Yes      |
| minipass                                                                      | 7.1.2                                     | ISC                                                                                  | https://github.com/isaacs/minipass                                                                  | Required          | Yes      |
| minizlib                                                                      | 2.1.2                                     | MIT                                                                                  | https://github.com/isaacs/minizlib                                                                  | Required          | Yes      |
| mkdirp                                                                        | 0.5.6                                     | MIT                                                                                  | https://github.com/substack/node-mkdirp                                                             | Required          | Yes      |
| mkdirp                                                                        | 1.0.4                                     | MIT                                                                                  | https://github.com/isaacs/node-mkdirp                                                               | Required          | Yes      |
| mkdirp                                                                        | 3.0.1                                     | MIT                                                                                  | https://github.com/isaacs/node-mkdirp                                                               | Required          | Yes      |
| mocha-junit-reporter                                                          | 2.2.1                                     | MIT                                                                                  | https://github.com/michaelleeallen/mocha-junit-reporter                                             | Required          | Yes      |
| moment-timezone-data-webpack-plugin                                           | 1.5.1                                     | MIT                                                                                  | https://github.com/gilmoreorless/moment-timezone-data-webpack-plugin                                | Required          | Yes      |
| moment-timezone                                                               | 0.5.46                                    | MIT                                                                                  | https://github.com/moment/moment-timezone                                                           | Required          | Yes      |
| moment                                                                        | 2.30.1                                    | MIT                                                                                  | https://github.com/moment/moment                                                                    | Required          | Yes      |
| moo-color                                                                     | 1.0.3                                     | MIT                                                                                  | https://github.com/archco/moo-color                                                                 | Required          | Yes      |
| moo                                                                           | 0.5.2                                     | BSD-3-Clause                                                                         | https://github.com/tjvr/moo                                                                         | Required          | Yes      |
| ms                                                                            | 2.0.0                                     | MIT                                                                                  | https://github.com/zeit/ms                                                                          | Required          | Yes      |
| ms                                                                            | 2.1.2                                     | MIT                                                                                  | https://github.com/zeit/ms                                                                          | Required          | Yes      |
| ms                                                                            | 2.1.3                                     | MIT                                                                                  | https://github.com/vercel/ms                                                                        | Required          | Yes      |
| mutation-observer                                                             | 1.0.3                                     | BSD*                                                                                 | https://github.com/webmodules/mutation-observer                                                     | Required          | Yes      |
| mz                                                                            | 2.7.0                                     | MIT                                                                                  | https://github.com/normalize/mz                                                                     | Required          | Yes      |
| nano-time                                                                     | 1.0.0                                     | ISC                                                                                  | https://github.com/sazze/node-nanotime                                                              | Required          | Yes      |
| nanoid                                                                        | 3.3.8                                     | MIT                                                                                  | https://github.com/ai/nanoid                                                                        | Required          | Yes      |
| natural-compare-lite                                                          | 1.4.0                                     | MIT                                                                                  | https://github.com/litejs/natural-compare-lite                                                      | Required          | Yes      |
| natural-compare                                                               | 1.4.0                                     | MIT                                                                                  | https://github.com/litejs/natural-compare-lite                                                      | Required          | Yes      |
| nconf                                                                         | 0.12.1                                    | MIT                                                                                  | https://github.com/flatiron/nconf                                                                   | Required          | Yes      |
| nearley                                                                       | 2.20.1                                    | MIT                                                                                  | https://github.com/hardmath123/nearley                                                              | Required          | Yes      |
| negotiator                                                                    | 0.6.3                                     | MIT                                                                                  | https://github.com/jshttp/negotiator                                                                | Required          | Yes      |
| negotiator                                                                    | 0.6.4                                     | MIT                                                                                  | https://github.com/jshttp/negotiator                                                                | Required          | Yes      |
| neo-async                                                                     | 2.6.2                                     | MIT                                                                                  | https://github.com/suguru03/neo-async                                                               | Required          | Yes      |
| no-case                                                                       | 3.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| node-dir                                                                      | 0.1.17                                    | MIT                                                                                  | https://github.com/fshost/node-dir                                                                  | Required          | Yes      |
| node-emoji                                                                    | 1.11.0                                    | MIT                                                                                  | https://github.com/omnidan/node-emoji                                                               | Required          | Yes      |
| node-environment-flags                                                        | 1.0.6                                     | Apache-2.0                                                                           | https://github.com/boneskull/node-environment-flags                                                 | Required          | Yes      |
| node-fetch                                                                    | 2.7.0                                     | MIT                                                                                  | https://github.com/bitinn/node-fetch                                                                | Required          | Yes      |
| node-forge                                                                    | 1.3.1                                     | (BSD-3-Clause OR GPL-2.0)                                                            | https://github.com/digitalbazaar/forge                                                              | Required          | Yes      |
| node-gyp                                                                      | 9.4.1                                     | MIT                                                                                  | https://github.com/nodejs/node-gyp                                                                  | Required          | Yes      |
| node-int64                                                                    | 0.4.0                                     | MIT                                                                                  | https://github.com/broofa/node-int64                                                                | Required          | Yes      |
| node-releases                                                                 | 2.0.14                                    | MIT                                                                                  | https://github.com/chicoxyzzy/node-releases                                                         | Required          | Yes      |
| node-releases                                                                 | 2.0.18                                    | MIT                                                                                  | https://github.com/chicoxyzzy/node-releases                                                         | Required          | Yes      |
| nodemon                                                                       | 3.1.9                                     | MIT                                                                                  | https://github.com/remy/nodemon                                                                     | Required          | Yes      |
| nopt                                                                          | 4.0.3                                     | ISC                                                                                  | https://github.com/npm/nopt                                                                         | Required          | Yes      |
| nopt                                                                          | 6.0.0                                     | ISC                                                                                  | https://github.com/npm/nopt                                                                         | Required          | Yes      |
| nopt                                                                          | 7.2.1                                     | ISC                                                                                  | https://github.com/npm/nopt                                                                         | Required          | Yes      |
| normalize-package-data                                                        | 2.5.0                                     | BSD-2-Clause                                                                         | https://github.com/npm/normalize-package-data                                                       | Required          | Yes      |
| normalize-package-data                                                        | 3.0.3                                     | BSD-2-Clause                                                                         | https://github.com/npm/normalize-package-data                                                       | Required          | Yes      |
| normalize-package-data                                                        | 5.0.0                                     | BSD-2-Clause                                                                         | https://github.com/npm/normalize-package-data                                                       | Required          | Yes      |
| normalize-path                                                                | 3.0.0                                     | MIT                                                                                  | https://github.com/jonschlinkert/normalize-path                                                     | Required          | Yes      |
| normalize-range                                                               | 0.1.2                                     | MIT                                                                                  | https://github.com/jamestalmage/normalize-range                                                     | Required          | Yes      |
| normalize-url                                                                 | 8.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/normalize-url                                                       | Required          | Yes      |
| npm-bundled                                                                   | 3.0.1                                     | ISC                                                                                  | https://github.com/npm/npm-bundled                                                                  | Required          | Yes      |
| npm-check-updates                                                             | 16.14.20                                  | Apache-2.0                                                                           | https://github.com/raineorshine/npm-check-updates                                                   | Required          | Yes      |
| npm-install-checks                                                            | 6.3.0                                     | BSD-2-Clause                                                                         | https://github.com/npm/npm-install-checks                                                           | Required          | Yes      |
| npm-normalize-package-bin                                                     | 1.0.1                                     | ISC                                                                                  | https://github.com/npm/npm-normalize-package-bin                                                    | Required          | Yes      |
| npm-normalize-package-bin                                                     | 3.0.1                                     | ISC                                                                                  | https://github.com/npm/npm-normalize-package-bin                                                    | Required          | Yes      |
| npm-package-arg                                                               | 10.1.0                                    | ISC                                                                                  | https://github.com/npm/npm-package-arg                                                              | Required          | Yes      |
| npm-packlist                                                                  | 7.0.4                                     | ISC                                                                                  | https://github.com/npm/npm-packlist                                                                 | Required          | Yes      |
| npm-pick-manifest                                                             | 8.0.2                                     | ISC                                                                                  | https://github.com/npm/npm-pick-manifest                                                            | Required          | Yes      |
| npm-registry-fetch                                                            | 14.0.5                                    | ISC                                                                                  | https://github.com/npm/npm-registry-fetch                                                           | Required          | Yes      |
| npm-run-path                                                                  | 4.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/npm-run-path                                                        | Required          | Yes      |
| npmlog                                                                        | 6.0.2                                     | ISC                                                                                  | https://github.com/npm/npmlog                                                                       | Required          | Yes      |
| nth-check                                                                     | 2.1.1                                     | BSD-2-Clause                                                                         | https://github.com/fb55/nth-check                                                                   | Required          | Yes      |
| numeral                                                                       | 2.0.6                                     | MIT                                                                                  | https://github.com/adamwdraper/Numeral-js                                                           | Required          | Yes      |
| nwsapi                                                                        | 2.2.10                                    | MIT                                                                                  | https://github.com/dperini/nwsapi                                                                   | Required          | Yes      |
| object-assign                                                                 | 4.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/object-assign                                                       | Required          | Yes      |
| object-inspect                                                                | 1.13.1                                    | MIT                                                                                  | https://github.com/inspect-js/object-inspect                                                        | Required          | Yes      |
| object-inspect                                                                | 1.13.3                                    | MIT                                                                                  | https://github.com/inspect-js/object-inspect                                                        | Required          | Yes      |
| object-is                                                                     | 1.1.6                                     | MIT                                                                                  | https://github.com/es-shims/object-is                                                               | Required          | Yes      |
| object-keys                                                                   | 1.1.1                                     | MIT                                                                                  | https://github.com/ljharb/object-keys                                                               | Required          | Yes      |
| object.assign                                                                 | 4.1.5                                     | MIT                                                                                  | https://github.com/ljharb/object.assign                                                             | Required          | Yes      |
| object.assign                                                                 | 4.1.7                                     | MIT                                                                                  | https://github.com/ljharb/object.assign                                                             | Required          | Yes      |
| object.entries                                                                | 1.1.8                                     | MIT                                                                                  | https://github.com/es-shims/Object.entries                                                          | Required          | Yes      |
| object.fromentries                                                            | 2.0.8                                     | MIT                                                                                  | https://github.com/es-shims/Object.fromEntries                                                      | Required          | Yes      |
| object.getownpropertydescriptors                                              | 2.1.8                                     | MIT                                                                                  | https://github.com/es-shims/object.getownpropertydescriptors                                        | Required          | Yes      |
| object.groupby                                                                | 1.0.3                                     | MIT                                                                                  | https://github.com/es-shims/Object.groupBy                                                          | Required          | Yes      |
| object.hasown                                                                 | 1.1.4                                     | MIT                                                                                  | https://github.com/es-shims/Object.hasOwn                                                           | Required          | Yes      |
| object.values                                                                 | 1.2.0                                     | MIT                                                                                  | https://github.com/es-shims/Object.values                                                           | Required          | Yes      |
| object.values                                                                 | 1.2.1                                     | MIT                                                                                  | https://github.com/es-shims/Object.values                                                           | Required          | Yes      |
| oblivious-set                                                                 | 1.0.0                                     | MIT                                                                                  | https://github.com/pubkey/oblivious-set                                                             | Required          | Yes      |
| on-exit-leak-free                                                             | 2.1.2                                     | MIT                                                                                  | https://github.com/mcollina/on-exit-or-gc                                                           | Required          | Yes      |
| on-finished                                                                   | 2.4.1                                     | MIT                                                                                  | https://github.com/jshttp/on-finished                                                               | Required          | Yes      |
| on-headers                                                                    | 1.0.2                                     | MIT                                                                                  | https://github.com/jshttp/on-headers                                                                | Required          | Yes      |
| once                                                                          | 1.4.0                                     | ISC                                                                                  | https://github.com/isaacs/once                                                                      | Required          | Yes      |
| onetime                                                                       | 5.1.2                                     | MIT                                                                                  | https://github.com/sindresorhus/onetime                                                             | Required          | Yes      |
| openapi-typescript                                                            | 4.5.0                                     | MIT                                                                                  | https://github.com/drwpow/openapi-typescript                                                        | Required          | Yes      |
| openapi-typescript                                                            | 6.7.6                                     | MIT                                                                                  | https://github.com/drwpow/openapi-typescript                                                        | Required          | Yes      |
| opentracing                                                                   | 0.14.7                                    | Apache-2.0                                                                           | https://github.com/opentracing/opentracing-javascript                                               | Required          | Yes      |
| optionator                                                                    | 0.9.4                                     | MIT                                                                                  | https://github.com/gkz/optionator                                                                   | Required          | Yes      |
| os-homedir                                                                    | 1.0.2                                     | MIT                                                                                  | https://github.com/sindresorhus/os-homedir                                                          | Required          | Yes      |
| os-tmpdir                                                                     | 1.0.2                                     | MIT                                                                                  | https://github.com/sindresorhus/os-tmpdir                                                           | Required          | Yes      |
| osenv                                                                         | 0.1.5                                     | ISC                                                                                  | https://github.com/npm/osenv                                                                        | Required          | Yes      |
| ospath                                                                        | 1.2.2                                     | MIT                                                                                  | https://github.com/jprichardson/ospath                                                              | Required          | Yes      |
| otplib                                                                        | 12.0.1                                    | MIT                                                                                  | https://github.com/yeojz/otplib                                                                     | Required          | Yes      |
| own-keys                                                                      | 1.0.1                                     | MIT                                                                                  | https://github.com/ljharb/own-keys                                                                  | Required          | Yes      |
| p-cancelable                                                                  | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-cancelable                                                        | Required          | Yes      |
| p-limit                                                                       | 2.3.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-limit                                                             | Required          | Yes      |
| p-limit                                                                       | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-limit                                                             | Required          | Yes      |
| p-limit                                                                       | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-limit                                                             | Required          | Yes      |
| p-locate                                                                      | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-locate                                                            | Required          | Yes      |
| p-locate                                                                      | 4.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-locate                                                            | Required          | Yes      |
| p-locate                                                                      | 5.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-locate                                                            | Required          | Yes      |
| p-locate                                                                      | 6.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-locate                                                            | Required          | Yes      |
| p-map                                                                         | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-map                                                               | Required          | Yes      |
| p-try                                                                         | 2.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/p-try                                                               | Required          | Yes      |
| package-json-from-dist                                                        | 1.0.0                                     | BlueOak-1.0.0                                                                        | https://github.com/isaacs/package-json-from-dist                                                    | Required          | Yes      |
| package-json                                                                  | 8.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/package-json                                                        | Required          | Yes      |
| pacote                                                                        | 15.2.0                                    | ISC                                                                                  | https://github.com/npm/pacote                                                                       | Required          | Yes      |
| pako                                                                          | 1.0.11                                    | (MIT AND Zlib)                                                                       | https://github.com/nodeca/pako                                                                      | Required          | Yes      |
| param-case                                                                    | 3.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| parent-module                                                                 | 1.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/parent-module                                                       | Required          | Yes      |
| parse-asn1                                                                    | 5.1.7                                     | ISC                                                                                  | https://github.com/crypto-browserify/parse-asn1                                                     | Required          | Yes      |
| parse-entities                                                                | 2.0.0                                     | MIT                                                                                  | https://github.com/wooorm/parse-entities                                                            | Required          | Yes      |
| parse-github-url                                                              | 1.0.2                                     | MIT                                                                                  | https://github.com/jonschlinkert/parse-github-url                                                   | Required          | Yes      |
| parse-json                                                                    | 5.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/parse-json                                                          | Required          | Yes      |
| parse-passwd                                                                  | 1.0.0                                     | MIT                                                                                  | https://github.com/doowb/parse-passwd                                                               | Required          | Yes      |
| parse5-htmlparser2-tree-adapter                                               | 6.0.1                                     | MIT                                                                                  | https://github.com/inikulin/parse5                                                                  | Required          | Yes      |
| parse5-htmlparser2-tree-adapter                                               | 7.0.0                                     | MIT                                                                                  | https://github.com/inikulin/parse5                                                                  | Required          | Yes      |
| parse5                                                                        | 5.1.1                                     | MIT                                                                                  | https://github.com/inikulin/parse5                                                                  | Required          | Yes      |
| parse5                                                                        | 6.0.1                                     | MIT                                                                                  | https://github.com/inikulin/parse5                                                                  | Required          | Yes      |
| parse5                                                                        | 7.1.2                                     | MIT                                                                                  | https://github.com/inikulin/parse5                                                                  | Required          | Yes      |
| parseurl                                                                      | 1.3.3                                     | MIT                                                                                  | https://github.com/pillarjs/parseurl                                                                | Required          | Yes      |
| pascal-case                                                                   | 3.1.2                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| path-browserify                                                               | 1.0.1                                     | MIT                                                                                  | https://github.com/browserify/path-browserify                                                       | Required          | Yes      |
| path-case                                                                     | 3.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| path-exists                                                                   | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/path-exists                                                         | Required          | Yes      |
| path-exists                                                                   | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/path-exists                                                         | Required          | Yes      |
| path-exists                                                                   | 5.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/path-exists                                                         | Required          | Yes      |
| path-is-absolute                                                              | 1.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/path-is-absolute                                                    | Required          | Yes      |
| path-key                                                                      | 3.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/path-key                                                            | Required          | Yes      |
| path-parse                                                                    | 1.0.7                                     | MIT                                                                                  | https://github.com/jbgutierrez/path-parse                                                           | Required          | Yes      |
| path-scurry                                                                   | 1.11.1                                    | BlueOak-1.0.0                                                                        | https://github.com/isaacs/path-scurry                                                               | Required          | Yes      |
| path-to-regexp                                                                | 0.1.12                                    | MIT                                                                                  | https://github.com/pillarjs/path-to-regexp                                                          | Required          | Yes      |
| path-to-regexp                                                                | 1.9.0                                     | MIT                                                                                  | https://github.com/pillarjs/path-to-regexp                                                          | Required          | Yes      |
| path-to-regexp                                                                | 2.4.0                                     | MIT                                                                                  | https://github.com/pillarjs/path-to-regexp                                                          | Required          | Yes      |
| path-type                                                                     | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/path-type                                                           | Required          | Yes      |
| pbkdf2                                                                        | 3.1.2                                     | MIT                                                                                  | https://github.com/crypto-browserify/pbkdf2                                                         | Required          | Yes      |
| pend                                                                          | 1.2.0                                     | MIT                                                                                  | https://github.com/andrewrk/node-pend                                                               | Required          | Yes      |
| performance-now                                                               | 2.1.0                                     | MIT                                                                                  | https://github.com/braveg1rl/performance-now                                                        | Required          | Yes      |
| picocolors                                                                    | 1.0.1                                     | ISC                                                                                  | https://github.com/alexeyraspopov/picocolors                                                        | Required          | Yes      |
| picocolors                                                                    | 1.1.1                                     | ISC                                                                                  | https://github.com/alexeyraspopov/picocolors                                                        | Required          | Yes      |
| picomatch                                                                     | 2.3.1                                     | MIT                                                                                  | https://github.com/micromatch/picomatch                                                             | Required          | Yes      |
| pify                                                                          | 2.3.0                                     | MIT                                                                                  | https://github.com/sindresorhus/pify                                                                | Required          | Yes      |
| pify                                                                          | 4.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/pify                                                                | Required          | Yes      |
| pino-abstract-transport                                                       | 2.0.0                                     | MIT                                                                                  | https://github.com/pinojs/pino-abstract-transport                                                   | Required          | Yes      |
| pino-pretty                                                                   | 11.3.0                                    | MIT                                                                                  | https://github.com/pinojs/pino-pretty                                                               | Required          | Yes      |
| pino-std-serializers                                                          | 7.0.0                                     | MIT                                                                                  | https://github.com/pinojs/pino-std-serializers                                                      | Required          | Yes      |
| pino                                                                          | 9.5.0                                     | MIT                                                                                  | https://github.com/pinojs/pino                                                                      | Required          | Yes      |
| pirates                                                                       | 4.0.6                                     | MIT                                                                                  | https://github.com/danez/pirates                                                                    | Required          | Yes      |
| pkg-dir                                                                       | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/pkg-dir                                                             | Required          | Yes      |
| pkg-dir                                                                       | 4.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/pkg-dir                                                             | Required          | Yes      |
| pkg-dir                                                                       | 5.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/pkg-dir                                                             | Required          | Yes      |
| pkg-dir                                                                       | 7.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/pkg-dir                                                             | Required          | Yes      |
| pluralize                                                                     | 8.0.0                                     | MIT                                                                                  | https://github.com/blakeembrey/pluralize                                                            | Required          | Yes      |
| possible-typed-array-names                                                    | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/possible-typed-array-names                                                | Required          | Yes      |
| postcss-calc                                                                  | 9.0.1                                     | MIT                                                                                  | https://github.com/postcss/postcss-calc                                                             | Required          | Yes      |
| postcss-colormin                                                              | 6.1.0                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-convert-values                                                        | 6.1.0                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-discard-comments                                                      | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-discard-duplicates                                                    | 6.0.3                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-discard-empty                                                         | 6.0.3                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-discard-overridden                                                    | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-loader                                                                | 7.3.4                                     | MIT                                                                                  | https://github.com/webpack-contrib/postcss-loader                                                   | Required          | Yes      |
| postcss-media-query-parser                                                    | 0.2.3                                     | MIT                                                                                  | https://github.com/dryoma/postcss-media-query-parser                                                | Required          | Yes      |
| postcss-merge-longhand                                                        | 6.0.5                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-merge-rules                                                           | 6.1.1                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-minify-font-values                                                    | 6.1.0                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-minify-gradients                                                      | 6.0.3                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-minify-params                                                         | 6.1.0                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-minify-selectors                                                      | 6.0.4                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-modules-extract-imports                                               | 3.1.0                                     | ISC                                                                                  | https://github.com/css-modules/postcss-modules-extract-imports                                      | Required          | Yes      |
| postcss-modules-local-by-default                                              | 4.0.5                                     | MIT                                                                                  | https://github.com/css-modules/postcss-modules-local-by-default                                     | Required          | Yes      |
| postcss-modules-scope                                                         | 3.2.0                                     | ISC                                                                                  | https://github.com/css-modules/postcss-modules-scope                                                | Required          | Yes      |
| postcss-modules-values                                                        | 4.0.0                                     | ISC                                                                                  | https://github.com/css-modules/postcss-modules-values                                               | Required          | Yes      |
| postcss-normalize-charset                                                     | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-normalize-display-values                                              | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-normalize-positions                                                   | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-normalize-repeat-style                                                | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-normalize-string                                                      | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-normalize-timing-functions                                            | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-normalize-unicode                                                     | 6.1.0                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-normalize-url                                                         | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-normalize-whitespace                                                  | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-ordered-values                                                        | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-reduce-initial                                                        | 6.1.0                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-reduce-transforms                                                     | 6.0.2                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-resolve-nested-selector                                               | 0.1.1                                     | MIT                                                                                  | N/A                                                                                                 | Required          | Yes      |
| postcss-safe-parser                                                           | 6.0.0                                     | MIT                                                                                  | https://github.com/postcss/postcss-safe-parser                                                      | Required          | Yes      |
| postcss-scss                                                                  | 4.0.9                                     | MIT                                                                                  | https://github.com/postcss/postcss-scss                                                             | Required          | Yes      |
| postcss-selector-parser                                                       | 6.1.0                                     | MIT                                                                                  | https://github.com/postcss/postcss-selector-parser                                                  | Required          | Yes      |
| postcss-svgo                                                                  | 6.0.3                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-unique-selectors                                                      | 6.0.4                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| postcss-value-parser                                                          | 4.2.0                                     | MIT                                                                                  | https://github.com/TrySound/postcss-value-parser                                                    | Required          | Yes      |
| postcss                                                                       | 8.4.38                                    | MIT                                                                                  | https://github.com/postcss/postcss                                                                  | Required          | Yes      |
| postcss                                                                       | 8.5.1                                     | MIT                                                                                  | https://github.com/postcss/postcss                                                                  | Required          | Yes      |
| prelude-ls                                                                    | 1.2.1                                     | MIT                                                                                  | https://github.com/gkz/prelude-ls                                                                   | Required          | Yes      |
| prettier-linter-helpers                                                       | 1.0.0                                     | MIT                                                                                  | https://github.com/prettier/prettier-linter-helpers                                                 | Required          | Yes      |
| prettier                                                                      | 2.8.8                                     | MIT                                                                                  | https://github.com/prettier/prettier                                                                | Required          | Yes      |
| pretty-bytes                                                                  | 5.6.0                                     | MIT                                                                                  | https://github.com/sindresorhus/pretty-bytes                                                        | Required          | Yes      |
| pretty-error                                                                  | 4.0.0                                     | MIT                                                                                  | https://github.com/AriaMinaei/pretty-error                                                          | Required          | Yes      |
| pretty-format                                                                 | 27.5.1                                    | MIT                                                                                  | https://github.com/facebook/jest                                                                    | Required          | Yes      |
| pretty-format                                                                 | 29.7.0                                    | MIT                                                                                  | https://github.com/jestjs/jest                                                                      | Required          | Yes      |
| pretty                                                                        | 2.0.0                                     | MIT                                                                                  | https://github.com/jonschlinkert/pretty                                                             | Required          | Yes      |
| prismjs                                                                       | 1.27.0                                    | MIT                                                                                  | https://github.com/PrismJS/prism                                                                    | Required          | Yes      |
| proc-log                                                                      | 3.0.0                                     | ISC                                                                                  | https://github.com/npm/proc-log                                                                     | Required          | Yes      |
| process-nextick-args                                                          | 2.0.1                                     | MIT                                                                                  | https://github.com/calvinmetcalf/process-nextick-args                                               | Required          | Yes      |
| process-warning                                                               | 4.0.0                                     | MIT                                                                                  | https://github.com/fastify/process-warning                                                          | Required          | Yes      |
| process                                                                       | 0.11.10                                   | MIT                                                                                  | https://github.com/shtylman/node-process                                                            | Required          | Yes      |
| progress                                                                      | 2.0.3                                     | MIT                                                                                  | https://github.com/visionmedia/node-progress                                                        | Required          | Yes      |
| promise-inflight                                                              | 1.0.1                                     | ISC                                                                                  | https://github.com/iarna/promise-inflight                                                           | Required          | Yes      |
| promise-polyfill                                                              | 8.3.0                                     | MIT                                                                                  | https://github.com/taylorhakes/promise-polyfill                                                     | Required          | Yes      |
| promise-retry                                                                 | 2.0.1                                     | MIT                                                                                  | https://github.com/IndigoUnited/node-promise-retry                                                  | Required          | Yes      |
| prompts-ncu                                                                   | 3.0.0                                     | MIT                                                                                  | https://github.com/raineorshine/prompts/tree/ncu                                                    | Required          | Yes      |
| prompts                                                                       | 2.4.2                                     | MIT                                                                                  | https://github.com/terkelg/prompts                                                                  | Required          | Yes      |
| prop-types                                                                    | 15.8.1                                    | MIT                                                                                  | https://github.com/facebook/prop-types                                                              | Required          | Yes      |
| property-information                                                          | 5.6.0                                     | MIT                                                                                  | https://github.com/wooorm/property-information                                                      | Required          | Yes      |
| proto-list                                                                    | 1.2.4                                     | ISC                                                                                  | https://github.com/isaacs/proto-list                                                                | Required          | Yes      |
| proxy-addr                                                                    | 2.0.7                                     | MIT                                                                                  | https://github.com/jshttp/proxy-addr                                                                | Required          | Yes      |
| proxy-from-env                                                                | 1.0.0                                     | MIT                                                                                  | https://github.com/Rob--W/proxy-from-env                                                            | Required          | Yes      |
| proxy-from-env                                                                | 1.1.0                                     | MIT                                                                                  | https://github.com/Rob--W/proxy-from-env                                                            | Required          | Yes      |
| prr                                                                           | 1.0.1                                     | MIT                                                                                  | https://github.com/rvagg/prr                                                                        | Required          | Yes      |
| psl                                                                           | 1.9.0                                     | MIT                                                                                  | https://github.com/lupomontero/psl                                                                  | Required          | Yes      |
| pstree.remy                                                                   | 1.1.8                                     | MIT                                                                                  | https://github.com/remy/pstree                                                                      | Required          | Yes      |
| public-encrypt                                                                | 4.0.3                                     | MIT                                                                                  | https://github.com/crypto-browserify/publicEncrypt                                                  | Required          | Yes      |
| pump                                                                          | 3.0.0                                     | MIT                                                                                  | https://github.com/mafintosh/pump                                                                   | Required          | Yes      |
| punycode                                                                      | 1.4.1                                     | MIT                                                                                  | https://github.com/bestiejs/punycode.js                                                             | Required          | Yes      |
| punycode                                                                      | 2.3.1                                     | MIT                                                                                  | https://github.com/mathiasbynens/punycode.js                                                        | Required          | Yes      |
| pupa                                                                          | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/pupa                                                                | Required          | Yes      |
| pure-rand                                                                     | 6.1.0                                     | MIT                                                                                  | https://github.com/dubzzz/pure-rand                                                                 | Required          | Yes      |
| qs                                                                            | 6.13.0                                    | BSD-3-Clause                                                                         | https://github.com/ljharb/qs                                                                        | Required          | Yes      |
| query-selector                                                                | 1.0.9                                     | MIT                                                                                  | https://github.com/yiminghe/query-selector                                                          | Required          | Yes      |
| query-string                                                                  | 7.1.3                                     | MIT                                                                                  | https://github.com/sindresorhus/query-string                                                        | Required          | Yes      |
| querystring                                                                   | 0.2.1                                     | MIT                                                                                  | https://github.com/Gozala/querystring                                                               | Required          | Yes      |
| querystringify                                                                | 2.2.0                                     | MIT                                                                                  | https://github.com/unshiftio/querystringify                                                         | Required          | Yes      |
| queue-microtask                                                               | 1.2.3                                     | MIT                                                                                  | https://github.com/feross/queue-microtask                                                           | Required          | Yes      |
| quick-format-unescaped                                                        | 4.0.4                                     | MIT                                                                                  | https://github.com/davidmarkclements/quick-format                                                   | Required          | Yes      |
| quick-lru                                                                     | 4.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/quick-lru                                                           | Required          | Yes      |
| quick-lru                                                                     | 5.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/quick-lru                                                           | Required          | Yes      |
| raf-schd                                                                      | 4.0.3                                     | MIT                                                                                  | https://github.com/alexreardon/raf-schd                                                             | Required          | Yes      |
| raf                                                                           | 3.4.1                                     | MIT                                                                                  | https://github.com/chrisdickinson/raf                                                               | Required          | Yes      |
| railroad-diagrams                                                             | 1.0.0                                     | CC0-1.0                                                                              | https://github.com/tabatkins/railroad-diagrams                                                      | Required          | Yes      |
| rambda                                                                        | 7.5.0                                     | MIT                                                                                  | https://github.com/selfrefactor/rambda                                                              | Required          | Yes      |
| randexp                                                                       | 0.4.6                                     | MIT                                                                                  | https://github.com/fent/randexp.js                                                                  | Required          | Yes      |
| randombytes                                                                   | 2.1.0                                     | MIT                                                                                  | https://github.com/crypto-browserify/randombytes                                                    | Required          | Yes      |
| randomfill                                                                    | 1.0.4                                     | MIT                                                                                  | https://github.com/crypto-browserify/randomfill                                                     | Required          | Yes      |
| range-parser                                                                  | 1.2.1                                     | MIT                                                                                  | https://github.com/jshttp/range-parser                                                              | Required          | Yes      |
| raw-body                                                                      | 2.5.2                                     | MIT                                                                                  | https://github.com/stream-utils/raw-body                                                            | Required          | Yes      |
| raw-loader                                                                    | 4.0.2                                     | MIT                                                                                  | https://github.com/webpack-contrib/raw-loader                                                       | Required          | Yes      |
| rc-config-loader                                                              | 4.1.3                                     | MIT                                                                                  | https://github.com/azu/rc-config-loader                                                             | Required          | Yes      |
| rc                                                                            | 1.2.8                                     | (BSD-2-Clause OR MIT OR Apache-2.0)                                                  | https://github.com/dominictarr/rc                                                                   | Required          | Yes      |
| re-reselect                                                                   | 3.4.0                                     | MIT                                                                                  | https://github.com/toomuchdesign/re-reselect                                                        | Required          | Yes      |
| react-ace                                                                     | 7.0.5                                     | MIT                                                                                  | https://github.com/securingsincity/react-ace                                                        | Required          | Yes      |
| react-beforeunload                                                            | 2.6.0                                     | MIT                                                                                  | https://github.com/jacobbuck/react-beforeunload                                                     | Required          | Yes      |
| react-clientside-effect                                                       | 1.2.6                                     | MIT                                                                                  | https://github.com/thekashey/react-clientside-effect                                                | Required          | Yes      |
| react-copy-to-clipboard                                                       | 5.1.0                                     | MIT                                                                                  | https://github.com/nkbt/react-copy-to-clipboard                                                     | Required          | Yes      |
| react-dom                                                                     | 17.0.2                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| react-dropzone                                                                | 11.7.1                                    | MIT                                                                                  | https://github.com/react-dropzone/react-dropzone                                                    | Required          | Yes      |
| react-element-to-jsx-string                                                   | 15.0.0                                    | MIT                                                                                  | https://github.com/algolia/react-element-to-jsx-string                                              | Required          | Yes      |
| react-error-boundary                                                          | 3.1.4                                     | MIT                                                                                  | https://github.com/bvaughn/react-error-boundary                                                     | Required          | Yes      |
| react-fast-compare                                                            | 2.0.4                                     | MIT                                                                                  | https://github.com/FormidableLabs/react-fast-compare                                                | Required          | Yes      |
| react-faux-dom                                                                | 4.5.0                                     | Unlicense                                                                            | https://github.com/Olical/react-faux-dom                                                            | Required          | Yes      |
| react-flip-move                                                               | 3.0.5                                     | MIT                                                                                  | https://github.com/joshwcomeau/react-flip-move                                                      | Required          | Yes      |
| react-focus-lock                                                              | 2.12.1                                    | MIT                                                                                  | https://github.com/theKashey/react-focus-lock                                                       | Required          | Yes      |
| react-focus-on                                                                | 3.9.3                                     | MIT                                                                                  | https://github.com/theKashey/react-focus-on                                                         | Required          | Yes      |
| react-intl                                                                    | 6.8.9                                     | BSD-3-Clause                                                                         | https://github.com/formatjs/formatjs                                                                | Required          | Yes      |
| react-is                                                                      | 16.13.1                                   | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| react-is                                                                      | 17.0.2                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| react-is                                                                      | 18.1.0                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| react-is                                                                      | 18.3.1                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| react-query                                                                   | 3.39.3                                    | MIT                                                                                  | https://github.com/tannerlinsley/react-query                                                        | Required          | Yes      |
| react-redux                                                                   | 7.2.9                                     | MIT                                                                                  | https://github.com/reduxjs/react-redux                                                              | Required          | Yes      |
| react-redux                                                                   | 8.1.3                                     | MIT                                                                                  | https://github.com/reduxjs/react-redux                                                              | Required          | Yes      |
| react-refresh                                                                 | 0.16.0                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| react-remove-scroll-bar                                                       | 2.3.6                                     | MIT                                                                                  | https://github.com/theKashey/react-remove-scroll-bar                                                | Required          | Yes      |
| react-remove-scroll                                                           | 2.5.10                                    | MIT                                                                                  | https://github.com/theKashey/react-remove-scroll                                                    | Required          | Yes      |
| react-responsive                                                              | 9.0.2                                     | MIT                                                                                  | https://github.com/contra/react-responsive                                                          | Required          | Yes      |
| react-router-config                                                           | 5.1.1                                     | MIT                                                                                  | https://github.com/ReactTraining/react-router                                                       | Required          | Yes      |
| react-router-dom                                                              | 5.3.0                                     | MIT                                                                                  | https://github.com/ReactTraining/react-router                                                       | Required          | Yes      |
| react-router                                                                  | 5.2.1                                     | MIT                                                                                  | https://github.com/ReactTraining/react-router                                                       | Required          | Yes      |
| react-script-loader-hoc                                                       | 1.2.2                                     | MIT                                                                                  | https://github.com/sesilio/react-script-loader-hoc                                                  | Required          | Yes      |
| react-shallow-renderer                                                        | 16.15.0                                   | MIT                                                                                  | https://github.com/NMinhNguyen/react-shallow-renderer                                               | Required          | Yes      |
| react-sticky-el                                                               | 2.1.1                                     | MIT                                                                                  | https://github.com/gm0t/react-sticky-el                                                             | Required          | Yes      |
| react-style-singleton                                                         | 2.2.1                                     | MIT                                                                                  | N/A                                                                                                 | Required          | Yes      |
| react-test-renderer                                                           | 17.0.2                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| react-text-truncate                                                           | 0.19.0                                    | MIT                                                                                  | https://github.com/ShinyChang/react-text-truncate                                                   | Required          | Yes      |
| react-virtualized-auto-sizer                                                  | 1.0.24                                    | MIT                                                                                  | https://github.com/bvaughn/react-virtualized-auto-sizer                                             | Required          | Yes      |
| react-window                                                                  | 1.8.10                                    | MIT                                                                                  | https://github.com/bvaughn/react-window                                                             | Required          | Yes      |
| react                                                                         | 17.0.2                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| read-installed                                                                | 4.0.3                                     | ISC                                                                                  | https://github.com/isaacs/read-installed                                                            | Required          | Yes      |
| read-package-json-fast                                                        | 3.0.2                                     | ISC                                                                                  | https://github.com/npm/read-package-json-fast                                                       | Required          | Yes      |
| read-package-json                                                             | 2.1.2                                     | ISC                                                                                  | https://github.com/npm/read-package-json                                                            | Required          | Yes      |
| read-package-json                                                             | 6.0.4                                     | ISC                                                                                  | https://github.com/npm/read-package-json                                                            | Required          | Yes      |
| read-pkg-up                                                                   | 7.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/read-pkg-up                                                         | Required          | Yes      |
| read-pkg-up                                                                   | 8.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/read-pkg-up                                                         | Required          | Yes      |
| read-pkg                                                                      | 5.2.0                                     | MIT                                                                                  | https://github.com/sindresorhus/read-pkg                                                            | Required          | Yes      |
| read-pkg                                                                      | 6.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/read-pkg                                                            | Required          | Yes      |
| readable-stream                                                               | 2.3.8                                     | MIT                                                                                  | https://github.com/nodejs/readable-stream                                                           | Required          | Yes      |
| readable-stream                                                               | 3.6.2                                     | MIT                                                                                  | https://github.com/nodejs/readable-stream                                                           | Required          | Yes      |
| readable-stream                                                               | 4.5.2                                     | MIT                                                                                  | https://github.com/nodejs/readable-stream                                                           | Required          | Yes      |
| readdir-scoped-modules                                                        | 1.1.0                                     | ISC                                                                                  | https://github.com/npm/readdir-scoped-modules                                                       | Required          | Yes      |
| readdirp                                                                      | 3.6.0                                     | MIT                                                                                  | https://github.com/paulmillr/readdirp                                                               | Required          | Yes      |
| real-require                                                                  | 0.2.0                                     | MIT                                                                                  | https://github.com/pinojs/real-require                                                              | Required          | Yes      |
| recast                                                                        | 0.20.5                                    | MIT                                                                                  | https://github.com/benjamn/recast                                                                   | Required          | Yes      |
| recast                                                                        | 0.23.9                                    | MIT                                                                                  | https://github.com/benjamn/recast                                                                   | Required          | Yes      |
| rechoir                                                                       | 0.8.0                                     | MIT                                                                                  | https://github.com/gulpjs/rechoir                                                                   | Required          | Yes      |
| redent                                                                        | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/redent                                                              | Required          | Yes      |
| redent                                                                        | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/redent                                                              | Required          | Yes      |
| redux-logger                                                                  | 3.0.6                                     | MIT                                                                                  | https://github.com/theaqua/redux-logger                                                             | Required          | Yes      |
| redux-mock-store                                                              | 1.5.5                                     | MIT                                                                                  | https://github.com/arnaudbenard/redux-mock-store                                                    | Required          | Yes      |
| redux-thunk                                                                   | 2.4.2                                     | MIT                                                                                  | https://github.com/reduxjs/redux-thunk                                                              | Required          | Yes      |
| redux                                                                         | 4.2.1                                     | MIT                                                                                  | https://github.com/reduxjs/redux                                                                    | Required          | Yes      |
| reflect.getprototypeof                                                        | 1.0.10                                    | MIT                                                                                  | https://github.com/es-shims/Reflect.getPrototypeOf                                                  | Required          | Yes      |
| reflect.getprototypeof                                                        | 1.0.6                                     | MIT                                                                                  | https://github.com/es-shims/Reflect.getPrototypeOf                                                  | Required          | Yes      |
| refractor                                                                     | 3.6.0                                     | MIT                                                                                  | https://github.com/wooorm/refractor                                                                 | Required          | Yes      |
| regenerate-unicode-properties                                                 | 10.1.1                                    | MIT                                                                                  | https://github.com/mathiasbynens/regenerate-unicode-properties                                      | Required          | Yes      |
| regenerate-unicode-properties                                                 | 10.2.0                                    | MIT                                                                                  | https://github.com/mathiasbynens/regenerate-unicode-properties                                      | Required          | Yes      |
| regenerate                                                                    | 1.4.2                                     | MIT                                                                                  | https://github.com/mathiasbynens/regenerate                                                         | Required          | Yes      |
| regenerator-runtime                                                           | 0.14.1                                    | MIT                                                                                  | https://github.com/facebook/regenerator/tree/main/packages/runtime                                  | Required          | Yes      |
| regenerator-transform                                                         | 0.15.2                                    | MIT                                                                                  | https://github.com/facebook/regenerator/tree/main/packages/transform                                | Required          | Yes      |
| regexp.prototype.flags                                                        | 1.5.2                                     | MIT                                                                                  | https://github.com/es-shims/RegExp.prototype.flags                                                  | Required          | Yes      |
| regexp.prototype.flags                                                        | 1.5.4                                     | MIT                                                                                  | https://github.com/es-shims/RegExp.prototype.flags                                                  | Required          | Yes      |
| regexpp                                                                       | 3.2.0                                     | MIT                                                                                  | https://github.com/mysticatea/regexpp                                                               | Required          | Yes      |
| regexpu-core                                                                  | 5.3.2                                     | MIT                                                                                  | https://github.com/mathiasbynens/regexpu-core                                                       | Required          | Yes      |
| regexpu-core                                                                  | 6.1.1                                     | MIT                                                                                  | https://github.com/mathiasbynens/regexpu-core                                                       | Required          | Yes      |
| registry-auth-token                                                           | 5.0.2                                     | MIT                                                                                  | https://github.com/rexxars/registry-auth-token                                                      | Required          | Yes      |
| registry-url                                                                  | 6.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/registry-url                                                        | Required          | Yes      |
| regjsgen                                                                      | 0.8.0                                     | MIT                                                                                  | https://github.com/bnjmnt4n/regjsgen                                                                | Required          | Yes      |
| regjsparser                                                                   | 0.11.2                                    | BSD-2-Clause                                                                         | https://github.com/jviereck/regjsparser                                                             | Required          | Yes      |
| regjsparser                                                                   | 0.9.1                                     | BSD-2-Clause                                                                         | https://github.com/jviereck/regjsparser                                                             | Required          | Yes      |
| rehype-raw                                                                    | 5.1.0                                     | MIT                                                                                  | https://github.com/rehypejs/rehype-raw                                                              | Required          | Yes      |
| rehype-react                                                                  | 6.2.1                                     | MIT                                                                                  | https://github.com/rehypejs/rehype-react                                                            | Required          | Yes      |
| rehype-stringify                                                              | 8.0.0                                     | MIT                                                                                  | https://github.com/rehypejs/rehype/tree/master/packages/rehype-stringify                            | Required          | Yes      |
| relateurl                                                                     | 0.2.7                                     | MIT                                                                                  | https://github.com/stevenvachon/relateurl                                                           | Required          | Yes      |
| remark-breaks                                                                 | 2.0.2                                     | MIT                                                                                  | https://github.com/remarkjs/remark-breaks                                                           | Required          | Yes      |
| remark-emoji                                                                  | 2.2.0                                     | MIT                                                                                  | https://github.com/rhysd/remark-emoji                                                               | Required          | Yes      |
| remark-parse-no-trim                                                          | 8.0.4                                     | MIT                                                                                  | https://github.com/docs/remark-parse-no-trim                                                        | Required          | Yes      |
| remark-rehype                                                                 | 8.1.0                                     | MIT                                                                                  | https://github.com/remarkjs/remark-rehype                                                           | Required          | Yes      |
| remote-git-tags                                                               | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/remote-git-tags                                                     | Required          | Yes      |
| remove-accents                                                                | 0.5.0                                     | MIT                                                                                  | https://github.com/tyxla/remove-accents                                                             | Required          | Yes      |
| renderkid                                                                     | 3.0.0                                     | MIT                                                                                  | https://github.com/AriaMinaei/RenderKid                                                             | Required          | Yes      |
| repeat-string                                                                 | 1.6.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/repeat-string                                                      | Required          | Yes      |
| request-progress                                                              | 3.0.0                                     | MIT                                                                                  | https://github.com/IndigoUnited/node-request-progress                                               | Required          | Yes      |
| require-directory                                                             | 2.1.1                                     | MIT                                                                                  | https://github.com/troygoode/node-require-directory                                                 | Required          | Yes      |
| require-from-string                                                           | 2.0.2                                     | MIT                                                                                  | https://github.com/floatdrop/require-from-string                                                    | Required          | Yes      |
| require-package-name                                                          | 2.0.1                                     | MIT                                                                                  | https://github.com/mattdesl/require-package-name                                                    | Required          | Yes      |
| requireindex                                                                  | 1.2.0                                     | MIT                                                                                  | https://github.com/stephenhandley/requireindex                                                      | Required          | Yes      |
| requires-port                                                                 | 1.0.0                                     | MIT                                                                                  | https://github.com/unshiftio/requires-port                                                          | Required          | Yes      |
| reselect                                                                      | 4.1.8                                     | MIT                                                                                  | https://github.com/reduxjs/reselect                                                                 | Required          | Yes      |
| resolve-alpn                                                                  | 1.2.1                                     | MIT                                                                                  | https://github.com/szmarczak/resolve-alpn                                                           | Required          | Yes      |
| resolve-cwd                                                                   | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/resolve-cwd                                                         | Required          | Yes      |
| resolve-from                                                                  | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/resolve-from                                                        | Required          | Yes      |
| resolve-from                                                                  | 5.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/resolve-from                                                        | Required          | Yes      |
| resolve-pathname                                                              | 3.0.0                                     | MIT                                                                                  | https://github.com/mjackson/resolve-pathname                                                        | Required          | Yes      |
| resolve-pkg-maps                                                              | 1.0.0                                     | MIT                                                                                  | https://github.com/privatenumber/resolve-pkg-maps                                                   | Required          | Yes      |
| resolve.exports                                                               | 2.0.2                                     | MIT                                                                                  | https://github.com/lukeed/resolve.exports                                                           | Required          | Yes      |
| resolve                                                                       | 1.22.8                                    | MIT                                                                                  | https://github.com/browserify/resolve                                                               | Required          | Yes      |
| resolve                                                                       | 2.0.0-next.5                              | MIT                                                                                  | https://github.com/browserify/resolve                                                               | Required          | Yes      |
| responselike                                                                  | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/responselike                                                        | Required          | Yes      |
| restore-cursor                                                                | 3.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/restore-cursor                                                      | Required          | Yes      |
| ret                                                                           | 0.1.15                                    | MIT                                                                                  | https://github.com/fent/ret.js                                                                      | Required          | Yes      |
| retry                                                                         | 0.12.0                                    | MIT                                                                                  | https://github.com/tim-kos/node-retry                                                               | Required          | Yes      |
| reusify                                                                       | 1.0.4                                     | MIT                                                                                  | https://github.com/mcollina/reusify                                                                 | Required          | Yes      |
| rfdc                                                                          | 1.3.1                                     | MIT                                                                                  | https://github.com/davidmarkclements/rfdc                                                           | Required          | Yes      |
| rimraf                                                                        | 2.6.3                                     | ISC                                                                                  | https://github.com/isaacs/rimraf                                                                    | Required          | Yes      |
| rimraf                                                                        | 3.0.2                                     | ISC                                                                                  | https://github.com/isaacs/rimraf                                                                    | Required          | Yes      |
| rimraf                                                                        | 5.0.7                                     | ISC                                                                                  | https://github.com/isaacs/rimraf                                                                    | Required          | Yes      |
| ripemd160                                                                     | 2.0.2                                     | MIT                                                                                  | https://github.com/crypto-browserify/ripemd160                                                      | Required          | Yes      |
| rst-selector-parser                                                           | 2.2.3                                     | BSD-3-Clause                                                                         | https://github.com/aweary/rst-selector-parser                                                       | Required          | Yes      |
| run-parallel                                                                  | 1.2.0                                     | MIT                                                                                  | https://github.com/feross/run-parallel                                                              | Required          | Yes      |
| rxjs                                                                          | 7.8.1                                     | Apache-2.0                                                                           | https://github.com/reactivex/rxjs                                                                   | Required          | Yes      |
| safe-array-concat                                                             | 1.1.2                                     | MIT                                                                                  | https://github.com/ljharb/safe-array-concat                                                         | Required          | Yes      |
| safe-array-concat                                                             | 1.1.3                                     | MIT                                                                                  | https://github.com/ljharb/safe-array-concat                                                         | Required          | Yes      |
| safe-buffer                                                                   | 5.1.2                                     | MIT                                                                                  | https://github.com/feross/safe-buffer                                                               | Required          | Yes      |
| safe-buffer                                                                   | 5.2.1                                     | MIT                                                                                  | https://github.com/feross/safe-buffer                                                               | Required          | Yes      |
| safe-push-apply                                                               | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/safe-push-apply                                                           | Required          | Yes      |
| safe-regex-test                                                               | 1.0.3                                     | MIT                                                                                  | https://github.com/ljharb/safe-regex-test                                                           | Required          | Yes      |
| safe-regex-test                                                               | 1.1.0                                     | MIT                                                                                  | https://github.com/ljharb/safe-regex-test                                                           | Required          | Yes      |
| safe-stable-stringify                                                         | 2.4.3                                     | MIT                                                                                  | https://github.com/BridgeAR/safe-stable-stringify                                                   | Required          | Yes      |
| safer-buffer                                                                  | 2.1.2                                     | MIT                                                                                  | https://github.com/ChALkeR/safer-buffer                                                             | Required          | Yes      |
| safeson                                                                       | 1.0.0                                     | MIT                                                                                  | https://github.com/bevacqua/safeson                                                                 | Required          | Yes      |
| sass-embedded-darwin-arm64                                                    | 1.83.4                                    | MIT                                                                                  | https://github.com/sass/embedded-host-node                                                          | Required          | Yes      |
| sass-embedded                                                                 | 1.83.4                                    | MIT                                                                                  | https://github.com/sass/embedded-host-node                                                          | Required          | Yes      |
| sass-loader                                                                   | 13.3.3                                    | MIT                                                                                  | https://github.com/webpack-contrib/sass-loader                                                      | Required          | Yes      |
| saxes                                                                         | 6.0.0                                     | ISC                                                                                  | https://github.com/lddubeau/saxes                                                                   | Required          | Yes      |
| scheduler                                                                     | 0.20.2                                    | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| schema-utils                                                                  | 3.1.1                                     | MIT                                                                                  | https://github.com/webpack/schema-utils                                                             | Required          | Yes      |
| schema-utils                                                                  | 3.3.0                                     | MIT                                                                                  | https://github.com/webpack/schema-utils                                                             | Required          | Yes      |
| schema-utils                                                                  | 4.2.0                                     | MIT                                                                                  | https://github.com/webpack/schema-utils                                                             | Required          | Yes      |
| schema-utils                                                                  | 4.3.0                                     | MIT                                                                                  | https://github.com/webpack/schema-utils                                                             | Required          | Yes      |
| scroll-into-view-if-needed                                                    | 3.1.0                                     | MIT                                                                                  | https://github.com/scroll-into-view/scroll-into-view-if-needed                                      | Required          | Yes      |
| secure-json-parse                                                             | 2.7.0                                     | BSD-3-Clause                                                                         | https://github.com/fastify/secure-json-parse                                                        | Required          | Yes      |
| secure-keys                                                                   | 1.0.0                                     | MIT                                                                                  | N/A                                                                                                 | Required          | Yes      |
| semver-diff                                                                   | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/semver-diff                                                         | Required          | Yes      |
| semver-utils                                                                  | 1.1.4                                     | MIT*                                                                                 | git://git.coolaj86.com/coolaj86/semver-utils.js                                                     | Required          | Yes      |
| semver                                                                        | 5.7.2                                     | ISC                                                                                  | https://github.com/npm/node-semver                                                                  | Required          | Yes      |
| semver                                                                        | 6.3.1                                     | ISC                                                                                  | https://github.com/npm/node-semver                                                                  | Required          | Yes      |
| semver                                                                        | 7.6.2                                     | ISC                                                                                  | https://github.com/npm/node-semver                                                                  | Required          | Yes      |
| semver                                                                        | 7.6.3                                     | ISC                                                                                  | https://github.com/npm/node-semver                                                                  | Required          | Yes      |
| send                                                                          | 0.19.0                                    | MIT                                                                                  | https://github.com/pillarjs/send                                                                    | Required          | Yes      |
| sentence-case                                                                 | 3.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| serialize-javascript                                                          | 6.0.2                                     | BSD-3-Clause                                                                         | https://github.com/yahoo/serialize-javascript                                                       | Required          | Yes      |
| serve-static                                                                  | 1.16.2                                    | MIT                                                                                  | https://github.com/expressjs/serve-static                                                           | Required          | Yes      |
| set-blocking                                                                  | 2.0.0                                     | ISC                                                                                  | https://github.com/yargs/set-blocking                                                               | Required          | Yes      |
| set-function-length                                                           | 1.2.2                                     | MIT                                                                                  | https://github.com/ljharb/set-function-length                                                       | Required          | Yes      |
| set-function-name                                                             | 2.0.2                                     | MIT                                                                                  | https://github.com/ljharb/set-function-name                                                         | Required          | Yes      |
| set-proto                                                                     | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/set-proto                                                                 | Required          | Yes      |
| setimmediate                                                                  | 1.0.5                                     | MIT                                                                                  | https://github.com/YuzuJS/setImmediate                                                              | Required          | Yes      |
| setprototypeof                                                                | 1.2.0                                     | ISC                                                                                  | https://github.com/wesleytodd/setprototypeof                                                        | Required          | Yes      |
| sha.js                                                                        | 2.4.11                                    | (MIT AND BSD-3-Clause)                                                               | https://github.com/crypto-browserify/sha.js                                                         | Required          | Yes      |
| shallow-clone                                                                 | 3.0.1                                     | MIT                                                                                  | https://github.com/jonschlinkert/shallow-clone                                                      | Required          | Yes      |
| shallow-equal                                                                 | 1.2.1                                     | MIT                                                                                  | https://github.com/moroshko/shallow-equal                                                           | Required          | Yes      |
| shallowequal                                                                  | 1.1.0                                     | MIT                                                                                  | https://github.com/dashed/shallowequal                                                              | Required          | Yes      |
| shebang-command                                                               | 2.0.0                                     | MIT                                                                                  | https://github.com/kevva/shebang-command                                                            | Required          | Yes      |
| shebang-regex                                                                 | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/shebang-regex                                                       | Required          | Yes      |
| shell-quote                                                                   | 1.8.1                                     | MIT                                                                                  | https://github.com/ljharb/shell-quote                                                               | Required          | Yes      |
| side-channel-list                                                             | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/side-channel-list                                                         | Required          | Yes      |
| side-channel-map                                                              | 1.0.1                                     | MIT                                                                                  | https://github.com/ljharb/side-channel-map                                                          | Required          | Yes      |
| side-channel-weakmap                                                          | 1.0.2                                     | MIT                                                                                  | https://github.com/ljharb/side-channel-weakmap                                                      | Required          | Yes      |
| side-channel                                                                  | 1.0.6                                     | MIT                                                                                  | https://github.com/ljharb/side-channel                                                              | Required          | Yes      |
| side-channel                                                                  | 1.1.0                                     | MIT                                                                                  | https://github.com/ljharb/side-channel                                                              | Required          | Yes      |
| signal-exit                                                                   | 3.0.7                                     | ISC                                                                                  | https://github.com/tapjs/signal-exit                                                                | Required          | Yes      |
| signal-exit                                                                   | 4.1.0                                     | ISC                                                                                  | https://github.com/tapjs/signal-exit                                                                | Required          | Yes      |
| sigstore                                                                      | 1.9.0                                     | Apache-2.0                                                                           | https://github.com/sigstore/sigstore-js                                                             | Required          | Yes      |
| simple-update-notifier                                                        | 2.0.0                                     | MIT                                                                                  | https://github.com/alexbrazier/simple-update-notifier                                               | Required          | Yes      |
| sisteransi                                                                    | 1.0.5                                     | MIT                                                                                  | https://github.com/terkelg/sisteransi                                                               | Required          | Yes      |
| slash                                                                         | 2.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/slash                                                               | Required          | Yes      |
| slash                                                                         | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/slash                                                               | Required          | Yes      |
| slash                                                                         | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/slash                                                               | Required          | Yes      |
| slice-ansi                                                                    | 3.0.0                                     | MIT                                                                                  | https://github.com/chalk/slice-ansi                                                                 | Required          | Yes      |
| slice-ansi                                                                    | 4.0.0                                     | MIT                                                                                  | https://github.com/chalk/slice-ansi                                                                 | Required          | Yes      |
| slide                                                                         | 1.1.6                                     | ISC                                                                                  | https://github.com/isaacs/slide-flow-control                                                        | Required          | Yes      |
| sluggish                                                                      | 1.0.1                                     | MIT                                                                                  | https://github.com/bevacqua/sluggish                                                                | Required          | Yes      |
| smart-buffer                                                                  | 4.2.0                                     | MIT                                                                                  | https://github.com/JoshGlazebrook/smart-buffer                                                      | Required          | Yes      |
| snake-case                                                                    | 3.0.4                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| socks-proxy-agent                                                             | 7.0.0                                     | MIT                                                                                  | https://github.com/TooTallNate/node-socks-proxy-agent                                               | Required          | Yes      |
| socks                                                                         | 2.8.3                                     | MIT                                                                                  | https://github.com/JoshGlazebrook/socks                                                             | Required          | Yes      |
| sonic-boom                                                                    | 4.1.0                                     | MIT                                                                                  | https://github.com/pinojs/sonic-boom                                                                | Required          | Yes      |
| source-map-js                                                                 | 1.2.0                                     | BSD-3-Clause                                                                         | https://github.com/7rulnik/source-map-js                                                            | Required          | Yes      |
| source-map-js                                                                 | 1.2.1                                     | BSD-3-Clause                                                                         | https://github.com/7rulnik/source-map-js                                                            | Required          | Yes      |
| source-map-support                                                            | 0.5.13                                    | MIT                                                                                  | https://github.com/evanw/node-source-map-support                                                    | Required          | Yes      |
| source-map-support                                                            | 0.5.21                                    | MIT                                                                                  | https://github.com/evanw/node-source-map-support                                                    | Required          | Yes      |
| source-map                                                                    | 0.5.7                                     | BSD-3-Clause                                                                         | https://github.com/mozilla/source-map                                                               | Required          | Yes      |
| source-map                                                                    | 0.6.1                                     | BSD-3-Clause                                                                         | https://github.com/mozilla/source-map                                                               | Required          | Yes      |
| source-map                                                                    | 0.7.4                                     | BSD-3-Clause                                                                         | https://github.com/mozilla/source-map                                                               | Required          | Yes      |
| space-separated-tokens                                                        | 1.1.5                                     | MIT                                                                                  | https://github.com/wooorm/space-separated-tokens                                                    | Required          | Yes      |
| spawn-please                                                                  | 2.0.2                                     | ISC                                                                                  | https://github.com/raineorshine/spawn-please                                                        | Required          | Yes      |
| spdx-compare                                                                  | 1.0.0                                     | MIT                                                                                  | https://github.com/kemitchell/spdx-compare.js                                                       | Required          | Yes      |
| spdx-correct                                                                  | 3.2.0                                     | Apache-2.0                                                                           | https://github.com/jslicense/spdx-correct.js                                                        | Required          | Yes      |
| spdx-exceptions                                                               | 2.5.0                                     | CC-BY-3.0                                                                            | https://github.com/kemitchell/spdx-exceptions.json                                                  | Required          | Yes      |
| spdx-expression-parse                                                         | 3.0.1                                     | MIT                                                                                  | https://github.com/jslicense/spdx-expression-parse.js                                               | Required          | Yes      |
| spdx-license-ids                                                              | 3.0.18                                    | CC0-1.0                                                                              | https://github.com/jslicense/spdx-license-ids                                                       | Required          | Yes      |
| spdx-ranges                                                                   | 2.1.1                                     | (MIT AND CC-BY-3.0)                                                                  | https://github.com/kemitchell/spdx-ranges.js                                                        | Required          | Yes      |
| spdx-satisfies                                                                | 4.0.1                                     | MIT                                                                                  | https://github.com/kemitchell/spdx-satisfies.js                                                     | Required          | Yes      |
| split-on-first                                                                | 1.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/split-on-first                                                      | Required          | Yes      |
| split2                                                                        | 4.2.0                                     | ISC                                                                                  | https://github.com/mcollina/split2                                                                  | Required          | Yes      |
| sprintf-js                                                                    | 1.0.3                                     | BSD-3-Clause                                                                         | https://github.com/alexei/sprintf.js                                                                | Required          | Yes      |
| sprintf-js                                                                    | 1.1.2                                     | BSD-3-Clause                                                                         | https://github.com/alexei/sprintf.js                                                                | Required          | Yes      |
| sprintf-js                                                                    | 1.1.3                                     | BSD-3-Clause                                                                         | https://github.com/alexei/sprintf.js                                                                | Required          | Yes      |
| sshpk                                                                         | 1.18.0                                    | MIT                                                                                  | https://github.com/joyent/node-sshpk                                                                | Required          | Yes      |
| ssri                                                                          | 10.0.6                                    | ISC                                                                                  | https://github.com/npm/ssri                                                                         | Required          | Yes      |
| ssri                                                                          | 9.0.1                                     | ISC                                                                                  | https://github.com/npm/ssri                                                                         | Required          | Yes      |
| stable-hash                                                                   | 0.0.4                                     | MIT                                                                                  | https://github.com/shuding/stable-hash                                                              | Required          | Yes      |
| stack-utils                                                                   | 2.0.6                                     | MIT                                                                                  | https://github.com/tapjs/stack-utils                                                                | Required          | Yes      |
| stackframe                                                                    | 0.3.1                                     | Public Domain                                                                        | https://github.com/stacktracejs/stackframe                                                          | Required          | Yes      |
| stackframe                                                                    | 1.3.4                                     | MIT                                                                                  | https://github.com/stacktracejs/stackframe                                                          | Required          | Yes      |
| state-toggle                                                                  | 1.0.3                                     | MIT                                                                                  | https://github.com/wooorm/state-toggle                                                              | Required          | Yes      |
| statuses                                                                      | 2.0.1                                     | MIT                                                                                  | https://github.com/jshttp/statuses                                                                  | Required          | Yes      |
| stop-iteration-iterator                                                       | 1.0.0                                     | MIT                                                                                  | https://github.com/ljharb/stop-iteration-iterator                                                   | Required          | Yes      |
| stream-browserify                                                             | 3.0.0                                     | MIT                                                                                  | https://github.com/browserify/stream-browserify                                                     | Required          | Yes      |
| strict-uri-encode                                                             | 2.0.0                                     | MIT                                                                                  | https://github.com/kevva/strict-uri-encode                                                          | Required          | Yes      |
| string-length                                                                 | 4.0.2                                     | MIT                                                                                  | https://github.com/sindresorhus/string-length                                                       | Required          | Yes      |
| string-width                                                                  | 4.2.3                                     | MIT                                                                                  | https://github.com/sindresorhus/string-width                                                        | Required          | Yes      |
| string-width                                                                  | 5.1.2                                     | MIT                                                                                  | https://github.com/sindresorhus/string-width                                                        | Required          | Yes      |
| string.prototype.matchall                                                     | 4.0.11                                    | MIT                                                                                  | https://github.com/es-shims/String.prototype.matchAll                                               | Required          | Yes      |
| string.prototype.matchall                                                     | 4.0.12                                    | MIT                                                                                  | https://github.com/es-shims/String.prototype.matchAll                                               | Required          | Yes      |
| string.prototype.repeat                                                       | 1.0.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/String.prototype.repeat                                            | Required          | Yes      |
| string.prototype.trim                                                         | 1.2.10                                    | MIT                                                                                  | https://github.com/es-shims/String.prototype.trim                                                   | Required          | Yes      |
| string.prototype.trim                                                         | 1.2.9                                     | MIT                                                                                  | https://github.com/es-shims/String.prototype.trim                                                   | Required          | Yes      |
| string.prototype.trimend                                                      | 1.0.8                                     | MIT                                                                                  | https://github.com/es-shims/String.prototype.trimEnd                                                | Required          | Yes      |
| string.prototype.trimend                                                      | 1.0.9                                     | MIT                                                                                  | https://github.com/es-shims/String.prototype.trimEnd                                                | Required          | Yes      |
| string.prototype.trimstart                                                    | 1.0.8                                     | MIT                                                                                  | https://github.com/es-shims/String.prototype.trimStart                                              | Required          | Yes      |
| string_decoder                                                                | 1.1.1                                     | MIT                                                                                  | https://github.com/nodejs/string_decoder                                                            | Required          | Yes      |
| string_decoder                                                                | 1.3.0                                     | MIT                                                                                  | https://github.com/nodejs/string_decoder                                                            | Required          | Yes      |
| stringify-entities                                                            | 3.1.0                                     | MIT                                                                                  | https://github.com/wooorm/stringify-entities                                                        | Required          | Yes      |
| strip-ansi                                                                    | 6.0.1                                     | MIT                                                                                  | https://github.com/chalk/strip-ansi                                                                 | Required          | Yes      |
| strip-ansi                                                                    | 7.1.0                                     | MIT                                                                                  | https://github.com/chalk/strip-ansi                                                                 | Required          | Yes      |
| strip-bom                                                                     | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/strip-bom                                                           | Required          | Yes      |
| strip-bom                                                                     | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/strip-bom                                                           | Required          | Yes      |
| strip-final-newline                                                           | 2.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/strip-final-newline                                                 | Required          | Yes      |
| strip-indent                                                                  | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/strip-indent                                                        | Required          | Yes      |
| strip-indent                                                                  | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/strip-indent                                                        | Required          | Yes      |
| strip-json-comments                                                           | 2.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/strip-json-comments                                                 | Required          | Yes      |
| strip-json-comments                                                           | 3.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/strip-json-comments                                                 | Required          | Yes      |
| strip-json-comments                                                           | 5.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/strip-json-comments                                                 | Required          | Yes      |
| style-attr                                                                    | 1.3.0                                     | MIT                                                                                  | https://github.com/joshwnj/style-attr                                                               | Required          | Yes      |
| style-search                                                                  | 0.1.0                                     | ISC                                                                                  | https://github.com/davidtheclark/style-search                                                       | Required          | Yes      |
| style-to-object                                                               | 0.3.0                                     | MIT                                                                                  | https://github.com/remarkablemark/style-to-object                                                   | Required          | Yes      |
| stylehacks                                                                    | 6.1.1                                     | MIT                                                                                  | https://github.com/cssnano/cssnano                                                                  | Required          | Yes      |
| stylelint-config-prettier-scss                                                | 1.0.0                                     | MIT                                                                                  | https://github.com/prettier/stylelint-config-prettier-scss                                          | Required          | Yes      |
| stylelint-config-sass-guidelines                                              | 10.0.0                                    | MIT                                                                                  | https://github.com/bjankord/stylelint-config-sass-guidelines                                        | Required          | Yes      |
| stylelint-scss                                                                | 4.7.0                                     | MIT                                                                                  | https://github.com/stylelint-scss/stylelint-scss                                                    | Required          | Yes      |
| stylelint                                                                     | 15.11.0                                   | MIT                                                                                  | https://github.com/stylelint/stylelint                                                              | Required          | Yes      |
| stylis                                                                        | 4.2.0                                     | MIT                                                                                  | https://github.com/thysultan/stylis.js                                                              | Required          | Yes      |
| supports-color                                                                | 5.5.0                                     | MIT                                                                                  | https://github.com/chalk/supports-color                                                             | Required          | Yes      |
| supports-color                                                                | 7.2.0                                     | MIT                                                                                  | https://github.com/chalk/supports-color                                                             | Required          | Yes      |
| supports-color                                                                | 8.1.1                                     | MIT                                                                                  | https://github.com/chalk/supports-color                                                             | Required          | Yes      |
| supports-color                                                                | 9.4.0                                     | MIT                                                                                  | https://github.com/chalk/supports-color                                                             | Required          | Yes      |
| supports-hyperlinks                                                           | 3.0.0                                     | MIT                                                                                  | https://github.com/jamestalmage/supports-hyperlinks                                                 | Required          | Yes      |
| supports-preserve-symlinks-flag                                               | 1.0.0                                     | MIT                                                                                  | https://github.com/inspect-js/node-supports-preserve-symlinks-flag                                  | Required          | Yes      |
| svg-tags                                                                      | 1.0.0                                     | MIT                                                                                  | https://github.com/element-io/svg-tags                                                              | Required          | Yes      |
| svgo                                                                          | 3.3.2                                     | MIT                                                                                  | https://github.com/svg/svgo                                                                         | Required          | Yes      |
| symbol-tree                                                                   | 3.2.4                                     | MIT                                                                                  | https://github.com/jsdom/js-symbol-tree                                                             | Required          | Yes      |
| sync-child-process                                                            | 1.0.2                                     | MIT                                                                                  | https://github.com/sass/sync-child-process                                                          | Required          | Yes      |
| sync-message-port                                                             | 1.1.3                                     | MIT                                                                                  | https://github.com/sass/sync-message-port                                                           | Required          | Yes      |
| tabbable                                                                      | 5.3.3                                     | MIT                                                                                  | https://github.com/focus-trap/tabbable                                                              | Required          | Yes      |
| table                                                                         | 6.8.2                                     | BSD-3-Clause                                                                         | https://github.com/gajus/table                                                                      | Required          | Yes      |
| tapable                                                                       | 2.2.1                                     | MIT                                                                                  | https://github.com/webpack/tapable                                                                  | Required          | Yes      |
| tar                                                                           | 6.2.1                                     | ISC                                                                                  | https://github.com/isaacs/node-tar                                                                  | Required          | Yes      |
| temp                                                                          | 0.8.4                                     | MIT                                                                                  | https://github.com/bruce/node-temp                                                                  | Required          | Yes      |
| terser-webpack-plugin                                                         | 5.3.10                                    | MIT                                                                                  | https://github.com/webpack-contrib/terser-webpack-plugin                                            | Required          | Yes      |
| terser-webpack-plugin                                                         | 5.3.11                                    | MIT                                                                                  | https://github.com/webpack-contrib/terser-webpack-plugin                                            | Required          | Yes      |
| terser                                                                        | 5.15.0                                    | BSD-2-Clause                                                                         | https://github.com/terser/terser                                                                    | Required          | Yes      |
| terser                                                                        | 5.30.3                                    | BSD-2-Clause                                                                         | https://github.com/terser/terser                                                                    | Required          | Yes      |
| terser                                                                        | 5.37.0                                    | BSD-2-Clause                                                                         | https://github.com/terser/terser                                                                    | Required          | Yes      |
| test-exclude                                                                  | 6.0.0                                     | ISC                                                                                  | https://github.com/istanbuljs/test-exclude                                                          | Required          | Yes      |
| text-diff                                                                     | 1.0.1                                     | Apache-2.0                                                                           | https://github.com/liddiard/text-diff                                                               | Required          | Yes      |
| text-table                                                                    | 0.2.0                                     | MIT                                                                                  | https://github.com/substack/text-table                                                              | Required          | Yes      |
| thenify-all                                                                   | 1.6.0                                     | MIT                                                                                  | https://github.com/thenables/thenify-all                                                            | Required          | Yes      |
| thenify                                                                       | 3.3.1                                     | MIT                                                                                  | https://github.com/thenables/thenify                                                                | Required          | Yes      |
| thirty-two                                                                    | 1.0.2                                     | MIT*                                                                                 | https://github.com/chrisumbel/thirty-two                                                            | Required          | Yes      |
| thread-stream                                                                 | 3.1.0                                     | MIT                                                                                  | https://github.com/mcollina/thread-stream                                                           | Required          | Yes      |
| throttleit                                                                    | 1.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/throttleit                                                          | Required          | Yes      |
| through                                                                       | 2.3.8                                     | MIT                                                                                  | https://github.com/dominictarr/through                                                              | Required          | Yes      |
| tiny-glob                                                                     | 0.2.9                                     | MIT                                                                                  | https://github.com/terkelg/tiny-glob                                                                | Required          | Yes      |
| tiny-invariant                                                                | 1.3.3                                     | MIT                                                                                  | https://github.com/alexreardon/tiny-invariant                                                       | Required          | Yes      |
| tiny-warning                                                                  | 1.0.3                                     | MIT                                                                                  | https://github.com/alexreardon/tiny-warning                                                         | Required          | Yes      |
| tldts-core                                                                    | 6.1.60                                    | MIT                                                                                  | https://github.com/remusao/tldts                                                                    | Required          | Yes      |
| tldts                                                                         | 6.1.60                                    | MIT                                                                                  | https://github.com/remusao/tldts                                                                    | Required          | Yes      |
| tmp                                                                           | 0.2.3                                     | MIT                                                                                  | https://github.com/raszi/node-tmp                                                                   | Required          | Yes      |
| tmpl                                                                          | 1.0.5                                     | BSD-3-Clause                                                                         | https://github.com/daaku/nodejs-tmpl                                                                | Required          | Yes      |
| to-fast-properties                                                            | 2.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/to-fast-properties                                                  | Required          | Yes      |
| to-regex-range                                                                | 5.0.1                                     | MIT                                                                                  | https://github.com/micromatch/to-regex-range                                                        | Required          | Yes      |
| toggle-selection                                                              | 1.0.6                                     | MIT                                                                                  | https://github.com/sudodoki/toggle-selection                                                        | Required          | Yes      |
| toidentifier                                                                  | 1.0.1                                     | MIT                                                                                  | https://github.com/component/toidentifier                                                           | Required          | Yes      |
| totp-generator                                                                | 1.0.0                                     | MIT                                                                                  | https://github.com/bellstrand/totp-generator                                                        | Required          | Yes      |
| touch                                                                         | 3.1.1                                     | ISC                                                                                  | https://github.com/isaacs/node-touch                                                                | Required          | Yes      |
| tough-cookie                                                                  | 4.1.4                                     | BSD-3-Clause                                                                         | https://github.com/salesforce/tough-cookie                                                          | Required          | Yes      |
| tough-cookie                                                                  | 5.0.0                                     | BSD-3-Clause                                                                         | https://github.com/salesforce/tough-cookie                                                          | Required          | Yes      |
| tr46                                                                          | 0.0.3                                     | MIT                                                                                  | https://github.com/Sebmaster/tr46.js                                                                | Required          | Yes      |
| tr46                                                                          | 1.0.1                                     | MIT                                                                                  | https://github.com/Sebmaster/tr46.js                                                                | Required          | Yes      |
| tr46                                                                          | 3.0.0                                     | MIT                                                                                  | https://github.com/jsdom/tr46                                                                       | Required          | Yes      |
| transform-imports                                                             | 2.2.0                                     | MIT                                                                                  | https://github.com/suchipi/transform-imports                                                        | Required          | Yes      |
| tree-kill                                                                     | 1.2.2                                     | MIT                                                                                  | https://github.com/pkrumins/node-tree-kill                                                          | Required          | Yes      |
| treeify                                                                       | 1.1.0                                     | MIT                                                                                  | https://github.com/notatestuser/treeify                                                             | Required          | Yes      |
| trim-newlines                                                                 | 3.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/trim-newlines                                                       | Required          | Yes      |
| trim-newlines                                                                 | 4.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/trim-newlines                                                       | Required          | Yes      |
| trim-trailing-lines                                                           | 1.1.4                                     | MIT                                                                                  | https://github.com/wooorm/trim-trailing-lines                                                       | Required          | Yes      |
| trough                                                                        | 1.0.5                                     | MIT                                                                                  | https://github.com/wooorm/trough                                                                    | Required          | Yes      |
| ts-api-utils                                                                  | 1.3.0                                     | MIT                                                                                  | https://github.com/JoshuaKGoldberg/ts-api-utils                                                     | Required          | Yes      |
| ts-debounce                                                                   | 4.0.0                                     | MIT                                                                                  | https://github.com/chodorowicz/ts-debounce                                                          | Required          | Yes      |
| ts-loader                                                                     | 9.5.2                                     | MIT                                                                                  | https://github.com/TypeStrong/ts-loader                                                             | Required          | Yes      |
| ts-node                                                                       | 10.9.2                                    | MIT                                                                                  | https://github.com/TypeStrong/ts-node                                                               | Required          | Yes      |
| ts-unused-exports                                                             | 10.1.0                                    | MIT                                                                                  | https://github.com/pzavolinsky/ts-unused-exports                                                    | Required          | Yes      |
| tsconfig-paths                                                                | 3.15.0                                    | MIT                                                                                  | https://github.com/dividab/tsconfig-paths                                                           | Required          | Yes      |
| tslib                                                                         | 1.14.1                                    | 0BSD                                                                                 | https://github.com/Microsoft/tslib                                                                  | Required          | Yes      |
| tslib                                                                         | 2.6.3                                     | 0BSD                                                                                 | https://github.com/Microsoft/tslib                                                                  | Required          | Yes      |
| tslib                                                                         | 2.8.1                                     | 0BSD                                                                                 | https://github.com/Microsoft/tslib                                                                  | Required          | Yes      |
| tsutils                                                                       | 3.21.0                                    | MIT                                                                                  | https://github.com/ajafff/tsutils                                                                   | Required          | Yes      |
| tuf-js                                                                        | 1.1.7                                     | MIT                                                                                  | https://github.com/theupdateframework/tuf-js                                                        | Required          | Yes      |
| tunnel-agent                                                                  | 0.6.0                                     | Apache-2.0                                                                           | https://github.com/mikeal/tunnel-agent                                                              | Required          | Yes      |
| tweetnacl                                                                     | 0.14.5                                    | Unlicense                                                                            | https://github.com/dchest/tweetnacl-js                                                              | Required          | Yes      |
| type-check                                                                    | 0.4.0                                     | MIT                                                                                  | https://github.com/gkz/type-check                                                                   | Required          | Yes      |
| type-detect                                                                   | 4.0.8                                     | MIT                                                                                  | https://github.com/chaijs/type-detect                                                               | Required          | Yes      |
| type-fest                                                                     | 0.18.1                                    | (MIT OR CC0-1.0)                                                                     | https://github.com/sindresorhus/type-fest                                                           | Required          | Yes      |
| type-fest                                                                     | 0.20.2                                    | (MIT OR CC0-1.0)                                                                     | https://github.com/sindresorhus/type-fest                                                           | Required          | Yes      |
| type-fest                                                                     | 0.21.3                                    | (MIT OR CC0-1.0)                                                                     | https://github.com/sindresorhus/type-fest                                                           | Required          | Yes      |
| type-fest                                                                     | 0.6.0                                     | (MIT OR CC0-1.0)                                                                     | https://github.com/sindresorhus/type-fest                                                           | Required          | Yes      |
| type-fest                                                                     | 0.8.1                                     | (MIT OR CC0-1.0)                                                                     | https://github.com/sindresorhus/type-fest                                                           | Required          | Yes      |
| type-fest                                                                     | 1.4.0                                     | (MIT OR CC0-1.0)                                                                     | https://github.com/sindresorhus/type-fest                                                           | Required          | Yes      |
| type-fest                                                                     | 2.19.0                                    | (MIT OR CC0-1.0)                                                                     | https://github.com/sindresorhus/type-fest                                                           | Required          | Yes      |
| type-is                                                                       | 1.6.18                                    | MIT                                                                                  | https://github.com/jshttp/type-is                                                                   | Required          | Yes      |
| typed-array-buffer                                                            | 1.0.2                                     | MIT                                                                                  | https://github.com/ljharb/typed-array-buffer                                                        | Required          | Yes      |
| typed-array-buffer                                                            | 1.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/typed-array-buffer                                                    | Required          | Yes      |
| typed-array-byte-length                                                       | 1.0.1                                     | MIT                                                                                  | https://github.com/inspect-js/typed-array-byte-length                                               | Required          | Yes      |
| typed-array-byte-length                                                       | 1.0.3                                     | MIT                                                                                  | https://github.com/inspect-js/typed-array-byte-length                                               | Required          | Yes      |
| typed-array-byte-offset                                                       | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/typed-array-byte-offset                                               | Required          | Yes      |
| typed-array-byte-offset                                                       | 1.0.4                                     | MIT                                                                                  | https://github.com/inspect-js/typed-array-byte-offset                                               | Required          | Yes      |
| typed-array-length                                                            | 1.0.6                                     | MIT                                                                                  | https://github.com/inspect-js/typed-array-length                                                    | Required          | Yes      |
| typed-array-length                                                            | 1.0.7                                     | MIT                                                                                  | https://github.com/inspect-js/typed-array-length                                                    | Required          | Yes      |
| typedarray-to-buffer                                                          | 3.1.5                                     | MIT                                                                                  | https://github.com/feross/typedarray-to-buffer                                                      | Required          | Yes      |
| typescript                                                                    | 5.4.5                                     | Apache-2.0                                                                           | https://github.com/Microsoft/TypeScript                                                             | Required          | Yes      |
| typescript                                                                    | 5.7.3                                     | Apache-2.0                                                                           | https://github.com/microsoft/TypeScript                                                             | Required          | Yes      |
| uc.micro                                                                      | 1.0.6                                     | MIT                                                                                  | https://github.com/markdown-it/uc.micro                                                             | Required          | Yes      |
| unbox-primitive                                                               | 1.0.2                                     | MIT                                                                                  | https://github.com/ljharb/unbox-primitive                                                           | Required          | Yes      |
| unbox-primitive                                                               | 1.1.0                                     | MIT                                                                                  | https://github.com/ljharb/unbox-primitive                                                           | Required          | Yes      |
| undefsafe                                                                     | 2.0.5                                     | MIT                                                                                  | https://github.com/remy/undefsafe                                                                   | Required          | Yes      |
| undici-types                                                                  | 5.26.5                                    | MIT                                                                                  | https://github.com/nodejs/undici                                                                    | Required          | Yes      |
| undici-types                                                                  | 6.19.8                                    | MIT                                                                                  | https://github.com/nodejs/undici                                                                    | Required          | Yes      |
| undici                                                                        | 5.28.5                                    | MIT                                                                                  | https://github.com/nodejs/undici                                                                    | Required          | Yes      |
| unfetch                                                                       | 4.2.0                                     | MIT                                                                                  | https://github.com/developit/unfetch                                                                | Required          | Yes      |
| unherit                                                                       | 1.1.3                                     | MIT                                                                                  | https://github.com/wooorm/unherit                                                                   | Required          | Yes      |
| unicode-canonical-property-names-ecmascript                                   | 2.0.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/unicode-canonical-property-names-ecmascript                        | Required          | Yes      |
| unicode-match-property-ecmascript                                             | 2.0.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/unicode-match-property-ecmascript                                  | Required          | Yes      |
| unicode-match-property-value-ecmascript                                       | 2.1.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/unicode-match-property-value-ecmascript                            | Required          | Yes      |
| unicode-property-aliases-ecmascript                                           | 2.1.0                                     | MIT                                                                                  | https://github.com/mathiasbynens/unicode-property-aliases-ecmascript                                | Required          | Yes      |
| unicoderegexp                                                                 | 0.4.1                                     | Custom: https://github.com/One-com/purify                                            | https://github.com/One-com/unicoderegexp                                                            | Required          | Yes      |
| unified                                                                       | 9.2.2                                     | MIT                                                                                  | https://github.com/unifiedjs/unified                                                                | Required          | Yes      |
| unique-filename                                                               | 2.0.1                                     | ISC                                                                                  | https://github.com/npm/unique-filename                                                              | Required          | Yes      |
| unique-filename                                                               | 3.0.0                                     | ISC                                                                                  | https://github.com/npm/unique-filename                                                              | Required          | Yes      |
| unique-slug                                                                   | 3.0.0                                     | ISC                                                                                  | https://github.com/npm/unique-slug                                                                  | Required          | Yes      |
| unique-slug                                                                   | 4.0.0                                     | ISC                                                                                  | https://github.com/npm/unique-slug                                                                  | Required          | Yes      |
| unique-string                                                                 | 3.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/unique-string                                                       | Required          | Yes      |
| unist-builder                                                                 | 2.0.3                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-builder                                                        | Required          | Yes      |
| unist-util-generated                                                          | 1.1.6                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-generated                                                 | Required          | Yes      |
| unist-util-is                                                                 | 3.0.0                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-is                                                        | Required          | Yes      |
| unist-util-is                                                                 | 4.1.0                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-is                                                        | Required          | Yes      |
| unist-util-position                                                           | 3.1.0                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-position                                                  | Required          | Yes      |
| unist-util-remove-position                                                    | 2.0.1                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-remove-position                                           | Required          | Yes      |
| unist-util-stringify-position                                                 | 2.0.3                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-stringify-position                                        | Required          | Yes      |
| unist-util-visit-parents                                                      | 2.1.2                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-visit-parents                                             | Required          | Yes      |
| unist-util-visit-parents                                                      | 3.1.1                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-visit-parents                                             | Required          | Yes      |
| unist-util-visit                                                              | 1.4.1                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-visit                                                     | Required          | Yes      |
| unist-util-visit                                                              | 2.0.3                                     | MIT                                                                                  | https://github.com/syntax-tree/unist-util-visit                                                     | Required          | Yes      |
| universalify                                                                  | 0.2.0                                     | MIT                                                                                  | https://github.com/RyanZim/universalify                                                             | Required          | Yes      |
| universalify                                                                  | 2.0.1                                     | MIT                                                                                  | https://github.com/RyanZim/universalify                                                             | Required          | Yes      |
| unload                                                                        | 2.2.0                                     | Apache-2.0                                                                           | https://github.com/pubkey/unload                                                                    | Required          | Yes      |
| unpipe                                                                        | 1.0.0                                     | MIT                                                                                  | https://github.com/stream-utils/unpipe                                                              | Required          | Yes      |
| untildify                                                                     | 4.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/untildify                                                           | Required          | Yes      |
| update-browserslist-db                                                        | 1.0.16                                    | MIT                                                                                  | https://github.com/browserslist/update-db                                                           | Required          | Yes      |
| update-browserslist-db                                                        | 1.1.0                                     | MIT                                                                                  | https://github.com/browserslist/update-db                                                           | Required          | Yes      |
| update-browserslist-db                                                        | 1.1.1                                     | MIT                                                                                  | https://github.com/browserslist/update-db                                                           | Required          | Yes      |
| update-notifier                                                               | 6.0.2                                     | BSD-2-Clause                                                                         | https://github.com/yeoman/update-notifier                                                           | Required          | Yes      |
| upper-case-first                                                              | 2.0.2                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| upper-case                                                                    | 2.0.2                                     | MIT                                                                                  | https://github.com/blakeembrey/change-case                                                          | Required          | Yes      |
| uri-js                                                                        | 4.4.1                                     | BSD-2-Clause                                                                         | https://github.com/garycourt/uri-js                                                                 | Required          | Yes      |
| url-join                                                                      | 4.0.1                                     | MIT                                                                                  | https://github.com/jfromaniello/url-join                                                            | Required          | Yes      |
| url-loader                                                                    | 4.1.1                                     | MIT                                                                                  | https://github.com/webpack-contrib/url-loader                                                       | Required          | Yes      |
| url-parse                                                                     | 1.5.10                                    | MIT                                                                                  | https://github.com/unshiftio/url-parse                                                              | Required          | Yes      |
| url-template                                                                  | 3.1.1                                     | BSD-3-Clause                                                                         | https://github.com/bramstein/url-template                                                           | Required          | Yes      |
| url                                                                           | 0.11.4                                    | MIT                                                                                  | https://github.com/defunctzombie/node-url                                                           | Required          | Yes      |
| use-callback-ref                                                              | 1.3.2                                     | MIT                                                                                  | https://github.com/theKashey/use-callback-ref                                                       | Required          | Yes      |
| use-memo-one                                                                  | 1.1.3                                     | MIT                                                                                  | https://github.com/alexreardon/use-memo-one                                                         | Required          | Yes      |
| use-sidecar                                                                   | 1.1.2                                     | MIT                                                                                  | https://github.com/theKashey/use-sidecar                                                            | Required          | Yes      |
| use-sync-external-store                                                       | 1.2.2                                     | MIT                                                                                  | https://github.com/facebook/react                                                                   | Required          | Yes      |
| util-deprecate                                                                | 1.0.2                                     | MIT                                                                                  | https://github.com/TooTallNate/util-deprecate                                                       | Required          | Yes      |
| util-extend                                                                   | 1.0.3                                     | MIT                                                                                  | https://github.com/isaacs/util-extend                                                               | Required          | Yes      |
| utila                                                                         | 0.4.0                                     | MIT                                                                                  | https://github.com/AriaMinaei/utila                                                                 | Required          | Yes      |
| utility-types                                                                 | 3.11.0                                    | MIT                                                                                  | https://github.com/piotrwitek/utility-types                                                         | Required          | Yes      |
| utils-merge                                                                   | 1.0.1                                     | MIT                                                                                  | https://github.com/jaredhanson/utils-merge                                                          | Required          | Yes      |
| uuid                                                                          | 8.3.2                                     | MIT                                                                                  | https://github.com/uuidjs/uuid                                                                      | Required          | Yes      |
| uuid                                                                          | 9.0.1                                     | MIT                                                                                  | https://github.com/uuidjs/uuid                                                                      | Required          | Yes      |
| v8-compile-cache-lib                                                          | 3.0.1                                     | MIT                                                                                  | https://github.com/cspotcode/v8-compile-cache-lib                                                   | Required          | Yes      |
| v8-to-istanbul                                                                | 9.2.0                                     | ISC                                                                                  | https://github.com/istanbuljs/v8-to-istanbul                                                        | Required          | Yes      |
| v8flags                                                                       | 3.2.0                                     | MIT                                                                                  | https://github.com/gulpjs/v8flags                                                                   | Required          | Yes      |
| validate-npm-package-license                                                  | 3.0.4                                     | Apache-2.0                                                                           | https://github.com/kemitchell/validate-npm-package-license.js                                       | Required          | Yes      |
| validate-npm-package-name                                                     | 5.0.1                                     | ISC                                                                                  | https://github.com/npm/validate-npm-package-name                                                    | Required          | Yes      |
| value-equal                                                                   | 1.0.1                                     | MIT                                                                                  | https://github.com/mjackson/value-equal                                                             | Required          | Yes      |
| varint                                                                        | 6.0.0                                     | MIT                                                                                  | https://github.com/chrisdickinson/varint                                                            | Required          | Yes      |
| vary                                                                          | 1.1.2                                     | MIT                                                                                  | https://github.com/jshttp/vary                                                                      | Required          | Yes      |
| verror                                                                        | 1.10.0                                    | MIT                                                                                  | https://github.com/davepacheco/node-verror                                                          | Required          | Yes      |
| vfile-location                                                                | 3.2.0                                     | MIT                                                                                  | https://github.com/vfile/vfile-location                                                             | Required          | Yes      |
| vfile-message                                                                 | 2.0.4                                     | MIT                                                                                  | https://github.com/vfile/vfile-message                                                              | Required          | Yes      |
| vfile                                                                         | 4.2.1                                     | MIT                                                                                  | https://github.com/vfile/vfile                                                                      | Required          | Yes      |
| vm-browserify                                                                 | 1.1.2                                     | MIT                                                                                  | https://github.com/substack/vm-browserify                                                           | Required          | Yes      |
| w3c-xmlserializer                                                             | 4.0.0                                     | MIT                                                                                  | https://github.com/jsdom/w3c-xmlserializer                                                          | Required          | Yes      |
| walker                                                                        | 1.0.8                                     | Apache-2.0                                                                           | https://github.com/daaku/nodejs-walker                                                              | Required          | Yes      |
| watchpack                                                                     | 2.4.1                                     | MIT                                                                                  | https://github.com/webpack/watchpack                                                                | Required          | Yes      |
| web-namespaces                                                                | 1.1.4                                     | MIT                                                                                  | https://github.com/wooorm/web-namespaces                                                            | Required          | Yes      |
| webidl-conversions                                                            | 3.0.1                                     | BSD-2-Clause                                                                         | https://github.com/jsdom/webidl-conversions                                                         | Required          | Yes      |
| webidl-conversions                                                            | 4.0.2                                     | BSD-2-Clause                                                                         | https://github.com/jsdom/webidl-conversions                                                         | Required          | Yes      |
| webidl-conversions                                                            | 7.0.0                                     | BSD-2-Clause                                                                         | https://github.com/jsdom/webidl-conversions                                                         | Required          | Yes      |
| webpack-cli                                                                   | 5.1.4                                     | MIT                                                                                  | https://github.com/webpack/webpack-cli                                                              | Required          | Yes      |
| webpack-dev-middleware                                                        | 6.1.3                                     | MIT                                                                                  | https://github.com/webpack/webpack-dev-middleware                                                   | Required          | Yes      |
| webpack-hot-middleware                                                        | 2.26.1                                    | MIT                                                                                  | https://github.com/webpack-contrib/webpack-hot-middleware                                           | Required          | Yes      |
| webpack-merge                                                                 | 5.10.0                                    | MIT                                                                                  | https://github.com/survivejs/webpack-merge                                                          | Required          | Yes      |
| webpack-sources                                                               | 3.2.3                                     | MIT                                                                                  | https://github.com/webpack/webpack-sources                                                          | Required          | Yes      |
| webpack                                                                       | 5.94.0                                    | MIT                                                                                  | https://github.com/webpack/webpack                                                                  | Required          | Yes      |
| whatwg-encoding                                                               | 2.0.0                                     | MIT                                                                                  | https://github.com/jsdom/whatwg-encoding                                                            | Required          | Yes      |
| whatwg-mimetype                                                               | 3.0.0                                     | MIT                                                                                  | https://github.com/jsdom/whatwg-mimetype                                                            | Required          | Yes      |
| whatwg-url                                                                    | 11.0.0                                    | MIT                                                                                  | https://github.com/jsdom/whatwg-url                                                                 | Required          | Yes      |
| whatwg-url                                                                    | 5.0.0                                     | MIT                                                                                  | https://github.com/jsdom/whatwg-url                                                                 | Required          | Yes      |
| whatwg-url                                                                    | 6.5.0                                     | MIT                                                                                  | https://github.com/jsdom/whatwg-url                                                                 | Required          | Yes      |
| which-boxed-primitive                                                         | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/which-boxed-primitive                                                 | Required          | Yes      |
| which-boxed-primitive                                                         | 1.1.1                                     | MIT                                                                                  | https://github.com/inspect-js/which-boxed-primitive                                                 | Required          | Yes      |
| which-builtin-type                                                            | 1.1.3                                     | MIT                                                                                  | https://github.com/inspect-js/which-builtin-type                                                    | Required          | Yes      |
| which-builtin-type                                                            | 1.2.1                                     | MIT                                                                                  | https://github.com/inspect-js/which-builtin-type                                                    | Required          | Yes      |
| which-collection                                                              | 1.0.2                                     | MIT                                                                                  | https://github.com/inspect-js/which-collection                                                      | Required          | Yes      |
| which-typed-array                                                             | 1.1.15                                    | MIT                                                                                  | https://github.com/inspect-js/which-typed-array                                                     | Required          | Yes      |
| which-typed-array                                                             | 1.1.18                                    | MIT                                                                                  | https://github.com/inspect-js/which-typed-array                                                     | Required          | Yes      |
| which                                                                         | 1.3.1                                     | ISC                                                                                  | https://github.com/isaacs/node-which                                                                | Required          | Yes      |
| which                                                                         | 2.0.2                                     | ISC                                                                                  | https://github.com/isaacs/node-which                                                                | Required          | Yes      |
| which                                                                         | 3.0.1                                     | ISC                                                                                  | https://github.com/npm/node-which                                                                   | Required          | Yes      |
| wide-align                                                                    | 1.1.5                                     | ISC                                                                                  | https://github.com/iarna/wide-align                                                                 | Required          | Yes      |
| widest-line                                                                   | 4.0.1                                     | MIT                                                                                  | https://github.com/sindresorhus/widest-line                                                         | Required          | Yes      |
| wildcard                                                                      | 2.0.1                                     | MIT                                                                                  | https://github.com/DamonOehlman/wildcard                                                            | Required          | Yes      |
| word-wrap                                                                     | 1.2.5                                     | MIT                                                                                  | https://github.com/jonschlinkert/word-wrap                                                          | Required          | Yes      |
| wrap-ansi                                                                     | 6.2.0                                     | MIT                                                                                  | https://github.com/chalk/wrap-ansi                                                                  | Required          | Yes      |
| wrap-ansi                                                                     | 7.0.0                                     | MIT                                                                                  | https://github.com/chalk/wrap-ansi                                                                  | Required          | Yes      |
| wrap-ansi                                                                     | 8.1.0                                     | MIT                                                                                  | https://github.com/chalk/wrap-ansi                                                                  | Required          | Yes      |
| wrappy                                                                        | 1.0.2                                     | ISC                                                                                  | https://github.com/npm/wrappy                                                                       | Required          | Yes      |
| write-file-atomic                                                             | 2.4.3                                     | ISC                                                                                  | https://github.com/iarna/write-file-atomic                                                          | Required          | Yes      |
| write-file-atomic                                                             | 3.0.3                                     | ISC                                                                                  | https://github.com/npm/write-file-atomic                                                            | Required          | Yes      |
| write-file-atomic                                                             | 4.0.2                                     | ISC                                                                                  | https://github.com/npm/write-file-atomic                                                            | Required          | Yes      |
| write-file-atomic                                                             | 5.0.1                                     | ISC                                                                                  | https://github.com/npm/write-file-atomic                                                            | Required          | Yes      |
| ws                                                                            | 8.17.1                                    | MIT                                                                                  | https://github.com/websockets/ws                                                                    | Required          | Yes      |
| xdg-basedir                                                                   | 5.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/xdg-basedir                                                         | Required          | Yes      |
| xml-name-validator                                                            | 4.0.0                                     | Apache-2.0                                                                           | https://github.com/jsdom/xml-name-validator                                                         | Required          | Yes      |
| xml                                                                           | 1.0.1                                     | MIT                                                                                  | https://github.com/dylang/node-xml                                                                  | Required          | Yes      |
| xmlbuilder2                                                                   | 3.1.1                                     | MIT                                                                                  | https://github.com/oozcitak/xmlbuilder2                                                             | Required          | Yes      |
| xmlchars                                                                      | 2.2.0                                     | MIT                                                                                  | https://github.com/lddubeau/xmlchars                                                                | Required          | Yes      |
| xtend                                                                         | 4.0.2                                     | MIT                                                                                  | https://github.com/Raynos/xtend                                                                     | Required          | Yes      |
| y18n                                                                          | 5.0.8                                     | ISC                                                                                  | https://github.com/yargs/y18n                                                                       | Required          | Yes      |
| yallist                                                                       | 3.1.1                                     | ISC                                                                                  | https://github.com/isaacs/yallist                                                                   | Required          | Yes      |
| yallist                                                                       | 4.0.0                                     | ISC                                                                                  | https://github.com/isaacs/yallist                                                                   | Required          | Yes      |
| yaml                                                                          | 1.10.2                                    | ISC                                                                                  | https://github.com/eemeli/yaml                                                                      | Required          | Yes      |
| yargs-parser                                                                  | 20.2.9                                    | ISC                                                                                  | https://github.com/yargs/yargs-parser                                                               | Required          | Yes      |
| yargs-parser                                                                  | 21.1.1                                    | ISC                                                                                  | https://github.com/yargs/yargs-parser                                                               | Required          | Yes      |
| yargs                                                                         | 16.2.0                                    | MIT                                                                                  | https://github.com/yargs/yargs                                                                      | Required          | Yes      |
| yargs                                                                         | 17.7.2                                    | MIT                                                                                  | https://github.com/yargs/yargs                                                                      | Required          | Yes      |
| yauzl                                                                         | 2.10.0                                    | MIT                                                                                  | https://github.com/thejoshwolfe/yauzl                                                               | Required          | Yes      |
| yn                                                                            | 3.1.1                                     | MIT                                                                                  | https://github.com/sindresorhus/yn                                                                  | Required          | Yes      |
| yocto-queue                                                                   | 0.1.0                                     | MIT                                                                                  | https://github.com/sindresorhus/yocto-queue                                                         | Required          | Yes      |
| yocto-queue                                                                   | 1.0.0                                     | MIT                                                                                  | https://github.com/sindresorhus/yocto-queue                                                         | Required          | Yes      |
| zod                                                                           | 3.24.1                                    | MIT                                                                                  | https://github.com/colinhacks/zod                                                                   | Required          | Yes      |
| zwitch                                                                        | 1.0.5                                     | MIT                                                                                  | https://github.com/wooorm/zwitch                                                                    | Required          | Yes      |