﻿---
title: ECE API examples
description: Learn how to use the Elastic Cloud Enterprise RESTful API by example. Check our setup instructions, and then you’re ready to try out these examples: A...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/api-examples
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE API examples
<note>
  This documentation applies to the Elastic Cloud Enterprise API only. If you are using [Elasticsearch Service](https://cloud.elastic.co/home), check the [Elastic Cloud API information](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-restful) instead.
</note>

Learn how to use the Elastic Cloud Enterprise RESTful API by example. Check our [setup instructions](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-setting-up-environment), and then you’re ready to try out these examples:
- [A first API call: What deployments are there?](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-get-deployments)
- [Create a first deployment: Elasticsearch and Kibana](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-create-deployment)
- [Applying a new plan: Resize and add high availability](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-resize-ha)
- [Updating a deployment: Check on progress](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-progress-checking)
- [Applying a new deployment configuration: Upgrade](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-upgrade)
- [Dipping a toe into platform automation: Generate a roles token](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-generate-roles-token)
- [Customize your deployment](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-customize-deployment)
- [Remove unwanted deployment templates and instance configurations](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-remove-deplopyment-instances-templates)
- [Secure your settings](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-restful-api-examples-configuring-keystore)

You can find additional RESTful API examples in:
- [Configure deployment templates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/configure-deployment-templates)
- [Generate roles tokens](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/generate-roles-tokens)
- [Manage Elastic Stack versions](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-elastic-stack-versions)
- [Manage security certificates](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates)
- [Create an autoscaled deployment](https://www.elastic.co/docs/deploy-manage/autoscaling/autoscaling-in-ece-and-ech)
- [Enable cross-cluster search](https://www.elastic.co/docs/deploy-manage/remote-clusters/ece-enable-ccs)
- [Manage network security through the API](https://www.elastic.co/docs/deploy-manage/security/network-security-api)
- [Enable Integrations Server through the API](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-integrations-server)
- [Switch from APM to Integrations Server payload](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/switch-from-apm-to-integrations-server-payload)

A complete list of available API operations and request/response models are available in the [API reference documentation](https://www.elastic.co/docs/api/doc/cloud-enterprise).