﻿---
title: ECE API calls
description: The API base path is /api/v1/. You communicate with our RESTful API through the HTTP and HTTPS protocols. We recommend that you use HTTPS on port 12443,...
url: https://www.elastic.co/docs/reference/cloud/cloud-enterprise/api-calls
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE API calls
<note>
  This documentation applies to the Elastic Cloud Enterprise API only. If you are using [Elasticsearch Service](https://cloud.elastic.co/home), check the [Elastic Cloud API information](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-restful) instead.
</note>

The API base path is `/api/v1/`.
You communicate with our RESTful API through the HTTP and HTTPS protocols. We recommend that you use HTTPS on port 12443, because it is much more secure.
RESTful API calls are stateless: Every request that you make happens in isolation from other calls and must include all the information necessary for ECE to fulfill the request. API requests return JSON ouput, which is a format that is machine-readable and works well for automation.
Calls to API endpoints require different request methods, depending on what they do. You use these four request methods to communicate with the Elastic Cloud Enterprise RESTful API:
- To fetch information: GET
- To add new information: POST
- To update existing information: PUT or PATCH
- To delete information: DELETE

Our [API Reference](https://www.elastic.co/docs/api/doc/cloud-enterprise) specifies the request method you need to use for each endpoint, along with supported parameters and the possible responses that you get returned.
Each API endpoint is represented as an object that contains:
- A description of what the endpoint does
- The parameters that the endpoint accepts
- The format of the request body
- The response body and all of the possible returned status codes
- Authentication requirements

For example, the slightly abridged specification for shutting down an Elasticsearch cluster that is running on ECE is:
```sh
"/clusters/elasticsearch/{cluster_id}/_shutdown": {
  "post": {
    "tags": ["ClustersElasticsearch"],
    "summary": "Shut down cluster",
    "description": "Shuts down the active Elasticsearch cluster and removes all of the cluster nodes. The cluster plan is retained. WARNING: To avoid data loss, save the data outside of the cluster before you shut the cluster down.",
    "operationId": "shutdown-es-cluster",
    "parameters": [{
      "name": "cluster_id",
      "in": "path",
      "description": "The Elasticsearch cluster identifier.",
      "required": true,
      "type": "string"
    }, {
      "name": "skip_snapshot",
      "in": "query",
      "description": "When `true`, skips the snapshot when the cluster is shut down.",
      "required": false,
      "type": "boolean",
      "default": false
    }, {
      "name": "hide",
      "in": "query",
      "description": "Hides the clusters during shutdown. NOTE: By default, hidden clusters are not listed.",
      "required": false,
      "type": "boolean",
      "default": false
    }],
    "responses": {
      "202": {
        "description": "The shutdown command was issued successfully, use the \"GET\" command on the /{cluster_id} resource to monitor progress",
        "schema": {
          "$ref": "#/definitions/ClusterCommandResponse"
        }
      },
      "404": {
        "description": "The cluster specified by {cluster_id} cannot be found (code: 'clusters.cluster_not_found')",
        "schema": {
          "$ref": "#/definitions/BasicFailedReply"
        }
      },
      "449": {
        "description": "elevated permissions are required. (code: '\"root.needs_elevated_permissions\"')",
        "schema": {
          "$ref": "#/definitions/BasicFailedReply"
        }
      }
    },
    ...
    }
  }
},
```