﻿---
title: Start Winlogbeat
description: Before starting Winlogbeat: Follow the steps in Quick start: installation and configuration to install, configure, and set up the Winlogbeat environment.Make...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-starting
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Start Winlogbeat
Before starting Winlogbeat:
- Follow the steps in [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration) to install, configure, and set up the Winlogbeat environment.
- Make sure Kibana and Elasticsearch are running.
- Make sure the user specified in `winlogbeat.yml` is [authorized to publish events](https://www.elastic.co/docs/reference/beats/winlogbeat/privileges-to-publish-events).

To start Winlogbeat, run:
```shell
PS C:\Program Files\Winlogbeat> Start-Service winlogbeat
```

Winlogbeat should now be running. If you used the logging configuration described here, you can view the log file at `C:\Program Files\winlogbeat-Data\Logs`.
By default Windows log files are stored in `C:\Program Files\Winlogbeat-Data\logs`.
<note>
  In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\winlogbeat\logs`.
</note>

You can view the status of the service and control it from the Services management console in Windows. To launch the management console, run this command:
```shell
PS C:\Program Files\Winlogbeat> services.msc
```