﻿---
title: Modules
description: This section contains detailed information about the available Windows event log processing modules contained in Winlogbeat. More details about each module...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-modules
products:
  - Beats
  - Winlogbeat
---

# Modules
<note>
  Winlogbeat modules have changed in 8.0.0 to use Elasticsearch Ingest Node for processing. If you are upgrading from 7.x please review the documentation and see the default configuration file.
</note>

This section contains detailed information about the available Windows event log processing modules contained in Winlogbeat. More details about each module can be found in the module’s documentation.
Winlogbeat modules are implemented using Elasticsearch Ingest Node pipelines. The events receive their transformations within Elasticsearch. All events are sent through Winlogbeat’s "routing" pipeline that routes events to specific module pipelines based on their `winlog.channel` value.
Winlogbeat’s default config file contains the option to send all events to the routing pipeline. If you remove this option then the module processing will not be applied.
```yaml
output.elasticsearch.pipeline: winlogbeat-%{[agent.version]}-routing
```

The general goal of each module is to transform events by renaming fields to comply with the [Elastic Common Schema](https://www.elastic.co/docs/reference/ecs) (ECS). The modules may also apply additional categorization, tagging, and parsing as necessary.
<note>
  The provided modules only support events in English. For more information about how to configure the language in `winlogbeat`, refer to [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-winlogbeat-options).
</note>


## Setup of Ingest Node pipelines

Winlogbeat’s Ingest Node pipelines must be installed to Elasticsearch if you want to apply the module processing to events. The simplest way to get started is to use the Elasticsearch output and Winlogbeat will automatically install the pipelines when it first connects to Elasticsearch.
Installation Methods
1. [On connection to Elasticsearch](/docs/reference/beats/winlogbeat/load-ingest-pipelines#winlogbeat-load-pipeline-auto)
2. [setup command](/docs/reference/beats/winlogbeat/load-ingest-pipelines#winlogbeat-load-pipeline-setup)
3. [Manually install pipelines](/docs/reference/beats/winlogbeat/load-ingest-pipelines#winlogbeat-load-pipeline-manual)


## Usage with Forwarded Events

No special configuration options are required when working with the `ForwardedEvents` channel. The events in this log retain the channel name of their origin (e.g. `winlog.channel: Security`). And because the routing pipeline processes events based on the channel name no special config is necessary.
```yaml
winlogbeat.event_logs:
- name: ForwardedEvents
  tags: [forwarded]
  language: 0x0409

output.elasticsearch.pipeline: winlogbeat-%{[agent.version]}-routing
```


## Modules

- [Powershell](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-module-powershell)
- [Security](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-module-security)
- [Sysmon](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-module-sysmon)