﻿---
title: Winlogbeat quick start: installation and configuration
description: This guide describes how to get started quickly with Windows log monitoring. You’ll learn how to: install Winlogbeat on each system you want to monitor,...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Winlogbeat quick start: installation and configuration
This guide describes how to get started quickly with Windows log monitoring. You’ll learn how to:
- install Winlogbeat on each system you want to monitor
- specify the location of your log files
- parse log data into fields and send it to Elasticsearch
- visualize the log data in Kibana

![Winlogbeat dashboard](https://www.elastic.co/docs/reference/beats/winlogbeat/images/winlogbeat-dashboard.png)

## Before you begin

You need Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    To get started quickly, spin up an [Elastic Cloud Hosted](https://www.elastic.co/cloud?page=docs&placement=docs-body) deployment. Elastic Cloud Hosted is available on AWS, GCP, and Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    To install and run Elasticsearch and Kibana, see [Installing the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
  </applies-item>
</applies-switch>


## Step 1: Install Winlogbeat

1. Download the Winlogbeat zip file from the [downloads page](https://www.elastic.co/downloads/beats/winlogbeat).
2. Extract the contents into `C:\Program Files`.
3. Rename the `winlogbeat-<version>` directory to `Winlogbeat`.
4. Open a PowerShell prompt as an Administrator (right-click on the PowerShell icon and select Run As Administrator).
5. From the PowerShell prompt, run the following commands to install the service.

```sh
PS C:\Users\Administrator> cd 'C:\Program Files\Winlogbeat'
PS C:\Program Files\Winlogbeat> .\install-service-winlogbeat.ps1

Security warning
Run only scripts that you trust. While scripts from the internet can be useful,
this script can potentially harm your computer. If you trust this script, use
the Unblock-File cmdlet to allow the script to run without this warning message.
Do you want to run C:\Program Files\Winlogbeat\install-service-winlogbeat.ps1?
[D] Do not run  [R] Run once  [S] Suspend  [?] Help (default is "D"): R

Status   Name               DisplayName
------   ----               -----------
Stopped  winlogbeat         winlogbeat
```

<note>
  If script execution is disabled on your system, you need to set the execution policy for the current session to allow the script to run. For example: `PowerShell.exe -ExecutionPolicy UnRestricted -File .\install-service-winlogbeat.ps1`.
</note>

<note>
  To use a local non-Administrator account to run Winlogbeat, follow [these additional steps](#local-user-account-setup).
</note>

<important applies-to="Elastic Stack: Generally available since 9.0.6">
  The base folder has changed from `C:\ProgramData\` to `C:\Program Files\`
  because the latter has stricter permissions. The home path (base for
  state and logs) is now `C:\Program Files\Winlogbeat-Data`.The install script (`install-service-winlogbeat.ps1`) will check whether
  `C:\ProgramData\Winlogbeat` exits and move it to `C:\Program Files\Winlogbeat-Data`.
  For more details on the installation script refer to: [install script](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-script).
</important>


## Step 2: Connect to the Elastic Stack

Connections to Elasticsearch and Kibana are required to set up Winlogbeat.
Set the connection information in `winlogbeat.yml`. To locate this configuration file, see [Directory layout](https://www.elastic.co/docs/reference/beats/winlogbeat/directory-layout).
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    Specify the [cloud.id](https://www.elastic.co/docs/reference/beats/winlogbeat/configure-cloud-id) of your Elastic Cloud Hosted deployment, and set [cloud.auth](https://www.elastic.co/docs/reference/beats/winlogbeat/configure-cloud-id) to a user who is authorized to set up Winlogbeat. For example:
    ```yaml
    cloud.id: "staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=="
    cloud.auth: "winlogbeat_setup:YOUR_PASSWORD" 
    ```
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    1. Set the host and port where Winlogbeat can find the Elasticsearch installation, and set the username and password of a user who is authorized to set up Winlogbeat. For example:
       ```yaml
       output.elasticsearch:
         hosts: ["https://myEShost:9200"]
         username: "winlogbeat_internal"
         password: "YOUR_PASSWORD" 
         ssl:
           enabled: true
           ca_trusted_fingerprint: "b9a10bbe64ee9826abeda6546fc988c8bf798b41957c33d05db736716513dc9c" 
       ```
    2. If you plan to use our pre-built Kibana dashboards, configure the Kibana endpoint. Skip this step if Kibana is running on the same host as Elasticsearch.
       ```yaml
         setup.kibana:
           host: "mykibanahost:5601" 
           username: "my_kibana_user" <2> 
           password: "YOUR_PASSWORD"
       ```
  </applies-item>
</applies-switch>

To learn more about required roles and privileges, see [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/winlogbeat/feature-roles).

## Step 3: Configure Winlogbeat

In `winlogbeat.yml`, configure the event logs that you want to monitor.
1. Under `winlogbeat.event_log`, specify a list of event logs to monitor. By default, Winlogbeat monitors application, security, and system logs.
   ```yaml
   winlogbeat.event_logs:
     - name: Application
     - name: Security
     - name: System
   ```
   To obtain a list of available event logs, run `Get-EventLog *` in PowerShell. For more information about this command, see the configuration details for [event_logs.name](/docs/reference/beats/winlogbeat/configuration-winlogbeat-options#configuration-winlogbeat-options-event_logs-name).
2. (Optional) Set logging options to write Winlogbeat logs to a file:
   ```yaml
   logging.to_files: true
   logging.files:
     path: C:\Program Files\winlogbeat-Data\Logs
   logging.level: info
   ```

By default Windows log files are stored in `C:\Program Files\Winlogbeat-Data\logs`.
<note>
  In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\winlogbeat\logs`.
</note>

1. After you save your configuration file, test it with the following command.
   ```shell
   PS C:\Program Files\Winlogbeat> .\winlogbeat.exe test config -c .\winlogbeat.yml -e
   ```

For more information about configuring Winlogbeat, also see:
- [Configure Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/configuring-howto-winlogbeat)
- [Config file format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format)
- [`winlogbeat.reference.yml`](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-reference-yml): This reference configuration file shows all non-deprecated options. You’ll find it in the same location as `winlogbeat.yml`.


## Step 4: Set up assets

Winlogbeat comes with predefined assets for parsing, indexing, and visualizing your data. To load these assets:
1. Make sure the user specified in `winlogbeat.yml` is [authorized to set up Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/privileges-to-setup-beats).
2. From the installation directory, run:
   ```sh
   PS > .\winlogbeat.exe setup -e
   ```

This step loads the recommended [index template](https://www.elastic.co/docs/manage-data/data-store/templates) for writing to Elasticsearch , loads the ingest pipelines to parse the events (x-pack only), and deploys the sample dashboards for visualizing the data in Kibana.
<tip>
  A connection to Elasticsearch (or Elastic Cloud Hosted) is required to set up the initial environment. If you’re using a different output, such as Logstash, see:
  - [Load the index template manually](/docs/reference/beats/winlogbeat/winlogbeat-template#load-template-manually)
  - [*Load Kibana dashboards*](https://www.elastic.co/docs/reference/beats/winlogbeat/load-kibana-dashboards)
  - [*Load ingest pipelines*](https://www.elastic.co/docs/reference/beats/winlogbeat/load-ingest-pipelines) (x-pack only)
</tip>


## Step 5: Start Winlogbeat

Before starting Winlogbeat, modify the user credentials in `winlogbeat.yml` and specify a user who is [authorized to publish events](https://www.elastic.co/docs/reference/beats/winlogbeat/privileges-to-publish-events).
To start the Winlogbeat service, run:
```shell
PS C:\Program Files\Winlogbeat> Start-Service winlogbeat
```

Winlogbeat should now be running. If you used the logging configuration described here, you can view the log file at `C:\Program Files\winlogbeat-Data\Logs\winlogbeat`.
By default Windows log files are stored in `C:\Program Files\Winlogbeat-Data\logs`.
<note>
  In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\winlogbeat\logs`.
</note>

You can view the status of the service and control it from the Services management console in Windows. To launch the management console, run this command:
```shell
PS C:\Program Files\Winlogbeat> services.msc
```


### Stop Winlogbeat

Stop the Winlogbeat service with the following command:
```shell
PS C:\Program Files\Winlogbeat> Stop-Service winlogbeat
```


## Step 6: View your data in Kibana

Winlogbeat comes with pre-built Kibana dashboards and UIs for visualizing log data. You loaded the dashboards earlier when you ran the `setup` command.
To open the dashboards:
1. Launch Kibana:
   <applies-switch>
   <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
   1. [Log in](https://cloud.elastic.co/) to your Elastic Cloud account.
   2. Navigate to the Kibana endpoint in your deployment.
   </applies-item>

   <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
   Point your browser to [http://localhost:5601](http://localhost:5601), replacing `localhost` with the name of the Kibana host.
   </applies-item>
   </applies-switch>
2. In the side navigation, click **Discover**. To see Winlogbeat data, make sure the predefined `winlogbeat-*` data view is selected.
   <tip>
   If you don’t see data in Kibana, try changing the time filter to a larger range. By default, Kibana shows the last 15 minutes.
   </tip>
3. In the side navigation, click **Dashboard**, then select the dashboard that you want to open.

The dashboards are provided as examples. We recommend that you [customize](https://www.elastic.co/docs/explore-analyze/dashboards) them to meet your needs.

## Using a local non-Administrator account to run Winlogbeat

By default, the `Winlogbeat` service runs as the `Local System` account. If you want to run the `Winlogbeat` service as a local user account that is not an Administrator, then follow the steps below. The local user account must be granted `Log on as a service` in the security policy and be made part of the `Builtin\Event Log Readers` group to read the event log.
1. Open the Services Management console with this command:
   ```shell
   PS C:\Program Files\Winlogbeat> services.msc
   ```
2. Right-click on service named `winlogbeat` and select `Properties`
3. Under `Log On` tab, select `This account:` and browse for the local account user that you want to run Winlogbeat service as.
4. Enter local user account’s password and click `Apply`.
5. Search and open `Local Group Policy Editor` in Windows search or run `gpedit.msc` from Powershell.
6. Navigate to path: `Computer Settings → Security Settings → Local Policies` and open `User Rights Assignment` under it.
7. Inside `User Rights Assignment`, add your local user account to the policy named `Log on as a service`. This should allow your local user account log on as a service.
8. Open `Local Users and Group Manager` by running `lusrmgr.msc` in Powershell.
9. Under `Users`, right-click on your local account user and open `Properties`.
10. Select `Member of` tab and click on `Add...`
11. Find and select the group named `Event Log Readers` and click `Apply`. This should allow your local account user to read the event log.


## What’s next?

Now that you have your logs streaming into Elasticsearch, learn how to unify your logs, metrics, uptime, and application performance data.
1. Ingest data from other sources by installing and configuring other Elastic Beats:
   | Elastic Beats                                                                                              | To capture                      |
   |------------------------------------------------------------------------------------------------------------|---------------------------------|
   | [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) | Infrastructure metrics          |
   | [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration)       | Logs                            |
   | [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-configuration)    | Uptime information              |
   | [APM](https://www.elastic.co/docs/solutions/observability/apm)                                             | Application performance metrics |
   | [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration)    | Audit events                    |
2. Use the Observability apps in Kibana to search across all your data:
   | Elastic apps                                                                                                           | Use to                                                           |
   |------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|
   | [Metrics app](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) | Explore metrics about systems and services across your ecosystem |
   | [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs)                                      | Tail related log data in real time                               |
   | [Uptime app](https://www.elastic.co/docs/solutions/observability/synthetics#monitoring-uptime)                         | Monitor availability issues across your apps and services        |
   | [APM app](https://www.elastic.co/docs/solutions/observability/apm/overviews)                                           | Monitor application performance                                  |
   | [SIEM app](https://www.elastic.co/docs/solutions/security)                                                             | Analyze security events                                          |