﻿---
title: Configure the Kibana endpoint
description: Kibana dashboards are loaded into Kibana via the Kibana API. This requires a Kibana endpoint configuration. For details on authenticating to the Kibana...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/setup-kibana-endpoint
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure the Kibana endpoint
Kibana dashboards are loaded into Kibana via the Kibana API. This requires a Kibana endpoint configuration. For details on authenticating to the Kibana API, see [Authentication](https://www.elastic.co/docs/api/doc/kibana/authentication).
You configure the endpoint in the `setup.kibana` section of the `winlogbeat.yml` config file.
Here is an example configuration:
```yaml
setup.kibana.host: "http://localhost:5601"
```


## Configuration options

You can specify the following options in the `setup.kibana` section of the `winlogbeat.yml` config file:

### `setup.kibana.host`

The Kibana host where the dashboards will be loaded. The default is `127.0.0.1:5601`. The value of `host` can be a `URL` or `IP:PORT`. For example: `http://192.15.3.2`, `192:15.3.2:5601` or `http://192.15.3.2:6701/path`. If no port is specified, `5601` is used.
<note>
  When a node is defined as an `IP:PORT`, the *scheme* and *path* are taken from the [setup.kibana.protocol](#kibana-protocol-option) and [setup.kibana.path](#kibana-path-option) config options.
</note>

IPv6 addresses must be defined using the following format: `https://[2001:db8::1]:5601`.

### `setup.kibana.protocol`

The name of the protocol Kibana is reachable on. The options are: `http` or `https`. The default is `http`. However, if you specify a URL for host, the value of `protocol` is overridden by whatever scheme you specify in the URL.
Example config:
```yaml
setup.kibana.host: "192.0.2.255:5601"
setup.kibana.protocol: "http"
setup.kibana.path: /kibana
```


### `setup.kibana.username`

The basic authentication username for connecting to Kibana. If you don’t specify a value for this setting, Winlogbeat uses the `username` specified for the Elasticsearch output.

### `setup.kibana.password`

The basic authentication password for connecting to Kibana. If you don’t specify a value for this setting, Winlogbeat uses the `password` specified for the Elasticsearch output.

### `setup.kibana.path`

An HTTP path prefix that is prepended to the HTTP API calls. This is useful for the cases where Kibana listens behind an HTTP reverse proxy that exports the API under a custom prefix.

### `setup.kibana.space.id`

The [Kibana space](https://www.elastic.co/docs/deploy-manage/manage-spaces) ID to use. If specified, Winlogbeat loads Kibana assets into this Kibana space. Omit this option to use the default space.

#### `setup.kibana.headers`

Custom HTTP headers to add to each request sent to Kibana. Example:
```yaml
setup.kibana.headers:
  X-My-Header: Header contents
```


### `setup.kibana.ssl.enabled`

Enables Winlogbeat to use SSL settings when connecting to Kibana via HTTPS. If you configure Winlogbeat to connect over HTTPS, this setting defaults to `true` and Winlogbeat uses the default SSL settings.
Example configuration:
```yaml
setup.kibana.host: "https://192.0.2.255:5601"
setup.kibana.ssl.enabled: true
setup.kibana.ssl.certificate_authorities: ["/etc/client/ca.pem"]
setup.kibana.ssl.certificate: "/etc/client/cert.pem"
setup.kibana.ssl.key: "/etc/client/cert.key
```

See [SSL](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-ssl) for more information.