﻿---
title: Secure communication with Elasticsearch
description: When sending data to a secured cluster through the elasticsearch output, Winlogbeat can use any of the following authentication methods: Basic authentication...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/securing-communication-elasticsearch
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Secure communication with Elasticsearch
When sending data to a secured cluster through the `elasticsearch` output, Winlogbeat can use any of the following authentication methods:
- Basic authentication credentials (username and password).
- Token-based API authentication.
- A client certificate.

Authentication is specified in the Winlogbeat configuration file:
- To use **basic authentication**, specify the `username` and `password` settings under `output.elasticsearch`. For example:
  ```yaml
  output.elasticsearch:
    hosts: ["https://myEShost:9200"]
    username: "winlogbeat_writer" 
    password: "YOUR_PASSWORD" 
  ```
- To use token-based **API key authentication**, specify the `api_key` under `output.elasticsearch`. For example:
  ```yaml
  output.elasticsearch:
    hosts: ["https://myEShost:9200"]
    api_key: "ZCV7VnwBgnX0T19fN8Qe:KnR6yE41RrSowb0kQ0HWoA" 
  ```
- To use **Public Key Infrastructure (PKI) certificates** to authenticate users, specify the `certificate` and `key` settings under `output.elasticsearch`. For example:
  ```yaml
  output.elasticsearch:
    hosts: ["https://myEShost:9200"]
    ssl.certificate: "/etc/pki/client/cert.pem" 
    ssl.key: "/etc/pki/client/cert.key" 
  ```
  These settings assume that the distinguished name (DN) in the certificate is mapped to the appropriate roles in the `role_mapping.yml` file on each node in the Elasticsearch cluster. For more information, see [Using role mapping files](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/mapping-users-groups-to-roles#mapping-roles-file).
  By default, Winlogbeat uses the list of trusted certificate authorities (CA) from the operating system where Winlogbeat is running. If the certificate authority that signed your node certificates is not in the host system’s trusted certificate authorities list, you need to add the path to the `.pem` file that contains your CA’s certificate to the Winlogbeat configuration. This will configure Winlogbeat to use a specific list of CA certificates instead of the default list from the OS.
  Here is an example configuration:
  ```yaml
  output.elasticsearch:
    hosts: ["https://myEShost:9200"]
    ssl.certificate_authorities: 
      - /etc/pki/my_root_ca.pem
      - /etc/pki/my_other_ca.pem
    ssl.certificate: "/etc/pki/client.pem" 
    ssl.key: "/etc/pki/key.pem" 
  ```
  <note>
  For any given connection, the SSL/TLS certificates must have a subject that matches the value specified for `hosts`, or the SSL handshake fails. For example, if you specify `hosts: ["foobar:9200"]`, the certificate MUST include `foobar` in the subject (`CN=foobar`) or as a subject alternative name (SAN). Make sure the hostname resolves to the correct IP address. If no DNS is available, then you can associate the IP address with your hostname in `/etc/hosts` (on Unix) or `C:\Windows\System32\drivers\etc\hosts` (on Windows).
  </note>


## Secure communication with the Kibana endpoint

If you’ve configured the [Kibana endpoint](https://www.elastic.co/docs/reference/beats/winlogbeat/setup-kibana-endpoint), you can also specify credentials for authenticating with Kibana under `kibana.setup`. If no credentials are specified, Kibana will use the configured authentication method in the Elasticsearch output.
For example, specify a unique username and password to connect to Kibana like this:
```yaml
setup.kibana:
  host: "mykibanahost:5601"
  username: "winlogbeat_kib_setup" 
  password: "YOUR_PASSWORD" 
```


## Learn more about secure communication

More information on sending data to a secured cluster is available in the configuration reference:
- [Elasticsearch](https://www.elastic.co/docs/reference/beats/winlogbeat/elasticsearch-output)
- [SSL](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-ssl)
- [Kibana endpoint](https://www.elastic.co/docs/reference/beats/winlogbeat/setup-kibana-endpoint)