﻿---
title: Not sure how to read from .evtx files
description: Yes, Winlogbeat can ingest archived .evtx files. When you set the name parameter as the absolute path to an event log file it will read from that file...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/reading-from-evtx
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Not sure how to read from .evtx files
Yes, Winlogbeat can ingest archived .evtx files. When you set the `name` parameter as the absolute path to an event log file it will read from that file. Here’s an example. First create a new config file for Winlogbeat.
winlogbeat-evtx.yml
```yaml
winlogbeat.event_logs:
  - name: ${EVTX_FILE} 
    no_more_events: stop 

winlogbeat.shutdown_timeout: 30s 
winlogbeat.registry_file: evtx-registry.yml 

output.elasticsearch.hosts: ['http://localhost:9200']
```

Now execute Winlogbeat and wait for it to complete. It will exit when it’s done.
```sh
.\winlogbeat.exe -e -c .\winlogbeat-evtx.yml -E EVTX_FILE=c:\backup\Security-2019.01.evtx
```