﻿---
title: Rate limit the flow of events
description: The rate_limit processor limits the throughput of events based on the specified configuration. In the current implementation, rate-limited events are...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/rate-limit
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Rate limit the flow of events
The `rate_limit` processor limits the throughput of events based on the specified configuration.
In the current implementation, rate-limited events are dropped. Future implementations may allow rate-limited events to be handled differently.
```yaml
processors:
- rate_limit:
   limit: "10000/m"
```

```yaml
processors:
- rate_limit:
   fields:
   - "cloudfoundry.org.name"
   limit: "400/s"
```

```yaml
processors:
- if.equals.cloudfoundry.org.name: "acme"
  then:
  - rate_limit:
      limit: "500/s"
```

The following settings are supported:
<definitions>
  <definition term="limit">
    The rate limit. Supported time units for the rate are `s` (per second), `m` (per minute), and `h` (per hour).
  </definition>
  <definition term="fields">
    (Optional) List of fields. The rate limit will be applied to each distinct value derived by combining the values of these fields.
  </definition>
</definitions>