﻿---
title: Event Processing Metrics
description: Winlogbeat exposes metrics under the HTTP monitoring endpoint. These metrics are exposed under the /inputs path. They can be used to observe the event...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/metrics-winlogbeat
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Event Processing Metrics
Winlogbeat exposes metrics under the [HTTP monitoring endpoint](https://www.elastic.co/docs/reference/beats/winlogbeat/http-endpoint). These metrics are exposed under the `/inputs` path. They can be used to observe the event log processing activity of Winlogbeat.

## Winlog Metrics


| Metric                   | Description                                                                                  |
|--------------------------|----------------------------------------------------------------------------------------------|
| `provider`               | Name of the provider being read.                                                             |
| `received_events_total`  | Total number of events received.                                                             |
| `discarded_events_total` | Total number of discarded events.                                                            |
| `errors_total`           | Total number of errors.                                                                      |
| `received_events_count`  | Histogram of the number of events in each non-zero batch.                                    |
| `source_lag_time`        | Histogram of the difference in nanoseconds between timestamped event’s creation and reading. |
| `batch_read_period`      | Histogram of the elapsed time in nanoseconds between non-zero batch reads.                   |