﻿---
title: Configure the Logstash output
description: The Logstash output sends events directly to Logstash by using the lumberjack protocol, which runs over TCP. Logstash allows for additional processing...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/logstash-output
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Configure the Logstash output
The Logstash output sends events directly to Logstash by using the lumberjack protocol, which runs over TCP. Logstash allows for additional processing and routing of generated events.
<admonition title="Prerequisite">
  To send events to Logstash, you also need to create a Logstash configuration pipeline that listens for incoming Beats connections and indexes the received events into Elasticsearch. For more information, see [Getting Started with Logstash](https://www.elastic.co/docs/reference/logstash/getting-started-with-logstash). Also see the documentation for the [Beats input](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-beats) and [Elasticsearch output](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) plugins.
</admonition>

If you want to use Logstash to perform additional processing on the data collected by Winlogbeat, you need to configure Winlogbeat to use Logstash.
To do this, edit the Winlogbeat configuration file to disable the Elasticsearch output by commenting it out and enable the Logstash output by uncommenting the Logstash section:
```yaml
output.logstash:
  hosts: ["127.0.0.1:5044"]
```

The `hosts` option specifies the Logstash server and the port (`5044`) where Logstash is configured to listen for incoming Beats connections.
For this configuration, you must [load the index template into Elasticsearch manually](/docs/reference/beats/winlogbeat/winlogbeat-template#load-template-manually) because the options for auto loading the template are only available for the Elasticsearch output.

## Accessing metadata fields

Every event sent to Logstash contains the following metadata fields that you can use in Logstash for indexing and filtering:
```json
{
    ...
    "@metadata": { 
      "beat": "winlogbeat", 
      "version": "9.3.0" 
    }
}
```

You can access this metadata from within the Logstash config file to set values dynamically based on the contents of the metadata.
For example, the following Logstash configuration file tells Logstash to use the index reported by Winlogbeat for indexing events into Elasticsearch:
```json
input {
  beats {
    port => 5044
  }
}

output {
  elasticsearch {
    hosts => ["http://localhost:9200"]
    index => "%{[@metadata][beat]}-%{[@metadata][version]}" 
    action => "create"
  }
}
```

Events indexed into Elasticsearch with the Logstash configuration shown here will be similar to events directly indexed by Winlogbeat into Elasticsearch.
<note>
  If ILM is not being used, set `index` to `%{[@metadata][beat]}-%{[@metadata][version]}-%{+YYYY.MM.dd}` instead so Logstash creates an index per day, based on the `@timestamp` value of the events coming from Beats.
</note>


## Compatibility

This output works with all compatible versions of Logstash. See the [Elastic Support Matrix](https://www.elastic.co/support/matrix#matrix_compatibility).

## Configuration options

You can specify the following options in the `logstash` section of the `winlogbeat.yml` config file:

### `enabled`

The enabled config is a boolean setting to enable or disable the output. If set to false, the output is disabled.
The default value is `true`.

### `hosts`

The list of known Logstash servers to connect to. If load balancing is disabled, but multiple hosts are configured, one host is selected randomly (there is no precedence). If one host becomes unreachable, another one is selected randomly.
All entries in this list can contain a port number. The default port number 5044 will be used if no number is given.

### `compression_level`

The gzip compression level. Setting this value to 0 disables compression. The compression level must be in the range of 1 (best speed) to 9 (best compression).
Increasing the compression level will reduce the network usage but will increase the CPU usage.
The default value is 3.

### `escape_html`

Configure escaping of HTML in strings. Set to `true` to enable escaping.
The default value is `false`.

### `worker` or `workers`

`worker` or `workers` specifies the number of connections created per host for publishing events.
Refer to the `loadblance` setting for details about how the load balancing works to distribute requests across the Elasticsearch cluster nodes.
The default value is `1`.

### `loadbalance`

When `loadbalance: true` is set, Winlogbeat connects to all configured hosts and sends data through all connections in parallel. If a connection fails, data is sent to the remaining hosts until it can be reestablished. Data will still be sent as long as Winlogbeat can connect to at least one of its configured hosts.
Use the `worker` or `workers` setting to specify the number of connections per host.
When `loadbalance: false` is set, Winlogbeat sends data to a single host at a time. The target host is chosen at random from the list of configured hosts, and all data is sent to that target until the connection fails, when a new target is selected. Data will still be sent as long as Winlogbeat can connect to at least one of its configured hosts. To rotate through the list of configured hosts over time, use this option in conjunction with the `ttl` setting to close the connection at the configured interval and choose a new target host.
The default value is `false`.
```yaml
output.logstash:
  hosts: ["localhost:5044", "localhost:5045"]
  loadbalance: true
  index: winlogbeat
```


### `ttl`

Time to live for a connection to Logstash after which the connection will be re-established. Useful when Logstash hosts represent load balancers. Since the connections to Logstash hosts are sticky, operating behind load balancers can lead to uneven load distribution between the instances. Specifying a TTL on the connection allows to achieve equal connection distribution between the instances.  Specifying a TTL of 0 will disable this feature.
The default value is 0. This setting accepts [duration](/docs/reference/beats/libbeat/config-file-format-type#_duration) data type values.
<note>
  The "ttl" option is not yet supported on an async Logstash client (one with the "pipelining" option set).
</note>


### `pipelining`

Configures the number of batches to be sent asynchronously to Logstash while waiting for ACK from Logstash. Output only becomes blocking once number of `pipelining` batches have been written. Pipelining is disabled if a value of 0 is configured. The default value is 2.

### `proxy_url`

The URL of the SOCKS5 proxy to use when connecting to the Logstash servers. The value must be a URL with a scheme of `socks5://`. The protocol used to communicate to Logstash is not based on HTTP so a web-proxy cannot be used.
If the SOCKS5 proxy server requires client authentication, then a username and password can be embedded in the URL as shown in the example.
When using a proxy, hostnames are resolved on the proxy server instead of on the client. You can change this behavior by setting the [`proxy_use_local_resolver`](#logstash-proxy-use-local-resolver) option.
```yaml
output.logstash:
  hosts: ["remote-host:5044"]
  proxy_url: socks5://user:password@socks5-proxy:2233
```


### `proxy_use_local_resolver`

The `proxy_use_local_resolver` option determines if Logstash hostnames are resolved locally when using a proxy. The default value is false, which means that when a proxy is used the name resolution occurs on the proxy server.

### `index`

The index root name to write events to. The default is the Beat name. For example `"winlogbeat"` generates `"[winlogbeat-][version]-YYYY.MM.DD"` indices (for example, `"winlogbeat-9.0.0-2017.04.26"`).
<note>
  This parameter’s value will be assigned to the `metadata.beat` field. It can then be accessed in Logstash's output section as `%{[@metadata][beat]}`.
</note>


### `ssl`

Configuration options for SSL parameters like the root CA for Logstash connections. See [SSL](https://www.elastic.co/docs/reference/beats/winlogbeat/configuration-ssl) for more information. To use SSL, you must also configure the [Beats input plugin for Logstash](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-beats) to use SSL/TLS.

### `timeout`

The number of seconds to wait for responses from the Logstash server before timing out. The default is 30 (seconds).

### `max_retries`

Winlogbeat ignores the `max_retries` setting and retries indefinitely.

### `bulk_max_size`

The maximum number of events to bulk in a single Logstash request. The default is 2048.
Events can be collected into batches. Winlogbeat will split batches read from the queue which are larger than `bulk_max_size` into multiple batches.
Specifying a larger batch size can improve performance by lowering the overhead of sending events. However big batch sizes can also increase processing times, which might result in API errors, killed connections, timed-out publishing requests, and, ultimately, lower throughput.
Setting `bulk_max_size` to values less than or equal to 0 disables the splitting of batches. When splitting is disabled, the queue decides on the number of events to be contained in a batch.

### `slow_start`

If enabled, only a subset of events in a batch of events is transferred per transaction. The number of events to be sent increases up to `bulk_max_size` if no error is encountered. On error, the number of events per transaction is reduced again.
The default is `false`.

### `backoff.init`

The number of seconds to wait before trying to reconnect to Logstash after a network error. After waiting `backoff.init` seconds, Winlogbeat tries to reconnect. If the attempt fails, the backoff timer is increased exponentially up to `backoff.max`. After a successful connection, the backoff timer is reset. The default is 1s.

### `backoff.max`

The maximum number of seconds to wait before attempting to connect to Logstash after a network error. The default is 60s.

### `queue`

Configuration options for internal queue.
See [Internal queue](https://www.elastic.co/docs/reference/beats/winlogbeat/configuring-internal-queue) for more information.
Note:`queue` options can be set under `winlogbeat.yml` or the `output` section but not both.