﻿---
title: Load ingest pipelines
description: Winlogbeat modules are implemented using Elasticsearch ingest node pipelines.  The events receive their transformations within Elasticsearch.  The ingest...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/load-ingest-pipelines
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Load ingest pipelines
Winlogbeat modules are implemented using Elasticsearch ingest node pipelines.  The events receive their transformations within Elasticsearch.  The ingest node pipelines must be loaded into Elasticsearch.  This can happen one of several ways.

## On connection to Elasticsearch

Winlogbeat will send ingest pipelines automatically to Elasticsearch if the Elasticsearch output is enabled.
Make sure the user specified in `winlogbeat.yml` is [authorized to set up Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/privileges-to-setup-beats).
If Winlogbeat is sending events to Logstash or another output you need to load the ingest pipelines with the `setup` command or manually.

## setup command

On a machine that has Winlogbeat installed and has Elasticsearch configured as the output, run the `setup` command with the `--pipelines` option specified.  For example, the following command loads the ingest pipelines:
```sh
PS > .\winlogbeat.exe setup --pipelines
```

Make sure the user specified in `winlogbeat.yml` is [authorized to set up Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/privileges-to-setup-beats).

## Manually install pipelines

On a machine that has Winlogbeat installed export the the pipelines to disk. This can be done with the `export` command with `pipelines` option specified.  For example, the following command exports the ingest pipelines:
```sh
PS> .\winlogbeat.exe export pipelines --es.version=7.16.0
```

Once the pipelines have been exported you can load them into Elasticsearch with the `_ingest/pipeline` REST API call.  The user making the REST API call will need to have the `ingest_admin` role assigned to them.