﻿---
title: Generate a fingerprint of an event
description: The fingerprint processor generates a fingerprint of an event based on a specified subset of its fields. The value that is hashed is constructed as a...
url: https://www.elastic.co/docs/reference/beats/winlogbeat/fingerprint
products:
  - Beats
  - Winlogbeat
applies_to:
  - Elastic Stack: Generally available
---

# Generate a fingerprint of an event
The `fingerprint` processor generates a fingerprint of an event based on a specified subset of its fields.
The value that is hashed is constructed as a concatenation of the field name and field value separated by `|`. For example `|field1|value1|field2|value2|`.
Nested fields are supported in the following format: `"field1.field2"` e.g: `["log.path.file", "foo"]`
```yaml
processors:
  - fingerprint:
      fields: ["field1", "field2", ...]
```

The following settings are supported:
<definitions>
  <definition term="fields">
    List of fields to use as the source for the fingerprint. The list will be alphabetically sorted by the processor.
  </definition>
  <definition term="ignore_missing">
    (Optional) Whether to ignore missing fields. Default is `false`.
  </definition>
  <definition term="target_field">
    (Optional) Field in which the generated fingerprint should be stored. Default is `fingerprint`.
  </definition>
  <definition term="method">
    (Optional) Algorithm to use for computing the fingerprint. Must be one of: `md5`, `sha1`, `sha256`, `sha384`, `sha512`, `xxhash`. Default is `sha256`.
  </definition>
  <definition term="encoding">
    (Optional) Encoding to use on the fingerprint value. Must be one of `hex`, `base32`, or `base64`. Default is `hex`.
  </definition>
</definitions>